/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.aggregate.GridSlice;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.util.InternationalString;

final class GridSliceLocator {
    final int searchDimension;
    private final long[] sliceLows;
    private final long[] sliceHighs;
    private final long[][] offsets;

    GridSliceLocator(List<GridSlice> list, int n, GridCoverageResource[] gridCoverageResourceArray) {
        this.searchDimension = n;
        list.sort((gridSlice, gridSlice2) -> Long.compare(gridSlice.getGridLow(n), gridSlice2.getGridLow(n)));
        this.sliceLows = new long[gridCoverageResourceArray.length];
        this.sliceHighs = new long[gridCoverageResourceArray.length];
        this.offsets = new long[gridCoverageResourceArray.length][];
        HashMap<GridSlice, long[]> hashMap = new HashMap<GridSlice, long[]>();
        for (int i = 0; i < gridCoverageResourceArray.length; ++i) {
            GridSlice gridSlice3 = list.get(i);
            GridExtent gridExtent = gridSlice3.getGridExtent();
            long[] lArray = gridSlice3.getOffset(hashMap);
            long l = lArray[n];
            this.sliceLows[i] = Math.subtractExact(gridExtent.getLow(n), l);
            this.sliceHighs[i] = Math.subtractExact(gridExtent.getHigh(n), l);
            gridCoverageResourceArray[i] = gridSlice3.resource;
            this.offsets[i] = lArray;
        }
    }

    final <E> GridGeometry union(GridGeometry gridGeometry, List<E> list, Function<E, GridExtent> function) {
        int n;
        GridExtent gridExtent = gridGeometry.getExtent();
        int n2 = gridExtent.getDimension();
        DimensionNameType[] dimensionNameTypeArray = new DimensionNameType[n2];
        long[] lArray = new long[n2];
        long[] lArray2 = new long[n2];
        for (n = 0; n < n2; ++n) {
            dimensionNameTypeArray[n] = gridExtent.getAxisType(n).orElse(null);
            lArray[n] = gridExtent.getLow(n);
            lArray2[n] = gridExtent.getHigh(n);
        }
        n = 0;
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            GridExtent gridExtent2 = function.apply(list.get(i));
            for (int j = 0; j < n2; ++j) {
                long l = this.offsets[i][j];
                long l2 = Math.subtractExact(gridExtent2.getLow(j), l);
                if (l2 < lArray[j]) {
                    lArray[j] = l2;
                    n = 1;
                }
                if ((l2 = Math.subtractExact(gridExtent2.getHigh(j), l)) <= lArray2[j]) continue;
                lArray2[j] = l2;
                n = 1;
            }
        }
        if (n == 0) {
            return gridGeometry;
        }
        gridExtent = new GridExtent(dimensionNameTypeArray, lArray, lArray2, true);
        return new GridGeometry(gridExtent, PixelInCell.CELL_CORNER, gridGeometry.getGridToCRS(PixelInCell.CELL_CORNER), gridGeometry.isDefined(1) ? gridGeometry.getCoordinateReferenceSystem() : null);
    }

    final GridExtent toSliceExtent(GridExtent gridExtent, int n) {
        return gridExtent.translate(this.offsets[n]);
    }

    final int getUpper(GridExtent gridExtent, int n, int n2) {
        long l = gridExtent.getHigh(this.searchDimension);
        int n3 = Arrays.binarySearch(this.sliceLows, n, n2, l);
        if (n3 < 0) {
            n3 ^= 0xFFFFFFFF;
        } else {
            while (++n3 < n2 && this.sliceLows[n3] <= l) {
            }
        }
        return n3;
    }

    final int getLower(GridExtent gridExtent, int n, int n2) {
        long l = gridExtent.getLow(this.searchDimension);
        while (n2 > n) {
            if (this.sliceHighs[--n2] >= l) continue;
            return n2 + 1;
        }
        return n2;
    }

    final boolean isSlice(GridExtent gridExtent) {
        return gridExtent.getLow(this.searchDimension) == gridExtent.getHigh(this.searchDimension);
    }

    final String getDimensionName(GridExtent gridExtent) {
        return gridExtent.getAxisType(this.searchDimension).map(Types::getCodeTitle).map(InternationalString::toString).orElseGet(() -> String.valueOf(this.searchDimension));
    }
}

