/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.sis.internal.util.Strings;

final class DimensionSelector
implements Comparable<DimensionSelector> {
    final int dimension;
    private final long[] positions;
    private BigInteger sumOfSize;
    private double relativeIncrement;
    private long incrementRange;
    boolean isConstantPosition;

    DimensionSelector(int n, int n2) {
        this.dimension = n;
        this.positions = new long[n2];
        this.sumOfSize = BigInteger.ZERO;
    }

    final void setSliceExtent(int n, long l, long l2) {
        this.positions[n] = l;
        this.sumOfSize = this.sumOfSize.add(BigInteger.valueOf(l2));
    }

    final void finish() {
        Arrays.sort(this.positions);
        long l = 0L;
        long l2 = Long.MAX_VALUE;
        BigInteger bigInteger = BigInteger.ZERO;
        long l3 = this.positions[0];
        for (int i = 1; i < this.positions.length; ++i) {
            long l4 = this.positions[i];
            long l5 = l4 - l3;
            if (l5 == 0L) continue;
            if (l5 < l2) {
                l2 = l5;
            }
            if (l5 > l) {
                l = l5;
            }
            bigInteger = bigInteger.add(BigInteger.valueOf(l5));
            l3 = l4;
        }
        boolean bl = this.isConstantPosition = l == 0L;
        if (l2 <= l) {
            this.relativeIncrement = bigInteger.doubleValue() / this.sumOfSize.doubleValue();
            this.incrementRange = l - l2;
        }
    }

    @Override
    public int compareTo(DimensionSelector dimensionSelector) {
        int n = Boolean.compare(dimensionSelector.isConstantPosition, this.isConstantPosition);
        if (n == 0 && (n = Double.compare(this.relativeIncrement, dimensionSelector.relativeIncrement)) == 0) {
            n = Long.compare(dimensionSelector.incrementRange, this.incrementRange);
        }
        return n;
    }

    public String toString() {
        return Strings.toString(this.getClass(), "dimension", this.dimension, "relativeIncrement", this.relativeIncrement);
    }
}

