/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.internal.simple.SimpleFormat;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.io.Markable;
import org.apache.sis.internal.storage.io.RewindableLineReader;
import org.apache.sis.measure.Range;
import org.apache.sis.storage.CanNotProbeException;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ForwardOnlyStorageException;
import org.apache.sis.storage.ProbeInputStream;
import org.apache.sis.storage.ProbeReader;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Version;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.distribution.Format;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

public abstract class DataStoreProvider {
    public static final String LOCATION = "location";
    public static final String CREATE = "create";
    private volatile Logger logger;

    protected DataStoreProvider() {
    }

    public abstract String getShortName();

    public Format getFormat() {
        return new SimpleFormat(this.getShortName());
    }

    public Range<Version> getSupportedVersions() {
        return null;
    }

    public abstract ParameterDescriptorGroup getOpenParameters();

    public abstract ProbeResult probeContent(StorageConnector var1) throws DataStoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <S> ProbeResult probeContent(StorageConnector storageConnector, Class<S> clazz, Prober<? super S> prober) throws DataStoreException {
        ArgumentChecks.ensureNonNull("prober", prober);
        boolean bl = false;
        Object object = storageConnector.storage;
        synchronized (object) {
            ProbeResult probeResult = this.tryProber(storageConnector, clazz, prober);
            boolean bl2 = bl = probeResult == ProbeResult.UNDETERMINED;
            if (probeResult != null && !bl) {
                return probeResult;
            }
            Prober<? super S> prober2 = prober;
            while (prober2 instanceof ProberList) {
                ProberList proberList = (ProberList)prober2;
                probeResult = this.tryNextProber(storageConnector, proberList);
                if (probeResult != null && probeResult != ProbeResult.UNDETERMINED) {
                    return probeResult;
                }
                bl |= probeResult == ProbeResult.UNDETERMINED;
                prober2 = proberList.next;
            }
        }
        return bl ? ProbeResult.UNDETERMINED : ProbeResult.UNSUPPORTED_STORAGE;
    }

    private <N> ProbeResult tryNextProber(StorageConnector storageConnector, ProberList<?, N> proberList) throws DataStoreException {
        return this.tryProber(storageConnector, proberList.type, proberList.next);
    }

    private <S> ProbeResult tryProber(StorageConnector storageConnector, Class<S> clazz, Prober<? super S> prober) throws DataStoreException {
        S s2 = storageConnector.getStorageAs(clazz);
        if (s2 == null) {
            return null;
        }
        if (s2 == storageConnector.storage && !StorageConnector.isSupportedType(clazz)) {
            throw new IllegalArgumentException(Errors.format((short)163, clazz));
        }
        ProbeResult probeResult = null;
        try {
            if (s2 instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)s2;
                probeResult = prober.test(clazz.cast(byteBuffer.asReadOnlyBuffer()));
            } else if (s2 instanceof Markable) {
                Markable markable = (Markable)s2;
                long l = markable.getStreamPosition();
                markable.mark();
                probeResult = prober.test(s2);
                markable.reset(l);
            } else if (s2 instanceof ImageInputStream) {
                ImageInputStream imageInputStream = (ImageInputStream)s2;
                long l = imageInputStream.getStreamPosition();
                probeResult = prober.test(s2);
                imageInputStream.seek(l);
            } else if (s2 instanceof InputStream) {
                ProbeInputStream probeInputStream = new ProbeInputStream(storageConnector, (InputStream)s2);
                probeResult = prober.test(clazz.cast(probeInputStream));
                probeInputStream.close();
            } else if (s2 instanceof RewindableLineReader) {
                RewindableLineReader rewindableLineReader = (RewindableLineReader)s2;
                rewindableLineReader.protectedMark();
                probeResult = prober.test(s2);
                rewindableLineReader.protectedReset();
            } else if (s2 instanceof Reader) {
                ProbeReader probeReader = new ProbeReader(storageConnector, (Reader)s2);
                probeResult = prober.test(clazz.cast(probeReader));
                ((Reader)probeReader).close();
            } else {
                probeResult = prober.test(s2);
            }
        }
        catch (DataStoreException dataStoreException) {
            throw dataStoreException;
        }
        catch (Exception exception) {
            String string = Errors.format((short)12, storageConnector.getStorageName());
            if (probeResult != null) {
                throw new ForwardOnlyStorageException(string, exception);
            }
            throw new CanNotProbeException(this, storageConnector, (Throwable)exception);
        }
        return probeResult;
    }

    public abstract DataStore open(StorageConnector var1) throws DataStoreException;

    public DataStore open(ParameterValueGroup parameterValueGroup) throws DataStoreException {
        ArgumentChecks.ensureNonNull("parameter", parameterValueGroup);
        return this.open(URIDataStore.Provider.connector(this, parameterValueGroup));
    }

    public Logger getLogger() {
        Logger logger = this.logger;
        if (logger == null) {
            this.logger = logger = Logging.getLogger(this.getClass());
        }
        return logger;
    }

    @FunctionalInterface
    protected static interface Prober<S> {
        public ProbeResult test(S var1) throws Exception;

        default public <A> Prober<S> orElse(Class<A> clazz, Prober<? super A> prober) {
            return new ProberList(this, clazz, prober);
        }
    }

    private static final class ProberList<S, N>
    implements Prober<S> {
        private final Prober<S> first;
        Prober<? super N> next;
        final Class<N> type;

        ProberList(Prober<S> prober, Class<N> clazz, Prober<? super N> prober2) {
            this.first = prober;
            this.type = clazz;
            this.next = prober2;
        }

        @Override
        public ProbeResult test(S s2) throws Exception {
            return this.first.test(s2);
        }

        @Override
        public <A> Prober<S> orElse(Class<A> clazz, Prober<? super A> prober) {
            this.next = this.next.orElse(clazz, prober);
            return this;
        }
    }
}

