/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.VerticalDatum;

@XmlType(name="VerticalCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="VerticalCRS")
public class DefaultVerticalCRS
extends AbstractCRS
implements VerticalCRS {
    private static final long serialVersionUID = 3565878468719941800L;
    private VerticalDatum datum;

    public DefaultVerticalCRS(Map<String, ?> map, VerticalDatum verticalDatum, VerticalCS verticalCS) {
        super(map, verticalCS);
        ArgumentChecks.ensureNonNull("datum", verticalDatum);
        this.datum = verticalDatum;
    }

    protected DefaultVerticalCRS(VerticalCRS verticalCRS) {
        super(verticalCRS);
        this.datum = verticalCRS.getDatum();
    }

    public static DefaultVerticalCRS castOrCopy(VerticalCRS verticalCRS) {
        return verticalCRS == null || verticalCRS instanceof DefaultVerticalCRS ? (DefaultVerticalCRS)verticalCRS : new DefaultVerticalCRS(verticalCRS);
    }

    public Class<? extends VerticalCRS> getInterface() {
        return VerticalCRS.class;
    }

    @Override
    @XmlElement(name="verticalDatum", required=true)
    public VerticalDatum getDatum() {
        return this.datum;
    }

    @Override
    @XmlElement(name="verticalCS", required=true)
    public VerticalCS getCoordinateSystem() {
        return (VerticalCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultVerticalCRS forConvention(AxesConvention axesConvention) {
        return (DefaultVerticalCRS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        return new DefaultVerticalCRS(map, this.datum, (VerticalCS)coordinateSystem);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        return formatter.getConvention().majorVersion() == 1 ? "Vert_CS" : (DefaultVerticalCRS.isBaseCRS(formatter) ? "BaseVertCRS" : formatter.shortOrLong("VertCRS", "VerticalCRS"));
    }

    private DefaultVerticalCRS() {
    }

    private void setDatum(VerticalDatum verticalDatum) {
        if (this.datum == null) {
            this.datum = verticalDatum;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultVerticalCRS.class, "setDatum", "verticalDatum");
        }
    }

    private void setCoordinateSystem(VerticalCS verticalCS) {
        this.setCoordinateSystem("verticalCS", verticalCS);
    }
}

