/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.time.Instant;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.CurveExtremum;
import org.apache.sis.geometry.EnvelopeReducer;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.WraparoundInEnvelope;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.TemporalAccessor;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class Envelopes
extends Static {
    static final double SPAN_FRACTION_AS_BOUND = 0.25;
    private static final boolean[] CORNERS = new boolean[]{false, false, false, true, true, true, true, false, false, false};

    private Envelopes() {
    }

    public static Envelope compound(Envelope ... envelopeArray) throws FactoryException {
        CoordinateReferenceSystem[] coordinateReferenceSystemArray;
        ArgumentChecks.ensureNonNull("components", envelopeArray);
        int n = 0;
        for (int i = 0; i < envelopeArray.length; ++i) {
            coordinateReferenceSystemArray = envelopeArray[i];
            ArgumentChecks.ensureNonNullElement("components", i, coordinateReferenceSystemArray);
            n += coordinateReferenceSystemArray.getDimension();
        }
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(n);
        coordinateReferenceSystemArray = null;
        int n2 = 0;
        for (int i = 0; i < envelopeArray.length; ++i) {
            Envelope envelope = envelopeArray[i];
            int n3 = envelope.getDimension();
            generalEnvelope.subEnvelope(n2, n2 += n3).setEnvelope(envelope);
            if (i == 0) {
                CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
                if (coordinateReferenceSystem == null) continue;
                coordinateReferenceSystemArray = new CoordinateReferenceSystem[envelopeArray.length];
                coordinateReferenceSystemArray[0] = coordinateReferenceSystem;
                continue;
            }
            if (coordinateReferenceSystemArray == null || (coordinateReferenceSystemArray[i] = envelope.getCoordinateReferenceSystem()) != null) continue;
            coordinateReferenceSystemArray = null;
        }
        if (n2 != n) {
            throw new ConcurrentModificationException();
        }
        if (coordinateReferenceSystemArray != null) {
            generalEnvelope.setCoordinateReferenceSystem(CRS.compound(coordinateReferenceSystemArray));
        }
        return generalEnvelope;
    }

    public static GeneralEnvelope union(Envelope ... envelopeArray) throws TransformException {
        return EnvelopeReducer.UNION.reduce(envelopeArray);
    }

    public static GeneralEnvelope intersect(Envelope ... envelopeArray) throws TransformException {
        return EnvelopeReducer.INTERSECT.reduce(envelopeArray);
    }

    public static CoordinateOperation findOperation(Envelope envelope, Envelope envelope2) throws FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem;
        CoordinateReferenceSystem coordinateReferenceSystem2;
        if (envelope != null && envelope2 != null && (coordinateReferenceSystem2 = envelope.getCoordinateReferenceSystem()) != null && (coordinateReferenceSystem = envelope2.getCoordinateReferenceSystem()) != null) {
            DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
            if (coordinateReferenceSystem2 != coordinateReferenceSystem) {
                try {
                    ReferencingServices referencingServices = ReferencingServices.getInstance();
                    defaultGeographicBoundingBox = referencingServices.setBounds(envelope, null, "findOperation");
                    DefaultGeographicBoundingBox defaultGeographicBoundingBox2 = referencingServices.setBounds(envelope2, null, "findOperation");
                    if (defaultGeographicBoundingBox == null) {
                        defaultGeographicBoundingBox = defaultGeographicBoundingBox2;
                    } else if (defaultGeographicBoundingBox2 != null) {
                        defaultGeographicBoundingBox.add(defaultGeographicBoundingBox2);
                    }
                }
                catch (TransformException transformException) {
                    Logging.recoverableException(Logger.getLogger("org.apache.sis.geometry"), Envelopes.class, "findOperation", transformException);
                }
            }
            return CRS.findOperation(coordinateReferenceSystem2, coordinateReferenceSystem, defaultGeographicBoundingBox);
        }
        return null;
    }

    static void recoverableException(Class<? extends Static> clazz, TransformException transformException) {
        Logging.recoverableException(Logger.getLogger("org.apache.sis.geometry"), clazz, "transform", transformException);
    }

    static Matrix derivativeAndTransform(MathTransform mathTransform, double[] dArray, double[] dArray2, int n, boolean bl) throws TransformException {
        if (mathTransform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)mathTransform).transform(dArray, 0, dArray2, n, bl);
        }
        Matrix matrix = bl ? mathTransform.derivative(new DirectPositionView.Double(dArray, 0, mathTransform.getSourceDimensions())) : null;
        mathTransform.transform(dArray, 0, dArray2, n, 1);
        return matrix;
    }

    public static Envelope transform(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem2;
        if (envelope != null && coordinateReferenceSystem != null && (coordinateReferenceSystem2 = envelope.getCoordinateReferenceSystem()) != coordinateReferenceSystem) {
            if (coordinateReferenceSystem2 == null) {
                envelope = new GeneralEnvelope(envelope);
                ((GeneralEnvelope)envelope).setCoordinateReferenceSystem(coordinateReferenceSystem);
            } else {
                CoordinateOperation coordinateOperation;
                try {
                    coordinateOperation = CoordinateOperations.factory().createOperation(coordinateReferenceSystem2, coordinateReferenceSystem);
                }
                catch (FactoryException factoryException) {
                    throw new TransformException(Errors.format((short)16), factoryException);
                }
                envelope = Envelopes.transform(coordinateOperation, envelope);
            }
            assert (Utilities.deepEquals(coordinateReferenceSystem, envelope.getCoordinateReferenceSystem(), ComparisonMode.DEBUG));
        }
        return envelope;
    }

    private static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope, double[] dArray, List<GeneralEnvelope> list) throws TransformException {
        if (mathTransform.isIdentity()) {
            GeneralEnvelope generalEnvelope = new GeneralEnvelope(envelope);
            generalEnvelope.setCoordinateReferenceSystem(null);
            if (dArray != null) {
                int n = envelope.getDimension();
                while (--n >= 0) {
                    dArray[n] = generalEnvelope.getMedian(n);
                }
            }
            return generalEnvelope;
        }
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        if (envelope.getDimension() != n) {
            throw new MismatchedDimensionException(Errors.format((short)80, n, envelope.getDimension()));
        }
        if (n >= 20) {
            throw new IllegalArgumentException(Errors.format((short)37, n));
        }
        boolean bl = true;
        DirectPosition directPosition = null;
        GeneralEnvelope generalEnvelope = null;
        Matrix[] matrixArray = new Matrix[Math.toIntExact(MathFunctions.pow(3L, n))];
        double[] dArray2 = new double[Math.multiplyExact(matrixArray.length, n2)];
        double[] dArray3 = new double[n];
        DirectPositionView.Double double_ = new DirectPositionView.Double(dArray2, 0, n2);
        WraparoundInEnvelope.Controller controller = new WraparoundInEnvelope.Controller(mathTransform);
        do {
            int n3;
            int n4 = n;
            while (--n4 >= 0) {
                dArray3[n4] = envelope.getMinimum(n4);
            }
            n4 = 0;
            block15: while (true) {
                int n5 = n4 * n2;
                try {
                    matrixArray[n4] = Envelopes.derivativeAndTransform(controller.transform, dArray3, dArray2, n5, bl);
                }
                catch (TransformException transformException) {
                    if (!bl) {
                        throw transformException;
                    }
                    bl = false;
                    controller.transform.transform(dArray3, 0, dArray2, n5, 1);
                    Envelopes.recoverableException(Envelopes.class, transformException);
                }
                if (generalEnvelope == null) {
                    generalEnvelope = new GeneralEnvelope(n2);
                    for (int i = 0; i < n2; ++i) {
                        double d = dArray2[n5 + i];
                        generalEnvelope.setRange(i, d, d);
                    }
                } else {
                    double_.offset = n5;
                    generalEnvelope.add(double_);
                }
                n3 = ++n4;
                int n6 = n;
                while (--n6 >= 0) {
                    switch (n3 % 3) {
                        case 0: {
                            dArray3[n6] = envelope.getMinimum(n6);
                            break;
                        }
                        case 1: {
                            dArray3[n6] = envelope.getMaximum(n6);
                            continue block15;
                        }
                        case 2: {
                            dArray3[n6] = envelope.getMedian(n6);
                            continue block15;
                        }
                        default: {
                            throw new AssertionError(n3);
                        }
                    }
                    n3 /= 3;
                }
                break;
            }
            assert (n4 == matrixArray.length) : n4;
            DirectPositionView.Double double_2 = new DirectPositionView.Double(dArray3, 0, n);
            CurveExtremum curveExtremum = new CurveExtremum();
            for (n3 = 0; n3 < matrixArray.length; ++n3) {
                Matrix matrix = matrixArray[n3];
                if (matrix == null) continue;
                int n7 = n3;
                int n8 = 1;
                int n9 = n;
                while (--n9 >= 0) {
                    int n10;
                    Matrix matrix2;
                    int n11 = n7 % 3;
                    if (n11 != 2 && (matrix2 = matrixArray[n10 = n3 + n8 * (2 - n11)]) != null) {
                        double d = envelope.getMinimum(n9);
                        double d2 = envelope.getMaximum(n9);
                        double d3 = envelope.getMedian(n9);
                        double d4 = n11 == 0 ? d : d2;
                        int n12 = n2 * n3;
                        int n13 = n2 * n10;
                        for (int i = 0; i < n2; ++i) {
                            curveExtremum.resolve(d4, dArray2[n12 + i], matrix.getElement(i, n9), d3, dArray2[n13 + i], matrix2.getElement(i, n9));
                            boolean bl2 = false;
                            do {
                                double d5;
                                double d6;
                                double d7 = d6 = bl2 ? curveExtremum.ex2 : curveExtremum.ex1;
                                if (!(d6 > d) || !(d6 < d2)) continue;
                                double d8 = d5 = bl2 ? curveExtremum.ey2 : curveExtremum.ey1;
                                if (!(d5 < generalEnvelope.getMinimum(i)) && !(d5 > generalEnvelope.getMaximum(i))) continue;
                                int n14 = n3;
                                int n15 = n;
                                while (--n15 >= 0) {
                                    double d9;
                                    if (n15 == n9) {
                                        d9 = d6;
                                    } else {
                                        switch (n14 % 3) {
                                            case 0: {
                                                d9 = envelope.getMinimum(n15);
                                                break;
                                            }
                                            case 1: {
                                                d9 = envelope.getMaximum(n15);
                                                break;
                                            }
                                            case 2: {
                                                d9 = envelope.getMedian(n15);
                                                break;
                                            }
                                            default: {
                                                throw new AssertionError(n14);
                                            }
                                        }
                                    }
                                    dArray3[n15] = d9;
                                    n14 /= 3;
                                }
                                directPosition = controller.transform.transform(double_2, directPosition);
                                generalEnvelope.add(directPosition);
                            } while (bl2 = !bl2);
                        }
                    }
                    n7 /= 3;
                    n8 *= 3;
                }
                matrixArray[n3] = null;
            }
            if (dArray != null) {
                System.arraycopy(dArray2, dArray2.length - n2, dArray, 0, n2);
                dArray = null;
            }
            if (list == null) continue;
            list.add(generalEnvelope);
            generalEnvelope = null;
        } while (controller.translate());
        return generalEnvelope;
    }

    public static GeneralEnvelope transform(CoordinateOperation coordinateOperation, Envelope envelope) throws TransformException {
        long l;
        int n;
        int n2;
        Object object;
        Object object2;
        Object object3;
        IdentifiedObject identifiedObject;
        Object object4;
        Object object5;
        ArgumentChecks.ensureNonNull("operation", coordinateOperation);
        if (envelope == null) {
            return null;
        }
        boolean bl = true;
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        if (coordinateReferenceSystem != null && (object5 = envelope.getCoordinateReferenceSystem()) != null && !Utilities.equalsIgnoreMetadata(object5, coordinateReferenceSystem)) {
            try {
                object4 = CoordinateOperations.factory().createOperation((CoordinateReferenceSystem)object5, coordinateReferenceSystem).getMathTransform();
            }
            catch (FactoryException factoryException) {
                throw new TransformException(Errors.format((short)16), factoryException);
            }
            if (!object4.isIdentity()) {
                bl = false;
                envelope = Envelopes.transform((MathTransform)object4, envelope);
            }
        }
        object5 = coordinateOperation.getMathTransform();
        object4 = new double[object5.getTargetDimensions()];
        GeneralEnvelope generalEnvelope = Envelopes.transform((MathTransform)object5, envelope, (double[])object4, null);
        if (coordinateReferenceSystem != null && (identifiedObject = coordinateReferenceSystem.getCoordinateSystem()) != null) {
            object3 = null;
            object2 = null;
            int n3 = identifiedObject.getDimension();
            for (int i = 0; i < n3; ++i) {
                object = identifiedObject.getAxis(i);
                if (object == null) continue;
                double d = envelope.getMinimum(i);
                double d2 = envelope.getMaximum(i);
                double d3 = object.getMinimumValue();
                double d4 = object.getMaximumValue();
                n2 = d3 > d && d3 < d2 ? 1 : 0;
                int n4 = n = d4 > d && d4 < d2 ? 1 : 0;
                if (n2 == 0 && n == 0) continue;
                if (object3 == null) {
                    object3 = new GeneralDirectPosition(n3);
                    for (int j = 0; j < n3; ++j) {
                        object3.setOrdinate(j, envelope.getMedian(j));
                    }
                }
                if (n2 != 0) {
                    object3.setOrdinate(i, d3);
                    object2 = object5.transform((DirectPosition)object3, (DirectPosition)object2);
                    generalEnvelope.add((DirectPosition)object2);
                }
                if (n != 0) {
                    object3.setOrdinate(i, d4);
                    object2 = object5.transform((DirectPosition)object3, (DirectPosition)object2);
                    generalEnvelope.add((DirectPosition)object2);
                }
                object3.setOrdinate(i, envelope.getMedian(i));
            }
        }
        if ((identifiedObject = coordinateOperation.getTargetCRS()) == null) {
            return generalEnvelope;
        }
        generalEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)identifiedObject);
        object3 = identifiedObject.getCoordinateSystem();
        if (object3 == null) {
            return generalEnvelope;
        }
        object2 = null;
        TransformException transformException = null;
        AbstractEnvelope abstractEnvelope = null;
        object = null;
        DirectPosition directPosition = null;
        DirectPosition directPosition2 = null;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        n2 = object3.getDimension();
        block10: for (n = 0; n < n2; ++n) {
            long l5 = Numerics.bitmask(n);
            CoordinateSystemAxis coordinateSystemAxis = object3.getAxis(n);
            if (coordinateSystemAxis == null) continue;
            boolean bl2 = false;
            do {
                double d;
                double d5 = d = bl2 ? coordinateSystemAxis.getMaximumValue() : coordinateSystemAxis.getMinimumValue();
                if (!Double.isFinite(d)) continue;
                if (object2 == null) {
                    try {
                        object2 = object5.inverse();
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        if (n2 < object5.getSourceDimensions()) break block10;
                        transformException = noninvertibleTransformException;
                        break block10;
                    }
                    directPosition = new GeneralDirectPosition((double[])object4.clone());
                    abstractEnvelope = AbstractEnvelope.castOrCopy(envelope);
                }
                directPosition.setOrdinate(n, d);
                try {
                    double d6;
                    object = object2.transform(directPosition, (DirectPosition)object);
                    if (!abstractEnvelope.contains((DirectPosition)object) || CoordinateOperations.isWrapAround(coordinateSystemAxis) && !((d6 = Math.abs((directPosition2 = object5.transform((DirectPosition)object, directPosition2)).getOrdinate(n) - d)) < 0.25 * (coordinateSystemAxis.getMaximumValue() - coordinateSystemAxis.getMinimumValue()))) continue;
                    generalEnvelope.add(directPosition);
                    if (bl2) {
                        l3 |= l5;
                        continue;
                    }
                    l2 |= l5;
                }
                catch (TransformException transformException2) {
                    if (transformException == null) {
                        transformException = transformException2;
                        continue;
                    }
                    transformException.addSuppressed(transformException2);
                }
            } while (bl2 = !bl2);
            if ((l2 & l3 & l5) == 0L && CoordinateOperations.isWrapAround(coordinateSystemAxis)) {
                l4 |= l5;
            }
            if (directPosition == null) continue;
            directPosition.setOrdinate(n, (double)object4[n]);
        }
        if ((l = l2 | l3) != 0L) {
            while (l4 != 0L) {
                long l6;
                int n5 = Long.numberOfTrailingZeros(l4);
                long l7 = Numerics.bitmask(n5);
                l4 &= l7 ^ 0xFFFFFFFFFFFFFFFFL;
                CoordinateSystemAxis coordinateSystemAxis = object3.getAxis(n5);
                double d = coordinateSystemAxis.getMinimumValue();
                double d7 = coordinateSystemAxis.getMaximumValue();
                for (long i = l & (l7 ^ 0xFFFFFFFFFFFFFFFFL); i != 0L; i &= l6 ^ 0xFFFFFFFFFFFFFFFFL) {
                    l6 = Long.lowestOneBit(i);
                    int n6 = Long.numberOfTrailingZeros(l6);
                    CoordinateSystemAxis coordinateSystemAxis2 = object3.getAxis(n6);
                    for (int j = 0; j < 4; ++j) {
                        double d8;
                        if ((j & 1) == 0) {
                            if (((j == 0 ? l2 : l3) & l6) == 0L) {
                                ++j;
                                continue;
                            }
                            directPosition.setOrdinate(n6, j == 0 ? coordinateSystemAxis2.getMinimumValue() : coordinateSystemAxis2.getMaximumValue());
                            d8 = d;
                        } else {
                            d8 = d7;
                        }
                        directPosition.setOrdinate(n5, d8);
                        try {
                            object = object2.transform(directPosition, (DirectPosition)object);
                            if (!abstractEnvelope.contains((DirectPosition)object)) continue;
                            generalEnvelope.add(directPosition);
                            continue;
                        }
                        catch (TransformException transformException3) {
                            if (transformException == null) {
                                transformException = transformException3;
                                continue;
                            }
                            transformException.addSuppressed(transformException3);
                        }
                    }
                    directPosition.setOrdinate(n6, (double)object4[n6]);
                }
                directPosition.setOrdinate(n5, (double)object4[n5]);
            }
        }
        Set<Integer> set = bl && coordinateOperation instanceof AbstractCoordinateOperation ? ((AbstractCoordinateOperation)coordinateOperation).getWrapAroundChanges() : CoordinateOperations.wrapAroundChanges(coordinateReferenceSystem, (CoordinateSystem)object3);
        generalEnvelope.normalize((CoordinateSystem)object3, 0, set.size(), set.iterator());
        if (transformException != null) {
            Envelopes.recoverableException(Envelopes.class, transformException);
        }
        return generalEnvelope;
    }

    public static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope) throws TransformException {
        ArgumentChecks.ensureNonNull("transform", mathTransform);
        return envelope != null ? Envelopes.transform(mathTransform, envelope, null, null) : null;
    }

    public static GeneralEnvelope[] wraparound(MathTransform mathTransform, Envelope envelope) throws TransformException {
        ArgumentChecks.ensureNonNull("transform", mathTransform);
        if (envelope == null) {
            return new GeneralEnvelope[0];
        }
        ArrayList<GeneralEnvelope> arrayList = new ArrayList<GeneralEnvelope>(4);
        GeneralEnvelope generalEnvelope = Envelopes.transform(mathTransform, envelope, null, arrayList);
        if (arrayList.isEmpty() && generalEnvelope != null) {
            return new GeneralEnvelope[]{generalEnvelope};
        }
        return arrayList.toArray(new GeneralEnvelope[arrayList.size()]);
    }

    public static Envelope fromWKT(CharSequence charSequence) throws FactoryException {
        ArgumentChecks.ensureNonNull("wkt", charSequence);
        try {
            return new GeneralEnvelope(charSequence);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(Errors.format((short)154, Envelope.class), illegalArgumentException);
        }
    }

    public static String toString(Envelope envelope) {
        return AbstractEnvelope.toString(envelope, false);
    }

    public static String toPolygonWKT(Envelope envelope) throws IllegalArgumentException {
        double d;
        int n;
        for (n = envelope.getDimension(); n != 0 && !Double.isFinite(d = envelope.getSpan(n - 1)); --n) {
        }
        if (n < 2) {
            throw new IllegalArgumentException(Errors.format((short)31));
        }
        StringBuilder stringBuilder = new StringBuilder("POLYGON(");
        String string = "(";
        for (int i = 0; i < CORNERS.length; i += 2) {
            for (int j = 0; j < n; ++j) {
                double d2;
                switch (j) {
                    case 0: 
                    case 1: {
                        d2 = CORNERS[i + j] ? envelope.getMaximum(j) : envelope.getMinimum(j);
                        break;
                    }
                    default: {
                        d2 = envelope.getMedian(j);
                    }
                }
                StringBuilders.trimFractionalPart(stringBuilder.append(string).append(d2));
                string = " ";
            }
            string = ", ";
        }
        return stringBuilder.append("))").toString();
    }

    public static Optional<Range<Instant>> toTimeRange(Envelope envelope) {
        TemporalAccessor temporalAccessor;
        if (envelope != null && (temporalAccessor = TemporalAccessor.of(envelope.getCoordinateReferenceSystem(), 0)) != null) {
            return Optional.of(temporalAccessor.getTimeRange(envelope));
        }
        return Optional.empty();
    }
}

