/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.EnhancementsImpl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.util.CancelTask;

public class StructureDS
extends Structure
implements VariableEnhanced {
    private static Logger log = LoggerFactory.getLogger(StructureDS.class);
    private EnhancementsImpl proxy;
    protected Structure orgVar;
    private String orgName;

    protected StructureDS(NetcdfFile ncfile, Group group, String shortName) {
        super(ncfile, group, null, shortName);
        this.proxy = new EnhancementsImpl(this);
    }

    public StructureDS(NetcdfDataset ds, Group group, Structure parentStructure, String shortName, String dims, String units, String desc) {
        super(ds, group, parentStructure, shortName);
        this.setDimensions(dims);
        this.proxy = new EnhancementsImpl(this, units, desc);
        if (units != null) {
            this.addAttribute(new Attribute("units", units));
        }
        if (desc != null) {
            this.addAttribute(new Attribute("long_name", desc));
        }
    }

    public StructureDS(Group g2, Structure orgVar) {
        super(orgVar);
        this.setParentGroup(g2);
        this.orgVar = orgVar;
        this.proxy = new EnhancementsImpl(this);
        this.ncfile = null;
        this.spiObject = null;
        this.createNewCache();
        if (orgVar instanceof StructureDS) {
            return;
        }
        ArrayList<Variable> newList = new ArrayList<Variable>(this.members.size());
        for (Variable v : this.members) {
            Variable newVar = this.convertVariable(g2, v);
            newVar.setParentStructure(this);
            newList.add(newVar);
        }
        this.setMemberVariables(newList);
    }

    private Variable convertVariable(Group g2, Variable v) {
        Variable newVar = v instanceof Sequence ? new SequenceDS(g2, (Sequence)v) : (v instanceof Structure ? new StructureDS(g2, (Structure)v) : new VariableDS(g2, v, false));
        return newVar;
    }

    public StructureDS(NetcdfDataset ds, Group group, Structure parent, String shortName, Structure orgVar) {
        super(ds, group, parent, shortName);
        this.spiObject = null;
        this.createNewCache();
        this.orgVar = orgVar;
        this.proxy = new EnhancementsImpl(this);
    }

    @Override
    protected Variable copy() {
        return new StructureDS(this.getParentGroup(), this);
    }

    @Override
    public Structure select(List<String> memberNames) {
        StructureDS result = new StructureDS(this.getParentGroup(), this.orgVar);
        ArrayList<Variable> members = new ArrayList<Variable>();
        for (String name : memberNames) {
            Variable m3 = this.findVariable(name);
            if (null == m3) continue;
            members.add(m3);
        }
        result.setMemberVariables(members);
        result.isSubset = true;
        return result;
    }

    @Override
    public Variable getOriginalVariable() {
        return this.orgVar;
    }

    @Override
    public void setOriginalVariable(Variable orgVar) {
        if (!(orgVar instanceof Structure)) {
            throw new IllegalArgumentException("StructureDS must wrap a Structure; name=" + orgVar.getFullName());
        }
        this.orgVar = (Structure)orgVar;
    }

    public DataType getOriginalDataType() {
        return DataType.STRUCTURE;
    }

    @Override
    public String getOriginalName() {
        return this.orgName;
    }

    @Override
    public String setName(String newName) {
        this.orgName = this.getShortName();
        this.setShortName(newName);
        return newName;
    }

    @Override
    public Array reallyRead(Variable client, CancelTask cancelTask) throws IOException {
        Array result;
        if (this.hasCachedData()) {
            result = super.reallyRead(client, cancelTask);
        } else if (this.orgVar != null) {
            result = this.orgVar.read();
        } else {
            throw new IllegalStateException("StructureDS has no way to get data");
        }
        return this.convert(result, null);
    }

    @Override
    public Array reallyRead(Variable client, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        Array result;
        if (section.computeSize() == this.getSize()) {
            return this._read();
        }
        if (this.hasCachedData()) {
            result = super.reallyRead(client, section, cancelTask);
        } else if (this.orgVar != null) {
            result = this.orgVar.read(section);
        } else {
            throw new IllegalStateException("StructureDS has no way to get data");
        }
        return this.convert(result, section);
    }

    private boolean convertNeeded(StructureMembers smData) {
        for (Variable v : this.getVariables()) {
            StructureDS nested;
            VariableDS vds;
            if (v instanceof VariableDS ? (vds = (VariableDS)v).needConvert() : v instanceof StructureDS && (nested = (StructureDS)v).convertNeeded(null)) {
                return true;
            }
            if (smData == null || this.varHasData(v, smData)) continue;
            return true;
        }
        return false;
    }

    protected ArrayStructure convert(Array data, Section section) throws IOException {
        Array mdata;
        ArrayStructure orgAS = (ArrayStructure)data;
        if (!this.convertNeeded(orgAS.getStructureMembers())) {
            this.convertMemberInfo(orgAS.getStructureMembers());
            return orgAS;
        }
        ArrayStructureMA newAS = ArrayStructureMA.factoryMA(orgAS);
        for (StructureMembers.Member m3 : newAS.getMembers()) {
            VariableEnhanced v2 = (VariableEnhanced)((Object)this.findVariable(m3.getName()));
            if (v2 == null && this.orgVar != null) {
                v2 = this.findVariableFromOrgName(m3.getName());
            }
            if (v2 == null) continue;
            if (v2 instanceof VariableDS) {
                VariableDS vds = (VariableDS)v2;
                if (!vds.needConvert()) continue;
                mdata = newAS.extractMemberArray(m3);
                mdata = vds.convert(mdata);
                newAS.setMemberArray(m3, mdata);
                continue;
            }
            if (!(v2 instanceof StructureDS)) continue;
            StructureDS innerStruct = (StructureDS)v2;
            if (innerStruct.convertNeeded(null)) {
                if (innerStruct.getDataType() == DataType.SEQUENCE) {
                    ArrayObject.D1 seqArray = (ArrayObject.D1)newAS.extractMemberArray(m3);
                    ArrayObject.D1 newSeq = new ArrayObject.D1(ArraySequence.class, (int)seqArray.getSize());
                    m3.setDataArray(newSeq);
                    int i = 0;
                    while ((long)i < seqArray.getSize()) {
                        ArraySequence innerSeq = (ArraySequence)seqArray.get(i);
                        newSeq.set(i, new SequenceConverter(innerStruct, innerSeq));
                        ++i;
                    }
                } else {
                    mdata = newAS.extractMemberArray(m3);
                    mdata = innerStruct.convert(mdata, null);
                    newAS.setMemberArray(m3, mdata);
                }
            }
            innerStruct.convertMemberInfo(m3.getStructureMembers());
        }
        StructureMembers sm = newAS.getStructureMembers();
        this.convertMemberInfo(sm);
        for (Variable v : this.getVariables()) {
            if (this.varHasData(v, sm)) continue;
            try {
                Variable completeVar = this.getParentGroup().findVariable(v.getShortName());
                mdata = completeVar.read(section);
                StructureMembers.Member m4 = sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), v.getShape());
                newAS.setMemberArray(m4, mdata);
            }
            catch (InvalidRangeException e) {
                throw new IOException(e.getMessage());
            }
        }
        return newAS;
    }

    protected StructureData convert(StructureData orgData, int recno) throws IOException {
        if (!this.convertNeeded(orgData.getStructureMembers())) {
            this.convertMemberInfo(orgData.getStructureMembers());
            return orgData;
        }
        StructureMembers smResult = new StructureMembers(orgData.getStructureMembers());
        StructureDataW result = new StructureDataW(smResult);
        for (StructureMembers.Member m3 : orgData.getMembers()) {
            Array mdata;
            VariableEnhanced v2 = (VariableEnhanced)((Object)this.findVariable(m3.getName()));
            if (v2 == null && this.orgVar != null) {
                v2 = this.findVariableFromOrgName(m3.getName());
            }
            if (v2 == null) {
                this.findVariableFromOrgName(m3.getName());
                continue;
            }
            StructureMembers.Member mResult = smResult.findMember(m3.getName());
            if (v2 instanceof VariableDS) {
                VariableDS vds = (VariableDS)v2;
                mdata = orgData.getArray(m3);
                if (vds.needConvert()) {
                    mdata = vds.convert(mdata);
                }
                result.setMemberData(mResult, mdata);
            }
            if (!(v2 instanceof StructureDS)) continue;
            StructureDS innerStruct = (StructureDS)v2;
            if (innerStruct.getDataType() == DataType.SEQUENCE) {
                Array seqArray;
                Array a = orgData.getArray(m3);
                if (a instanceof ArrayObject.D1) {
                    seqArray = (ArrayObject.D1)a;
                    ArrayObject.D1 newSeq = new ArrayObject.D1(ArraySequence.class, (int)seqArray.getSize());
                    mResult.setDataArray(newSeq);
                    int i = 0;
                    while ((long)i < seqArray.getSize()) {
                        ArraySequence innerSeq = (ArraySequence)((ArrayObject.D1)seqArray).get(i);
                        newSeq.set(i, new SequenceConverter(innerStruct, innerSeq));
                        ++i;
                    }
                } else {
                    seqArray = (ArraySequence)a;
                    result.setMemberData(mResult, (Array)new SequenceConverter(innerStruct, (ArraySequence)seqArray));
                }
            } else {
                mdata = orgData.getArray(m3);
                mdata = innerStruct.convert(mdata, null);
                result.setMemberData(mResult, mdata);
            }
            innerStruct.convertMemberInfo(mResult.getStructureMembers());
        }
        StructureMembers sm = result.getStructureMembers();
        this.convertMemberInfo(sm);
        for (Variable v : this.getVariables()) {
            if (this.varHasData(v, sm)) continue;
            try {
                Variable completeVar = this.getParentGroup().findVariable(v.getShortName());
                Array mdata = completeVar.read(new Section().appendRange(recno, recno));
                StructureMembers.Member m4 = sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), v.getShape());
                result.setMemberData(m4, mdata);
            }
            catch (InvalidRangeException e) {
                throw new IOException(e.getMessage());
            }
        }
        return result;
    }

    private void convertMemberInfo(StructureMembers wrapperSm) {
        for (StructureMembers.Member m3 : wrapperSm.getMembers()) {
            Variable v = this.findVariable(m3.getName());
            if (v == null && this.orgVar != null) {
                v = (Variable)((Object)this.findVariableFromOrgName(m3.getName()));
            }
            if (v != null) {
                m3.setVariableInfo(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType());
            }
            if (!(v instanceof StructureDS)) continue;
            StructureDS innerStruct = (StructureDS)v;
            innerStruct.convertMemberInfo(m3.getStructureMembers());
        }
    }

    private VariableEnhanced findVariableFromOrgName(String orgName) {
        Iterator<Variable> i$ = this.getVariables().iterator();
        while (i$.hasNext()) {
            Variable vTop;
            Variable v = vTop = i$.next();
            while (v instanceof VariableEnhanced) {
                VariableEnhanced ve = (VariableEnhanced)((Object)v);
                if (ve.getOriginalName() != null && ve.getOriginalName().equals(orgName)) {
                    return (VariableEnhanced)((Object)vTop);
                }
                v = ve.getOriginalVariable();
            }
        }
        return null;
    }

    private boolean varHasData(Variable v, StructureMembers sm) {
        if (sm.findMember(v.getShortName()) != null) {
            return true;
        }
        while (v instanceof VariableEnhanced) {
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            if (sm.findMember(ve.getOriginalName()) != null) {
                return true;
            }
            v = ve.getOriginalVariable();
        }
        return false;
    }

    @Override
    public void enhance(Set<NetcdfDataset.Enhance> mode) {
        for (Variable v : this.getVariables()) {
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            ve.enhance(mode);
        }
    }

    @Override
    public void clearCoordinateSystems() {
        this.proxy = new EnhancementsImpl(this, this.getUnitsString(), this.getDescription());
    }

    @Override
    public void addCoordinateSystem(CoordinateSystem p0) {
        this.proxy.addCoordinateSystem(p0);
    }

    @Override
    public void removeCoordinateSystem(CoordinateSystem p0) {
        this.proxy.removeCoordinateSystem(p0);
    }

    @Override
    public List<CoordinateSystem> getCoordinateSystems() {
        return this.proxy.getCoordinateSystems();
    }

    @Override
    public String getDescription() {
        return this.proxy.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.proxy.getUnitsString();
    }

    @Override
    public void setUnitsString(String units) {
        this.proxy.setUnitsString(units);
    }

    private static class StructureDataConverter
    implements StructureDataIterator {
        private StructureDataIterator orgIter;
        private StructureDS newStruct;
        private int count = 0;

        StructureDataConverter(StructureDS newStruct, StructureDataIterator orgIter) {
            this.newStruct = newStruct;
            this.orgIter = orgIter;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.orgIter.hasNext();
        }

        @Override
        public StructureData next() throws IOException {
            StructureData sdata = this.orgIter.next();
            return this.newStruct.convert(sdata, this.count++);
        }

        @Override
        public void setBufferSize(int bytes) {
            this.orgIter.setBufferSize(bytes);
        }

        @Override
        public StructureDataIterator reset() {
            this.orgIter = this.orgIter.reset();
            return this.orgIter == null ? null : this;
        }

        @Override
        public int getCurrentRecno() {
            return this.orgIter.getCurrentRecno();
        }

        @Override
        public void finish() {
            this.orgIter.finish();
        }
    }

    private static class SequenceConverter
    extends ArraySequence {
        StructureDS orgStruct;
        ArraySequence orgSeq;

        SequenceConverter(StructureDS orgStruct, ArraySequence orgSeq) {
            super(orgSeq.getStructureMembers(), orgSeq.getShape());
            this.orgStruct = orgStruct;
            this.orgSeq = orgSeq;
            this.nelems = orgSeq.getStructureDataCount();
            this.members = new StructureMembers(orgSeq.getStructureMembers());
            orgStruct.convertMemberInfo(this.members);
        }

        @Override
        public StructureDataIterator getStructureDataIterator() {
            return new StructureDataConverter(this.orgStruct, this.orgSeq.getStructureDataIterator());
        }
    }
}

