/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.LocalizedException;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.InternationalString;

final class MetadataVisitorException
extends BackingStoreException
implements LocalizedException {
    private static final long serialVersionUID = 3779183393705626697L;
    private final String[] propertyPath;

    public MetadataVisitorException(String[] stringArray, Class<?> clazz, Exception exception) {
        super(clazz.getSimpleName(), exception);
        this.propertyPath = stringArray;
    }

    @Override
    public String getMessage() {
        return this.getInternationalMessage().toString();
    }

    @Override
    public InternationalString getInternationalMessage() {
        short s2 = 152;
        int n = 2;
        String string = super.getMessage();
        int n2 = this.propertyPath.length;
        if (n2 != 0) {
            string = string + '.' + this.propertyPath[--n2];
            if (n2 != 0) {
                s2 = 184;
                n = 3;
            }
        }
        Throwable throwable = this.getCause();
        Object object = null;
        if (throwable instanceof LocalizedException) {
            object = ((LocalizedException)((Object)throwable)).getInternationalMessage();
        }
        if (object == null && (object = throwable.getLocalizedMessage()) == null) {
            object = throwable.getClass();
        }
        Object[] objectArray = new Object[n];
        objectArray[--n] = object;
        objectArray[--n] = string;
        if (n != 0) {
            objectArray[0] = String.join((CharSequence)".", UnmodifiableArrayList.wrap(this.propertyPath, 0, n2));
        }
        return Errors.formatInternational(s2, objectArray);
    }
}

