/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.esri;

import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferFloat;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.storage.RangeArgument;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.esri.AsciiGridStoreProvider;
import org.apache.sis.internal.storage.esri.CharactersView;
import org.apache.sis.internal.storage.esri.RasterStore;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.datum.PixelInCell;

class AsciiGridStore
extends RasterStore {
    static final String XLLCORNER = "XLLCORNER";
    static final String YLLCORNER = "YLLCORNER";
    static final String XLLCENTER = "XLLCENTER";
    static final String YLLCENTER = "YLLCENTER";
    static final String CELLSIZE = "CELLSIZE";
    static final String NODATA_VALUE = "NODATA_VALUE";
    static final String[] CELLSIZES = new String[]{"XCELLSIZE", "YCELLSIZE", "XDIM", "YDIM", "DX", "DY"};
    private static final double DEFAULT_NODATA = -9999.0;
    private CharactersView input;
    private int width;
    private int height;
    private String nodataText;
    private GridGeometry gridGeometry;
    private GridCoverage coverage;

    AsciiGridStore(AsciiGridStoreProvider asciiGridStoreProvider, StorageConnector storageConnector, boolean bl) throws DataStoreException {
        super(asciiGridStoreProvider, storageConnector);
        ChannelDataInput channelDataInput;
        if (bl) {
            channelDataInput = storageConnector.commit(ChannelDataInput.class, "ASCII Grid");
        } else {
            channelDataInput = storageConnector.getStorageAs(ChannelDataInput.class);
            if (channelDataInput != null) {
                storageConnector.closeAllExcept(channelDataInput);
            }
        }
        if (channelDataInput != null) {
            this.input = new CharactersView(channelDataInput, channelDataInput.buffer);
        }
    }

    boolean canReadOrWrite(boolean bl) {
        return !bl && this.input != null;
    }

    private void readHeader() throws DataStoreException {
        if (this.gridGeometry == null) {
            try {
                Object object;
                Map<String, String> map = this.input().readHeader();
                Matrix3 matrix3 = new Matrix3();
                PixelInCell pixelInCell = PixelInCell.CELL_CORNER;
                String string = null;
                try {
                    int n;
                    int n2;
                    block21: {
                        string = "NCOLS";
                        this.width = Integer.parseInt(this.getHeaderValue(map, "NCOLS"));
                        string = "NROWS";
                        this.height = Integer.parseInt(this.getHeaderValue(map, "NROWS"));
                        string = CELLSIZE;
                        object = map.remove(CELLSIZE);
                        if (object != null) {
                            matrix3.m00 = Double.parseDouble((String)object);
                            matrix3.m11 = -matrix3.m00;
                        } else {
                            n2 = 0;
                            n = 0;
                            while (n < CELLSIZES.length) {
                                if ((object = map.remove(string = CELLSIZES[n++])) != null) {
                                    matrix3.m00 = Double.parseDouble((String)object);
                                    n2 |= 1;
                                }
                                if ((object = map.remove(string = CELLSIZES[n++])) != null) {
                                    matrix3.m11 = -Double.parseDouble((String)object);
                                    n2 |= 2;
                                }
                                if (n2 != 3) continue;
                                break block21;
                            }
                            throw new DataStoreContentException(this.messageForProperty((short)197, CELLSIZE));
                        }
                    }
                    string = XLLCENTER;
                    object = map.remove(XLLCENTER);
                    int n3 = n2 = object != null ? 1 : 0;
                    if (n2 == 0) {
                        string = XLLCORNER;
                        object = this.getHeaderValue(map, XLLCORNER);
                    }
                    matrix3.m02 = Double.parseDouble((String)object);
                    string = YLLCENTER;
                    object = map.remove(YLLCENTER);
                    int n4 = n = object != null ? 1 : 0;
                    if (n == 0) {
                        string = YLLCORNER;
                        object = this.getHeaderValue(map, YLLCORNER);
                    }
                    matrix3.m12 = Double.parseDouble((String)object) - matrix3.m11 * (double)this.height;
                    if ((n2 & n) != 0) {
                        pixelInCell = PixelInCell.CELL_CENTER;
                    } else if (n2 != n) {
                        matrix3.convertBefore(n2 != 0 ? 0 : 1, null, -0.5);
                    }
                    string = NODATA_VALUE;
                    this.nodataText = map.remove(NODATA_VALUE);
                    if (this.nodataText != null) {
                        try {
                            this.nodataValue = Double.parseDouble(this.nodataText);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.nodataValue = Double.NaN;
                            this.listeners.warning(this.messageForProperty((short)196, string), numberFormatException);
                        }
                    } else {
                        this.nodataValue = -9999.0;
                        this.nodataText = "null";
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataStoreContentException(this.messageForProperty((short)196, string), numberFormatException);
                }
                this.readPRJ();
                this.gridGeometry = new GridGeometry(new GridExtent((long)this.width, this.height), pixelInCell, MathTransforms.linear(matrix3), this.crs);
                if (!map.isEmpty()) {
                    object = new StringJoiner(", ");
                    map.keySet().forEach(((StringJoiner)object)::add);
                    this.listeners.warning(this.messageForProperty((short)141, ((StringJoiner)object).toString()));
                }
            }
            catch (DataStoreException dataStoreException) {
                this.closeOnError(dataStoreException);
                throw dataStoreException;
            }
            catch (Exception exception) {
                this.closeOnError(exception);
                throw new DataStoreException(exception);
            }
        }
    }

    private String messageForProperty(short s2, String string) {
        return Errors.getResources(this.getLocale()).getString(s2, this.input.input.filename, string);
    }

    private String getHeaderValue(Map<String, String> map, String string) throws DataStoreException {
        String string2 = map.remove(string);
        if (string2 == null) {
            throw new DataStoreContentException(this.messageForProperty((short)197, string));
        }
        return string2;
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            this.createMetadata("ASCII Grid", "ASCGRD");
        }
        return this.metadata;
    }

    @Override
    public synchronized GridGeometry getGridGeometry() throws DataStoreException {
        this.readHeader();
        return this.gridGeometry;
    }

    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        return this.read(null, null).getSampleDimensions();
    }

    @Override
    public synchronized GridCoverage read(GridGeometry gridGeometry, int ... nArray) throws DataStoreException {
        RangeArgument rangeArgument = RangeArgument.validate(1, nArray, this.listeners);
        if (this.coverage == null) {
            try {
                Object object;
                this.readHeader();
                CharactersView charactersView = this.input();
                String string = charactersView.input.filename;
                Statistics statistics = new Statistics(string);
                float[] fArray = new float[this.width * this.height];
                for (int i = 0; i < fArray.length; ++i) {
                    double d;
                    object = charactersView.readToken();
                    try {
                        d = Double.parseDouble((String)object);
                        if (d == this.nodataValue) {
                            d = Double.NaN;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (((String)object).equalsIgnoreCase(this.nodataText)) {
                            d = Double.NaN;
                        }
                        throw new DataStoreContentException(Resources.forLocale(this.getLocale()).getString((short)68, i % this.width, i / this.width, string), numberFormatException);
                    }
                    fArray[i] = (float)d;
                    statistics.accept(d);
                }
                if (!this.canReadOrWrite(true)) {
                    this.input = null;
                    charactersView.input.channel.close();
                }
                BandedSampleModel bandedSampleModel = new BandedSampleModel(4, this.width, this.height, 1);
                this.loadBandDescriptions(string, bandedSampleModel, statistics);
                object = new DataBufferFloat(fArray, fArray.length);
                WritableRaster writableRaster = WritableRaster.createWritableRaster(bandedSampleModel, (DataBuffer)object, null);
                this.coverage = this.createCoverage(this.gridGeometry, rangeArgument, writableRaster, statistics);
            }
            catch (DataStoreException dataStoreException) {
                this.closeOnError(dataStoreException);
                throw dataStoreException;
            }
            catch (Exception exception) {
                this.closeOnError(exception);
                throw new DataStoreException(exception);
            }
        }
        return this.coverage;
    }

    final Number setCoverage(GridCoverage gridCoverage, RenderedImage renderedImage, int n) {
        this.coverage = gridCoverage;
        this.gridGeometry = gridCoverage.getGridGeometry();
        this.crs = this.gridGeometry.isDefined(1) ? this.gridGeometry.getCoordinateReferenceSystem() : null;
        this.width = renderedImage.getWidth();
        this.height = renderedImage.getHeight();
        this.metadata = null;
        this.nodataText = "null";
        this.nodataValue = Double.NaN;
        SampleDimension sampleDimension = gridCoverage.getSampleDimensions().get(n);
        NumberRange numberRange = sampleDimension.getSampleRange().orElse(null);
        if (numberRange != null) {
            try {
                for (Number number : sampleDimension.forConvertedValues(false).getNoDataValues()) {
                    if (numberRange.containsAny(number)) continue;
                    this.nodataValue = number.doubleValue();
                    return number;
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.listeners.warning(illegalStateException);
            }
            if (numberRange.containsAny(-9999.0)) {
                this.nodataValue = -9999.0;
            }
        }
        return this.nodataValue;
    }

    final CharactersView input() throws DataStoreException {
        CharactersView charactersView = this.input;
        if (charactersView == null) {
            throw new DataStoreClosedException(this.getLocale(), "ASCII Grid", StandardOpenOption.READ);
        }
        return charactersView;
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.listeners.close();
        CharactersView charactersView = this.input;
        this.input = null;
        this.coverage = null;
        this.gridGeometry = null;
        super.close();
        if (charactersView != null) {
            try {
                charactersView.input.channel.close();
            }
            catch (IOException iOException) {
                throw new DataStoreException(iOException);
            }
        }
    }

    final void closeOnError(Throwable throwable) {
        try {
            this.close();
        }
        catch (Throwable throwable2) {
            throwable.addSuppressed(throwable2);
        }
    }
}

