/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.NilReason;

public final class ImplementationHelper
extends Static {
    public static final String ISO_NAMESPACE = "http://standards.iso.org/iso/";

    private ImplementationHelper() {
    }

    public static long toMilliseconds(Date date) {
        return date != null ? date.getTime() : Long.MIN_VALUE;
    }

    public static Date toDate(long l) {
        return l != Long.MIN_VALUE ? new Date(l) : null;
    }

    public static Collection<?> valueIfDefined(Collection<?> collection) {
        return collection == null || collection.isEmpty() ? null : collection;
    }

    public static boolean ensurePositive(Class<?> clazz, String string, boolean bl, Number number) throws IllegalArgumentException {
        if (number != null) {
            double d = number.doubleValue();
            if (!(!bl ? d >= 0.0 : d > 0.0) && NilReason.forObject(number) == null) {
                String string2 = ImplementationHelper.logOrFormat(clazz, string, bl ? (short)165 : 92, string, number);
                if (string2 != null) {
                    throw new IllegalArgumentException(string2);
                }
                return false;
            }
        }
        return true;
    }

    public static boolean ensureInRange(Class<?> clazz, String string, Number number, Number number2, Number number3) throws IllegalArgumentException {
        double d;
        if (!(number3 == null || (d = number3.doubleValue()) >= number.doubleValue() && d <= number2.doubleValue() || NilReason.forObject(number3) != null)) {
            String string2 = ImplementationHelper.logOrFormat(clazz, string, (short)166, string, number, number2, number3);
            if (string2 != null) {
                throw new IllegalArgumentException(string2);
            }
            return false;
        }
        return true;
    }

    private static String logOrFormat(Class<?> clazz, String string, short s2, Object ... objectArray) {
        Context context = Context.current();
        if (context == null) {
            return Errors.format(s2, objectArray);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 3).append("set").append(string);
        stringBuilder.setCharAt(3, Character.toUpperCase(stringBuilder.charAt(3)));
        Context.warningOccured(context, clazz, stringBuilder.toString(), Errors.class, s2, objectArray);
        return null;
    }

    public static void propertyAlreadySet(Class<?> clazz, String string, String string2) throws IllegalStateException {
        Context context = Context.current();
        if (context == null) {
            throw new IllegalStateException(Errors.format((short)27, string2));
        }
        Context.warningOccured(context, clazz, string, Errors.class, (short)27, string2);
    }

    public static <T> Collection<T> setFirst(Collection<T> collection, T t) {
        if (collection == null) {
            return CollectionsExt.singletonOrEmpty(t);
        }
        if (t == null) {
            Iterator<T> iterator = collection.iterator();
            if (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        } else if (collection.isEmpty()) {
            collection.add(t);
        } else {
            if (!(collection instanceof List)) {
                collection = new ArrayList<T>(collection);
            }
            ((List)collection).set(0, t);
        }
        return collection;
    }

    public static String getObjectID(IdentifiedObject identifiedObject) {
        Context context = Context.current();
        String string = Context.getObjectID(context, identifiedObject);
        if (string == null && (string = identifiedObject.getIdentifierMap().getSpecialized(IdentifierSpace.ID)) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!Strings.appendUnicodeIdentifier(stringBuilder, '\u0000', string, ":-", false)) {
                return null;
            }
            string = stringBuilder.toString();
            if (!Context.setObjectForID(context, identifiedObject, string)) {
                int n = stringBuilder.append('-').length();
                int n2 = 0;
                do {
                    if (++n2 == 100) {
                        return null;
                    }
                    string = stringBuilder.append(n2).toString();
                    stringBuilder.setLength(n);
                } while (!Context.setObjectForID(context, identifiedObject, string));
            }
        }
        return string;
    }

    public static void setObjectID(IdentifiedObject identifiedObject, String string) {
        if ((string = CharSequences.trimWhitespaces(string)) != null && !string.isEmpty()) {
            identifiedObject.getIdentifierMap().putSpecialized(IdentifierSpace.ID, string);
            Context context = Context.current();
            if (!Context.setObjectForID(context, identifiedObject, string)) {
                Context.warningOccured(context, identifiedObject.getClass(), "setID", Errors.class, (short)25, string);
            }
        }
    }
}

