/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.resources;

import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.InternationalString;

public final class Vocabulary
extends IndexedResourceBundle {
    Vocabulary(URL uRL) {
        super(uRL);
    }

    @Override
    protected KeyConstants getKeyConstants() {
        return Keys.INSTANCE;
    }

    public static Vocabulary getResources(Locale locale) throws MissingResourceException {
        return Vocabulary.getBundle(Vocabulary.class, locale);
    }

    public static Vocabulary getResources(Map<?, ?> map) throws MissingResourceException {
        return Vocabulary.getResources(Vocabulary.getLocale(map));
    }

    public static String format(short s2) throws MissingResourceException {
        return Vocabulary.getResources((Locale)null).getString(s2);
    }

    public static InternationalString formatInternational(short s2) {
        return new International(s2);
    }

    public static InternationalString formatInternational(short s2, Object object) {
        return new International(s2, object);
    }

    public static InternationalString formatInternational(short s2, Object ... objectArray) {
        return new International(s2, objectArray);
    }

    private static final class International
    extends ResourceInternationalString {
        private static final long serialVersionUID = -5423999784169092823L;

        International(short s2) {
            super(s2);
        }

        International(short s2, Object object) {
            super(s2, object);
        }

        @Override
        protected KeyConstants getKeyConstants() {
            return Keys.INSTANCE;
        }

        @Override
        protected IndexedResourceBundle getBundle(Locale locale) {
            return Vocabulary.getResources(locale);
        }
    }

    public static final class Keys
    extends KeyConstants {
        static final Keys INSTANCE = new Keys();
        public static final short Accuracy = 1;
        public static final short Administrator = 130;
        public static final short Aliases = 2;
        public static final short AlternativeIdentifiers = 131;
        public static final short Angle = 3;
        public static final short AngularDegrees = 4;
        public static final short AngularMinutes = 5;
        public static final short AngularSeconds = 6;
        public static final short Attributes = 7;
        public static final short AxisChanges = 8;
        public static final short Azimuth = 168;
        public static final short Band_1 = 161;
        public static final short BarometricAltitude = 9;
        public static final short Cardinality = 10;
        public static final short CausedBy_1 = 11;
        public static final short CellCount_1 = 149;
        public static final short CharacterEncoding = 12;
        public static final short Characteristics = 13;
        public static final short Classpath = 14;
        public static final short Code = 128;
        public static final short Code_1 = 15;
        public static final short Commands = 16;
        public static final short ConstantPressureSurface = 17;
        public static final short Container = 18;
        public static final short Conversion = 150;
        public static final short Coordinate = 129;
        public static final short CoordinateRefSys = 132;
        public static final short Correlation = 19;
        public static final short CoverageDomain = 162;
        public static final short CurrentDateTime = 20;
        public static final short CurrentDirectory = 21;
        public static final short CycleOmitted = 22;
        public static final short DataBase = 23;
        public static final short DataDirectory = 24;
        public static final short DataFormats = 119;
        public static final short Datum = 25;
        public static final short DatumShift = 26;
        public static final short DaylightTime = 27;
        public static final short DefaultValue = 28;
        public static final short Deprecated = 29;
        public static final short DerivedFrom_1 = 30;
        public static final short Description = 31;
        public static final short Designation = 142;
        public static final short Destination = 32;
        public static final short Details = 33;
        public static final short DigitalElevationModel = 146;
        public static final short Dimension_1 = 148;
        public static final short Dimensions = 34;
        public static final short Directory = 35;
        public static final short DittoMark = 36;
        public static final short Domain = 37;
        public static final short DublinJulian = 38;
        public static final short EastBound = 133;
        public static final short Ellipsoid = 39;
        public static final short EllipsoidChange = 40;
        public static final short EllipsoidalHeight = 41;
        public static final short EndDate = 134;
        public static final short EndPoint = 169;
        public static final short EntryCount_1 = 121;
        public static final short Envelope = 151;
        public static final short Errors = 167;
        public static final short Exit = 143;
        public static final short File = 144;
        public static final short FillValue = 159;
        public static final short Geocentric = 42;
        public static final short GeocentricConversion = 43;
        public static final short GeocentricRadius = 44;
        public static final short GeodesicDistance = 170;
        public static final short GeodeticDataset = 45;
        public static final short GeographicExtent = 172;
        public static final short GeographicIdentifier = 135;
        public static final short GridExtent = 152;
        public static final short Height = 46;
        public static final short Identifier = 47;
        public static final short Identity = 48;
        public static final short Implementation = 49;
        public static final short InBetweenWords = 50;
        public static final short Index = 51;
        public static final short Invalid = 52;
        public static final short InverseOperation = 53;
        public static final short JavaExtensions = 54;
        public static final short JavaHome = 55;
        public static final short Julian = 56;
        public static final short Latitude = 57;
        public static final short Legend = 58;
        public static final short Level = 59;
        public static final short Libraries = 60;
        public static final short LinearTransformation = 165;
        public static final short LocalConfiguration = 61;
        public static final short Locale = 62;
        public static final short Localization = 63;
        public static final short LocationType = 136;
        public static final short Logging = 64;
        public static final short Longitude = 65;
        public static final short LowerBound = 173;
        public static final short Mandatory = 66;
        public static final short Mapping = 127;
        public static final short MaximumValue = 67;
        public static final short MeanValue = 68;
        public static final short Measures = 157;
        public static final short Methods = 69;
        public static final short MinimumValue = 70;
        public static final short MissingValue = 160;
        public static final short ModifiedJulian = 71;
        public static final short Multiplicity = 147;
        public static final short Name = 72;
        public static final short Nodata = 156;
        public static final short None = 73;
        public static final short NorthBound = 137;
        public static final short Note = 74;
        public static final short NumberOfNaN = 75;
        public static final short NumberOfValues = 76;
        public static final short Obligation = 77;
        public static final short Of_3 = 78;
        public static final short Offset = 79;
        public static final short Open = 145;
        public static final short OperatingSystem = 80;
        public static final short Operations = 81;
        public static final short Optional = 82;
        public static final short Options = 83;
        public static final short OriginInCellCenter = 155;
        public static final short OtherSurface = 84;
        public static final short Others = 85;
        public static final short Parenthesis_2 = 126;
        public static final short Paths = 86;
        public static final short Plugins = 120;
        public static final short Preprocessing = 166;
        public static final short Quoted_1 = 87;
        public static final short Read = 122;
        public static final short Remarks = 88;
        public static final short RemoteConfiguration = 89;
        public static final short RepresentativeValue = 141;
        public static final short Resolution = 153;
        public static final short Result = 164;
        public static final short Root = 90;
        public static final short RootMeanSquare = 91;
        public static final short SampleDimensions = 163;
        public static final short Scale = 92;
        public static final short SlashSeparatedList_2 = 124;
        public static final short Source = 93;
        public static final short SouthBound = 138;
        public static final short StandardDeviation = 94;
        public static final short StartDate = 139;
        public static final short StartPoint = 171;
        public static final short SubsetOf_1 = 95;
        public static final short SupersededBy_1 = 96;
        public static final short Temporal = 97;
        public static final short TemporalExtent = 175;
        public static final short TemporaryFiles = 98;
        public static final short Time = 99;
        public static final short Time_1 = 100;
        public static final short Timezone = 101;
        public static final short Transformation = 102;
        public static final short TransformationAccuracy = 103;
        public static final short TruncatedJulian = 104;
        public static final short Type = 105;
        public static final short UnavailableContent = 106;
        public static final short Units = 107;
        public static final short Unknown = 125;
        public static final short Unnamed = 108;
        public static final short Unspecified = 154;
        public static final short Untitled = 109;
        public static final short UpperBound = 174;
        public static final short UserHome = 110;
        public static final short Value = 111;
        public static final short ValueDomain = 112;
        public static final short Values = 158;
        public static final short Variables = 113;
        public static final short Version_2 = 114;
        public static final short Versions = 115;
        public static final short Vertical = 116;
        public static final short Warnings = 117;
        public static final short WestBound = 140;
        public static final short World = 118;
        public static final short Write = 123;

        private Keys() {
        }
    }
}

