/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.QuietLogRecord;
import org.apache.sis.util.logging.WarningListener;
import org.apache.sis.util.resources.Errors;

@Deprecated
public class WarningListeners<S>
implements Localized {
    private final S source;
    private WarningListener<? super S>[] listeners;

    public WarningListeners(S s2) {
        this.source = s2;
    }

    public WarningListeners(S s2, WarningListeners<? super S> warningListeners) {
        this(s2);
        if (warningListeners != null) {
            this.listeners = warningListeners.listeners;
        }
    }

    public S getSource() {
        return this.source;
    }

    @Override
    public Locale getLocale() {
        return this.source instanceof Localized ? ((Localized)this.source).getLocale() : null;
    }

    public Logger getLogger() {
        return Logging.getLogger(this.source.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warning(LogRecord logRecord) {
        WarningListener<? super S>[] warningListenerArray;
        WarningListeners object = this;
        synchronized (object) {
            warningListenerArray = this.listeners;
        }
        if (warningListenerArray != null) {
            for (WarningListener<S> warningListener : warningListenerArray) {
                warningListener.warningOccured(this.source, logRecord);
            }
        } else {
            Logger logger;
            String string = logRecord.getLoggerName();
            if (string != null) {
                logger = Logging.getLogger(string);
            } else {
                logger = this.getLogger();
                logRecord.setLoggerName(logger.getName());
            }
            if (logRecord instanceof QuietLogRecord) {
                ((QuietLogRecord)logRecord).clearThrown();
            }
            logger.log(logRecord);
        }
    }

    public void warning(String string, Exception exception) {
        this.warning(Level.WARNING, string, exception);
    }

    public void warning(Level level, String string, Exception exception) {
        LogRecord logRecord;
        StackTraceElement[] stackTraceElementArray;
        ArgumentChecks.ensureNonNull("level", level);
        if (exception != null) {
            stackTraceElementArray = exception.getStackTrace();
            string = Exceptions.formatChainedMessages(this.getLocale(), string, exception);
            if (string == null) {
                string = exception.toString();
            }
            logRecord = new QuietLogRecord(level, string, exception);
        } else {
            ArgumentChecks.ensureNonEmpty("message", string);
            stackTraceElementArray = Thread.currentThread().getStackTrace();
            logRecord = new LogRecord(level, string);
        }
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (!WarningListeners.isPublic(stackTraceElement)) continue;
            logRecord.setSourceClassName(stackTraceElement.getClassName());
            logRecord.setSourceMethodName(stackTraceElement.getMethodName());
            break;
        }
        this.warning(logRecord);
    }

    static boolean isPublic(StackTraceElement stackTraceElement) {
        String string = stackTraceElement.getClassName();
        if (string.startsWith("java") || string.startsWith("org.apache.sis.internal.") || string.indexOf(36) >= 0 || stackTraceElement.getMethodName().indexOf(36) >= 0) {
            return false;
        }
        if (string.startsWith("org.apache.sis.util.logging.")) {
            return string.endsWith("Test");
        }
        return true;
    }

    public synchronized void addWarningListener(WarningListener<? super S> warningListener) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("listener", warningListener);
        WarningListener<? super S>[] warningListenerArray = this.listeners;
        int n = warningListenerArray != null ? warningListenerArray.length : 0;
        WarningListener[] warningListenerArray2 = new WarningListener[n + 1];
        for (int i = 0; i < n; ++i) {
            WarningListener<? super S> warningListener2 = warningListenerArray[i];
            if (warningListener2 == warningListener) {
                throw new IllegalArgumentException(Errors.format((short)27, warningListener));
            }
            warningListenerArray2[i] = warningListener2;
        }
        warningListenerArray2[n] = warningListener;
        this.listeners = warningListenerArray2;
    }

    public synchronized void removeWarningListener(WarningListener<? super S> warningListener) throws NoSuchElementException {
        ArgumentChecks.ensureNonNull("listener", warningListener);
        WarningListener<? super S>[] warningListenerArray = this.listeners;
        if (warningListenerArray != null) {
            for (int i = 0; i < warningListenerArray.length; ++i) {
                if (warningListenerArray[i] != warningListener) continue;
                if (warningListenerArray.length == 1) {
                    this.listeners = null;
                } else {
                    WarningListener[] warningListenerArray2 = new WarningListener[warningListenerArray.length - 1];
                    System.arraycopy(warningListenerArray, 0, warningListenerArray2, 0, i);
                    System.arraycopy(warningListenerArray, i + 1, warningListenerArray2, i, warningListenerArray2.length - i);
                    this.listeners = warningListenerArray2;
                }
                return;
            }
        }
        throw new NoSuchElementException(Errors.format((short)28, warningListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WarningListener<? super S>> getListeners() {
        WarningListener<? super S>[] warningListenerArray;
        WarningListeners warningListeners = this;
        synchronized (warningListeners) {
            warningListenerArray = this.listeners;
        }
        return warningListenerArray != null ? UnmodifiableArrayList.wrap(warningListenerArray) : Collections.emptyList();
    }

    public synchronized boolean hasListeners() {
        return this.listeners != null;
    }
}

