/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

public class TableColumn<V>
implements CheckedContainer<V> {
    public static final TableColumn<CharSequence> NAME = new Constant<CharSequence>("NAME", CharSequence.class, 72);
    public static final TableColumn<String> IDENTIFIER = new Constant<String>("IDENTIFIER", String.class, 47);
    public static final TableColumn<Integer> INDEX = new Constant<Integer>("INDEX", Integer.class, 51);
    public static final TableColumn<Class<?>> TYPE = new Constant<Class>("TYPE", Class.class, 105);
    public static final TableColumn<Object> VALUE = new Constant<Object>("VALUE", Object.class, 111);
    public static final TableColumn<CharSequence> VALUE_AS_TEXT = new Constant<CharSequence>("VALUE_AS_TEXT", CharSequence.class, 111);
    public static final TableColumn<Number> VALUE_AS_NUMBER = new Constant<Number>("VALUE_AS_NUMBER", Number.class, 111);
    public static final TableColumn<CharSequence> REMARKS = new Constant<CharSequence>("REMARKS", CharSequence.class, 88);
    static final Map<TableColumn<?>, Integer> NAME_MAP = Collections.singletonMap(NAME, 0);
    private final Class<V> type;
    CharSequence header;

    protected TableColumn() {
        this.type = null;
    }

    TableColumn(Class<V> clazz) {
        this.type = clazz;
    }

    public TableColumn(Class<V> clazz, CharSequence charSequence) {
        this.type = clazz;
        ArgumentChecks.ensureNonNull("type", this.type);
        this.header = charSequence;
        ArgumentChecks.ensureNonNull("header", this.header);
    }

    public synchronized InternationalString getHeader() {
        CharSequence charSequence = this.header;
        if (charSequence == null || charSequence instanceof InternationalString) {
            return (InternationalString)charSequence;
        }
        SimpleInternationalString simpleInternationalString = new SimpleInternationalString(charSequence.toString());
        this.header = simpleInternationalString;
        return simpleInternationalString;
    }

    @Override
    public final Class<V> getElementType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.getHeader());
    }

    private static final class Constant<V>
    extends TableColumn<V>
    implements Serializable {
        private static final long serialVersionUID = -3460868641711391888L;
        private final String field;
        private final transient short resourceKey;

        Constant(String string, Class<V> clazz, short s2) {
            super(clazz);
            this.field = string;
            this.resourceKey = s2;
        }

        @Override
        public synchronized InternationalString getHeader() {
            InternationalString internationalString = (InternationalString)this.header;
            if (internationalString == null) {
                internationalString = Vocabulary.formatInternational(this.resourceKey);
                this.header = internationalString;
            }
            return internationalString;
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                return TableColumn.class.getField(this.field).get(null);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw (InvalidObjectException)new InvalidObjectException(reflectiveOperationException.toString()).initCause(reflectiveOperationException);
            }
        }
    }
}

