/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.util.BitSet;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;

public final class ArgumentChecks
extends Static {
    private ArgumentChecks() {
    }

    public static void ensureNonNull(String string, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format((short)113, string));
        }
    }

    public static void ensureNonNullElement(String string, int n, Object object) throws NullArgumentException {
        if (object == null) {
            StringBuilder stringBuilder = new StringBuilder(string);
            int n2 = string.indexOf("[#]");
            if (n2 >= 0) {
                stringBuilder.setLength(n2 + 1);
                stringBuilder.append(n).append(string, n2 + 2, string.length());
            } else {
                stringBuilder.append('[').append(n).append(']');
            }
            throw new NullArgumentException(Errors.format((short)113, stringBuilder.toString()));
        }
    }

    public static void ensureNonEmpty(String string, CharSequence charSequence) throws NullArgumentException, IllegalArgumentException {
        if (charSequence == null) {
            throw new NullArgumentException(Errors.format((short)113, string));
        }
        if (charSequence.length() == 0) {
            throw new IllegalArgumentException(Errors.format((short)29, string));
        }
    }

    public static void ensureNonEmpty(String string, Object[] objectArray) throws NullArgumentException, IllegalArgumentException {
        if (objectArray == null) {
            throw new NullArgumentException(Errors.format((short)113, string));
        }
        if (objectArray.length == 0) {
            throw new IllegalArgumentException(Errors.format((short)29, string));
        }
    }

    public static void ensureNonEmpty(String string, int[] nArray, int n, int n2, boolean bl) throws IllegalArgumentException {
        if (nArray == null) {
            throw new NullArgumentException(Errors.format((short)113, string));
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException(Errors.format((short)29, string));
        }
        long l = 0L;
        BitSet bitSet = null;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n3 < n || n3 > n2) {
                throw new IllegalArgumentException(Errors.format((short)166, Strings.toIndexed(string, i), n, n2, n3));
            }
            if (!bl) continue;
            int n4 = n3 - n;
            if (n4 <= 64) {
                if (l != (l |= 1L << n4)) {
                    continue;
                }
            } else {
                n4 -= 64;
                if (bitSet == null) {
                    bitSet = new BitSet();
                }
                if (!bitSet.get(n4)) {
                    bitSet.set(n4);
                    continue;
                }
            }
            throw new IllegalArgumentException(Errors.format((short)187, n3));
        }
    }

    public static void ensureExpectedCount(String string, int n, int n2) {
        if (n2 != n) {
            String string2 = n2 == 0 ? Errors.format((short)29, string) : (n2 < n ? Errors.format((short)127, n, n2) : Errors.format((short)129, n, n2));
            throw new IllegalArgumentException(string2);
        }
    }

    public static void ensureCanCast(String string, Class<?> clazz, Object object) throws IllegalArgumentException {
        Class<?> clazz2;
        if (object != null && !clazz.isAssignableFrom(clazz2 = object.getClass())) {
            Object[] objectArray;
            short s2;
            if (string != null) {
                s2 = 43;
                objectArray = new Object[]{string, clazz, clazz2};
            } else {
                s2 = 50;
                objectArray = new Object[]{clazz, clazz2};
            }
            throw new IllegalArgumentException(Errors.format(s2, objectArray));
        }
    }

    public static void ensureValidIndex(int n, int n2) throws IndexOutOfBoundsException {
        if (n2 < 0 || n2 >= n) {
            throw new IndexOutOfBoundsException(Errors.format((short)71, n2));
        }
    }

    public static void ensureValidIndexRange(int n, int n2, int n3) throws IndexOutOfBoundsException {
        if (n2 < 0 || n3 < n2 || n3 > n) {
            throw new IndexOutOfBoundsException(Errors.format((short)60, n2, n3));
        }
    }

    public static void ensurePositive(String string, int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException(Errors.format((short)92, string, n));
        }
    }

    public static void ensurePositive(String string, long l) throws IllegalArgumentException {
        if (l < 0L) {
            throw new IllegalArgumentException(Errors.format((short)92, string, l));
        }
    }

    public static void ensurePositive(String string, float f) throws IllegalArgumentException {
        if (!(f >= 0.0f)) {
            throw new IllegalArgumentException(Float.isNaN(f) ? Errors.format((short)110, string) : Errors.format((short)92, string, Float.valueOf(f)));
        }
    }

    public static void ensurePositive(String string, double d) throws IllegalArgumentException {
        if (!(d >= 0.0)) {
            throw new IllegalArgumentException(Double.isNaN(d) ? Errors.format((short)110, string) : Errors.format((short)92, string, d));
        }
    }

    public static void ensureStrictlyPositive(String string, int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException(Errors.format((short)165, string, n));
        }
    }

    public static void ensureStrictlyPositive(String string, long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException(Errors.format((short)165, string, l));
        }
    }

    public static void ensureStrictlyPositive(String string, float f) throws IllegalArgumentException {
        if (!(f > 0.0f)) {
            throw new IllegalArgumentException(Float.isNaN(f) ? Errors.format((short)110, string) : Errors.format((short)165, string, Float.valueOf(f)));
        }
    }

    public static void ensureStrictlyPositive(String string, double d) throws IllegalArgumentException {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException(Double.isNaN(d) ? Errors.format((short)110, string) : Errors.format((short)165, string, d));
        }
    }

    public static void ensureFinite(String string, float f) {
        if (!Float.isFinite(f)) {
            throw new IllegalArgumentException(Errors.format(Float.isNaN(f) ? (short)110 : 73, string));
        }
    }

    public static void ensureFinite(String string, double d) {
        if (!Double.isFinite(d)) {
            throw new IllegalArgumentException(Errors.format(Double.isNaN(d) ? (short)110 : 73, string));
        }
    }

    public static void ensureBetween(String string, int n, int n2, int n3) throws IllegalArgumentException {
        if (n3 < n || n3 > n2) {
            throw new IllegalArgumentException(Errors.format((short)166, string, n, n2, n3));
        }
    }

    public static void ensureBetween(String string, long l, long l2, long l3) throws IllegalArgumentException {
        if (l3 < l || l3 > l2) {
            throw new IllegalArgumentException(Errors.format((short)166, string, l, l2, l3));
        }
    }

    public static void ensureBetween(String string, float f, float f2, float f3) throws IllegalArgumentException {
        if (!(f3 >= f) || !(f3 <= f2)) {
            throw new IllegalArgumentException(Float.isNaN(f3) ? Errors.format((short)110, string) : Errors.format((short)166, string, Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3)));
        }
    }

    public static void ensureBetween(String string, double d, double d2, double d3) throws IllegalArgumentException {
        if (!(d3 >= d) || !(d3 <= d2)) {
            throw new IllegalArgumentException(Double.isNaN(d3) ? Errors.format((short)110, string) : Errors.format((short)166, string, d, d2, d3));
        }
    }

    public static void ensureSizeBetween(String string, int n, int n2, int n3) throws IllegalArgumentException {
        String string2;
        if (n3 < n) {
            string2 = n == 1 ? Errors.format((short)29, string) : Errors.format((short)74, string, n, n3);
        } else if (n3 > n2) {
            string2 = Errors.format((short)35, string, n2, n3);
        } else {
            return;
        }
        throw new IllegalArgumentException(string2);
    }

    public static void ensureValidUnicodeCodePoint(String string, int n) throws IllegalArgumentException {
        if (!Character.isValidCodePoint(n)) {
            throw new IllegalArgumentException(Errors.format((short)61, string, n < 0 ? Integer.valueOf(n) : "U+" + Integer.toHexString(n).toUpperCase()));
        }
    }

    public static void ensureDimensionMatches(String string, int n, CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        int n2;
        CoordinateSystem coordinateSystem;
        if (coordinateReferenceSystem != null && (coordinateSystem = coordinateReferenceSystem.getCoordinateSystem()) != null && (n2 = coordinateSystem.getDimension()) != n) {
            throw new MismatchedDimensionException(Errors.format((short)81, string, n, n2));
        }
    }

    public static void ensureDimensionMatches(String string, int n, CoordinateSystem coordinateSystem) throws MismatchedDimensionException {
        int n2;
        if (coordinateSystem != null && (n2 = coordinateSystem.getDimension()) != n) {
            throw new MismatchedDimensionException(Errors.format((short)81, string, n, n2));
        }
    }

    public static void ensureDimensionMatches(String string, int n, int[] nArray) throws MismatchedDimensionException {
        int n2;
        if (nArray != null && (n2 = nArray.length) != n) {
            throw new MismatchedDimensionException(Errors.format((short)81, string, n, n2));
        }
    }

    public static void ensureDimensionMatches(String string, int n, double[] dArray) throws MismatchedDimensionException {
        int n2;
        if (dArray != null && (n2 = dArray.length) != n) {
            throw new MismatchedDimensionException(Errors.format((short)81, string, n, n2));
        }
    }

    public static void ensureDimensionMatches(String string, int n, DirectPosition directPosition) throws MismatchedDimensionException {
        int n2;
        if (directPosition != null && (n2 = directPosition.getDimension()) != n) {
            throw new MismatchedDimensionException(Errors.format((short)81, string, n, n2));
        }
    }

    public static void ensureDimensionMatches(String string, int n, Envelope envelope) throws MismatchedDimensionException {
        int n2;
        if (envelope != null && (n2 = envelope.getDimension()) != n) {
            throw new MismatchedDimensionException(Errors.format((short)81, string, n, n2));
        }
    }
}

