/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.MathTransformsOrFactory;
import org.apache.sis.referencing.operation.transform.PassThroughTransform2D;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class PassThroughTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -910726602881388979L;
    final int firstAffectedCoordinate;
    final int numTrailingCoordinates;
    final MathTransform subTransform;
    PassThroughTransform inverse;

    protected PassThroughTransform(int n, MathTransform mathTransform, int n2) {
        ArgumentChecks.ensurePositive("firstAffectedCoordinate", n);
        ArgumentChecks.ensurePositive("numTrailingCoordinates", n2);
        if (mathTransform instanceof PassThroughTransform) {
            PassThroughTransform passThroughTransform = (PassThroughTransform)mathTransform;
            this.firstAffectedCoordinate = passThroughTransform.firstAffectedCoordinate + n;
            this.numTrailingCoordinates = passThroughTransform.numTrailingCoordinates + n2;
            this.subTransform = passThroughTransform.subTransform;
        } else {
            this.firstAffectedCoordinate = n;
            this.numTrailingCoordinates = n2;
            this.subTransform = mathTransform;
        }
    }

    @Deprecated
    public static MathTransform create(int n, MathTransform mathTransform, int n2) {
        return MathTransforms.passThrough(n, mathTransform, n2);
    }

    static MathTransform create0(int n, MathTransform mathTransform, int n2) {
        Matrix matrix = MathTransforms.getMatrix(mathTransform);
        if (matrix != null) {
            return PassThroughTransform.newInstance(n, matrix, n2);
        }
        if (mathTransform instanceof ConcatenatedTransform) {
            MathTransform mathTransform2 = ((ConcatenatedTransform)mathTransform).transform1;
            MathTransform mathTransform3 = ((ConcatenatedTransform)mathTransform).transform2;
            matrix = MathTransforms.getMatrix(mathTransform2);
            if (matrix != null && mathTransform3 instanceof PassThroughTransform) {
                mathTransform2 = PassThroughTransform.newInstance(n, matrix, n2);
                mathTransform3 = PassThroughTransform.newInstance(n, mathTransform3, n2);
                return MathTransforms.concatenate(mathTransform2, mathTransform3);
            }
            matrix = MathTransforms.getMatrix(mathTransform3);
            if (matrix != null && mathTransform2 instanceof PassThroughTransform) {
                mathTransform2 = PassThroughTransform.newInstance(n, mathTransform2, n2);
                mathTransform3 = PassThroughTransform.newInstance(n, matrix, n2);
                return MathTransforms.concatenate(mathTransform2, mathTransform3);
            }
        }
        return PassThroughTransform.newInstance(n, mathTransform, n2);
    }

    private static LinearTransform newInstance(int n, Matrix matrix, int n2) {
        return MathTransforms.linear(PassThroughTransform.expand(MatrixSIS.castOrCopy(matrix), n, n2, 1));
    }

    private static PassThroughTransform newInstance(int n, MathTransform mathTransform, int n2) {
        int n3 = mathTransform.getSourceDimensions();
        if (mathTransform.getTargetDimensions() == n3 && (n3 += n + n2) == 2) {
            return new PassThroughTransform2D(n, mathTransform, n2);
        }
        return new PassThroughTransform(n, mathTransform, n2);
    }

    @Override
    public final int getSourceDimensions() {
        return this.firstAffectedCoordinate + this.subTransform.getSourceDimensions() + this.numTrailingCoordinates;
    }

    @Override
    public final int getTargetDimensions() {
        return this.firstAffectedCoordinate + this.subTransform.getTargetDimensions() + this.numTrailingCoordinates;
    }

    public final int[] getModifiedCoordinates() {
        return ArraysExt.range(this.firstAffectedCoordinate, this.firstAffectedCoordinate + this.subTransform.getSourceDimensions());
    }

    public final MathTransform getSubTransform() {
        return this.subTransform;
    }

    @Override
    public boolean isIdentity() {
        return this.subTransform.isIdentity();
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        Matrix matrix = null;
        if (bl) {
            matrix = this.derivative(new DirectPositionView.Double(dArray, n, this.getSourceDimensions()));
        }
        if (dArray2 != null) {
            this.transform(dArray, n, dArray2, n2, 1);
        }
        return matrix;
    }

    private static Object newArray(Object object, int n) {
        return Array.newInstance(object.getClass().getComponentType(), n);
    }

    private void transformOverlapping(Object object, int n, Object object2, int n2, int n3) throws TransformException {
        if (n3 <= 0) {
            return;
        }
        int n4 = this.subTransform.getSourceDimensions();
        int n5 = this.subTransform.getTargetDimensions();
        int n6 = this.firstAffectedCoordinate + this.numTrailingCoordinates;
        int n7 = n4 + n6;
        int n8 = n5 + n6;
        Object object3 = PassThroughTransform.newArray(object, n6 * n3);
        System.arraycopy(object, n, object3, 0, this.firstAffectedCoordinate);
        int n9 = this.firstAffectedCoordinate;
        int n10 = n + n9 + n4;
        int n11 = n3 - 1;
        while (--n11 >= 0) {
            System.arraycopy(object, n10, object3, n9, n6);
            n9 += n6;
            n10 += n7;
        }
        System.arraycopy(object, n10, object3, n9, this.numTrailingCoordinates);
        Object object4 = object2;
        n10 = n2;
        n11 = n + this.firstAffectedCoordinate;
        int n12 = n7;
        int n13 = n4;
        IterationStrategy iterationStrategy = n4 > n5 + n6 ? IterationStrategy.BUFFER_TARGET : (object != object2 ? IterationStrategy.ASCENDING : IterationStrategy.suggest(n, n12, n2, n13, n3));
        switch (iterationStrategy) {
            case ASCENDING: {
                break;
            }
            case DESCENDING: {
                n11 += (n3 - 1) * n12;
                n12 = -n12;
                n10 += (n3 - 1) * n13;
                n13 = -n13;
                break;
            }
            default: {
                object4 = PassThroughTransform.newArray(object4, Math.max(n4, n5) * n3);
                n10 = 0;
            }
        }
        int n14 = n3;
        do {
            System.arraycopy(object, n11, object4, n10, n4);
            n10 += n13;
            n11 += n12;
        } while (--n14 != 0);
        int n15 = n10 = object4 == object2 ? n2 : 0;
        if (object4 instanceof double[]) {
            this.subTransform.transform((double[])object4, n10, (double[])object4, n10, n3);
        } else {
            this.subTransform.transform((float[])object4, n10, (float[])object4, n10, n3);
        }
        n11 = n3 * n6;
        n10 += n3 * n5;
        n2 += n3 * n8;
        if (--n3 >= 0) {
            System.arraycopy(object3, n11 -= this.numTrailingCoordinates, object2, n2 -= this.numTrailingCoordinates, this.numTrailingCoordinates);
            System.arraycopy(object4, n10 -= n5, object2, n2 -= n5, n5);
            while (--n3 >= 0) {
                System.arraycopy(object3, n11 -= n6, object2, n2 -= n6, n6);
                System.arraycopy(object4, n10 -= n5, object2, n2 -= n5, n5);
            }
            System.arraycopy(object3, n11 - this.firstAffectedCoordinate, object2, n2 - this.firstAffectedCoordinate, this.firstAffectedCoordinate);
        }
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        this.transformOverlapping(dArray, n, dArray2, n2, n3);
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        this.transformOverlapping(fArray, n, fArray2, n2, n3);
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        int n4 = this.subTransform.getSourceDimensions();
        int n5 = this.subTransform.getTargetDimensions();
        while (--n3 >= 0) {
            int n6;
            for (n6 = 0; n6 < this.firstAffectedCoordinate; ++n6) {
                fArray[n2++] = (float)dArray[n++];
            }
            this.subTransform.transform(dArray, n, fArray, n2, 1);
            n += n4;
            n2 += n5;
            for (n6 = 0; n6 < this.numTrailingCoordinates; ++n6) {
                fArray[n2++] = (float)dArray[n++];
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        int n4 = this.subTransform.getSourceDimensions();
        int n5 = this.subTransform.getTargetDimensions();
        while (--n3 >= 0) {
            int n6;
            for (n6 = 0; n6 < this.firstAffectedCoordinate; ++n6) {
                dArray[n2++] = fArray[n++];
            }
            this.subTransform.transform(fArray, n, dArray, n2, 1);
            n += n4;
            n2 += n5;
            for (n6 = 0; n6 < this.numTrailingCoordinates; ++n6) {
                dArray[n2++] = fArray[n++];
            }
        }
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        int n = this.firstAffectedCoordinate + this.numTrailingCoordinates;
        int n2 = this.subTransform.getSourceDimensions();
        ArgumentChecks.ensureDimensionMatches("point", n2 + n, directPosition);
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n2);
        for (int i = 0; i < n2; ++i) {
            generalDirectPosition.coordinates[i] = directPosition.getOrdinate(i + this.firstAffectedCoordinate);
        }
        return PassThroughTransform.expand(MatrixSIS.castOrCopy(this.subTransform.derivative(generalDirectPosition)), this.firstAffectedCoordinate, this.numTrailingCoordinates, 0);
    }

    private static Matrix expand(MatrixSIS matrixSIS, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n + n2;
        int n8 = matrixSIS.getNumRow() - n3;
        int n9 = matrixSIS.getNumCol() - n3;
        int n10 = n8 + (n7 + n3);
        int n11 = n9 + (n7 + n3);
        Object[] objectArray = new Number[n10 * n11];
        Arrays.fill(objectArray, (Object)0);
        Integer n12 = 1;
        for (n6 = 0; n6 < n; ++n6) {
            objectArray[n6 * n11 + n6] = n12;
        }
        for (n6 = 0; n6 < n8; ++n6) {
            for (n5 = 0; n5 < n9; ++n5) {
                objectArray[(n6 + n) * n11 + (n5 + n)] = matrixSIS.getNumber(n6, n5);
            }
        }
        n6 = n9 - n8;
        n5 = n8 + n7;
        int n13 = n9 + n7;
        for (n4 = n5 - n2; n4 < n5; ++n4) {
            objectArray[n4 * n11 + (n4 + n6)] = n12;
        }
        if (n3 != 0) {
            for (n4 = 0; n4 < n8; ++n4) {
                objectArray[(n4 + n) * n11 + n13] = matrixSIS.getNumber(n4, n9);
            }
            for (n4 = 0; n4 < n9; ++n4) {
                objectArray[n5 * n11 + (n4 + n)] = matrixSIS.getNumber(n8, n4);
            }
            objectArray[n5 * n11 + n13] = matrixSIS.getNumber(n8, n9);
        }
        return Matrices.create(n10, n11, (Number[])objectArray);
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = new PassThroughTransform(this.firstAffectedCoordinate, this.subTransform.inverse(), this.numTrailingCoordinates);
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    private Matrix toSubMatrix(boolean bl, Matrix matrix) {
        int n;
        int n2 = matrix.getNumRow();
        if (n2 != (n = matrix.getNumCol())) {
            return null;
        }
        int n3 = bl ? this.subTransform.getSourceDimensions() : this.subTransform.getTargetDimensions();
        MatrixSIS matrixSIS = Matrices.createIdentity(n3 + 1);
        int n4 = n2;
        while (--n4 >= 0) {
            int n5 = n4 - this.firstAffectedCoordinate;
            int n6 = n;
            while (--n6 >= 0) {
                double d = matrix.getElement(n4, n6);
                if (n5 >= 0 && n5 < n3) {
                    boolean bl2;
                    int n7;
                    if (n6 == n - 1) {
                        n7 = n3;
                        bl2 = true;
                    } else {
                        n7 = n6 - this.firstAffectedCoordinate;
                        boolean bl3 = bl2 = n7 >= 0 && n7 < n3;
                    }
                    if (bl2) {
                        matrixSIS.setElement(n5, n7, d);
                        continue;
                    }
                }
                if (d == (double)(n6 == n4 ? 1 : 0)) continue;
                return null;
            }
        }
        return matrixSIS;
    }

    @Override
    protected MathTransform tryConcatenate(boolean bl, MathTransform mathTransform, MathTransformFactory mathTransformFactory) throws FactoryException {
        Object object;
        MathTransformsOrFactory mathTransformsOrFactory = MathTransformsOrFactory.wrap(mathTransformFactory);
        if (mathTransform instanceof PassThroughTransform) {
            object = (PassThroughTransform)mathTransform;
            if (((PassThroughTransform)object).firstAffectedCoordinate == this.firstAffectedCoordinate && ((PassThroughTransform)object).numTrailingCoordinates == this.numTrailingCoordinates) {
                MathTransform mathTransform2 = mathTransformsOrFactory.concatenate(bl, this.subTransform, ((PassThroughTransform)object).subTransform);
                return mathTransformsOrFactory.passThrough(this.firstAffectedCoordinate, mathTransform2, this.numTrailingCoordinates);
            }
        }
        if ((object = MathTransforms.getMatrix(mathTransform)) != null) {
            int n;
            Matrix matrix = this.toSubMatrix(bl, (Matrix)object);
            if (matrix != null) {
                MathTransform mathTransform3 = mathTransformsOrFactory.linear(matrix);
                mathTransform3 = mathTransformsOrFactory.concatenate(bl, this.subTransform, mathTransform3);
                return mathTransformsOrFactory.passThrough(this.firstAffectedCoordinate, mathTransform3, this.numTrailingCoordinates);
            }
            if (!bl && (n = object.getNumCol() - 1) <= 64) {
                boolean bl2;
                long l = 0L;
                int n2 = object.getNumRow();
                block0: for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        if (object.getElement(j, i) == 0.0) continue;
                        l |= 1L << i;
                        continue block0;
                    }
                }
                long l2 = PassThroughTransform.maskLowBits(n);
                long l3 = PassThroughTransform.maskLowBits(this.subTransform.getTargetDimensions()) << this.firstAffectedCoordinate;
                boolean bl3 = bl2 = (l & l3) != 0L;
                if (bl2) {
                    l |= l3;
                }
                if (l != l2) {
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    int n7 = this.subTransform.getSourceDimensions() - this.subTransform.getTargetDimensions();
                    if (n7 == 0 && !bl2) {
                        return mathTransform;
                    }
                    MatrixSIS matrixSIS = MatrixSIS.castOrCopy((Matrix)object);
                    long l4 = (l ^ 0xFFFFFFFFFFFFFFFFL) & l2;
                    do {
                        n5 = Long.numberOfTrailingZeros(l4);
                        n6 = Long.numberOfTrailingZeros((l4 | PassThroughTransform.maskLowBits(n5)) ^ 0xFFFFFFFFFFFFFFFFL);
                        matrixSIS = matrixSIS.removeColumns(n5, n6);
                        l4 &= PassThroughTransform.maskLowBits(n6) ^ 0xFFFFFFFFFFFFFFFFL;
                    } while ((l4 >>>= n6 - n5) != 0L);
                    long l5 = PassThroughTransform.maskLowBits(this.firstAffectedCoordinate);
                    int n8 = Long.bitCount(l & ((l5 | l3) ^ 0xFFFFFFFFFFFFFFFFL));
                    int n9 = Long.bitCount(l & l5);
                    int[] nArray = new int[Long.bitCount(l) + n7];
                    for (n4 = 0; n4 < nArray.length; ++n4) {
                        n3 = Long.numberOfTrailingZeros(l);
                        if (n3 == this.firstAffectedCoordinate) {
                            if (n7 < 0) {
                                l >>>= -n7;
                                l &= l5 ^ 0xFFFFFFFFFFFFFFFFL;
                            } else {
                                l <<= n7;
                                l |= PassThroughTransform.maskLowBits(n7) << n3;
                            }
                        }
                        l &= 1L << n3 ^ 0xFFFFFFFFFFFFFFFFL;
                        nArray[n4] = n3;
                    }
                    if (!bl2) {
                        n4 = nArray.length;
                        while (--n4 >= 0 && (n3 = nArray[n4]) > this.firstAffectedCoordinate) {
                            nArray[n4] = n3 - n7;
                        }
                    }
                    MathTransform mathTransform4 = mathTransformsOrFactory.linear(Matrices.createDimensionSelect(n + n7, nArray));
                    if (bl2) {
                        mathTransform4 = mathTransformsOrFactory.concatenate(mathTransform4, mathTransformsOrFactory.passThrough(n9, this.subTransform, n8));
                    }
                    mathTransform4 = mathTransformsOrFactory.concatenate(mathTransform4, mathTransformsOrFactory.linear(matrixSIS));
                    return mathTransform4;
                }
            }
        }
        return null;
    }

    private static long maskLowBits(int n) {
        return Numerics.bitmask(n) - 1L;
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ this.subTransform.hashCode() + this.firstAffectedCoordinate;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            PassThroughTransform passThroughTransform = (PassThroughTransform)object;
            return this.firstAffectedCoordinate == passThroughTransform.firstAffectedCoordinate && this.numTrailingCoordinates == passThroughTransform.numTrailingCoordinates && Utilities.deepEquals(this.subTransform, passThroughTransform.subTransform, comparisonMode);
        }
        return false;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        formatter.append(this.firstAffectedCoordinate);
        if (this.numTrailingCoordinates != 0) {
            formatter.append(this.numTrailingCoordinates);
        }
        formatter.append(this.subTransform);
        if (this.numTrailingCoordinates != 0) {
            formatter.setInvalidWKT(PassThroughTransform.class, null);
        }
        return "PassThrough_MT";
    }
}

