/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Statistics;
import org.apache.sis.math.StatisticsFormat;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.builder.LinearTransformBuilder;
import org.apache.sis.referencing.operation.builder.ResidualGrid;
import org.apache.sis.referencing.operation.builder.TransformBuilder;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class LocalizationGridBuilder
extends TransformBuilder {
    private static final double EPS = 1.0E-13;
    private final LinearTransformBuilder linear;
    private final int[] tmp = new int[2];
    private LinearTransform sourceToGrid;
    private double precision;
    private static final double DEFAULT_PRECISION = 1.0E-7;
    private MathTransform transform;

    public LocalizationGridBuilder(int n, int n2) {
        this.linear = new LinearTransformBuilder(n, n2);
        this.sourceToGrid = MathTransforms.identity(2);
    }

    public LocalizationGridBuilder(Vector vector, Vector vector2) {
        Matrix3 matrix3 = new Matrix3();
        int n = LocalizationGridBuilder.infer(vector, matrix3, 0);
        int n2 = LocalizationGridBuilder.infer(vector2, matrix3, 1);
        this.linear = new LinearTransformBuilder(n, n2);
        try {
            this.sourceToGrid = MathTransforms.linear(matrix3).inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw (ArithmeticException)new ArithmeticException(noninvertibleTransformException.getLocalizedMessage()).initCause(noninvertibleTransformException);
        }
    }

    public LocalizationGridBuilder(LinearTransformBuilder linearTransformBuilder) {
        ArgumentChecks.ensureNonNull("localizations", linearTransformBuilder);
        int n = linearTransformBuilder.getGridDimensions();
        if (n != 2) {
            Vector[] vectorArray;
            if (n < 0 && (n = (vectorArray = linearTransformBuilder.sources()).length) == 2) {
                Matrix3 matrix3 = new Matrix3();
                int n2 = LocalizationGridBuilder.infer(vectorArray[0], matrix3, 0);
                int n3 = LocalizationGridBuilder.infer(vectorArray[1], matrix3, 1);
                this.linear = new LinearTransformBuilder(n2, n3);
                this.linear.setControlPoints(linearTransformBuilder.getControlPoints());
                try {
                    this.sourceToGrid = MathTransforms.linear(matrix3).inverse();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    throw (ArithmeticException)new ArithmeticException(noninvertibleTransformException.getLocalizedMessage()).initCause(noninvertibleTransformException);
                }
                this.linear.setLinearizers(linearTransformBuilder);
                return;
            }
            throw new IllegalArgumentException(Resources.format((short)37, 0, 2, n));
        }
        this.linear = linearTransformBuilder;
        this.sourceToGrid = MathTransforms.identity(2);
    }

    private static int infer(Vector vector, Matrix matrix, int n) {
        double d;
        NumberRange<?> numberRange = vector.range();
        double d2 = numberRange.getMinDouble(true);
        double d3 = numberRange.getMaxDouble(true) - d2;
        Number number = vector.increment(1.0E-13 * d3);
        if (number != null) {
            d = number.doubleValue();
        } else {
            d = d3;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                double d4;
                double d5 = vector.doubleValue(i) - d2;
                if (!(Math.abs(d5 % d) > 1.0E-13)) continue;
                do {
                    d4 = d % d5;
                    d = d5;
                } while (Math.abs(d5 = d4) > 1.0E-13);
            }
        }
        matrix.setElement(n, n, d);
        matrix.setElement(n, 2, d2);
        double d6 = d3 / d;
        if (d6 >= 0.5 && d6 < (double)vector.size() - 0.5) {
            return (int)Math.round(d6) + 1;
        }
        throw new ArithmeticException(Resources.format((short)75, numberRange));
    }

    private void ensureModifiable() throws IllegalStateException {
        if (!this.linear.isModifiable()) {
            throw new IllegalStateException(Errors.format((short)153, LocalizationGridBuilder.class));
        }
    }

    public void setDesiredPrecision(double d) {
        this.ensureModifiable();
        ArgumentChecks.ensureStrictlyPositive("precision", d);
        this.precision = d;
    }

    public double getDesiredPrecision() {
        return this.precision;
    }

    public void setSourceToGrid(LinearTransform linearTransform) {
        this.ensureModifiable();
        ArgumentChecks.ensureNonNull("sourceToGrid", linearTransform);
        int n = 0;
        int n2 = linearTransform.getSourceDimensions();
        if (n2 >= 2) {
            n = 1;
            n2 = linearTransform.getTargetDimensions();
            if (n2 == 2) {
                this.sourceToGrid = linearTransform;
                return;
            }
        }
        throw new MismatchedDimensionException(Resources.format((short)37, n, 2, n2));
    }

    public LinearTransform getSourceToGrid() {
        return this.sourceToGrid;
    }

    public Envelope getSourceEnvelope(boolean bl) throws TransformException {
        Envelope envelope = this.linear.getSourceEnvelope();
        if (bl) {
            int n = envelope.getDimension();
            while (--n >= 0) {
                GeneralEnvelope generalEnvelope = GeneralEnvelope.castOrCopy(envelope);
                generalEnvelope.setRange(n, generalEnvelope.getLower(n) - 0.5, generalEnvelope.getUpper(n) + 0.5);
                envelope = generalEnvelope;
            }
        }
        return Envelopes.transform(this.sourceToGrid.inverse(), envelope);
    }

    public void setControlPoints(Vector ... vectorArray) {
        this.ensureModifiable();
        ArgumentChecks.ensureNonNull("coordinates", vectorArray);
        this.linear.setControlPoints(vectorArray);
    }

    public void setControlPoint(int n, int n2, double ... dArray) {
        this.ensureModifiable();
        this.tmp[0] = n;
        this.tmp[1] = n2;
        this.linear.setControlPoint(this.tmp, dArray);
    }

    public double[] getControlPoint(int n, int n2) {
        this.tmp[0] = n;
        this.tmp[1] = n2;
        return this.linear.getControlPoint(this.tmp);
    }

    public Vector getRow(int n, int n2) {
        this.tmp[0] = 0;
        this.tmp[1] = n2;
        return this.linear.getTransect(n, this.tmp, 0);
    }

    public Vector getColumn(int n, int n2) {
        this.tmp[0] = n2;
        this.tmp[1] = 0;
        return this.linear.getTransect(n, this.tmp, 1);
    }

    public NumberRange<Double> resolveWraparoundAxis(int n, int n2, double d) {
        this.ensureModifiable();
        ArgumentChecks.ensureBetween("dimension", 0, this.linear.getTargetDimensions() - 1, n);
        ArgumentChecks.ensureBetween("direction", 0, this.linear.getSourceDimensions() - 1, n2);
        ArgumentChecks.ensureStrictlyPositive("period", d);
        return this.linear.resolveWraparoundAxis(n, n2, d);
    }

    public void addLinearizers(Map<String, MathTransform> map, int ... nArray) {
        this.ensureModifiable();
        this.linear.addLinearizers(map, nArray);
    }

    @Override
    public MathTransform create(MathTransformFactory mathTransformFactory) throws FactoryException {
        if (this.transform == null) {
            Object object;
            LinearTransform linearTransform = this.linear.create(mathTransformFactory);
            boolean bl = true;
            boolean bl2 = true;
            for (double d : this.linear.correlation()) {
                bl &= d == 1.0;
                if (d >= 0.9999) continue;
                bl2 = false;
                break;
            }
            if (bl) {
                object = MathTransforms.concatenate(this.sourceToGrid, linearTransform);
            } else {
                int n = this.linear.gridSize(0);
                int n2 = this.linear.gridSize(1);
                float[] fArray = new float[2 * this.linear.gridLength];
                double[] dArray = new double[2 * n];
                double d = this.precision;
                try {
                    double d2;
                    int n3;
                    Object object2;
                    if (d > 0.0 && !this.sourceToGrid.isIdentity()) {
                        object2 = new double[this.sourceToGrid.getSourceDimensions()];
                        double[] dArray2 = new double[this.sourceToGrid.getTargetDimensions()];
                        double d3 = 0.0;
                        for (n3 = 0; n3 < ((Object)object2).length; ++n3) {
                            object2[n3] = this.precision;
                            this.sourceToGrid.deltaTransform((double[])object2, 0, dArray2, 0, 1);
                            d2 = MathFunctions.magnitude(dArray2);
                            if (d2 > d3) {
                                d3 = d2;
                            }
                            object2[n3] = 0.0;
                        }
                        d = d3;
                    }
                    object2 = linearTransform.inverse();
                    int n4 = 0;
                    for (int i = 0; i < n2; ++i) {
                        this.tmp[0] = 0;
                        this.tmp[1] = i;
                        this.linear.getControlRow(this.tmp, dArray);
                        object2.transform(dArray, 0, dArray, 0, n);
                        int n5 = 0;
                        for (n3 = 0; n3 < n; ++n3) {
                            d2 = dArray[n5++] - (double)n3;
                            double d4 = dArray[n5++] - (double)i;
                            bl2 &= d2 <= d;
                            bl2 &= d4 <= d;
                            fArray[n4++] = (float)d2;
                            fArray[n4++] = (float)d4;
                        }
                    }
                }
                catch (TransformException transformException) {
                    throw new FactoryException(transformException);
                }
                object = bl2 ? (Object)MathTransforms.concatenate(this.sourceToGrid, linearTransform) : (Object)InterpolatedTransform.createGeodeticTransformation(LocalizationGridBuilder.nonNull(mathTransformFactory), new ResidualGrid(this.sourceToGrid, linearTransform, n, n2, fArray, d > 0.0 ? d : 1.0E-7));
            }
            Optional<MathTransform> optional = this.linear.linearizer();
            if (optional.isPresent()) {
                try {
                    object = mathTransformFactory.createConcatenatedTransform((MathTransform)object, optional.get().inverse());
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    throw new InvalidGeodeticParameterException(Resources.format((short)52, this.linear.linearizerID()), noninvertibleTransformException);
                }
            }
            this.transform = object;
        }
        return this.transform;
    }

    public Statistics[] error(MathTransform mathTransform) throws NoninvertibleTransformException {
        int n = mathTransform.getTargetDimensions();
        double[] dArray = new double[Math.max(n, 2)];
        Statistics[] statisticsArray = new Statistics[n + 2];
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < statisticsArray.length; ++i) {
            stringBuilder.setLength(0);
            if (i < n) {
                stringBuilder.append("P \u2192 ");
                if (i < 3) {
                    stringBuilder.append((char)(120 + i));
                } else {
                    stringBuilder.append('z').append(i - 1);
                }
            } else {
                stringBuilder.append((char)(105 + (i - n))).append(" \u2190 P\u2032");
            }
            statisticsArray[i] = new Statistics(stringBuilder.toString());
        }
        Optional<MathTransform> optional = this.linear.linearizer();
        MathTransform mathTransform2 = optional.isPresent() ? optional.get().inverse() : null;
        MathTransform mathTransform3 = mathTransform.inverse();
        int n2 = this.linear.gridSize(0);
        int n3 = this.linear.gridSize(1);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4;
                double[] dArray2;
                block13: {
                    this.tmp[0] = j;
                    dArray[0] = this.tmp[0];
                    this.tmp[1] = i;
                    dArray[1] = this.tmp[1];
                    try {
                        mathTransform.transform(dArray, 0, dArray, 0, 1);
                        dArray2 = this.linear.getControlPoint(this.tmp);
                        if (mathTransform2 == null) break block13;
                        mathTransform2.transform(dArray2, 0, dArray2, 0, 1);
                    }
                    catch (TransformException transformException) {
                        continue;
                    }
                }
                for (n4 = 0; n4 < n; ++n4) {
                    statisticsArray[n4].accept(dArray[n4] - dArray2[n4]);
                }
                try {
                    mathTransform3.transform(dArray2, 0, dArray2, 0, 1);
                }
                catch (TransformException transformException) {
                    continue;
                }
                for (n4 = 0; n4 < 2; ++n4) {
                    statisticsArray[n + n4].accept(dArray2[n4] - (double)this.tmp[n4]);
                }
            }
        }
        return statisticsArray;
    }

    public String toString(Locale locale) {
        StringBuilder stringBuilder = new StringBuilder(400);
        String string = null;
        try {
            string = this.linear.appendTo(stringBuilder, this.getClass(), locale, (short)165);
            if (this.transform != null) {
                stringBuilder.append("\u25b6\u00a0");
                Vocabulary vocabulary = Vocabulary.getResources(locale);
                vocabulary.appendLabel((short)167, stringBuilder);
                stringBuilder.append(string);
                StatisticsFormat statisticsFormat = locale != null ? StatisticsFormat.getInstance(locale) : StatisticsFormat.getInstance();
                statisticsFormat.format(this.error(this.transform), (Appendable)stringBuilder);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        Strings.insertLineInLeftMargin(stringBuilder, string);
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(null);
    }
}

