/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.gco.StringAdapter;
import org.apache.sis.internal.jaxb.referencing.CC_OperationMethod;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.operation.DefaultFormula;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.Formula;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;

@XmlType(name="OperationMethodType", propOrder={"formulaCitation", "formulaDescription", "sourceDimensions", "targetDimensions", "descriptors"})
@XmlRootElement(name="OperationMethod")
public class DefaultOperationMethod
extends AbstractIdentifiedObject
implements OperationMethod {
    private static final long serialVersionUID = 2870579345991143357L;
    private Formula formula;
    private Integer sourceDimensions;
    private Integer targetDimensions;
    private ParameterDescriptorGroup parameters;

    public DefaultOperationMethod(Map<String, ?> map, Integer n, Integer n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(map);
        if (n != null) {
            ArgumentChecks.ensurePositive("sourceDimensions", n);
        }
        if (n2 != null) {
            ArgumentChecks.ensurePositive("targetDimensions", n2);
        }
        ArgumentChecks.ensureNonNull("parameters", parameterDescriptorGroup);
        Object obj = map.get("formula");
        if (obj == null || obj instanceof Formula) {
            this.formula = (Formula)obj;
        } else if (obj instanceof Citation) {
            this.formula = new DefaultFormula((Citation)obj);
        } else if (obj instanceof CharSequence) {
            this.formula = new DefaultFormula((CharSequence)obj);
        } else {
            throw new IllegalArgumentException(Errors.getResources(map).getString((short)58, "formula", obj.getClass()));
        }
        this.parameters = parameterDescriptorGroup;
        this.sourceDimensions = n;
        this.targetDimensions = n2;
    }

    public DefaultOperationMethod(MathTransform mathTransform) {
        super(DefaultOperationMethod.getProperties(mathTransform));
        this.sourceDimensions = mathTransform.getSourceDimensions();
        this.targetDimensions = mathTransform.getTargetDimensions();
        this.parameters = mathTransform instanceof Parameterized ? ((Parameterized)((Object)mathTransform)).getParameterDescriptors() : null;
        this.formula = null;
    }

    private static Map<String, ?> getProperties(MathTransform mathTransform) {
        ParameterDescriptorGroup parameterDescriptorGroup;
        ArgumentChecks.ensureNonNull("transform", mathTransform);
        if (mathTransform instanceof Parameterized && (parameterDescriptorGroup = ((Parameterized)((Object)mathTransform)).getParameterDescriptors()) != null) {
            return DefaultOperationMethod.getProperties(parameterDescriptorGroup, null);
        }
        return Collections.singletonMap("name", NilReferencingObject.UNNAMED);
    }

    private static Map<String, Object> getProperties(IdentifiedObject identifiedObject, Citation citation) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(IdentifiedObjects.getProperties(identifiedObject, new String[0]));
        hashMap.put("name", new NamedIdentifier(citation, identifiedObject.getName().getCode()));
        hashMap.remove("identifiers");
        return hashMap;
    }

    protected DefaultOperationMethod(OperationMethod operationMethod) {
        super(operationMethod);
        this.formula = operationMethod.getFormula();
        this.parameters = operationMethod.getParameters();
        this.sourceDimensions = operationMethod.getSourceDimensions();
        this.targetDimensions = operationMethod.getTargetDimensions();
    }

    public static DefaultOperationMethod castOrCopy(OperationMethod operationMethod) {
        return operationMethod == null || operationMethod instanceof DefaultOperationMethod ? (DefaultOperationMethod)operationMethod : new DefaultOperationMethod(operationMethod);
    }

    private DefaultOperationMethod(OperationMethod operationMethod, Integer n, Integer n2) {
        super(operationMethod);
        this.formula = operationMethod.getFormula();
        this.parameters = operationMethod.getParameters();
        this.sourceDimensions = n;
        this.targetDimensions = n2;
    }

    private static OperationMethod redimension(OperationMethod operationMethod, int n, Integer n2, int n3, Integer n4) {
        boolean bl;
        boolean bl2 = n2 != null && n2 == n;
        boolean bl3 = bl = n4 != null && n4 == n3;
        if (bl2 && bl) {
            return operationMethod;
        }
        boolean bl4 = n2 == null;
        boolean bl5 = n4 == null;
        ArgumentChecks.ensurePositive("sourceDimensions", n);
        ArgumentChecks.ensurePositive("targetDimensions", n3);
        if (!(bl2 |= bl4) || !(bl |= bl5)) {
            throw new IllegalArgumentException(Resources.format((short)21, operationMethod.getName().getCode(), n, n3));
        }
        return new DefaultOperationMethod(operationMethod, n, n3);
    }

    public static OperationMethod redimension(OperationMethod operationMethod, int n, int n2) {
        if (operationMethod != null) {
            if (operationMethod instanceof DefaultOperationMethod) {
                return ((DefaultOperationMethod)operationMethod).redimension(n, n2);
            }
            operationMethod = DefaultOperationMethod.redimension(operationMethod, n, operationMethod.getSourceDimensions(), n2, operationMethod.getTargetDimensions());
        }
        return operationMethod;
    }

    public OperationMethod redimension(int n, int n2) {
        return DefaultOperationMethod.redimension(this, n, this.sourceDimensions, n2, this.targetDimensions);
    }

    public Class<? extends OperationMethod> getInterface() {
        return OperationMethod.class;
    }

    public Class<? extends SingleOperation> getOperationType() {
        return SingleOperation.class;
    }

    @Override
    public Formula getFormula() {
        return this.formula;
    }

    @Override
    @XmlElement(name="sourceDimensions")
    @XmlSchemaType(name="positiveInteger")
    public Integer getSourceDimensions() {
        return this.sourceDimensions;
    }

    @Override
    @XmlElement(name="targetDimensions")
    @XmlSchemaType(name="positiveInteger")
    public Integer getTargetDimensions() {
        return this.targetDimensions;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return this.parameters;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            OperationMethod operationMethod;
            switch (comparisonMode) {
                case STRICT: {
                    DefaultOperationMethod defaultOperationMethod = (DefaultOperationMethod)object;
                    return Objects.equals(this.formula, defaultOperationMethod.formula) && Objects.equals(this.sourceDimensions, defaultOperationMethod.sourceDimensions) && Objects.equals(this.targetDimensions, defaultOperationMethod.targetDimensions) && Objects.equals(this.parameters, defaultOperationMethod.parameters);
                }
                case BY_CONTRACT: {
                    if (Objects.equals(this.getFormula(), ((OperationMethod)object).getFormula())) break;
                    return false;
                }
                default: {
                    operationMethod = (OperationMethod)object;
                    Boolean bl = Identifiers.hasCommonIdentifier(this.getIdentifiers(), operationMethod.getIdentifiers());
                    if (!(bl != null ? bl == false : !this.isHeuristicMatchForName(operationMethod.getName().getCode()) && !IdentifiedObjects.isHeuristicMatchForName(operationMethod, this.getName().getCode()))) break;
                    return false;
                }
            }
            operationMethod = (OperationMethod)object;
            return Objects.equals(this.getSourceDimensions(), operationMethod.getSourceDimensions()) && Objects.equals(this.getTargetDimensions(), operationMethod.getTargetDimensions()) && Utilities.deepEquals(this.getParameters(), operationMethod.getParameters(), comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.sourceDimensions, this.targetDimensions, this.parameters);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        Class<? extends SingleOperation> clazz;
        boolean bl = formatter.getConvention().majorVersion() == 1;
        Citation citation = formatter.getNameAuthority();
        String string = IdentifiedObjects.getName(this, citation);
        ElementKind elementKind = ElementKind.METHOD;
        if (string == null) {
            Conversion conversion;
            clazz = formatter.getEnclosingElement(bl ? 1 : 2);
            if (clazz instanceof GeneralDerivedCRS && (conversion = ((GeneralDerivedCRS)((Object)clazz)).getConversionFromBase()) != null) {
                ParameterDescriptorGroup parameterDescriptorGroup = conversion instanceof Parameterized ? ((Parameterized)((Object)conversion)).getParameterDescriptors() : conversion.getParameterValues().getDescriptor();
                string = IdentifiedObjects.getName(parameterDescriptorGroup, citation);
            }
            if (string == null && (string = IdentifiedObjects.getName(this, null)) == null) {
                string = Vocabulary.getResources(formatter.getLocale()).getString((short)108);
                elementKind = ElementKind.NAME;
            }
        }
        formatter.append(string, elementKind);
        if (bl) {
            clazz = this.getOperationType();
            if (Projection.class.isAssignableFrom(clazz) || clazz.isAssignableFrom(Projection.class)) {
                return "Projection";
            }
            formatter.setInvalidWKT(this, null);
        }
        return "Method";
    }

    private DefaultOperationMethod() {
        super(NilReferencingObject.INSTANCE);
    }

    private void setSourceDimensions(Integer n) {
        if (this.sourceDimensions == null) {
            this.sourceDimensions = n;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultOperationMethod.class, "setSourceDimensions", "sourceDimensions");
        }
    }

    private void setTargetDimensions(Integer n) {
        if (this.targetDimensions == null) {
            this.targetDimensions = n;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultOperationMethod.class, "setTargetDimensions", "targetDimensions");
        }
    }

    @XmlElement(name="formulaCitation")
    private Citation getFormulaCitation() {
        Formula formula = this.getFormula();
        return formula != null ? formula.getCitation() : null;
    }

    @XmlElement(name="formula")
    private String getFormulaDescription() {
        Formula formula = this.getFormula();
        return formula != null ? StringAdapter.toString(formula.getFormula()) : null;
    }

    private void setFormulaCitation(Citation citation) {
        if (this.formula == null || this.formula.getCitation() == null) {
            this.formula = this.formula == null ? new DefaultFormula(citation) : new DefaultFormula(this.formula.getFormula(), citation);
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultOperationMethod.class, "setFormulaCitation", "formulaCitation");
        }
    }

    private void setFormulaDescription(String string) {
        if (this.formula == null || this.formula.getFormula() == null) {
            this.formula = this.formula == null ? new DefaultFormula(string) : new DefaultFormula(new SimpleInternationalString(string), this.formula.getCitation());
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultOperationMethod.class, "setFormulaDescription", "formula");
        }
    }

    @XmlElement(name="parameter")
    private GeneralParameterDescriptor[] getDescriptors() {
        List<GeneralParameterDescriptor> list;
        if (this.parameters != null && (list = this.parameters.descriptors()) != null) {
            return CC_OperationMethod.filterImplicit(list.toArray(new GeneralParameterDescriptor[list.size()]));
        }
        return null;
    }

    private void setDescriptors(GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        if (this.parameters == null) {
            this.parameters = CC_OperationMethod.group(super.getName(), generalParameterDescriptorArray);
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultOperationMethod.class, "setDescriptors", "parameter");
        }
    }

    final void updateDescriptors(GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        ParameterDescriptorGroup parameterDescriptorGroup = this.parameters;
        this.parameters = new DefaultParameterDescriptorGroup(IdentifiedObjects.getProperties(parameterDescriptorGroup, new String[0]), parameterDescriptorGroup.getMinimumOccurs(), parameterDescriptorGroup.getMaximumOccurs(), generalParameterDescriptorArray);
    }
}

