/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.referencing.LazySet;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.AbstractIterator;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.DefinitionURI;
import org.apache.sis.internal.util.SetOfUnknownSize;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.AuthorityFactoryIdentifier;
import org.apache.sis.referencing.factory.AuthorityFactoryProxy;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.LazySynchronizedIterator;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public class MultiAuthoritiesFactory
extends GeodeticAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    private final Iterable<? extends AuthorityFactory>[] providers;
    private final ConcurrentMap<AuthorityFactoryIdentifier, AuthorityFactory> factories;
    private final AtomicInteger isIterationCompleted;
    private volatile Set<String> codeSpaces;
    private volatile boolean isLenient;
    private final Map<AuthorityFactoryIdentifier, Boolean> warnings;

    public MultiAuthoritiesFactory(Iterable<? extends CRSAuthorityFactory> iterable, Iterable<? extends CSAuthorityFactory> iterable2, Iterable<? extends DatumAuthorityFactory> iterable3, Iterable<? extends CoordinateOperationAuthorityFactory> iterable4) {
        Iterable[] iterableArray = new Iterable[]{iterable, iterable2, iterable3, iterable4};
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < iterableArray.length; ++i) {
            if (iterableArray[i] != null) {
                n = i + 1;
                continue;
            }
            n2 |= 1 << i;
        }
        this.providers = ArraysExt.resize(iterableArray, n);
        this.factories = new ConcurrentHashMap<AuthorityFactoryIdentifier, AuthorityFactory>();
        this.warnings = new HashMap<AuthorityFactoryIdentifier, Boolean>();
        this.isIterationCompleted = new AtomicInteger(n2);
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    public void setLenient(boolean bl) {
        this.isLenient = bl;
    }

    @Override
    public Citation getAuthority() {
        return null;
    }

    @Override
    public Set<String> getAuthorityCodes(final Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return new SetOfUnknownSize<String>(){
            private final Map<AuthorityFactory, Set<String>> cache = new IdentityHashMap<AuthorityFactory, Set<String>>();
            private int size = -1;
            private final AuthorityFactoryProxy<Boolean> contains = new AuthorityFactoryProxy<Boolean>(Boolean.class, 5){

                @Override
                Boolean createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
                    return this.getAuthorityCodes(authorityFactory).contains(string);
                }

                @Override
                AuthorityFactoryProxy<Boolean> specialize(String string) {
                    return this;
                }
            };

            @Override
            public Iterator<String> iterator() {
                return new AbstractIterator<String>(){
                    private final Iterator<AuthorityFactory> factories;
                    private Iterator<String> codes;
                    private String prefix;
                    private final Set<String> done;
                    {
                        this.factories = MultiAuthoritiesFactory.this.getAllFactories();
                        this.codes = Collections.emptyIterator();
                        this.done = new HashSet<String>();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.next == null) {
                            while (!this.codes.hasNext()) {
                                do {
                                    if (!this.factories.hasNext()) {
                                        return false;
                                    }
                                    AuthorityFactory authorityFactory = this.factories.next();
                                    this.codes = this.getAuthorityCodes(authorityFactory).iterator();
                                    this.prefix = MultiAuthoritiesFactory.getCodeSpace(authorityFactory);
                                } while (!this.done.add(this.prefix));
                            }
                            this.next = this.codes.next();
                        }
                        return true;
                    }

                    @Override
                    public String next() {
                        String string = (String)super.next();
                        if (this.prefix != null && string.indexOf(58) < 0) {
                            string = this.prefix + ':' + string;
                        }
                        return string;
                    }
                };
            }

            final Set<String> getAuthorityCodes(AuthorityFactory authorityFactory) {
                Set<String> set = this.cache.get(authorityFactory);
                if (set == null) {
                    try {
                        set = authorityFactory.getAuthorityCodes(clazz);
                    }
                    catch (FactoryException factoryException) {
                        throw new BackingStoreException(factoryException);
                    }
                    if (this.cache.put(authorityFactory, set) != null) {
                        throw new ConcurrentModificationException();
                    }
                }
                return set;
            }

            @Override
            protected boolean isSizeKnown() {
                return this.size >= 0;
            }

            @Override
            public int size() {
                if (this.size < 0) {
                    int n = 0;
                    HashSet<String> hashSet = new HashSet<String>();
                    Iterator<AuthorityFactory> iterator = MultiAuthoritiesFactory.this.getAllFactories();
                    while (iterator.hasNext()) {
                        AuthorityFactory authorityFactory = iterator.next();
                        if (!hashSet.add(MultiAuthoritiesFactory.getCodeSpace(authorityFactory))) continue;
                        n += this.getAuthorityCodes(authorityFactory).size();
                    }
                    this.size = n;
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                if (this.size == -1) {
                    Iterator<AuthorityFactory> iterator = MultiAuthoritiesFactory.this.getAllFactories();
                    while (iterator.hasNext()) {
                        if (this.getAuthorityCodes(iterator.next()).isEmpty()) continue;
                        this.size = -2;
                        return false;
                    }
                    this.size = 0;
                }
                return this.size == 0;
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof String) {
                    try {
                        return (Boolean)MultiAuthoritiesFactory.this.create(this.contains, (String)object);
                    }
                    catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                    }
                    catch (FactoryException factoryException) {
                        throw new BackingStoreException(factoryException);
                    }
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<String> getCodeSpaces() {
        Set<String> set = this.codeSpaces;
        if (set == null) {
            set = new LinkedHashSet<String>();
            Iterator<AuthorityFactory> iterator = this.getAllFactories();
            while (iterator.hasNext()) {
                set.addAll(MultiAuthoritiesFactory.getCodeSpaces(iterator.next()));
            }
            this.codeSpaces = set = CollectionsExt.unmodifiableOrCopy(set);
        }
        return set;
    }

    private static Set<String> getCodeSpaces(AuthorityFactory authorityFactory) {
        if (authorityFactory instanceof GeodeticAuthorityFactory) {
            return ((GeodeticAuthorityFactory)authorityFactory).getCodeSpaces();
        }
        String string = Citations.toCodeSpace(authorityFactory.getAuthority());
        return string != null ? Collections.singleton(string) : Collections.emptySet();
    }

    static String getCodeSpace(AuthorityFactory authorityFactory) {
        return CollectionsExt.first(MultiAuthoritiesFactory.getCodeSpaces(authorityFactory));
    }

    private AuthorityFactory cache(AuthorityFactoryIdentifier authorityFactoryIdentifier, AuthorityFactory authorityFactory) {
        AuthorityFactory authorityFactory2 = this.factories.putIfAbsent(authorityFactoryIdentifier.intern(), authorityFactory);
        return authorityFactory2 != null ? authorityFactory2 : authorityFactory;
    }

    final Iterator<AuthorityFactory> getAllFactories() {
        return new LazySynchronizedIterator<AuthorityFactory>(this.providers);
    }

    public final <T extends AuthorityFactory> T getAuthorityFactory(Class<T> clazz, String string, String string2) throws NoSuchAuthorityFactoryException {
        ArgumentChecks.ensureNonNull("type", clazz);
        ArgumentChecks.ensureNonNull("authority", string);
        return (T)((AuthorityFactory)clazz.cast(this.getAuthorityFactory(AuthorityFactoryIdentifier.create(clazz, string, string2))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorityFactory getAuthorityFactory(AuthorityFactoryIdentifier authorityFactoryIdentifier) throws NoSuchAuthorityFactoryException {
        byte by;
        int n;
        AuthorityFactory authorityFactory = (AuthorityFactory)this.factories.get(authorityFactoryIdentifier);
        if (authorityFactory != null) {
            return authorityFactory;
        }
        if (authorityFactoryIdentifier.hasVersion() && (authorityFactory = (AuthorityFactory)this.factories.get(authorityFactoryIdentifier.versionOf(null))) != null) {
            if (authorityFactoryIdentifier.versionOf(authorityFactory.getAuthority()) == authorityFactoryIdentifier) {
                return this.cache(authorityFactoryIdentifier, authorityFactory);
            }
            authorityFactory = null;
        }
        if (((n = this.isIterationCompleted.get()) & 1 << (by = authorityFactoryIdentifier.type)) == 0) {
            if (by >= 0 && by < this.providers.length) {
                Iterator<? extends AuthorityFactory> iterator;
                Iterable<? extends AuthorityFactory> iterable;
                Iterable<? extends AuthorityFactory> iterable2 = iterable = this.providers[by];
                synchronized (iterable2) {
                    iterator = iterable.iterator();
                    while (iterator.hasNext() && (authorityFactory = iterator.next()) == null) {
                    }
                }
                while (authorityFactory != null) {
                    for (String string : MultiAuthoritiesFactory.getCodeSpaces(authorityFactory)) {
                        AuthorityFactory authorityFactory2;
                        AuthorityFactoryIdentifier authorityFactoryIdentifier2 = authorityFactoryIdentifier.unversioned(string);
                        AuthorityFactory authorityFactory3 = this.cache(authorityFactoryIdentifier2, authorityFactory);
                        AuthorityFactory authorityFactory4 = authorityFactory2 = authorityFactoryIdentifier.equals(authorityFactoryIdentifier2) ? authorityFactory3 : null;
                        if (authorityFactory != authorityFactory3 || authorityFactoryIdentifier.hasVersion() && authorityFactoryIdentifier.isSameAuthority(authorityFactoryIdentifier2)) {
                            AuthorityFactoryIdentifier authorityFactoryIdentifier3 = authorityFactoryIdentifier2.versionOf(authorityFactory.getAuthority());
                            if (authorityFactoryIdentifier3 != authorityFactoryIdentifier2) {
                                if (authorityFactory != authorityFactory3) {
                                    this.cache(authorityFactoryIdentifier2.versionOf(authorityFactory3.getAuthority()), authorityFactory3);
                                }
                                authorityFactory3 = this.cache(authorityFactoryIdentifier3, authorityFactory);
                            }
                            if (authorityFactory != authorityFactory3 && this.canLog(authorityFactoryIdentifier3)) {
                                authorityFactoryIdentifier3.logConflict(authorityFactory3);
                            }
                            if (authorityFactoryIdentifier.equals(authorityFactoryIdentifier3)) {
                                return authorityFactory3;
                            }
                        }
                        if (authorityFactory2 == null) continue;
                        return authorityFactory2;
                    }
                    authorityFactory = null;
                    iterable2 = iterable;
                    synchronized (iterable2) {
                        while (iterator.hasNext() && (authorityFactory = iterator.next()) == null) {
                        }
                    }
                }
            } else if (by >= 4) {
                assert (this.providers.length <= Math.min(by, 127)) : by;
                block14: for (byte by2 = 0; by2 < this.providers.length; by2 = (byte)(by2 + 1)) {
                    authorityFactory = this.getAuthorityFactory(authorityFactoryIdentifier.newType(by2));
                    switch (by) {
                        case 5: {
                            return authorityFactory;
                        }
                        case 4: {
                            if (!(authorityFactory instanceof GeodeticAuthorityFactory)) continue block14;
                            return authorityFactory;
                        }
                    }
                }
            }
            while (!this.isIterationCompleted.compareAndSet(n, n | 1 << by)) {
                n = this.isIterationCompleted.get();
            }
        }
        if (authorityFactoryIdentifier.hasVersion() && this.isLenient) {
            authorityFactory = this.getAuthorityFactory(authorityFactoryIdentifier.versionOf(null));
            if (this.canLog(authorityFactoryIdentifier)) {
                authorityFactoryIdentifier.logFallback();
            }
            return authorityFactory;
        }
        String string = authorityFactoryIdentifier.getAuthorityAndVersion().toString();
        throw new NoSuchAuthorityFactoryException(Resources.format((short)66, string), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canLog(AuthorityFactoryIdentifier authorityFactoryIdentifier) {
        Map<AuthorityFactoryIdentifier, Boolean> map = this.warnings;
        synchronized (map) {
            if (this.warnings.containsKey(authorityFactoryIdentifier)) {
                return false;
            }
            return this.warnings.putIfAbsent(authorityFactoryIdentifier.intern(), Boolean.TRUE) == null;
        }
    }

    private <T> T create(AuthorityFactoryProxy<? extends T> authorityFactoryProxy, String string) throws FactoryException {
        String[] stringArray;
        String string2;
        String string3;
        Serializable serializable;
        ArgumentChecks.ensureNonNull("code", string);
        DefinitionURI definitionURI = DefinitionURI.parse(string);
        if (definitionURI != null) {
            DefinitionURI[] object;
            serializable = authorityFactoryProxy.type;
            authorityFactoryProxy = authorityFactoryProxy.specialize(definitionURI.type);
            if (definitionURI.code == null && (object = definitionURI.components) != null) {
                for (int i = 0; i < object.length; ++i) {
                    if (object[i] != null) continue;
                    throw new NoSuchAuthorityCodeException(Resources.format((short)78, i + 1, definitionURI.isHTTP ? 1 : 0), definitionURI.authority, null, definitionURI.toString());
                }
                if (authorityFactoryProxy != null) {
                    serializable = authorityFactoryProxy.type;
                }
                return this.combine((Class<T>)serializable, object, definitionURI.isHTTP);
            }
            if (definitionURI.authority == null) {
                throw new NoSuchAuthorityCodeException(Resources.format((short)39, string), null, definitionURI.code, string);
            }
            string3 = definitionURI.authority;
            string2 = definitionURI.version;
            string = definitionURI.code;
            stringArray = definitionURI.parameters;
            if (string == null || authorityFactoryProxy == null) {
                String n3 = definitionURI.toString();
                String string4 = string == null ? Errors.format((short)85, n3, "code") : Resources.format((short)4, serializable, "urn:ogc:def:" + definitionURI.type);
                throw new NoSuchAuthorityCodeException(string4, string3, string, n3);
            }
        } else {
            int n;
            int n2;
            int n22 = string.indexOf(58);
            int n3 = CharSequences.skipTrailingWhitespaces(string, 0, n22);
            int n4 = CharSequences.skipLeadingWhitespaces(string, 0, n3);
            if (n4 >= n3) {
                throw new NoSuchAuthorityCodeException(Resources.format((short)39, string), null, string);
            }
            string3 = string.substring(n4, n3);
            String string5 = string2 = (n4 = CharSequences.skipLeadingWhitespaces(string, ++n22, n2 = string.indexOf(58, n22))) < (n = CharSequences.skipTrailingWhitespaces(string, n4, n2)) && !string.regionMatches(n4, "0", 0, "0".length()) ? string.substring(n4, n) : null;
            if (string2 != null && !Character.isUnicodeIdentifierPart(string2.codePointAt(0))) {
                throw new NoSuchAuthorityCodeException(Errors.format((short)179, string2), string3, string);
            }
            string = CharSequences.trimWhitespaces(string, Math.max(n22, n2 + 1), string.length()).toString();
            stringArray = null;
        }
        if (stringArray != null || string.indexOf(44) >= 0) {
            serializable = new StringBuilder(string3.length() + string.length() + 1).append(string3).append(':').append(string);
            if (stringArray != null) {
                for (String string6 : stringArray) {
                    ((StringBuilder)serializable).append(',').append(string6);
                }
            }
            string = ((StringBuilder)serializable).toString();
        }
        return authorityFactoryProxy.createFromAPI(this.getAuthorityFactory(AuthorityFactoryIdentifier.create(authorityFactoryProxy.factoryType, string3, string2)), string);
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.DESCRIPTION, string);
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.OBJECT, string);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.CRS, string);
    }

    @Override
    public GeographicCRS createGeographicCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.GEOGRAPHIC_CRS, string);
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.GEOCENTRIC_CRS, string);
    }

    @Override
    public ProjectedCRS createProjectedCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.PROJECTED_CRS, string);
    }

    @Override
    public VerticalCRS createVerticalCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.VERTICAL_CRS, string);
    }

    @Override
    public TemporalCRS createTemporalCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.TEMPORAL_CRS, string);
    }

    @Override
    public CompoundCRS createCompoundCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.COMPOUND_CRS, string);
    }

    @Override
    public DerivedCRS createDerivedCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.DERIVED_CRS, string);
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ENGINEERING_CRS, string);
    }

    @Override
    public ImageCRS createImageCRS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.IMAGE_CRS, string);
    }

    @Override
    public Datum createDatum(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.DATUM, string);
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.GEODETIC_DATUM, string);
    }

    @Override
    public VerticalDatum createVerticalDatum(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.VERTICAL_DATUM, string);
    }

    @Override
    public TemporalDatum createTemporalDatum(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.TEMPORAL_DATUM, string);
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ENGINEERING_DATUM, string);
    }

    @Override
    public ImageDatum createImageDatum(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.IMAGE_DATUM, string);
    }

    @Override
    public Ellipsoid createEllipsoid(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ELLIPSOID, string);
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.PRIME_MERIDIAN, string);
    }

    @Override
    public Extent createExtent(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.EXTENT, string);
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.COORDINATE_SYSTEM, string);
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.ELLIPSOIDAL_CS, string);
    }

    @Override
    public VerticalCS createVerticalCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.VERTICAL_CS, string);
    }

    @Override
    public TimeCS createTimeCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.TIME_CS, string);
    }

    @Override
    public CartesianCS createCartesianCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.CARTESIAN_CS, string);
    }

    @Override
    public SphericalCS createSphericalCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.SPHERICAL_CS, string);
    }

    @Override
    public CylindricalCS createCylindricalCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.CYLINDRICAL_CS, string);
    }

    @Override
    public PolarCS createPolarCS(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.POLAR_CS, string);
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.AXIS, string);
    }

    @Override
    public Unit<?> createUnit(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.UNIT, string);
    }

    @Override
    public ParameterDescriptor<?> createParameterDescriptor(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.PARAMETER, string);
    }

    @Override
    public OperationMethod createOperationMethod(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.METHOD, string);
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String string) throws FactoryException {
        return this.create(AuthorityFactoryProxy.OPERATION, string);
    }

    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String string, String string2) throws FactoryException {
        Deferred deferred = new Deferred();
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.create(deferred, string);
        String string3 = deferred.code;
        if (this.create(deferred, string2) == coordinateOperationAuthorityFactory) {
            return coordinateOperationAuthorityFactory.createFromCoordinateReferenceSystemCodes(string3, deferred.code);
        }
        LogRecord logRecord = Resources.forLocale(null).getLogRecord(Level.WARNING, (short)34, string, string2);
        logRecord.setLoggerName("org.apache.sis.referencing.factory");
        Logging.log(MultiAuthoritiesFactory.class, "createFromCoordinateReferenceSystemCodes", logRecord);
        return super.createFromCoordinateReferenceSystemCodes(string, string2);
    }

    private <T> T combine(Class<T> clazz, DefinitionURI[] definitionURIArray, boolean bl) throws FactoryException {
        Object object;
        Object object2;
        IdentifiedObject[] identifiedObjectArray;
        Class clazz2;
        int n;
        if (CoordinateReferenceSystem.class.isAssignableFrom(clazz)) {
            n = 0;
            clazz2 = CoordinateReferenceSystem.class;
            identifiedObjectArray = new CoordinateReferenceSystem[definitionURIArray.length];
        } else if (CoordinateOperation.class.isAssignableFrom(clazz)) {
            n = 3;
            clazz2 = CoordinateOperation.class;
            identifiedObjectArray = new CoordinateOperation[definitionURIArray.length];
        } else {
            throw new FactoryException(Resources.format((short)79, clazz));
        }
        String string = NameMeaning.toObjectType(clazz2);
        for (int i = 0; i < definitionURIArray.length; ++i) {
            object2 = definitionURIArray[i];
            object = this.createObject(object2.toString());
            if (!(clazz2 == null || clazz2.isInstance(object) && string.equalsIgnoreCase(object2.type))) {
                clazz2 = null;
                identifiedObjectArray = (IdentifiedObject[])Arrays.copyOf(identifiedObjectArray, identifiedObjectArray.length, IdentifiedObject[].class);
            }
            identifiedObjectArray[i] = object;
        }
        IdentifiedObject identifiedObject = null;
        switch (n) {
            case 3: {
                if (clazz2 == null) break;
                object2 = (CoordinateOperation[])identifiedObjectArray;
                object = IdentifiedObjects.getIdentifierOrName(object2[0]) + " \u27f6 " + IdentifiedObjects.getIdentifierOrName(object2[((CoordinateOperation[])object2).length - 1]);
                identifiedObject = DefaultFactories.forBuildin(CoordinateOperationFactory.class).createConcatenatedOperation(Collections.singletonMap("name", object), (CoordinateOperation)object2);
                break;
            }
            case 0: {
                if (clazz2 != null) {
                    identifiedObject = CRS.compound((CoordinateReferenceSystem[])identifiedObjectArray);
                    break;
                }
                if (bl || (object2 = MultiAuthoritiesFactory.remove(definitionURIArray, identifiedObjectArray, CoordinateSystem.class)) == null) break;
                object = MultiAuthoritiesFactory.remove(definitionURIArray, identifiedObjectArray, Datum.class);
                if (object != null) {
                    if (!ArraysExt.allEquals(definitionURIArray, null)) break;
                    identifiedObject = MultiAuthoritiesFactory.combine((GeodeticDatum)object, (CoordinateSystem)object2);
                    break;
                }
                CoordinateReferenceSystem coordinateReferenceSystem = MultiAuthoritiesFactory.remove(definitionURIArray, identifiedObjectArray, CoordinateReferenceSystem.class);
                CoordinateOperation coordinateOperation = MultiAuthoritiesFactory.remove(definitionURIArray, identifiedObjectArray, CoordinateOperation.class);
                if (!ArraysExt.allEquals(definitionURIArray, null) || !(coordinateOperation instanceof Conversion)) break;
                identifiedObject = MultiAuthoritiesFactory.combine(coordinateReferenceSystem, (Conversion)coordinateOperation, (CoordinateSystem)object2);
            }
        }
        if (identifiedObject == null) {
            throw new FactoryException(Resources.format((short)80));
        }
        object2 = this.newIdentifiedObjectFinder().findSingleton(identifiedObject);
        return clazz.cast(object2 != null ? object2 : identifiedObject);
    }

    private static <T> T remove(DefinitionURI[] definitionURIArray, IdentifiedObject[] identifiedObjectArray, Class<T> clazz) {
        String string = NameMeaning.toObjectType(clazz);
        for (int i = 0; i < definitionURIArray.length; ++i) {
            DefinitionURI definitionURI = definitionURIArray[i];
            if (definitionURI == null || !string.equalsIgnoreCase(definitionURI.type)) continue;
            definitionURIArray[i] = null;
            return clazz.cast(identifiedObjectArray[i]);
        }
        return null;
    }

    private static GeodeticCRS combine(GeodeticDatum geodeticDatum, CoordinateSystem coordinateSystem) throws FactoryException {
        Map<String, ?> map = IdentifiedObjects.getProperties(geodeticDatum, "identifiers");
        CRSFactory cRSFactory = DefaultFactories.forBuildin(CRSFactory.class);
        if (geodeticDatum instanceof GeodeticDatum) {
            if (coordinateSystem instanceof EllipsoidalCS) {
                return cRSFactory.createGeographicCRS(map, geodeticDatum, (EllipsoidalCS)coordinateSystem);
            }
            if (coordinateSystem instanceof SphericalCS) {
                return cRSFactory.createGeocentricCRS(map, geodeticDatum, (SphericalCS)coordinateSystem);
            }
        }
        return null;
    }

    private static GeneralDerivedCRS combine(CoordinateReferenceSystem coordinateReferenceSystem, Conversion conversion, CoordinateSystem coordinateSystem) throws FactoryException {
        if (coordinateReferenceSystem != null && conversion.getSourceCRS() == null && conversion.getTargetCRS() == null) {
            Map<String, ?> map = IdentifiedObjects.getProperties(conversion, "identifiers");
            CRSFactory cRSFactory = DefaultFactories.forBuildin(CRSFactory.class);
            if (coordinateReferenceSystem instanceof GeographicCRS && coordinateSystem instanceof CartesianCS) {
                return cRSFactory.createProjectedCRS(map, (GeographicCRS)coordinateReferenceSystem, conversion, (CartesianCS)coordinateSystem);
            }
            return cRSFactory.createDerivedCRS(map, coordinateReferenceSystem, conversion, coordinateSystem);
        }
        return null;
    }

    @Override
    public IdentifiedObjectFinder newIdentifiedObjectFinder() throws FactoryException {
        return new Finder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        for (int i = 0; i < this.providers.length; ++i) {
            Iterable<? extends AuthorityFactory> iterable = this.providers[i];
            if (iterable == null) continue;
            Iterable<? extends AuthorityFactory> iterable2 = iterable;
            synchronized (iterable2) {
                if (iterable instanceof LazySet) {
                    ((LazySet)iterable).reload();
                }
                if (iterable instanceof ServiceLoader) {
                    ((ServiceLoader)iterable).reload();
                }
                this.applyAndMask(~(1 << i));
                Iterator iterator = this.factories.keySet().iterator();
                while (iterator.hasNext()) {
                    if (((AuthorityFactoryIdentifier)iterator.next()).type != i) continue;
                    iterator.remove();
                }
                continue;
            }
        }
        this.applyAndMask(this.providers.length - 1);
    }

    private void applyAndMask(int n) {
        int n2;
        while (!this.isIterationCompleted.compareAndSet(n2 = this.isIterationCompleted.get(), n2 & n)) {
        }
    }

    private static class Finder
    extends IdentifiedObjectFinder {
        private IdentifiedObjectFinder[] finders;

        protected Finder(MultiAuthoritiesFactory multiAuthoritiesFactory) throws FactoryException {
            super(multiAuthoritiesFactory);
        }

        @Override
        public void setSearchDomain(IdentifiedObjectFinder.Domain domain) {
            super.setSearchDomain(domain);
            if (this.finders != null) {
                for (IdentifiedObjectFinder identifiedObjectFinder : this.finders) {
                    identifiedObjectFinder.setSearchDomain(domain);
                }
            }
        }

        @Override
        public void setIgnoringAxes(boolean bl) {
            super.setIgnoringAxes(bl);
            if (this.finders != null) {
                for (IdentifiedObjectFinder identifiedObjectFinder : this.finders) {
                    identifiedObjectFinder.setIgnoringAxes(bl);
                }
            }
        }

        @Override
        final Set<IdentifiedObject> createFromCodes(IdentifiedObject identifiedObject) throws FactoryException {
            LinkedHashSet<IdentifiedObject> linkedHashSet;
            if (this.finders == null) {
                try {
                    linkedHashSet = new ArrayList();
                    IdentityHashMap identityHashMap = new IdentityHashMap();
                    Iterator<AuthorityFactory> iterator = ((MultiAuthoritiesFactory)this.factory).getAllFactories();
                    while (iterator.hasNext()) {
                        IdentifiedObjectFinder identifiedObjectFinder;
                        AuthorityFactory authorityFactory = iterator.next();
                        if (!(authorityFactory instanceof GeodeticAuthorityFactory) || identityHashMap.put(authorityFactory, Boolean.TRUE) != null || (identifiedObjectFinder = ((GeodeticAuthorityFactory)authorityFactory).newIdentifiedObjectFinder()) == null) continue;
                        identifiedObjectFinder.ignoreIdentifiers = true;
                        identifiedObjectFinder.setWrapper(this);
                        ((ArrayList)((Object)linkedHashSet)).add((IdentifiedObject)((Object)identifiedObjectFinder));
                    }
                    this.finders = ((ArrayList)((Object)linkedHashSet)).toArray((IdentifiedObjectFinder[])new IdentifiedObjectFinder[((ArrayList)((Object)linkedHashSet)).size()]);
                }
                catch (BackingStoreException backingStoreException) {
                    throw backingStoreException.unwrapOrRethrow(FactoryException.class);
                }
            }
            linkedHashSet = new LinkedHashSet();
            for (IdentifiedObjectFinder identifiedObjectFinder : this.finders) {
                linkedHashSet.addAll(identifiedObjectFinder.find(identifiedObject));
            }
            return linkedHashSet;
        }
    }

    private static final class Deferred
    extends AuthorityFactoryProxy<CoordinateOperationAuthorityFactory> {
        String code;

        Deferred() {
            super(CoordinateOperationAuthorityFactory.class, (byte)3);
        }

        @Override
        CoordinateOperationAuthorityFactory createFromAPI(AuthorityFactory authorityFactory, String string) throws FactoryException {
            this.code = string;
            return this.opFactory(authorityFactory);
        }
    }
}

