/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.internal.referencing.EPSGParameterDomain;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.ReferenceIdentifier;

final class Verifier {
    private final short errorKey;
    private final boolean internal;
    private final boolean needsValue;
    private final Object[] arguments;

    private Verifier(boolean bl, short s2, boolean bl2, Object ... objectArray) {
        this.errorKey = s2;
        this.internal = bl;
        this.needsValue = bl2;
        this.arguments = objectArray;
    }

    static <T> T ensureValidValue(ParameterDescriptor<T> parameterDescriptor, Object object, Unit<?> unit) throws InvalidParameterValueException {
        Serializable serializable;
        Object object2;
        Object object3;
        Class<T> clazz = parameterDescriptor.getValueClass();
        UnitConverter unitConverter = null;
        Object object4 = object;
        if (unit != null) {
            object3 = parameterDescriptor.getUnit();
            if (object3 == null && (object3 = Verifier.getCompatibleUnit(Parameters.getValueDomain(parameterDescriptor), unit)) == null) {
                String string = Verifier.getDisplayName(parameterDescriptor);
                throw new InvalidParameterValueException(Resources.format((short)65, string), string, unit);
            }
            if (!unit.equals(object3)) {
                short s2 = Verifier.getUnitMessageID(object3);
                if (Verifier.getUnitMessageID(unit) != s2) {
                    throw new IllegalArgumentException(Errors.format(s2, unit));
                }
                if (object != null) {
                    if (!clazz.isInstance(object)) {
                        String string = Verifier.getDisplayName(parameterDescriptor);
                        throw new InvalidParameterValueException(Resources.format((short)24, string, clazz, object.getClass()), string, object);
                    }
                    try {
                        unitConverter = unit.getConverterToAny((Unit<?>)object3);
                    }
                    catch (IncommensurableException incommensurableException) {
                        throw new IllegalArgumentException(Errors.format((short)66, unit, object3), incommensurableException);
                    }
                    object2 = clazz.getComponentType();
                    if (object2 != null) {
                        int n = Array.getLength(object);
                        if (n != 0) {
                            serializable = Numbers.primitiveToWrapper(object2).asSubclass(Number.class);
                            object4 = Array.newInstance(object2, n);
                            int n2 = 0;
                            try {
                                do {
                                    Number number = (Number)Array.get(object, n2);
                                    number = unitConverter.convert(number);
                                    number = Numbers.cast(number, serializable);
                                    Array.set(object4, n2, number);
                                } while (++n2 < n);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw (InvalidParameterValueException)new InvalidParameterValueException(illegalArgumentException.getLocalizedMessage(), Strings.toIndexed(Verifier.getDisplayName(parameterDescriptor), n2), object).initCause(illegalArgumentException);
                            }
                        }
                    } else {
                        try {
                            Number number = unitConverter.convert((Number)object);
                            object4 = Numbers.cast(number, clazz.asSubclass(Number.class));
                        }
                        catch (ClassCastException | IllegalArgumentException runtimeException) {
                            throw (InvalidParameterValueException)new InvalidParameterValueException(runtimeException.getLocalizedMessage(), Verifier.getDisplayName(parameterDescriptor), object).initCause(runtimeException);
                        }
                    }
                }
            }
        }
        if (object4 != null) {
            Set<T> set = parameterDescriptor.getValidValues();
            object3 = parameterDescriptor instanceof DefaultParameterDescriptor ? Verifier.ensureValidValue(clazz, set, ((DefaultParameterDescriptor)parameterDescriptor).getValueDomain(), object4) : Verifier.ensureValidValue(clazz, set, parameterDescriptor.getMinimumValue(), parameterDescriptor.getMaximumValue(), object4);
            if (object3 != null) {
                super.convertRange(unitConverter);
                object2 = Verifier.getDisplayName(parameterDescriptor);
                String string = ((Verifier)object3).message(null, (String)object2, object);
                if (!Semaphores.query(16)) {
                    throw new InvalidParameterValueException(string, (String)object2, object);
                }
                serializable = new LogRecord(Level.WARNING, string);
                serializable.setLoggerName("org.apache.sis.referencing.operation");
                Logging.log(DefaultParameterValue.class, "setValue", serializable);
            }
        }
        return clazz.cast(object4);
    }

    static <T> Verifier ensureValidValue(Class<T> clazz, Set<T> set, Range<?> range, Object object) {
        Verifier verifier = Verifier.ensureValidValue(clazz, set, null, null, object);
        if (verifier == null && range != null) {
            boolean bl = clazz.isArray();
            assert (range.getElementType() == (bl ? Numbers.primitiveToWrapper(clazz.getComponentType()) : clazz)) : range;
            int n = bl ? Array.getLength(object) : 1;
            for (int i = 0; i < n; ++i) {
                Object[] objectArray;
                short s2;
                Object object2;
                Object object3 = object2 = bl ? Array.get(object, i) : object;
                if (range.contains((Comparable)object2)) continue;
                Object obj = range.getMinValue();
                if (obj instanceof Number && ((Number)obj).doubleValue() == 0.0 && !range.isMinIncluded() && object2 instanceof Number && ((Number)object2).doubleValue() < 0.0) {
                    s2 = 165;
                    objectArray = new Object[2];
                } else {
                    s2 = 166;
                    objectArray = new Object[4];
                    objectArray[1] = obj;
                    objectArray[2] = range.getMaxValue();
                }
                if (bl) {
                    objectArray[0] = i;
                }
                objectArray[objectArray.length - 1] = object2;
                return new Verifier(false, s2, true, objectArray);
            }
        }
        return verifier;
    }

    private static <T> Verifier ensureValidValue(Class<T> clazz, Set<T> set, Comparable<T> comparable, Comparable<T> comparable2, Object object) {
        if (!clazz.isInstance(object)) {
            return new Verifier(true, 24, false, null, clazz, object.getClass());
        }
        if (set != null && !set.contains(object)) {
            return new Verifier(true, 25, true, null, object);
        }
        if (comparable != null && comparable.compareTo(object) > 0 || comparable2 != null && comparable2.compareTo(object) < 0) {
            return new Verifier(false, 166, true, null, comparable, comparable2, object);
        }
        return null;
    }

    private void convertRange(UnitConverter unitConverter) {
        if (unitConverter != null && !this.internal && this.errorKey == 166) {
            unitConverter = unitConverter.inverse();
            Object object = this.arguments[1];
            Object object2 = this.arguments[2];
            object = object != null ? Double.valueOf(unitConverter.convert(((Number)object).doubleValue())) : "\u2212\u221e";
            object2 = object2 != null ? Double.valueOf(unitConverter.convert(((Number)object2).doubleValue())) : "\u221e";
            this.arguments[1] = object;
            this.arguments[2] = object2;
        }
    }

    private static Unit<?> getCompatibleUnit(Range<?> range, Unit<?> unit) {
        if (range instanceof EPSGParameterDomain) {
            for (Unit<?> unit2 : ((EPSGParameterDomain)range).units) {
                if (!unit.isCompatible(unit2)) continue;
                return unit2;
            }
        }
        return null;
    }

    String message(Map<?, ?> map, String string, Object object) {
        Object object2 = this.arguments[0];
        if (object2 != null) {
            string = Strings.bracket(string, object2);
            object = Array.get(object, (Integer)object2);
        }
        this.arguments[0] = string;
        if (this.needsValue) {
            this.arguments[this.arguments.length - 1] = object;
        }
        return (this.internal ? Resources.forProperties(map) : Errors.getResources(map)).getString(this.errorKey, this.arguments);
    }

    static String getDisplayName(GeneralParameterDescriptor generalParameterDescriptor) {
        String string;
        ReferenceIdentifier referenceIdentifier;
        if (generalParameterDescriptor != null && (referenceIdentifier = generalParameterDescriptor.getName()) != null && (string = referenceIdentifier.getCode()) != null) {
            return string;
        }
        return Vocabulary.format((short)108);
    }

    static short getUnitMessageID(Unit<?> unit) {
        if (Units.isLinear(unit)) {
            return 103;
        }
        if (Units.isAngular(unit)) {
            return 100;
        }
        if (Units.isTemporal(unit)) {
            return 107;
        }
        if (Units.isScale(unit)) {
            return 105;
        }
        return 65;
    }
}

