/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.acquisition;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Plan;
import org.opengis.metadata.acquisition.Priority;
import org.opengis.metadata.acquisition.RequestedDate;
import org.opengis.metadata.acquisition.Requirement;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;

@XmlType(name="MI_Requirement_Type", propOrder={"citation", "identifier", "requestors", "recipients", "priority", "requestedDate", "expiryDate", "satisfiedPlans"})
@XmlRootElement(name="MI_Requirement")
public class DefaultRequirement
extends ISOMetadata
implements Requirement {
    private static final long serialVersionUID = -4987984804974769238L;
    private Citation citation;
    private Collection<ResponsibleParty> requestors;
    private Collection<ResponsibleParty> recipients;
    private Priority priority;
    private RequestedDate requestedDate;
    private long expiryDate = Long.MIN_VALUE;
    private Collection<Plan> satisfiedPlans;

    public DefaultRequirement() {
    }

    public DefaultRequirement(Requirement requirement) {
        super(requirement);
        if (requirement != null) {
            this.citation = requirement.getCitation();
            this.identifiers = this.singleton(requirement.getIdentifier(), Identifier.class);
            this.requestors = this.copyCollection(requirement.getRequestors(), ResponsibleParty.class);
            this.recipients = this.copyCollection(requirement.getRecipients(), ResponsibleParty.class);
            this.priority = requirement.getPriority();
            this.requestedDate = requirement.getRequestedDate();
            this.expiryDate = MetadataUtilities.toMilliseconds(requirement.getExpiryDate());
            this.satisfiedPlans = this.copyCollection(requirement.getSatisfiedPlans(), Plan.class);
        }
    }

    public static DefaultRequirement castOrCopy(Requirement requirement) {
        if (requirement == null || requirement instanceof DefaultRequirement) {
            return (DefaultRequirement)requirement;
        }
        return new DefaultRequirement(requirement);
    }

    @Override
    @XmlElement(name="citation")
    public Citation getCitation() {
        return this.citation;
    }

    public void setCitation(Citation citation) {
        this.checkWritePermission(this.citation);
        this.citation = citation;
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    @Override
    public void setIdentifier(Identifier identifier) {
        super.setIdentifier(identifier);
    }

    @XmlElement(name="requestor", required=true)
    public Collection<ResponsibleParty> getRequestors() {
        this.requestors = this.nonNullCollection(this.requestors, ResponsibleParty.class);
        return this.requestors;
    }

    public void setRequestors(Collection<? extends ResponsibleParty> collection) {
        this.requestors = this.writeCollection(collection, this.requestors, ResponsibleParty.class);
    }

    @XmlElement(name="recipient", required=true)
    public Collection<ResponsibleParty> getRecipients() {
        this.recipients = this.nonNullCollection(this.recipients, ResponsibleParty.class);
        return this.recipients;
    }

    public void setRecipients(Collection<? extends ResponsibleParty> collection) {
        this.recipients = this.writeCollection(collection, this.recipients, ResponsibleParty.class);
    }

    @Override
    @XmlElement(name="priority", required=true)
    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.checkWritePermission(this.priority);
        this.priority = priority;
    }

    @Override
    @XmlElement(name="requestedDate", required=true)
    public RequestedDate getRequestedDate() {
        return this.requestedDate;
    }

    public void setRequestedDate(RequestedDate requestedDate) {
        this.checkWritePermission(this.requestedDate);
        this.requestedDate = requestedDate;
    }

    @Override
    @XmlElement(name="expiryDate", required=true)
    public Date getExpiryDate() {
        return MetadataUtilities.toDate(this.expiryDate);
    }

    public void setExpiryDate(Date date) {
        this.checkWritePermission(MetadataUtilities.toDate(this.expiryDate));
        this.expiryDate = MetadataUtilities.toMilliseconds(date);
    }

    @XmlElement(name="satisifiedPlan")
    public Collection<Plan> getSatisfiedPlans() {
        this.satisfiedPlans = this.nonNullCollection(this.satisfiedPlans, Plan.class);
        return this.satisfiedPlans;
    }

    public void setSatisfiedPlans(Collection<? extends Plan> collection) {
        this.satisfiedPlans = this.writeCollection(collection, this.satisfiedPlans, Plan.class);
    }
}

