/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.NilReason;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Datatype;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.util.InternationalString;

@TitleProperty(name="name")
@XmlType(name="MD_ExtendedElementInformation_Type", namespace="http://standards.iso.org/iso/19115/-3/mex/1.0", propOrder={"name", "shortName", "domainCode", "definition", "obligation", "condition", "dataType", "maxOccurs", "domainValue", "parentEntity", "rule", "rationale", "sources"})
@XmlRootElement(name="MD_ExtendedElementInformation", namespace="http://standards.iso.org/iso/19115/-3/mex/1.0")
public class DefaultExtendedElementInformation
extends ISOMetadata
implements ExtendedElementInformation {
    private static final long serialVersionUID = 5892811836634834434L;
    private String name;
    @Deprecated
    private String shortName;
    @Deprecated
    private Integer domainCode;
    private InternationalString definition;
    private org.opengis.metadata.Obligation obligation;
    private InternationalString condition;
    private Datatype dataType;
    private Integer maximumOccurrence;
    private InternationalString domainValue;
    private Collection<String> parentEntity;
    private InternationalString rule;
    private Collection<InternationalString> rationales;
    private Collection<ResponsibleParty> sources;

    public DefaultExtendedElementInformation() {
    }

    public DefaultExtendedElementInformation(String string, CharSequence charSequence, CharSequence charSequence2, Datatype datatype, String string2, CharSequence charSequence3, ResponsibleParty responsibleParty) {
        this.name = string;
        this.definition = Types.toInternationalString(charSequence);
        this.condition = Types.toInternationalString(charSequence2);
        this.dataType = datatype;
        this.parentEntity = this.singleton(string2, String.class);
        this.rule = Types.toInternationalString(charSequence3);
        this.sources = this.singleton(responsibleParty, ResponsibleParty.class);
    }

    public DefaultExtendedElementInformation(ExtendedElementInformation extendedElementInformation) {
        super(extendedElementInformation);
        if (extendedElementInformation != null) {
            this.name = extendedElementInformation.getName();
            this.shortName = extendedElementInformation.getShortName();
            this.domainCode = extendedElementInformation.getDomainCode();
            this.definition = extendedElementInformation.getDefinition();
            this.obligation = extendedElementInformation.getObligation();
            this.condition = extendedElementInformation.getCondition();
            this.dataType = extendedElementInformation.getDataType();
            this.maximumOccurrence = extendedElementInformation.getMaximumOccurrence();
            this.domainValue = extendedElementInformation.getDomainValue();
            this.parentEntity = this.copyCollection(extendedElementInformation.getParentEntity(), String.class);
            this.rule = extendedElementInformation.getRule();
            this.rationales = this.copyCollection(extendedElementInformation.getRationales(), InternationalString.class);
            this.sources = this.copyCollection(extendedElementInformation.getSources(), ResponsibleParty.class);
        }
    }

    public static DefaultExtendedElementInformation castOrCopy(ExtendedElementInformation extendedElementInformation) {
        if (extendedElementInformation == null || extendedElementInformation instanceof DefaultExtendedElementInformation) {
            return (DefaultExtendedElementInformation)extendedElementInformation;
        }
        return new DefaultExtendedElementInformation(extendedElementInformation);
    }

    @Override
    @XmlElement(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.checkWritePermission(this.name);
        this.name = string;
    }

    @Override
    @Deprecated
    @XmlElement(name="shortName", namespace="http://www.isotc211.org/2005/gmd")
    public String getShortName() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.shortName : null;
    }

    @Deprecated
    public void setShortName(String string) {
        this.checkWritePermission(this.shortName);
        this.shortName = string;
    }

    @Override
    @Deprecated
    @XmlElement(name="domainCode", namespace="http://www.isotc211.org/2005/gmd")
    public Integer getDomainCode() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.domainCode : null;
    }

    @Deprecated
    public void setDomainCode(Integer n) {
        this.checkWritePermission(this.domainCode);
        this.domainCode = n;
    }

    @Override
    @XmlElement(name="definition", required=true)
    public InternationalString getDefinition() {
        return this.definition;
    }

    public void setDefinition(InternationalString internationalString) {
        this.checkWritePermission(this.definition);
        this.definition = internationalString;
    }

    @Override
    @XmlElement(name="obligation")
    public org.opengis.metadata.Obligation getObligation() {
        return this.obligation;
    }

    public void setObligation(org.opengis.metadata.Obligation obligation) {
        this.checkWritePermission(this.obligation);
        this.obligation = obligation;
    }

    @Override
    @XmlElement(name="condition")
    public InternationalString getCondition() {
        return this.condition;
    }

    public void setCondition(InternationalString internationalString) {
        this.checkWritePermission(this.condition);
        this.condition = internationalString;
    }

    @Override
    @XmlElement(name="dataType", required=true)
    public Datatype getDataType() {
        return this.dataType;
    }

    public void setDataType(Datatype datatype) {
        this.checkWritePermission(this.dataType);
        this.dataType = datatype;
    }

    @Override
    @ValueRange(minimum=0.0)
    public Integer getMaximumOccurrence() {
        return this.maximumOccurrence;
    }

    public void setMaximumOccurrence(Integer n) {
        this.checkWritePermission(this.maximumOccurrence);
        if (MetadataUtilities.ensurePositive(DefaultExtendedElementInformation.class, "maximumOccurrence", false, n)) {
            this.maximumOccurrence = n;
        }
    }

    @Override
    @XmlElement(name="domainValue")
    public InternationalString getDomainValue() {
        return this.domainValue;
    }

    public void setDomainValue(InternationalString internationalString) {
        this.checkWritePermission(this.domainValue);
        this.domainValue = internationalString;
    }

    @Override
    @XmlElement(name="parentEntity", required=true)
    public Collection<String> getParentEntity() {
        this.parentEntity = this.nonNullCollection(this.parentEntity, String.class);
        return this.parentEntity;
    }

    public void setParentEntity(Collection<? extends String> collection) {
        this.parentEntity = this.writeCollection(collection, this.parentEntity, String.class);
    }

    @Override
    @XmlElement(name="rule", required=true)
    public InternationalString getRule() {
        return this.rule;
    }

    public void setRule(InternationalString internationalString) {
        this.checkWritePermission(this.rule);
        this.rule = internationalString;
    }

    @XmlElement(name="rationale")
    @UML(identifier="rationale", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getRationale() {
        return LegacyPropertyAdapter.getSingleton(this.rationales, InternationalString.class, null, DefaultExtendedElementInformation.class, "getRationale");
    }

    public void setRationale(InternationalString internationalString) {
        this.rationales = this.writeCollection(CollectionsExt.singletonOrEmpty(internationalString), this.rationales, InternationalString.class);
    }

    @Deprecated
    @Dependencies(value={"getRationale"})
    public Collection<InternationalString> getRationales() {
        this.rationales = this.nonNullCollection(this.rationales, InternationalString.class);
        return this.rationales;
    }

    @Deprecated
    public void setRationales(Collection<? extends InternationalString> collection) {
        this.rationales = this.writeCollection(collection, this.rationales, InternationalString.class);
    }

    @XmlElement(name="source", required=true)
    public Collection<ResponsibleParty> getSources() {
        this.sources = this.nonNullCollection(this.sources, ResponsibleParty.class);
        return this.sources;
    }

    public void setSources(Collection<? extends ResponsibleParty> collection) {
        this.sources = this.writeCollection(collection, this.sources, ResponsibleParty.class);
    }

    @XmlElement(name="maximumOccurrence")
    private String getMaxOccurs() {
        Integer n = this.getMaximumOccurrence();
        if (n == null) {
            return null;
        }
        NilReason nilReason = NilReason.forObject(n);
        if (nilReason != null) {
            return nilReason.createNilObject(String.class);
        }
        return n.toString();
    }

    private void setMaxOccurs(String string) {
        if (string != null) {
            Integer n;
            NilReason nilReason = NilReason.forObject(string);
            if (nilReason != null) {
                n = nilReason.createNilObject(Integer.class);
            } else {
                try {
                    n = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    Context.warningOccured(Context.current(), DefaultExtendedElementInformation.class, "setMaximumOccurrence", numberFormatException, true);
                    return;
                }
            }
            this.setMaximumOccurrence(n);
        }
    }
}

