/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.IntSupplier;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;

abstract class ArrayVector<E extends Number>
extends Vector
implements CheckedContainer<E>,
Serializable {
    private static final long serialVersionUID = 3496467575389288163L;

    ArrayVector() {
    }

    static Vector newInstance(Object object, boolean bl) throws IllegalArgumentException {
        ArrayVector arrayVector;
        if (object instanceof double[]) {
            arrayVector = new Doubles((double[])object);
        } else if (object instanceof float[]) {
            arrayVector = new Floats((float[])object);
        } else if (object instanceof long[]) {
            arrayVector = bl ? new UnsignedLongs((long[])object) : new Longs((long[])object);
        } else if (object instanceof int[]) {
            arrayVector = bl ? new UnsignedIntegers((int[])object) : new Integers((int[])object);
        } else if (object instanceof short[]) {
            arrayVector = bl ? new UnsignedShorts((short[])object) : new Shorts((short[])object);
        } else if (object instanceof byte[]) {
            arrayVector = bl ? new UnsignedBytes((byte[])object) : new Bytes((byte[])object);
        } else if (object instanceof Number[]) {
            arrayVector = new Raw((Number[])object);
        } else if (object instanceof String[]) {
            arrayVector = new ASCII((String[])object);
        } else {
            throw new IllegalArgumentException(Errors.format((short)42, "array", Classes.getClass(object)));
        }
        return arrayVector;
    }

    static Vector compress(Vector vector, long l, long l2) {
        boolean bl;
        boolean bl2 = bl = l >= -128L && l2 <= 127L;
        if (bl || l >= 0L && l2 <= 255L) {
            if (vector instanceof Bytes) {
                return null;
            }
            byte[] byArray = new byte[vector.size()];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)vector.intValue(i);
            }
            return bl ? new Bytes(byArray) : new UnsignedBytes(byArray);
        }
        boolean bl3 = bl = l >= -32768L && l2 <= 32767L;
        if (bl || l >= 0L && l2 <= 65535L) {
            if (vector instanceof Shorts) {
                return null;
            }
            short[] sArray = new short[vector.size()];
            for (int i = 0; i < sArray.length; ++i) {
                sArray[i] = (short)vector.intValue(i);
            }
            return bl ? new Shorts(sArray) : new UnsignedShorts(sArray);
        }
        boolean bl4 = bl = l >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE;
        if (bl || l >= 0L && l2 <= -1L) {
            if (vector instanceof Integers) {
                return null;
            }
            int[] nArray = new int[vector.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (int)vector.longValue(i);
            }
            return bl ? new Integers(nArray) : new UnsignedIntegers(nArray);
        }
        if (!(vector instanceof Longs || vector instanceof Floats || vector instanceof Doubles)) {
            long[] lArray = new long[vector.size()];
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = vector.longValue(i);
            }
            return new Longs(lArray);
        }
        return null;
    }

    static Vector compress(Vector vector, double d) {
        if (!Float.class.equals(vector.getElementType())) {
            int n;
            double d2;
            int n2;
            double d3;
            double d4;
            int n3 = vector.size();
            int n4 = 0;
            do {
                if (n4 >= n3) {
                    return new Floats(vector.floatValues());
                }
                n2 = n4++;
            } while (!(Math.abs(d4 - (double)((float)(d3 = vector.doubleValue(n2)))) > d));
            n4 = 0;
            do {
                if (n4 >= n3) {
                    return new Decimal(vector.floatValues());
                }
                n = n4++;
            } while (!(Math.abs(d2 - DecimalFunctions.floatToDouble((float)(d3 = vector.doubleValue(n)))) > d));
        }
        return null;
    }

    @Override
    public boolean isNaN(int n) {
        return false;
    }

    void verifyType(Number number, byte by) {
        Class<?> clazz = number.getClass();
        byte by2 = Numbers.getEnumConstant(clazz);
        if (by2 < 3 || by2 > by) {
            throw new ClassCastException(Errors.format((short)7, clazz, Numbers.wrapperToPrimitive(this.getElementType())));
        }
    }

    private static final class Raw
    extends ArrayVector<Number> {
        private static final long serialVersionUID = 5444263017359778157L;
        private final Number[] array;

        Raw(Number[] numberArray) {
            this.array = numberArray;
        }

        @Override
        public final Class getElementType() {
            return this.array.getClass().getComponentType();
        }

        @Override
        public boolean isNaN(int n) {
            Number number = this.array[n];
            if (number == null) {
                return true;
            }
            if (number instanceof Float) {
                return ((Float)number).isNaN();
            }
            if (number instanceof Double) {
                return ((Double)number).isNaN();
            }
            return false;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Number get(int n) {
            return this.array[n];
        }

        @Override
        public double doubleValue(int n) {
            return this.array[n].doubleValue();
        }

        @Override
        public float floatValue(int n) {
            return this.array[n].floatValue();
        }

        @Override
        public long longValue(int n) {
            return this.array[n].longValue();
        }

        @Override
        public int intValue(int n) {
            return this.array[n].intValue();
        }

        @Override
        public short shortValue(int n) {
            return this.array[n].shortValue();
        }

        @Override
        public byte byteValue(int n) {
            return this.array[n].byteValue();
        }

        @Override
        public String stringValue(int n) {
            Number number = this.array[n];
            return number != null ? number.toString() : null;
        }

        @Override
        public final Number set(int n, Number number) {
            Number number2 = this.array[n];
            this.array[n] = number;
            ++this.modCount;
            return number2;
        }
    }

    private static final class ASCII
    extends ArrayVector<Double> {
        private static final long serialVersionUID = 2801615620517491573L;
        private final String[] array;

        ASCII(String[] stringArray) {
            this.array = stringArray;
        }

        @Override
        public final Class<Double> getElementType() {
            return Double.class;
        }

        @Override
        public boolean isNaN(int n) {
            String string = this.array[n];
            if (string == null) {
                return true;
            }
            if (string.contains("NaN")) {
                string = string.trim();
                switch (string.length()) {
                    case 3: {
                        return true;
                    }
                    case 4: {
                        char c = string.charAt(0);
                        return c == '+' || c == '-';
                    }
                }
            }
            return false;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public String stringValue(int n) {
            return this.array[n];
        }

        @Override
        public double doubleValue(int n) {
            return Double.parseDouble(this.array[n]);
        }

        @Override
        public float floatValue(int n) {
            return Float.parseFloat(this.array[n]);
        }

        @Override
        public long longValue(int n) {
            return Long.parseLong(this.array[n]);
        }

        @Override
        public int intValue(int n) {
            return Integer.parseInt(this.array[n]);
        }

        @Override
        public short shortValue(int n) {
            return Short.parseShort(this.array[n]);
        }

        @Override
        public byte byteValue(int n) {
            return Byte.parseByte(this.array[n]);
        }

        @Override
        public Number get(int n) {
            String string = this.array[n];
            return string != null ? Double.valueOf(Double.parseDouble(string)) : null;
        }

        @Override
        public final Number set(int n, Number number) {
            Number number2 = this.get(n);
            this.array[n] = number.toString();
            ++this.modCount;
            return number2;
        }
    }

    private static final class UnsignedBytes
    extends Bytes {
        private static final long serialVersionUID = -2150064612523948331L;

        UnsignedBytes(byte[] byArray) {
            super(byArray);
        }

        @Override
        public boolean isUnsigned() {
            return true;
        }

        @Override
        public double doubleValue(int n) {
            return this.intValue(n);
        }

        @Override
        public float floatValue(int n) {
            return this.intValue(n);
        }

        @Override
        public long longValue(int n) {
            return Byte.toUnsignedLong(super.byteValue(n));
        }

        @Override
        public int intValue(int n) {
            return Byte.toUnsignedInt(super.byteValue(n));
        }

        @Override
        public short shortValue(int n) {
            return (short)this.intValue(n);
        }

        @Override
        public byte byteValue(int n) {
            byte by = super.byteValue(n);
            if (by >= 0) {
                return by;
            }
            throw new ArithmeticException(Errors.format((short)188, 8));
        }

        @Override
        public Number get(int n) {
            byte by = super.byteValue(n);
            if (by >= 0) {
                return by;
            }
            return (short)Byte.toUnsignedInt(by);
        }

        @Override
        void verifyType(Number number, byte by) {
            int n = number.intValue();
            if ((n & 0xFFFFFF00) == 0) {
                by = (byte)4;
            }
            super.verifyType(number, by);
        }

        @Override
        public String stringValue(int n) {
            return Integer.toString(this.intValue(n));
        }

        @Override
        NumberRange<?> range(IntSupplier intSupplier, int n) {
            short s2 = Short.MAX_VALUE;
            short s3 = Short.MIN_VALUE;
            while (--n >= 0) {
                short s4 = this.shortValue(intSupplier != null ? intSupplier.getAsInt() : n);
                if (s4 < s2) {
                    s2 = s4;
                }
                if (s4 <= s3) continue;
                s3 = s4;
            }
            return NumberRange.create(s2, true, s3, true);
        }
    }

    private static final class UnsignedShorts
    extends Shorts {
        private static final long serialVersionUID = 8219060080494444776L;

        UnsignedShorts(short[] sArray) {
            super(sArray);
        }

        @Override
        public boolean isUnsigned() {
            return true;
        }

        @Override
        public double doubleValue(int n) {
            return this.intValue(n);
        }

        @Override
        public float floatValue(int n) {
            return this.intValue(n);
        }

        @Override
        public long longValue(int n) {
            return Short.toUnsignedLong(super.shortValue(n));
        }

        @Override
        public int intValue(int n) {
            return Short.toUnsignedInt(super.shortValue(n));
        }

        @Override
        public short shortValue(int n) {
            short s2 = super.shortValue(n);
            if (s2 >= 0) {
                return s2;
            }
            throw new ArithmeticException(Errors.format((short)188, 16));
        }

        @Override
        public Number get(int n) {
            short s2 = super.shortValue(n);
            if (s2 >= 0) {
                return s2;
            }
            return Short.toUnsignedInt(s2);
        }

        @Override
        void verifyType(Number number, byte by) {
            int n = number.intValue();
            if ((n & 0xFFFF0000) == 0) {
                by = (byte)5;
            }
            super.verifyType(number, by);
        }

        @Override
        public String stringValue(int n) {
            return Integer.toString(this.intValue(n));
        }

        @Override
        NumberRange<?> range(IntSupplier intSupplier, int n) {
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MIN_VALUE;
            while (--n >= 0) {
                int n4 = this.intValue(intSupplier != null ? intSupplier.getAsInt() : n);
                if (n4 < n2) {
                    n2 = n4;
                }
                if (n4 <= n3) continue;
                n3 = n4;
            }
            return NumberRange.create(n2, true, n3, true);
        }
    }

    private static final class UnsignedIntegers
    extends Integers {
        private static final long serialVersionUID = 8420585724189054050L;

        UnsignedIntegers(int[] nArray) {
            super(nArray);
        }

        @Override
        public boolean isUnsigned() {
            return true;
        }

        @Override
        public double doubleValue(int n) {
            return this.longValue(n);
        }

        @Override
        public float floatValue(int n) {
            return this.longValue(n);
        }

        @Override
        public long longValue(int n) {
            return Integer.toUnsignedLong(super.intValue(n));
        }

        @Override
        public int intValue(int n) {
            int n2 = super.intValue(n);
            if (n2 >= 0) {
                return n2;
            }
            throw new ArithmeticException(Errors.format((short)188, 32));
        }

        @Override
        public Number get(int n) {
            int n2 = super.intValue(n);
            if (n2 >= 0) {
                return n2;
            }
            return Integer.toUnsignedLong(n2);
        }

        @Override
        void verifyType(Number number, byte by) {
            long l = number.longValue();
            if ((l & 0xFFFFFFFF00000000L) == 0L) {
                by = (byte)6;
            }
            super.verifyType(number, by);
        }

        @Override
        public String stringValue(int n) {
            return Integer.toUnsignedString(super.intValue(n));
        }

        @Override
        NumberRange<?> range(IntSupplier intSupplier, int n) {
            long l = Long.MAX_VALUE;
            long l2 = Long.MIN_VALUE;
            while (--n >= 0) {
                long l3 = this.longValue(intSupplier != null ? intSupplier.getAsInt() : n);
                if (l3 < l) {
                    l = l3;
                }
                if (l3 <= l2) continue;
                l2 = l3;
            }
            return NumberRange.create(l, true, l2, true);
        }
    }

    private static final class UnsignedLongs
    extends Longs {
        private static final long serialVersionUID = 712968674526282882L;

        UnsignedLongs(long[] lArray) {
            super(lArray);
        }

        @Override
        public boolean isUnsigned() {
            return true;
        }

        @Override
        public double doubleValue(int n) {
            return Numerics.toUnsignedDouble(super.longValue(n));
        }

        @Override
        public float floatValue(int n) {
            return Numerics.toUnsignedFloat(super.longValue(n));
        }

        @Override
        public long longValue(int n) {
            long l = super.longValue(n);
            if (l >= 0L) {
                return l;
            }
            throw new ArithmeticException(Errors.format((short)188, 64));
        }

        @Override
        public String stringValue(int n) {
            return Long.toUnsignedString(super.longValue(n));
        }

        NumberRange<Double> range(IntSupplier intSupplier, int n) {
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            while (--n >= 0) {
                double d3 = this.doubleValue(intSupplier != null ? intSupplier.getAsInt() : n);
                if (d3 < d) {
                    d = d3;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
            }
            return NumberRange.create(d, true, d2, true);
        }
    }

    private static class Bytes
    extends ArrayVector<Byte> {
        private static final long serialVersionUID = 7933568876180528548L;
        private final byte[] array;

        Bytes(byte[] byArray) {
            this.array = byArray;
        }

        @Override
        public final Class<Byte> getElementType() {
            return Byte.class;
        }

        @Override
        public final boolean isInteger() {
            return true;
        }

        @Override
        public String stringValue(int n) {
            return Byte.toString(this.array[n]);
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public double doubleValue(int n) {
            return this.array[n];
        }

        @Override
        public float floatValue(int n) {
            return this.array[n];
        }

        @Override
        public long longValue(int n) {
            return this.array[n];
        }

        @Override
        public int intValue(int n) {
            return this.array[n];
        }

        @Override
        public short shortValue(int n) {
            return this.array[n];
        }

        @Override
        public byte byteValue(int n) {
            return this.array[n];
        }

        @Override
        public Number get(int n) {
            return this.array[n];
        }

        @Override
        public final Number set(int n, Number number) {
            this.verifyType(number, (byte)3);
            Number number2 = this.get(n);
            this.array[n] = number.byteValue();
            ++this.modCount;
            return number2;
        }

        @Override
        final int indexOf(int n, int n2, boolean bl) {
            byte by = this.array[n];
            while (n2 < this.array.length && by == this.array[n2] != bl) {
                ++n2;
            }
            return n2;
        }

        @Override
        final boolean equals(int n, int n2, Vector vector, int n3) {
            if (vector.getClass() == this.getClass()) {
                byte[] byArray = ((Bytes)vector).array;
                while (n < n2) {
                    if (this.array[n++] == byArray[n3++]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(n, n2, vector, n3);
        }

        @Override
        NumberRange<?> range(IntSupplier intSupplier, int n) {
            byte by = 127;
            byte by2 = -128;
            while (--n >= 0) {
                byte by3 = this.array[intSupplier != null ? intSupplier.getAsInt() : n];
                if (by3 < by) {
                    by = by3;
                }
                if (by3 <= by2) continue;
                by2 = by3;
            }
            return NumberRange.create(by, true, by2, true);
        }

        @Override
        public final Optional<Buffer> buffer() {
            return Optional.of(ByteBuffer.wrap(this.array));
        }

        @Override
        public final int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    private static class Shorts
    extends ArrayVector<Short> {
        private static final long serialVersionUID = -126825963332296000L;
        private final short[] array;

        Shorts(short[] sArray) {
            this.array = sArray;
        }

        @Override
        public final Class<Short> getElementType() {
            return Short.class;
        }

        @Override
        public final boolean isInteger() {
            return true;
        }

        @Override
        public String stringValue(int n) {
            return Short.toString(this.array[n]);
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public double doubleValue(int n) {
            return this.array[n];
        }

        @Override
        public float floatValue(int n) {
            return this.array[n];
        }

        @Override
        public long longValue(int n) {
            return this.array[n];
        }

        @Override
        public int intValue(int n) {
            return this.array[n];
        }

        @Override
        public short shortValue(int n) {
            return this.array[n];
        }

        @Override
        public Number get(int n) {
            return this.array[n];
        }

        @Override
        public final Number set(int n, Number number) {
            this.verifyType(number, (byte)4);
            Number number2 = this.get(n);
            this.array[n] = number.shortValue();
            ++this.modCount;
            return number2;
        }

        @Override
        final int indexOf(int n, int n2, boolean bl) {
            short s2 = this.array[n];
            while (n2 < this.array.length && s2 == this.array[n2] != bl) {
                ++n2;
            }
            return n2;
        }

        @Override
        final boolean equals(int n, int n2, Vector vector, int n3) {
            if (vector.getClass() == this.getClass()) {
                short[] sArray = ((Shorts)vector).array;
                while (n < n2) {
                    if (this.array[n++] == sArray[n3++]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(n, n2, vector, n3);
        }

        @Override
        NumberRange<?> range(IntSupplier intSupplier, int n) {
            short s2 = Short.MAX_VALUE;
            short s3 = Short.MIN_VALUE;
            while (--n >= 0) {
                short s4 = this.array[intSupplier != null ? intSupplier.getAsInt() : n];
                if (s4 < s2) {
                    s2 = s4;
                }
                if (s4 <= s3) continue;
                s3 = s4;
            }
            return NumberRange.create(s2, true, s3, true);
        }

        @Override
        public final Optional<Buffer> buffer() {
            return Optional.of(ShortBuffer.wrap(this.array));
        }

        @Override
        public final int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    private static class Integers
    extends ArrayVector<Integer> {
        private static final long serialVersionUID = -1292641147544275801L;
        private final int[] array;

        Integers(int[] nArray) {
            this.array = nArray;
        }

        @Override
        public final Class<Integer> getElementType() {
            return Integer.class;
        }

        @Override
        public final boolean isInteger() {
            return true;
        }

        @Override
        public String stringValue(int n) {
            return Integer.toString(this.array[n]);
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public double doubleValue(int n) {
            return this.array[n];
        }

        @Override
        public float floatValue(int n) {
            return this.array[n];
        }

        @Override
        public long longValue(int n) {
            return this.array[n];
        }

        @Override
        public int intValue(int n) {
            return this.array[n];
        }

        @Override
        public Number get(int n) {
            return this.array[n];
        }

        @Override
        public final Number set(int n, Number number) {
            this.verifyType(number, (byte)5);
            Number number2 = this.get(n);
            this.array[n] = number.intValue();
            ++this.modCount;
            return number2;
        }

        @Override
        final int indexOf(int n, int n2, boolean bl) {
            int n3 = this.array[n];
            while (n2 < this.array.length && n3 == this.array[n2] != bl) {
                ++n2;
            }
            return n2;
        }

        @Override
        final boolean equals(int n, int n2, Vector vector, int n3) {
            if (vector.getClass() == this.getClass()) {
                int[] nArray = ((Integers)vector).array;
                while (n < n2) {
                    if (this.array[n++] == nArray[n3++]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(n, n2, vector, n3);
        }

        @Override
        NumberRange<?> range(IntSupplier intSupplier, int n) {
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MIN_VALUE;
            while (--n >= 0) {
                int n4 = this.array[intSupplier != null ? intSupplier.getAsInt() : n];
                if (n4 < n2) {
                    n2 = n4;
                }
                if (n4 <= n3) continue;
                n3 = n4;
            }
            return NumberRange.create(n2, true, n3, true);
        }

        @Override
        public final Number increment(double d) {
            if (!(d >= 0.0) || !(d < 1.0)) {
                return super.increment(d);
            }
            int n = this.array.length;
            if (n >= 2) {
                long l;
                boolean bl;
                boolean bl2 = bl = (l = this.longValue(--n) - this.longValue(--n)) >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE;
                if (bl || this.isUnsigned()) {
                    int n2 = (int)l;
                    int n3 = this.array[n];
                    while (n != 0) {
                        if (n3 - (n3 = this.array[--n]) == n2) continue;
                        return null;
                    }
                    if (bl) {
                        return n2;
                    }
                    return l;
                }
            }
            return null;
        }

        @Override
        public final Optional<Buffer> buffer() {
            return Optional.of(IntBuffer.wrap(this.array));
        }

        @Override
        public final int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    private static class Longs
    extends ArrayVector<Long> {
        private static final long serialVersionUID = 338413429037224587L;
        private final long[] array;

        Longs(long[] lArray) {
            this.array = lArray;
        }

        @Override
        public final Class<Long> getElementType() {
            return Long.class;
        }

        @Override
        public final boolean isInteger() {
            return true;
        }

        @Override
        public String stringValue(int n) {
            return Long.toString(this.array[n]);
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public double doubleValue(int n) {
            return this.array[n];
        }

        @Override
        public float floatValue(int n) {
            return this.array[n];
        }

        @Override
        public long longValue(int n) {
            return this.array[n];
        }

        @Override
        public final Number get(int n) {
            return this.longValue(n);
        }

        @Override
        public final Number set(int n, Number number) {
            this.verifyType(number, (byte)6);
            Number number2 = this.get(n);
            this.array[n] = number.longValue();
            ++this.modCount;
            return number2;
        }

        @Override
        final int indexOf(int n, int n2, boolean bl) {
            long l = this.array[n];
            while (n2 < this.array.length && l == this.array[n2] != bl) {
                ++n2;
            }
            return n2;
        }

        @Override
        final boolean equals(int n, int n2, Vector vector, int n3) {
            if (vector.getClass() == this.getClass()) {
                long[] lArray = ((Longs)vector).array;
                while (n < n2) {
                    if (this.array[n++] == lArray[n3++]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(n, n2, vector, n3);
        }

        @Override
        NumberRange<?> range(IntSupplier intSupplier, int n) {
            long l = Long.MAX_VALUE;
            long l2 = Long.MIN_VALUE;
            while (--n >= 0) {
                long l3 = this.array[intSupplier != null ? intSupplier.getAsInt() : n];
                if (l3 < l) {
                    l = l3;
                }
                if (l3 <= l2) continue;
                l2 = l3;
            }
            return NumberRange.create(l, true, l2, true);
        }

        @Override
        public final Number increment(double d) {
            if (!(d >= 0.0) || !(d < 1.0)) {
                return super.increment(d);
            }
            int n = this.array.length;
            if (n >= 2) {
                long l;
                long l2;
                try {
                    long l3 = this.array[--n];
                    l2 = this.array[--n];
                    l = this.subtract(l3, l2);
                }
                catch (ArithmeticException arithmeticException) {
                    this.warning("increment", arithmeticException);
                    return null;
                }
                while (n != 0) {
                    if (l2 - (l2 = this.array[--n]) == l) continue;
                    return null;
                }
                return l;
            }
            return null;
        }

        @Override
        public final Optional<Buffer> buffer() {
            return Optional.of(LongBuffer.wrap(this.array));
        }

        @Override
        public final int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    static final class Decimal
    extends Floats {
        private static final long serialVersionUID = 6085386820455858377L;

        Decimal(float[] fArray) {
            super(fArray);
        }

        @Override
        public double doubleValue(int n) {
            return DecimalFunctions.floatToDouble(super.floatValue(n));
        }

        @Override
        public Number get(int n) {
            return this.doubleValue(n);
        }

        @Override
        NumberRange<?> createRange(float f, float f2) {
            return NumberRange.create(DecimalFunctions.floatToDouble(f), true, DecimalFunctions.floatToDouble(f2), true);
        }

        @Override
        public int hashCode() {
            int n = 1;
            int n2 = this.size();
            for (int i = 0; i < n2; ++i) {
                n = 31 * n + Double.hashCode(this.doubleValue(i));
            }
            return n;
        }
    }

    private static class Floats
    extends ArrayVector<Float> {
        private static final long serialVersionUID = 5395284704294981455L;
        private final float[] array;

        Floats(float[] fArray) {
            this.array = fArray;
        }

        @Override
        public final Class<Float> getElementType() {
            return Float.class;
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public final boolean isNaN(int n) {
            return Float.isNaN(this.array[n]);
        }

        @Override
        public final String stringValue(int n) {
            return Float.toString(this.array[n]);
        }

        @Override
        public double doubleValue(int n) {
            return this.array[n];
        }

        @Override
        public final float floatValue(int n) {
            return this.array[n];
        }

        @Override
        public Number get(int n) {
            return Float.valueOf(this.array[n]);
        }

        @Override
        public final Number set(int n, Number number) {
            float f = this.array[n];
            this.array[n] = number.floatValue();
            ++this.modCount;
            return Float.valueOf(f);
        }

        @Override
        final int indexOf(int n, int n2, boolean bl) {
            int n3 = Float.floatToIntBits(this.array[n]);
            while (n2 < this.array.length && n3 == Float.floatToIntBits(this.array[n2]) != bl) {
                ++n2;
            }
            return n2;
        }

        @Override
        final boolean equals(int n, int n2, Vector vector, int n3) {
            if (vector.getClass() == this.getClass()) {
                float[] fArray = ((Floats)vector).array;
                while (n < n2) {
                    if (Float.floatToIntBits(this.array[n++]) == Float.floatToIntBits(fArray[n3++])) continue;
                    return false;
                }
                return true;
            }
            return super.equals(n, n2, vector, n3);
        }

        @Override
        final NumberRange<?> range(IntSupplier intSupplier, int n) {
            float f = Float.POSITIVE_INFINITY;
            float f2 = Float.NEGATIVE_INFINITY;
            while (--n >= 0) {
                float f3 = this.array[intSupplier != null ? intSupplier.getAsInt() : n];
                if (f3 < f) {
                    f = f3;
                }
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            return this.createRange(f, f2);
        }

        NumberRange<?> createRange(float f, float f2) {
            return NumberRange.create(f, true, f2, true);
        }

        @Override
        public final Optional<Buffer> buffer() {
            return Optional.of(FloatBuffer.wrap(this.array));
        }

        @Override
        public final float[] floatValues() {
            return (float[])this.array.clone();
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    static final class Doubles
    extends ArrayVector<Double> {
        private static final long serialVersionUID = -2900375382498345812L;
        private final double[] array;

        Doubles(double[] dArray) {
            this.array = dArray;
        }

        @Override
        public Class<Double> getElementType() {
            return Double.class;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public boolean isNaN(int n) {
            return Double.isNaN(this.array[n]);
        }

        @Override
        public String stringValue(int n) {
            return Double.toString(this.array[n]);
        }

        @Override
        public double doubleValue(int n) {
            return this.array[n];
        }

        @Override
        public float floatValue(int n) {
            return (float)this.array[n];
        }

        @Override
        public Number get(int n) {
            return this.array[n];
        }

        @Override
        public Number set(int n, Number number) {
            double d = this.array[n];
            this.array[n] = number.doubleValue();
            ++this.modCount;
            return d;
        }

        @Override
        int indexOf(int n, int n2, boolean bl) {
            long l = Double.doubleToLongBits(this.array[n]);
            while (n2 < this.array.length && l == Double.doubleToLongBits(this.array[n2]) != bl) {
                ++n2;
            }
            return n2;
        }

        @Override
        boolean equals(int n, int n2, Vector vector, int n3) {
            if (vector instanceof Doubles) {
                double[] dArray = ((Doubles)vector).array;
                while (n < n2) {
                    if (Double.doubleToLongBits(this.array[n++]) == Double.doubleToLongBits(dArray[n3++])) continue;
                    return false;
                }
                return true;
            }
            return super.equals(n, n2, vector, n3);
        }

        NumberRange<Double> range(IntSupplier intSupplier, int n) {
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            while (--n >= 0) {
                double d3 = this.array[intSupplier != null ? intSupplier.getAsInt() : n];
                if (d3 < d) {
                    d = d3;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
            }
            return NumberRange.create(d, true, d2, true);
        }

        @Override
        public Optional<Buffer> buffer() {
            return Optional.of(DoubleBuffer.wrap(this.array));
        }

        @Override
        public double[] doubleValues() {
            return (double[])this.array.clone();
        }

        @Override
        public float[] floatValues() {
            return ArraysExt.copyAsFloats(this.array);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }
}

