/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Set;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.GeodeticException;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public final class EPSGFactoryProxy
implements CRSAuthorityFactory {
    private volatile CRSAuthorityFactory factory;

    private CRSAuthorityFactory factory() throws FactoryException {
        CRSAuthorityFactory cRSAuthorityFactory = this.factory;
        if (cRSAuthorityFactory == null) {
            this.factory = cRSAuthorityFactory = CRS.getAuthorityFactory("EPSG");
        }
        return cRSAuthorityFactory;
    }

    @Override
    public Citation getAuthority() {
        try {
            return this.factory().getAuthority();
        }
        catch (FactoryException factoryException) {
            throw new GeodeticException(factoryException);
        }
    }

    @Override
    public Citation getVendor() {
        try {
            return this.factory().getVendor();
        }
        catch (FactoryException factoryException) {
            throw new GeodeticException(factoryException);
        }
    }

    @Override
    public InternationalString getDescriptionText(String string) throws FactoryException {
        return this.factory().getDescriptionText(string);
    }

    @Override
    public IdentifiedObject createObject(String string) throws FactoryException {
        return this.factory().createObject(string);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String string) throws FactoryException {
        return this.factory().createCoordinateReferenceSystem(string);
    }

    @Override
    public CompoundCRS createCompoundCRS(String string) throws FactoryException {
        return this.factory().createCompoundCRS(string);
    }

    @Override
    public DerivedCRS createDerivedCRS(String string) throws FactoryException {
        return this.factory().createDerivedCRS(string);
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String string) throws FactoryException {
        return this.factory().createEngineeringCRS(string);
    }

    @Override
    public GeographicCRS createGeographicCRS(String string) throws FactoryException {
        return this.factory().createGeographicCRS(string);
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String string) throws FactoryException {
        return this.factory().createGeocentricCRS(string);
    }

    @Override
    public ImageCRS createImageCRS(String string) throws FactoryException {
        return this.factory().createImageCRS(string);
    }

    @Override
    public ProjectedCRS createProjectedCRS(String string) throws FactoryException {
        return this.factory().createProjectedCRS(string);
    }

    @Override
    public TemporalCRS createTemporalCRS(String string) throws FactoryException {
        return this.factory().createTemporalCRS(string);
    }

    @Override
    public VerticalCRS createVerticalCRS(String string) throws FactoryException {
        return this.factory().createVerticalCRS(string);
    }

    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> clazz) throws FactoryException {
        return this.factory().getAuthorityCodes(clazz);
    }
}

