/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.measure.Unit;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.ucar.DimensionWrapper;
import org.apache.sis.internal.netcdf.ucar.GridWrapper;
import org.apache.sis.internal.netcdf.ucar.Utils;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreException;
import org.opengis.referencing.operation.Matrix;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.VariableIF;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.EnhanceScaleMissing;
import ucar.nc2.dataset.Enhancements;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;

final class VariableWrapper
extends Variable {
    private final VariableIF variable;
    private final VariableIF raw;
    private transient Vector values;

    VariableWrapper(Decoder decoder, VariableIF variableIF) {
        super(decoder);
        this.variable = variableIF;
        if (variableIF instanceof VariableEnhanced && (variableIF = ((VariableEnhanced)variableIF).getOriginalVariable()) == null) {
            variableIF = this.variable;
        }
        this.raw = variableIF;
    }

    @Override
    public String getFilename() {
        String string;
        if (this.variable instanceof ucar.nc2.Variable && (string = Utils.nonEmpty(((ucar.nc2.Variable)this.variable).getDatasetLocation())) != null) {
            return string.substring(Math.max(string.lastIndexOf(47), string.lastIndexOf(File.separatorChar)) + 1);
        }
        return super.getFilename();
    }

    @Override
    public String getGroupName() {
        Group group = this.variable.getParentGroup();
        return group != null ? group.getShortName() : null;
    }

    @Override
    public String getName() {
        return this.variable.getShortName();
    }

    @Override
    public String getDescription() {
        return Utils.nonEmpty(this.variable.getDescription());
    }

    @Override
    protected String getUnitsString() {
        String string = this.variable.getUnitsString();
        return string != null && (string = string.trim()).isEmpty() ? null : string;
    }

    @Override
    protected Unit<?> parseUnit(String string) throws Exception {
        if (TIME_UNIT_PATTERN.matcher(string).matches()) {
            DateUnit dateUnit = new DateUnit(string);
            this.epoch = dateUnit.getDateOrigin().toInstant();
            return Units.SECOND.multiply(dateUnit.getTimeUnit().getValueInSeconds());
        }
        SimpleUnit simpleUnit = SimpleUnit.factoryWithExceptions(string);
        if (simpleUnit.isUnknownUnit()) {
            return Units.valueOf(string);
        }
        String string2 = simpleUnit.getUnitString();
        Unit<?> unit = Units.valueOf(string2);
        double d = simpleUnit.getValue();
        double d2 = simpleUnit.convertTo(0.0, SimpleUnit.factoryWithExceptions(string2));
        unit = unit.shift(d2);
        if (!Double.isNaN(d)) {
            unit = unit.multiply(d);
        }
        return unit;
    }

    @Override
    public DataType getDataType() {
        DataType dataType;
        switch (this.variable.getDataType()) {
            case STRING: {
                return DataType.STRING;
            }
            case CHAR: {
                return DataType.CHAR;
            }
            case BYTE: {
                dataType = DataType.BYTE;
                break;
            }
            case SHORT: {
                dataType = DataType.SHORT;
                break;
            }
            case INT: {
                dataType = DataType.INT;
                break;
            }
            case LONG: {
                dataType = DataType.INT64;
                break;
            }
            case FLOAT: {
                return DataType.FLOAT;
            }
            case DOUBLE: {
                return DataType.DOUBLE;
            }
            default: {
                return DataType.UNKNOWN;
            }
        }
        return dataType.unsigned(this.variable.isUnsigned());
    }

    @Override
    protected boolean isUnlimited() {
        return this.variable.isUnlimited();
    }

    @Override
    protected boolean isCoordinateSystemAxis() {
        return this.variable.isCoordinateVariable();
    }

    @Override
    protected Grid getGrid(Variable.Adjustment adjustment) throws IOException, DataStoreException {
        if (this.variable instanceof Enhancements) {
            Grid[] gridArray = this.decoder.getGrids();
            List<CoordinateSystem> list = ((Enhancements)((Object)this.variable)).getCoordinateSystems();
            if (!list.isEmpty()) {
                GridWrapper gridWrapper = null;
                String[] stringArray = this.decoder.convention().namesOfAxisVariables(this);
                for (Grid grid : gridArray) {
                    GridWrapper gridWrapper2 = ((GridWrapper)grid).forVariable(this.variable, list, stringArray);
                    if (gridWrapper2 == null || gridWrapper != null && gridWrapper2.getSourceDimensions() <= gridWrapper.getSourceDimensions()) continue;
                    gridWrapper = gridWrapper2;
                }
                if (gridWrapper != null) {
                    return gridWrapper;
                }
            }
        }
        return (GridWrapper)super.getGrid(adjustment);
    }

    @Override
    public List<Dimension> getGridDimensions() {
        return DimensionWrapper.wrap(this.variable.getDimensions());
    }

    @Override
    public Collection<String> getAttributeNames() {
        return VariableWrapper.toNames(this.variable.getAttributes());
    }

    @Override
    public Class<?> getAttributeType(String string) {
        return VariableWrapper.getAttributeType(this.raw.findAttributeIgnoreCase(string));
    }

    static Class<?> getAttributeType(Attribute attribute) {
        if (attribute != null) {
            if (attribute.isArray()) {
                return Vector.class;
            }
            switch (attribute.getDataType()) {
                case BYTE: {
                    return Byte.class;
                }
                case SHORT: {
                    return Short.class;
                }
                case INT: {
                    return Integer.class;
                }
                case LONG: {
                    return Long.class;
                }
                case FLOAT: {
                    return Float.class;
                }
                case DOUBLE: {
                    return Double.class;
                }
                case STRING: {
                    return String.class;
                }
            }
            return Object.class;
        }
        return null;
    }

    @Override
    protected Object getAttributeValue(String string) {
        return VariableWrapper.getAttributeValue(this.raw.findAttributeIgnoreCase(string));
    }

    static Object getAttributeValue(Attribute attribute) {
        if (attribute != null) {
            int n = attribute.getLength();
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    Object object = attribute.getValue(0);
                    if (object instanceof String) {
                        return Utils.nonEmpty((String)object);
                    }
                    if (!(object instanceof Number)) break;
                    return Utils.fixSign((Number)object, attribute.isUnsigned());
                }
                default: {
                    if (attribute.isString()) {
                        boolean bl = false;
                        String[] stringArray = new String[n];
                        for (int i = 0; i < n; ++i) {
                            stringArray[i] = Utils.nonEmpty(attribute.getStringValue(i));
                            bl |= stringArray[i] != null;
                        }
                        if (!bl) break;
                        return stringArray;
                    }
                    Array array = attribute.getValues();
                    return VariableWrapper.createDecimalVector(array.get1DJavaArray(array.getElementType()), attribute.isUnsigned());
                }
            }
        }
        return null;
    }

    static List<String> toNames(List<Attribute> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = list.get(i).getShortName();
        }
        return UnmodifiableArrayList.wrap(stringArray);
    }

    @Override
    protected NumberRange<?> getRangeFallback() {
        EnhanceScaleMissing enhanceScaleMissing;
        if (this.variable instanceof EnhanceScaleMissing && (enhanceScaleMissing = (EnhanceScaleMissing)((Object)this.variable)).hasInvalidData()) {
            return MeasurementRange.create(enhanceScaleMissing.getValidMin(), true, enhanceScaleMissing.getValidMax(), true, this.getUnit());
        }
        return super.getRangeFallback();
    }

    @Override
    public Vector read() throws IOException {
        if (this.values == null) {
            Array array = this.variable.read();
            this.values = VariableWrapper.createDecimalVector(this.get1DJavaArray(array), this.variable.isUnsigned());
            this.values = SHARED_VECTORS.unique(this.values);
        }
        return this.values;
    }

    @Override
    public Vector read(GridExtent gridExtent, int[] nArray) throws IOException, DataStoreException {
        Array array;
        int n = gridExtent.getDimension();
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n--];
        for (int i = 0; i <= n; ++i) {
            int n2 = n - i;
            nArray2[n2] = Math.toIntExact(gridExtent.getLow(i));
            nArray3[n2] = Math.toIntExact(gridExtent.getSize(i));
            nArray4[n2] = nArray[i];
        }
        try {
            array = this.variable.read(new Section(nArray2, nArray3, nArray4));
        }
        catch (InvalidRangeException invalidRangeException) {
            throw new DataStoreException(invalidRangeException);
        }
        return Vector.create(this.get1DJavaArray(array), this.variable.isUnsigned());
    }

    private Object get1DJavaArray(Array array) {
        Object object = array.get1DJavaArray(array.getElementType());
        this.replaceNaN(object);
        return object;
    }

    @Override
    protected double coordinateForAxis(int n, int n2) {
        return this.variable instanceof CoordinateAxis2D ? ((CoordinateAxis2D)this.variable).getCoordValue(n, n2) : Double.NaN;
    }

    @Override
    protected boolean trySetTransform(Matrix matrix, int n, int n2, Vector vector) throws IOException, DataStoreException {
        CoordinateAxis1D coordinateAxis1D;
        if (this.variable instanceof CoordinateAxis1D && (coordinateAxis1D = (CoordinateAxis1D)this.variable).isRegular()) {
            double d = coordinateAxis1D.getStart();
            double d2 = coordinateAxis1D.getIncrement();
            if (d != 0.0 || d2 != 0.0) {
                matrix.setElement(n2, n, d2);
                matrix.setElement(n2, matrix.getNumCol() - 1, d);
                return true;
            }
        }
        return super.trySetTransform(matrix, n, n2, vector);
    }

    final boolean isWrapperFor(VariableIF variableIF) {
        return this.variable == variableIF || this.raw == variableIF;
    }
}

