/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.OptionalLong;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.feature.MovingFeature;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.DiscreteSampling;
import org.apache.sis.internal.netcdf.impl.ChannelDecoder;
import org.apache.sis.internal.netcdf.impl.DimensionInfo;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.collection.BackingStoreException;

final class FeaturesInfo
extends DiscreteSampling {
    private final Vector counts;
    private final VariableInfo identifiers;
    private final VariableInfo time;
    private final VariableInfo[] coordinates;
    private final VariableInfo[] properties;
    private final DefaultFeatureType type;

    private FeaturesInfo(ChannelDecoder channelDecoder, Vector vector, VariableInfo variableInfo, VariableInfo variableInfo2, Collection<VariableInfo> collection, Collection<VariableInfo> collection2) {
        super(channelDecoder.geomlib, channelDecoder.listeners);
        this.counts = vector;
        this.identifiers = variableInfo;
        this.coordinates = collection.toArray(new VariableInfo[collection.size()]);
        this.properties = collection2.toArray(new VariableInfo[collection2.size()]);
        this.time = variableInfo2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        AbstractIdentifiedType[] abstractIdentifiedTypeArray = new AbstractIdentifiedType[this.properties.length + 2];
        DefaultAttributeType[] defaultAttributeTypeArray = null;
        for (int i = 0; i < abstractIdentifiedTypeArray.length; ++i) {
            Class clazz;
            VariableInfo variableInfo3;
            int n = 1;
            int n2 = 1;
            switch (i) {
                case 0: {
                    variableInfo3 = variableInfo;
                    clazz = Integer.class;
                    break;
                }
                case 1: {
                    variableInfo3 = null;
                    clazz = this.factory.polylineClass;
                    defaultAttributeTypeArray = new DefaultAttributeType[]{MovingFeature.TIME};
                    break;
                }
                default: {
                    variableInfo3 = this.properties[i - 2];
                    clazz = variableInfo3.meaning(0) != null ? String.class : Number.class;
                    n = 0;
                    n2 = Integer.MAX_VALUE;
                }
            }
            hashMap.put("name", variableInfo3 != null ? variableInfo3.getName() : "trajectory");
            abstractIdentifiedTypeArray[i] = new DefaultAttributeType<Object>(hashMap, clazz, n, n2, null, defaultAttributeTypeArray);
        }
        String string = "Features";
        hashMap.put("name", channelDecoder.nameFactory.createLocalName(channelDecoder.namespace, string));
        this.type = new DefaultFeatureType(hashMap, false, null, abstractIdentifiedTypeArray);
    }

    private static boolean isSupportedRole(String string) {
        return "trajectory_id".equalsIgnoreCase(string);
    }

    static FeaturesInfo[] create(ChannelDecoder channelDecoder) throws IOException, DataStoreException {
        ArrayList<FeaturesInfo> arrayList = new ArrayList<FeaturesInfo>(3);
        block4: for (VariableInfo variableInfo : channelDecoder.variables) {
            String string;
            if (variableInfo.dimensions.length != 1 || !variableInfo.getDataType().isInteger || (string = variableInfo.getAttributeAsString("sample_dimension")) == null) continue;
            DimensionInfo dimensionInfo = variableInfo.dimensions[0];
            DimensionInfo dimensionInfo2 = channelDecoder.findDimension(string);
            if (dimensionInfo2 == null) {
                channelDecoder.listeners.warning(channelDecoder.resources().getString((short)1, channelDecoder.getFilename(), variableInfo.getName(), string));
                continue;
            }
            VariableInfo variableInfo2 = channelDecoder.findVariable(dimensionInfo.name);
            if (variableInfo2 == null || !FeaturesInfo.isSupportedRole(variableInfo2.getAttributeAsString("cf_role"))) {
                VariableInfo variableInfo3 = null;
                for (VariableInfo variableInfo4 : channelDecoder.variables) {
                    if (variableInfo4.dimensions.length == 0 || variableInfo4.dimensions[0] != dimensionInfo || !FeaturesInfo.isSupportedRole(variableInfo4.getAttributeAsString("cf_role"))) continue;
                    if (variableInfo3 != null) {
                        variableInfo3 = null;
                        break;
                    }
                    variableInfo3 = variableInfo4;
                }
                if (variableInfo3 != null) {
                    variableInfo2 = variableInfo3;
                }
                if (variableInfo2 == null) {
                    channelDecoder.listeners.warning(channelDecoder.resources().getString((short)3, channelDecoder.getFilename(), dimensionInfo.name));
                    continue;
                }
            }
            for (int i = 0; i < variableInfo2.dimensions.length; ++i) {
                boolean bl;
                switch (i) {
                    case 0: {
                        bl = variableInfo2.dimensions[0] == dimensionInfo;
                        break;
                    }
                    case 1: {
                        bl = variableInfo2.getDataType() == DataType.CHAR;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                if (bl) continue;
                channelDecoder.listeners.warning(channelDecoder.resources().getString((short)2, channelDecoder.getFilename(), variableInfo2.getName(), dimensionInfo.getName(), variableInfo2.dimensions[i].name));
                continue block4;
            }
            LinkedHashMap<String, VariableInfo> linkedHashMap = new LinkedHashMap<String, VariableInfo>();
            ArrayList arrayList2 = new ArrayList();
            for (VariableInfo variableInfo5 : channelDecoder.variables) {
                if (variableInfo5.dimensions.length != 1 || variableInfo5.dimensions[0] != dimensionInfo2) continue;
                String string2 = variableInfo5.getAttributeAsString("axis");
                if (string2 == null) {
                    arrayList2.add(variableInfo5);
                    continue;
                }
                if (linkedHashMap.put(string2, variableInfo5) != null) continue block4;
            }
            VariableInfo variableInfo6 = (VariableInfo)linkedHashMap.remove("T");
            if (variableInfo6 == null) continue;
            arrayList.add(new FeaturesInfo(channelDecoder, variableInfo.read(), variableInfo2, variableInfo6, linkedHashMap.values(), arrayList2));
        }
        return arrayList.toArray(new FeaturesInfo[arrayList.size()]);
    }

    @Override
    public DefaultFeatureType getType() {
        return this.type;
    }

    @Override
    protected OptionalLong getFeatureCount() {
        return OptionalLong.of(this.counts.size());
    }

    @Override
    public Stream<AbstractFeature> features(boolean bl) {
        return StreamSupport.stream(new Iter(), false);
    }

    private final class Iter
    implements Spliterator<AbstractFeature> {
        private int index;
        private int position;

        Iter() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super AbstractFeature> consumer) {
            int n;
            Object object;
            Vector vector;
            int n2 = FeaturesInfo.this.counts.intValue(this.index);
            GridExtent gridExtent = new GridExtent(null, new long[]{this.position}, new long[]{Math.addExact(this.position, n2)}, false);
            int[] nArray = new int[]{1};
            Vector[] vectorArray = new Vector[FeaturesInfo.this.coordinates.length];
            Object[] objectArray = new Object[FeaturesInfo.this.properties.length];
            try {
                int n3;
                vector = FeaturesInfo.this.identifiers.read();
                Vector vector2 = FeaturesInfo.this.time.read(gridExtent, nArray);
                for (n3 = 0; n3 < FeaturesInfo.this.coordinates.length; ++n3) {
                    vectorArray[n3] = FeaturesInfo.this.coordinates[n3].read(gridExtent, nArray);
                }
                for (n3 = 0; n3 < FeaturesInfo.this.properties.length; ++n3) {
                    VariableInfo variableInfo = FeaturesInfo.this.properties[n3];
                    object = variableInfo.read(gridExtent, nArray);
                    if (variableInfo.isEnumeration()) {
                        String[] stringArray = new String[((Vector)object).size()];
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string = variableInfo.meaning(((Vector)object).intValue(i));
                            stringArray[i] = string != null ? string : "";
                        }
                        objectArray[n3] = Arrays.asList(stringArray);
                        continue;
                    }
                    objectArray[n3] = object;
                }
            }
            catch (IOException | DataStoreException exception) {
                throw new BackingStoreException(FeaturesInfo.this.canNotReadFile(), exception);
            }
            AbstractFeature abstractFeature = FeaturesInfo.this.type.newInstance();
            abstractFeature.setPropertyValue(FeaturesInfo.this.identifiers.getName(), vector.intValue(this.index));
            for (n = 0; n < FeaturesInfo.this.properties.length; ++n) {
                abstractFeature.setPropertyValue(FeaturesInfo.this.properties[n].getName(), objectArray[n]);
            }
            n = FeaturesInfo.this.coordinates.length;
            object = new double[n2 * n];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = vectorArray[i % n].doubleValue(i / n);
            }
            abstractFeature.setPropertyValue("trajectory", FeaturesInfo.this.factory.createPolyline(n, Vector.create((double[])object)));
            consumer.accept(abstractFeature);
            this.position = Math.addExact(this.position, n2);
            return ++this.index < FeaturesInfo.this.counts.size();
        }

        @Override
        public Spliterator<AbstractFeature> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return FeaturesInfo.this.counts.size();
        }

        @Override
        public int characteristics() {
            return 1360;
        }
    }
}

