/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import javax.naming.spi.NamingManager;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.system.Shutdown;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Messages;

public abstract class Initializer {
    public static final String DATABASE = "SpatialMetadata";
    private static final String DERBY_HOME_KEY = "derby.system.home";
    public static final String JNDI = "jdbc/SpatialMetadata";
    public static final String EMBEDDED = "Embedded";
    @Deprecated
    private static URLClassLoader javadbLoader;
    private static Supplier<DataSource> supplier;
    private static DataSource source;
    private static boolean connected;

    protected Initializer() {
    }

    protected abstract void createSchema(Connection var1) throws SQLException;

    protected abstract void dataSourceChanged();

    public static synchronized boolean setDefault(Supplier<DataSource> supplier) {
        if (source == null) {
            Initializer.supplier = supplier;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static synchronized DataSource getDataSource() throws Exception {
        if (source == null) {
            Object object;
            Object object2;
            if (Initializer.hasJNDI()) {
                try {
                    Context context = (Context)InitialContext.doLookup("java:comp/env");
                    source = (DataSource)context.lookup(JNDI);
                    if (context instanceof EventContext) {
                        Listener.register((EventContext)context);
                    }
                    return source;
                }
                catch (NameNotFoundException nameNotFoundException) {
                    LogRecord logRecord = Messages.getResources(null).getLogRecord(Level.CONFIG, (short)24, JNDI);
                    logRecord.setLoggerName("org.apache.sis.sql");
                    Logging.log(null, null, logRecord);
                }
            }
            if (supplier != null && (source = supplier.get()) != null) {
                supplier = null;
                return source;
            }
            boolean bl = false;
            boolean bl2 = DataDirectory.isEnvClear();
            if (!bl2 || (source = Initializer.embedded()) == null) {
                Object object3;
                object2 = AccessController.doPrivileged(() -> System.getProperty(DERBY_HOME_KEY));
                object = DataDirectory.DATABASES.getDirectory();
                if (object != null) {
                    void var5_9;
                    Path path;
                    Path object4 = object.resolve(DATABASE);
                    if (object2 != null) {
                        try {
                            Path path2 = Paths.get((String)object2, new String[0]).relativize(object4);
                        }
                        catch (IllegalArgumentException | SecurityException runtimeException) {
                            Logging.recoverableException(Logging.getLogger("org.apache.sis.sql"), Initializer.class, "getDataSource", runtimeException);
                        }
                    }
                    bl = !Files.exists(path = var5_9.normalize(), new LinkOption[0]);
                    object3 = path.toString().replace(path.getFileSystem().getSeparator(), "/");
                } else if (object2 != null) {
                    Path path = Paths.get((String)object2, new String[0]);
                    bl = !Files.exists(path.resolve(DATABASE), new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
                    object3 = DATABASE;
                } else {
                    bl = true;
                    object3 = null;
                }
                if (bl & !bl2) {
                    source = Initializer.embedded();
                    boolean bl3 = bl = source == null;
                }
                if (source == null) {
                    if (object3 == null) {
                        return null;
                    }
                    source = Initializer.forJavaDB((String)object3);
                }
            }
            supplier = null;
            Shutdown.register(() -> {
                Initializer.shutdown();
                return null;
            });
            if (bl) {
                object2 = source.getClass().getMethod("setCreateDatabase", String.class);
                ((Method)object2).invoke((Object)source, "create");
                try {
                    object = source.getConnection();
                    try {
                        for (Initializer initializer : DefaultFactories.createServiceLoader(Initializer.class)) {
                            initializer.createSchema((Connection)object);
                        }
                    }
                    finally {
                        if (object != null) {
                            object.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    ((Method)object2).invoke((Object)source, "no");
                    throw throwable;
                }
                ((Method)object2).invoke((Object)source, "no");
            }
        }
        return source;
    }

    public static boolean hasJNDI() {
        return NamingManager.hasInitialContextFactoryBuilder() || AccessController.doPrivileged(() -> System.getProperty("java.naming.factory.initial") != null) != false;
    }

    private static DataSource embedded() {
        for (InstallationResources installationResources : DefaultFactories.createServiceLoader(InstallationResources.class)) {
            if (!installationResources.getAuthorities().contains(EMBEDDED)) continue;
            try {
                String[] stringArray = installationResources.getResourceNames(EMBEDDED);
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object;
                    if (!DATABASE.equals(stringArray[i]) || !((object = installationResources.getResource(EMBEDDED, i)) instanceof DataSource)) continue;
                    return (DataSource)object;
                }
            }
            catch (IOException iOException) {
                Logging.unexpectedException(Logging.getLogger("org.apache.sis.sql"), Initializer.class, "getDataSource", iOException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogRecord connected(DatabaseMetaData databaseMetaData) throws SQLException {
        Object object = Initializer.class;
        synchronized (Initializer.class) {
            Level level = connected ? Level.FINE : Level.CONFIG;
            connected = true;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            object = Messages.getResources(null).getLogRecord(level, (short)6, SQLUtilities.getSimplifiedURL(databaseMetaData));
            ((LogRecord)object).setLoggerName("org.apache.sis.system");
            return object;
        }
    }

    public static Object unspecified(Locale locale, boolean bl) {
        String string;
        short s2;
        if (Initializer.hasJNDI()) {
            s2 = 24;
            string = JNDI;
        } else {
            s2 = 16;
            string = "SIS_DATA";
        }
        Messages messages = Messages.getResources(locale);
        return bl ? messages.getLogRecord(Level.WARNING, s2, string) : messages.getString(s2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataSource forJavaDB(String string) throws Exception {
        try {
            return Initializer.forJavaDB(string, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<Initializer> clazz = Initializer.class;
            synchronized (Initializer.class) {
                Path path;
                String string2;
                URLClassLoader uRLClassLoader = javadbLoader;
                if (uRLClassLoader == null && (string2 = System.getProperty("java.home")) != null && Files.isRegularFile(path = Paths.get(string2, new String[0]).resolveSibling("db/lib/derby.jar"), new LinkOption[0])) {
                    javadbLoader = uRLClassLoader = new URLClassLoader(new URL[]{path.toUri().toURL(), path.resolveSibling("derbynet.jar").toUri().toURL()});
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                if (uRLClassLoader == null) {
                    throw classNotFoundException;
                }
                return Initializer.forJavaDB(string, uRLClassLoader);
            }
        }
    }

    private static DataSource forJavaDB(String string, ClassLoader classLoader) throws Exception {
        Class<?> clazz = Class.forName("org.apache.derby.jdbc.EmbeddedDataSource", true, classLoader);
        DataSource dataSource = (DataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class[] classArray = new Class[]{String.class};
        clazz.getMethod("setDatabaseName", classArray).invoke((Object)dataSource, string);
        clazz.getMethod("setDataSourceName", classArray).invoke((Object)dataSource, "Apache SIS spatial metadata");
        return dataSource;
    }

    private static synchronized void shutdown() throws ReflectiveOperationException {
        DataSource dataSource = source;
        if (dataSource != null) {
            source = null;
            connected = false;
            dataSource.getClass().getMethod("setShutdownDatabase", String.class).invoke((Object)dataSource, "shutdown");
            try {
                dataSource.getConnection().close();
            }
            catch (SQLException sQLException) {
                LogRecord logRecord = new LogRecord(Level.FINE, sQLException.getMessage());
                if (!Initializer.isSuccessfulShutdown(sQLException)) {
                    logRecord.setLevel(Level.WARNING);
                    logRecord.setThrown(sQLException);
                }
                logRecord.setLoggerName("org.apache.sis.sql");
                Logging.log(Initializer.class, "shutdown", logRecord);
            }
        }
    }

    public static boolean isSuccessfulShutdown(SQLException sQLException) {
        String string = sQLException.getSQLState();
        return "08006".equals(string) || "XJ004".equals(string);
    }

    private static final class Listener
    implements ObjectChangeListener,
    Callable<Object> {
        private final EventContext context;

        private Listener(EventContext eventContext) {
            this.context = eventContext;
        }

        static void register(EventContext eventContext) throws NamingException {
            Listener listener = new Listener(eventContext);
            eventContext.addNamingListener(Initializer.JNDI, 0, (NamingListener)listener);
            Shutdown.register(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws NamingException {
            Class<Initializer> clazz = Initializer.class;
            synchronized (Initializer.class) {
                this.context.removeNamingListener(this);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void objectChanged(NamingEvent namingEvent) {
            try {
                Class<Initializer> clazz = Initializer.class;
                synchronized (Initializer.class) {
                    source = null;
                    connected = false;
                    Shutdown.unregister(this);
                    this.context.removeNamingListener(this);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
            catch (NamingException namingException) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.system"), Listener.class, "objectChanged", namingException);
            }
            {
                for (Initializer initializer : DefaultFactories.createServiceLoader(Initializer.class)) {
                    initializer.dataSourceChanged();
                }
                return;
            }
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent namingExceptionEvent) {
            Logging.unexpectedException(Logging.getLogger("org.apache.sis.system"), Listener.class, "namingExceptionThrown", namingExceptionEvent.getException());
            this.objectChanged(null);
        }
    }
}

