/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.builder.AssociationRoleBuilder;
import org.apache.sis.feature.builder.AttributeRole;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.OperationWrapper;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.feature.builder.RemoveOnlyList;
import org.apache.sis.feature.builder.TypeBuilder;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CorruptedObjectException;
import org.opengis.metadata.acquisition.GeometryType;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public class FeatureTypeBuilder
extends TypeBuilder {
    private final NameFactory nameFactory;
    private final List<PropertyTypeBuilder> properties;
    private final List<DefaultFeatureType> superTypes;
    private boolean isAbstract;
    private NameSpace namespace;
    int defaultMinimumOccurs;
    int defaultMaximumOccurs;
    private String idPrefix;
    private String idSuffix;
    private String idDelimiter;
    int identifierCount;
    AttributeTypeBuilder<?> defaultGeometry;
    private final Geometries<?> geometries;
    private transient DefaultFeatureType feature;

    public FeatureTypeBuilder() {
        this(null, null, null);
    }

    public FeatureTypeBuilder(DefaultFeatureType defaultFeatureType) {
        this(null, null, null);
        if (defaultFeatureType != null) {
            this.initialize(defaultFeatureType);
        }
    }

    public FeatureTypeBuilder(NameFactory nameFactory, GeometryLibrary geometryLibrary, Locale locale) {
        super(locale);
        if (nameFactory == null) {
            nameFactory = DefaultFactories.forBuildin(NameFactory.class);
        }
        this.nameFactory = nameFactory;
        this.geometries = Geometries.implementation(geometryLibrary);
        this.properties = new ArrayList<PropertyTypeBuilder>();
        this.superTypes = new ArrayList<DefaultFeatureType>();
        this.idDelimiter = ":";
        this.defaultMinimumOccurs = 1;
        this.defaultMaximumOccurs = 1;
    }

    public FeatureTypeBuilder clear() {
        this.reset();
        this.properties.clear();
        this.superTypes.clear();
        this.isAbstract = false;
        this.namespace = null;
        this.defaultMinimumOccurs = 1;
        this.defaultMaximumOccurs = 1;
        this.idPrefix = null;
        this.idSuffix = null;
        this.idDelimiter = ":";
        this.identifierCount = 0;
        this.defaultGeometry = null;
        this.clearCache();
        return this;
    }

    public FeatureTypeBuilder setAll(DefaultFeatureType defaultFeatureType) {
        this.clear();
        if (defaultFeatureType != null) {
            this.initialize(defaultFeatureType);
        }
        return this;
    }

    private void initialize(DefaultFeatureType defaultFeatureType) {
        PropertyTypeBuilder propertyTypeBuilder;
        super.initialize(defaultFeatureType);
        this.feature = defaultFeatureType;
        this.isAbstract = defaultFeatureType.isAbstract();
        this.superTypes.addAll(defaultFeatureType.getSuperTypes());
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        for (AbstractIdentifiedType object : defaultFeatureType.getProperties(false)) {
            AttributeRole attributeRole;
            propertyTypeBuilder = object instanceof DefaultAttributeType ? new AttributeTypeBuilder(this, (DefaultAttributeType)object) : (object instanceof DefaultAssociationRole ? new AssociationRoleBuilder(this, (DefaultAssociationRole)object) : null);
            GenericName genericName = object.getName();
            if (AttributeConvention.IDENTIFIER_PROPERTY.equals(genericName)) {
                attributeRole = AttributeRole.IDENTIFIER_COMPONENT;
            } else if (AttributeConvention.GEOMETRY_PROPERTY.equals(genericName)) {
                attributeRole = AttributeRole.DEFAULT_GEOMETRY;
            } else if (AttributeConvention.ENVELOPE_PROPERTY.equals(genericName)) {
                attributeRole = null;
            } else {
                if (propertyTypeBuilder == null) {
                    propertyTypeBuilder = new OperationWrapper(this, object);
                }
                attributeRole = null;
            }
            if (attributeRole != null) {
                Set<AttributeRole> set = Collections.singleton(attributeRole);
                if (object instanceof AbstractOperation) {
                    for (String string : ((AbstractOperation)object).getDependencies()) {
                        hashMap.merge(string, set, AttributeRole::merge);
                    }
                } else {
                    hashMap.merge(genericName.toString(), set, AttributeRole::merge);
                }
            }
            if (propertyTypeBuilder == null) continue;
            this.properties.add(propertyTypeBuilder);
        }
        if (!hashMap.isEmpty()) {
            for (Map.Entry entry : hashMap.entrySet()) {
                propertyTypeBuilder = this.forName(this.properties, (String)entry.getKey(), true);
                if (!(propertyTypeBuilder instanceof AttributeTypeBuilder)) continue;
                ((AttributeTypeBuilder)propertyTypeBuilder).roles().addAll((Collection)entry.getValue());
            }
        }
    }

    @Override
    final void clearCache() {
        this.feature = null;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public FeatureTypeBuilder setAbstract(boolean bl) {
        if (this.isAbstract != bl) {
            this.isAbstract = bl;
            this.clearCache();
        }
        return this;
    }

    public DefaultFeatureType[] getSuperTypes() {
        return this.superTypes.toArray(new DefaultFeatureType[this.superTypes.size()]);
    }

    public FeatureTypeBuilder setSuperTypes(DefaultFeatureType ... defaultFeatureTypeArray) {
        this.ensureNonNull("parents", defaultFeatureTypeArray);
        List<DefaultFeatureType> list = Arrays.asList(defaultFeatureTypeArray);
        if (!this.superTypes.equals(list)) {
            this.superTypes.clear();
            this.superTypes.addAll(list);
            int n = this.superTypes.size();
            while (--n >= 0) {
                if (this.superTypes.get(n) != null) continue;
                this.superTypes.remove(n);
            }
            this.clearCache();
        }
        return this;
    }

    public CharSequence getNameSpace() {
        return this.namespace != null ? this.namespace.name().toString() : null;
    }

    public FeatureTypeBuilder setNameSpace(CharSequence charSequence) {
        this.namespace = charSequence != null && charSequence.length() != 0 ? this.nameFactory.createNameSpace(this.nameFactory.createLocalName(null, charSequence), null) : null;
        return this;
    }

    @Override
    public FeatureTypeBuilder setName(GenericName genericName) {
        super.setName(genericName);
        return this;
    }

    @Override
    public FeatureTypeBuilder setName(CharSequence charSequence) {
        super.setName(charSequence);
        return this;
    }

    @Override
    public FeatureTypeBuilder setName(CharSequence ... charSequenceArray) {
        super.setName(charSequenceArray);
        return this;
    }

    @Override
    final GenericName createLocalName(CharSequence charSequence) {
        return this.nameFactory.createLocalName(this.namespace, charSequence);
    }

    @Override
    final GenericName createGenericName(CharSequence ... charSequenceArray) {
        return this.nameFactory.createGenericName(this.namespace, charSequenceArray);
    }

    @Deprecated
    public FeatureTypeBuilder setDefaultCardinality(int n, int n2) {
        return this.setDefaultMultiplicity(n, n2);
    }

    public FeatureTypeBuilder setDefaultMultiplicity(int n, int n2) {
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException(this.errors().getString((short)60, n, n2));
        }
        this.defaultMinimumOccurs = n;
        this.defaultMaximumOccurs = n2;
        return this;
    }

    public FeatureTypeBuilder setIdentifierDelimiters(String string, String string2, String string3) {
        this.ensureNonEmpty("delimiter", string);
        if (!(string.equals(this.idDelimiter) && Objects.equals(string2, this.idPrefix) && Objects.equals(string3, this.idSuffix))) {
            this.idDelimiter = string;
            this.idPrefix = string2;
            this.idSuffix = string3;
            this.clearCache();
        }
        return this;
    }

    public List<PropertyTypeBuilder> properties() {
        return new RemoveOnlyList<PropertyTypeBuilder>(this.properties);
    }

    public boolean isNameUsed(String string) {
        return this.forName(this.properties, string, false) != null;
    }

    public PropertyTypeBuilder getProperty(String string) {
        return this.forName(this.properties, string, true);
    }

    public <V> AttributeTypeBuilder<V> addAttribute(Class<V> clazz) {
        this.ensureNonNull("valueClass", clazz);
        if (AbstractFeature.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(this.errors().getString((short)45, "valueClass", clazz));
        }
        AttributeTypeBuilder<V> attributeTypeBuilder = new AttributeTypeBuilder<V>(this, clazz);
        this.properties.add(attributeTypeBuilder);
        this.clearCache();
        return attributeTypeBuilder;
    }

    public <V> AttributeTypeBuilder<V> addAttribute(DefaultAttributeType<V> defaultAttributeType) {
        this.ensureNonNull("template", defaultAttributeType);
        AttributeTypeBuilder<V> attributeTypeBuilder = new AttributeTypeBuilder<V>(this, defaultAttributeType);
        this.properties.add(attributeTypeBuilder);
        this.clearCache();
        return attributeTypeBuilder;
    }

    public AttributeTypeBuilder<?> addAttribute(GeometryType geometryType) {
        Class<Object> clazz;
        this.ensureNonNull("type", geometryType);
        if (geometryType.equals(GeometryType.POINT)) {
            clazz = this.geometries.pointClass;
        } else if (geometryType.equals(GeometryType.LINEAR)) {
            clazz = this.geometries.polylineClass;
        } else if (geometryType.equals(GeometryType.AREAL)) {
            clazz = this.geometries.polygonClass;
        } else {
            throw new IllegalArgumentException(this.errors().getString((short)170, geometryType));
        }
        return this.addAttribute(clazz);
    }

    public AssociationRoleBuilder addAssociation(DefaultFeatureType defaultFeatureType) {
        this.ensureNonNull("type", defaultFeatureType);
        AssociationRoleBuilder associationRoleBuilder = new AssociationRoleBuilder(this, defaultFeatureType, defaultFeatureType.getName());
        this.properties.add(associationRoleBuilder);
        this.clearCache();
        return associationRoleBuilder;
    }

    public AssociationRoleBuilder addAssociation(GenericName genericName) {
        this.ensureNonNull("type", genericName);
        AssociationRoleBuilder associationRoleBuilder = new AssociationRoleBuilder(this, null, genericName);
        this.properties.add(associationRoleBuilder);
        this.clearCache();
        return associationRoleBuilder;
    }

    public AssociationRoleBuilder addAssociation(DefaultAssociationRole defaultAssociationRole) {
        this.ensureNonNull("template", defaultAssociationRole);
        AssociationRoleBuilder associationRoleBuilder = new AssociationRoleBuilder(this, defaultAssociationRole);
        this.properties.add(associationRoleBuilder);
        this.clearCache();
        return associationRoleBuilder;
    }

    public PropertyTypeBuilder addProperty(AbstractIdentifiedType abstractIdentifiedType) {
        this.ensureNonNull("template", abstractIdentifiedType);
        if (abstractIdentifiedType instanceof DefaultAttributeType) {
            return this.addAttribute((DefaultAttributeType)abstractIdentifiedType);
        }
        if (abstractIdentifiedType instanceof DefaultAssociationRole) {
            return this.addAssociation((DefaultAssociationRole)abstractIdentifiedType);
        }
        OperationWrapper operationWrapper = new OperationWrapper(this, abstractIdentifiedType);
        this.properties.add(operationWrapper);
        this.clearCache();
        return operationWrapper;
    }

    @Override
    public FeatureTypeBuilder setDefinition(CharSequence charSequence) {
        super.setDefinition(charSequence);
        return this;
    }

    @Override
    public FeatureTypeBuilder setDesignation(CharSequence charSequence) {
        super.setDesignation(charSequence);
        return this;
    }

    @Override
    public FeatureTypeBuilder setDescription(CharSequence charSequence) {
        super.setDescription(charSequence);
        return this;
    }

    @Override
    public FeatureTypeBuilder setDeprecated(boolean bl) {
        super.setDeprecated(bl);
        return this;
    }

    @Override
    public DefaultFeatureType build() throws IllegalStateException {
        if (this.feature == null) {
            AbstractIdentifiedType[] abstractIdentifiedTypeArray;
            int n;
            int n2 = this.properties.size();
            int n3 = -1;
            int n4 = -1;
            if (this.identifierCount == 0) {
                n = 0;
                abstractIdentifiedTypeArray = null;
            } else {
                n = 1;
                abstractIdentifiedTypeArray = new AbstractIdentifiedType[this.identifierCount];
            }
            if (this.defaultGeometry != null) {
                n3 = n++;
                if (!AttributeConvention.GEOMETRY_PROPERTY.equals(this.defaultGeometry.getName())) {
                    n4 = n++;
                }
            }
            AbstractIdentifiedType[] abstractIdentifiedTypeArray2 = new AbstractIdentifiedType[n + n2];
            int n5 = n;
            int n6 = 0;
            for (int i = 0; i < n2; ++i) {
                AbstractIdentifiedType abstractIdentifiedType;
                PropertyTypeBuilder propertyTypeBuilder = this.properties.get(i);
                abstractIdentifiedTypeArray2[n5] = abstractIdentifiedType = propertyTypeBuilder.build();
                if (propertyTypeBuilder.isIdentifier()) {
                    abstractIdentifiedTypeArray[n6++] = abstractIdentifiedType;
                }
                if (propertyTypeBuilder == this.defaultGeometry && n4 >= 0) {
                    if (abstractIdentifiedTypeArray2[n4] != null) {
                        throw new CorruptedObjectException();
                    }
                    abstractIdentifiedTypeArray2[n4] = FeatureOperations.link(FeatureTypeBuilder.name(AttributeConvention.GEOMETRY_PROPERTY), abstractIdentifiedType);
                }
                ++n5;
            }
            if (n3 >= 0) {
                try {
                    abstractIdentifiedTypeArray2[n3] = FeatureOperations.envelope(FeatureTypeBuilder.name(AttributeConvention.ENVELOPE_PROPERTY), null, abstractIdentifiedTypeArray2);
                }
                catch (FactoryException factoryException) {
                    throw new IllegalStateException(factoryException);
                }
            }
            if (abstractIdentifiedTypeArray != null) {
                if (n6 != abstractIdentifiedTypeArray.length) {
                    throw new CorruptedObjectException();
                }
                if (AttributeConvention.IDENTIFIER_PROPERTY.equals(abstractIdentifiedTypeArray[0].getName())) {
                    if (n6 > 1) {
                        throw new IllegalStateException(Resources.format((short)15, this.getDisplayName(), AttributeConvention.IDENTIFIER_PROPERTY));
                    }
                    System.arraycopy(abstractIdentifiedTypeArray2, 1, abstractIdentifiedTypeArray2, 0, --n5);
                } else {
                    abstractIdentifiedTypeArray2[0] = FeatureOperations.compound(FeatureTypeBuilder.name(AttributeConvention.IDENTIFIER_PROPERTY), this.idDelimiter, this.idPrefix, this.idSuffix, abstractIdentifiedTypeArray);
                }
            }
            this.feature = new DefaultFeatureType(this.identification(), this.isAbstract(), this.superTypes.toArray(new DefaultFeatureType[this.superTypes.size()]), ArraysExt.resize(abstractIdentifiedTypeArray2, n5));
        }
        return this.feature;
    }

    private static Map<String, ?> name(GenericName genericName) {
        return Collections.singletonMap("name", genericName);
    }

    final void replace(PropertyTypeBuilder propertyTypeBuilder, PropertyTypeBuilder propertyTypeBuilder2) {
        int n = this.properties.lastIndexOf(propertyTypeBuilder);
        if (n < 0 || (propertyTypeBuilder2 != null ? this.properties.set(n, propertyTypeBuilder2) : this.properties.remove(n)) != propertyTypeBuilder) {
            throw new CorruptedObjectException();
        }
        if (propertyTypeBuilder == this.defaultGeometry) {
            this.defaultGeometry = (AttributeTypeBuilder)propertyTypeBuilder2;
        }
        this.clearCache();
    }

    @Override
    final void toStringInternal(StringBuilder stringBuilder) {
        if (this.isAbstract()) {
            stringBuilder.insert(stringBuilder.indexOf("[") + 1, "abstract ");
        }
        String string = " : ";
        for (DefaultFeatureType object : this.superTypes) {
            stringBuilder.append(string).append('\u201c').append(object.getName()).append('\u201d');
            string = ", ";
        }
        stringBuilder.append(" {");
        string = System.lineSeparator();
        for (PropertyTypeBuilder propertyTypeBuilder : this.properties) {
            propertyTypeBuilder.appendStringTo(stringBuilder.append(string).append("    ").append(propertyTypeBuilder.getClass().getSimpleName()));
        }
        stringBuilder.append(string).append('}');
    }
}

