/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.math.RoundingMode;
import java.text.Format;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.IncompleteGridGeometryException;
import org.apache.sis.coverage.grid.PixelTranslation;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.TemporalAccessor;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridGeometry
implements Serializable {
    private static final long serialVersionUID = -954786616001606624L;
    public static final int CRS = 1;
    public static final int ENVELOPE = 2;
    public static final int EXTENT = 4;
    public static final int GRID_TO_CRS = 8;
    public static final int RESOLUTION = 16;
    public static final int GEOGRAPHIC_EXTENT = 32;
    public static final int TEMPORAL_EXTENT = 64;
    protected final GridExtent extent;
    protected final ImmutableEnvelope envelope;
    protected final MathTransform gridToCRS;
    private final MathTransform cornerToCRS;
    protected final double[] resolution;
    private final long nonLinears;
    private volatile transient GeographicBoundingBox geographicBBox;
    private volatile transient Instant[] timeRange;
    public static final GridGeometry UNDEFINED = new GridGeometry();

    private GridGeometry() {
        this.extent = null;
        this.gridToCRS = null;
        this.cornerToCRS = null;
        this.envelope = null;
        this.resolution = null;
        this.nonLinears = 0L;
    }

    protected GridGeometry(GridGeometry gridGeometry) {
        this.extent = gridGeometry.extent;
        this.gridToCRS = gridGeometry.gridToCRS;
        this.cornerToCRS = gridGeometry.cornerToCRS;
        this.envelope = gridGeometry.envelope;
        this.resolution = gridGeometry.resolution;
        this.nonLinears = gridGeometry.nonLinears;
    }

    GridGeometry(GridGeometry gridGeometry, GridExtent gridExtent, MathTransform mathTransform) throws TransformException {
        Object object;
        int n = gridGeometry.getDimension();
        this.extent = gridExtent;
        GridGeometry.ensureDimensionMatches(n, gridExtent);
        if (mathTransform == null || mathTransform.isIdentity()) {
            this.gridToCRS = gridGeometry.gridToCRS;
            this.cornerToCRS = gridGeometry.cornerToCRS;
            this.resolution = gridGeometry.resolution;
            this.nonLinears = gridGeometry.nonLinears;
        } else {
            object = MathTransforms.concatenate(MathTransforms.uniformTranslation(n, 0.5), mathTransform, MathTransforms.uniformTranslation(n, -0.5));
            this.cornerToCRS = MathTransforms.concatenate(mathTransform, gridGeometry.cornerToCRS);
            this.gridToCRS = MathTransforms.concatenate((MathTransform)object, gridGeometry.gridToCRS);
            this.resolution = GridGeometry.resolution(this.gridToCRS, gridExtent);
            this.nonLinears = GridGeometry.findNonLinearTargets(this.gridToCRS);
        }
        object = gridGeometry.envelope;
        ImmutableEnvelope immutableEnvelope = this.computeEnvelope(this.gridToCRS, GridGeometry.getCoordinateReferenceSystem((Envelope)object), (Envelope)object);
        if (immutableEnvelope == null || !immutableEnvelope.equals(object)) {
            object = immutableEnvelope;
        }
        this.envelope = object;
        if (object == null && this.gridToCRS == null) {
            ArgumentChecks.ensureNonNull("extent", gridExtent);
        }
    }

    public GridGeometry(GridExtent gridExtent, PixelInCell pixelInCell, MathTransform mathTransform, CoordinateReferenceSystem coordinateReferenceSystem) {
        if (mathTransform != null) {
            GridGeometry.ensureDimensionMatches(mathTransform.getSourceDimensions(), gridExtent);
            ArgumentChecks.ensureDimensionMatches("crs", mathTransform.getTargetDimensions(), coordinateReferenceSystem);
        } else if (coordinateReferenceSystem == null) {
            ArgumentChecks.ensureNonNull("extent", gridExtent);
        }
        try {
            this.extent = gridExtent;
            this.gridToCRS = PixelTranslation.translate(mathTransform, pixelInCell, PixelInCell.CELL_CENTER);
            this.cornerToCRS = PixelTranslation.translate(mathTransform, pixelInCell, PixelInCell.CELL_CORNER);
            this.envelope = this.computeEnvelope(mathTransform, coordinateReferenceSystem, null);
            this.resolution = GridGeometry.resolution(mathTransform, gridExtent);
            this.nonLinears = GridGeometry.findNonLinearTargets(mathTransform);
        }
        catch (TransformException transformException) {
            throw new IllegalGridGeometryException(transformException, "gridToCRS");
        }
    }

    private ImmutableEnvelope computeEnvelope(MathTransform mathTransform, CoordinateReferenceSystem coordinateReferenceSystem, Envelope envelope) throws TransformException {
        GeneralEnvelope generalEnvelope;
        if (this.extent != null && this.cornerToCRS != null) {
            generalEnvelope = this.extent.toCRS(this.cornerToCRS, mathTransform, envelope);
            generalEnvelope.setCoordinateReferenceSystem(coordinateReferenceSystem);
            if (envelope != null) {
                generalEnvelope.intersect(envelope);
            }
        } else if (coordinateReferenceSystem != null) {
            generalEnvelope = new GeneralEnvelope(coordinateReferenceSystem);
            generalEnvelope.setToNaN();
        } else {
            return null;
        }
        return new ImmutableEnvelope(generalEnvelope);
    }

    public GridGeometry(PixelInCell pixelInCell, MathTransform mathTransform, Envelope envelope, GridRoundingMode gridRoundingMode) {
        if (mathTransform == null) {
            ArgumentChecks.ensureNonNull("envelope", envelope);
        } else {
            ArgumentChecks.ensureDimensionMatches("envelope", mathTransform.getTargetDimensions(), envelope);
        }
        ArgumentChecks.ensureNonNull("rounding", (Object)gridRoundingMode);
        this.gridToCRS = PixelTranslation.translate(mathTransform, pixelInCell, PixelInCell.CELL_CENTER);
        this.cornerToCRS = PixelTranslation.translate(mathTransform, pixelInCell, PixelInCell.CELL_CORNER);
        Matrix matrix = MathTransforms.getMatrix(mathTransform);
        int n = 1;
        if (envelope != null && this.cornerToCRS != null) {
            GeneralEnvelope generalEnvelope;
            try {
                generalEnvelope = Envelopes.transform(this.cornerToCRS.inverse(), envelope);
                this.extent = new GridExtent(generalEnvelope, gridRoundingMode, null, null, null);
                generalEnvelope = this.extent.toCRS(this.cornerToCRS, mathTransform, envelope);
            }
            catch (TransformException transformException) {
                throw new IllegalGridGeometryException(transformException, "gridToCRS");
            }
            generalEnvelope.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
            this.envelope = new ImmutableEnvelope(generalEnvelope);
            if (matrix == null) {
                try {
                    matrix = mathTransform.derivative(new DirectPositionView.Double(this.extent.getPointOfInterest()));
                    n = 0;
                }
                catch (TransformException transformException) {
                    GridGeometry.recoverableException(transformException);
                }
            }
        } else {
            this.extent = null;
            this.envelope = ImmutableEnvelope.castOrCopy(envelope);
        }
        this.resolution = matrix != null ? GridGeometry.resolution(matrix, n) : null;
        this.nonLinears = GridGeometry.findNonLinearTargets(mathTransform);
    }

    private static void ensureDimensionMatches(int n, GridExtent gridExtent) throws MismatchedDimensionException {
        int n2;
        if (gridExtent != null && (n2 = gridExtent.getDimension()) != n) {
            throw new MismatchedDimensionException(Errors.format((short)81, "extent", n, n2));
        }
    }

    static void recoverableException(Exception exception) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.raster"), GridGeometry.class, "<init>", exception);
    }

    public GridGeometry(GridExtent gridExtent, Envelope envelope) {
        this.extent = gridExtent;
        this.nonLinears = 0L;
        boolean bl = true;
        ImmutableEnvelope immutableEnvelope = ImmutableEnvelope.castOrCopy(envelope);
        if (immutableEnvelope == null || (bl = immutableEnvelope.isAllNaN()) && immutableEnvelope.getCoordinateReferenceSystem() == null) {
            ArgumentChecks.ensureNonNull("extent", gridExtent);
            this.envelope = null;
        } else {
            this.envelope = immutableEnvelope;
            if (gridExtent != null && !bl) {
                MatrixSIS matrixSIS = gridExtent.cornerToCRS(immutableEnvelope);
                this.cornerToCRS = MathTransforms.linear(matrixSIS);
                int n = this.cornerToCRS.getSourceDimensions();
                int n2 = this.cornerToCRS.getTargetDimensions();
                this.resolution = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    DoubleDouble doubleDouble = (DoubleDouble)matrixSIS.getNumber(i, i);
                    DoubleDouble doubleDouble2 = (DoubleDouble)matrixSIS.getNumber(i, n);
                    this.resolution[i] = doubleDouble.doubleValue();
                    doubleDouble.multiply(0.5);
                    doubleDouble2.add(doubleDouble);
                    matrixSIS.setNumber(i, n, doubleDouble2);
                }
                this.gridToCRS = MathTransforms.linear(matrixSIS);
                return;
            }
        }
        this.gridToCRS = null;
        this.cornerToCRS = null;
        this.resolution = null;
    }

    private GridGeometry(GridGeometry gridGeometry, int[] nArray) throws FactoryException {
        int n;
        int n2;
        double[] dArray;
        Object object;
        Object object2;
        this.extent = gridGeometry.extent != null ? gridGeometry.extent.reduce(nArray) : null;
        int n3 = nArray.length;
        if (gridGeometry.gridToCRS != null) {
            object2 = nArray;
            object = new TransformSeparator(gridGeometry.gridToCRS);
            ((TransformSeparator)object).addSourceDimensions((int[])object2);
            this.gridToCRS = ((TransformSeparator)object).separate();
            nArray = ((TransformSeparator)object).getTargetDimensions();
            assert (nArray.length == n3) : Arrays.toString(nArray);
            if (!ArraysExt.isSorted(nArray, true)) {
                throw new IllegalGridGeometryException(Resources.format((short)33, "dimensions"));
            }
            object = new TransformSeparator(gridGeometry.cornerToCRS);
            ((TransformSeparator)object).addSourceDimensions((int[])object2);
            ((TransformSeparator)object).addTargetDimensions(nArray);
            this.cornerToCRS = ((TransformSeparator)object).separate();
            assert (Arrays.equals(((TransformSeparator)object).getSourceDimensions(), nArray)) : Arrays.toString(nArray);
        } else {
            this.gridToCRS = null;
            this.cornerToCRS = null;
        }
        if ((object2 = (Object)gridGeometry.envelope) != null) {
            object = ((ImmutableEnvelope)object2).getCoordinateReferenceSystem();
            object = org.apache.sis.referencing.CRS.reduce((CoordinateReferenceSystem)object, nArray);
            double[] dArray2 = new double[n3];
            dArray = new double[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                n = nArray[n2];
                dArray2[n2] = ((ImmutableEnvelope)object2).getLower(n);
                dArray[n2] = ((ImmutableEnvelope)object2).getUpper(n);
            }
            this.envelope = new ImmutableEnvelope(dArray2, dArray, (CoordinateReferenceSystem)object);
        } else {
            this.envelope = null;
        }
        long l = 0L;
        dArray = gridGeometry.resolution;
        if (dArray != null) {
            dArray = new double[n3];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray[n2];
            if (dArray != null) {
                dArray[n2] = gridGeometry.resolution[n];
            }
            l |= (gridGeometry.nonLinears >>> n & 1L) << n2;
        }
        this.resolution = dArray;
        this.nonLinears = l;
    }

    public final int getDimension() {
        if (this.extent != null) {
            return this.extent.getDimension();
        }
        if (this.gridToCRS != null) {
            return this.gridToCRS.getSourceDimensions();
        }
        return this.envelope.getDimension();
    }

    private int getTargetDimension() {
        if (this.envelope != null) {
            return this.envelope.getDimension();
        }
        if (this.gridToCRS != null) {
            return this.gridToCRS.getTargetDimensions();
        }
        return this.extent.getDimension();
    }

    public GridExtent getExtent() {
        if (this.extent != null) {
            return this.extent;
        }
        throw this.incomplete(4, (short)52);
    }

    public MathTransform getGridToCRS(PixelInCell pixelInCell) {
        MathTransform mathTransform = PixelInCell.CELL_CENTER.equals(pixelInCell) ? this.gridToCRS : (PixelInCell.CELL_CORNER.equals(pixelInCell) ? this.cornerToCRS : PixelTranslation.translate(this.gridToCRS, PixelInCell.CELL_CENTER, pixelInCell));
        if (mathTransform != null) {
            return mathTransform;
        }
        throw this.incomplete(8, (short)54);
    }

    private static CoordinateReferenceSystem getCoordinateReferenceSystem(Envelope envelope) {
        return envelope != null ? envelope.getCoordinateReferenceSystem() : null;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        CoordinateReferenceSystem coordinateReferenceSystem = GridGeometry.getCoordinateReferenceSystem(this.envelope);
        if (coordinateReferenceSystem != null) {
            return coordinateReferenceSystem;
        }
        throw this.incomplete(1, (short)51);
    }

    public Envelope getEnvelope() {
        if (this.envelope != null && !this.envelope.isAllNaN()) {
            return this.envelope;
        }
        throw this.incomplete(2, this.extent == null ? (short)52 : 54);
    }

    public Optional<GeographicBoundingBox> getGeographicExtent() {
        return Optional.ofNullable(this.geographicBBox());
    }

    private GeographicBoundingBox geographicBBox() {
        GeographicBoundingBox geographicBoundingBox = this.geographicBBox;
        if (geographicBoundingBox == null && GridGeometry.getCoordinateReferenceSystem(this.envelope) != null && !this.envelope.isAllNaN()) {
            try {
                DefaultGeographicBoundingBox defaultGeographicBoundingBox = ReferencingServices.getInstance().setBounds(this.envelope, null, null);
                defaultGeographicBoundingBox.transitionTo(ModifiableMetadata.State.EDITABLE);
                geographicBoundingBox = defaultGeographicBoundingBox;
            }
            catch (TransformException transformException) {
                geographicBoundingBox = NilReason.INAPPLICABLE.createNilObject(GeographicBoundingBox.class);
            }
            this.geographicBBox = geographicBoundingBox;
        }
        return geographicBoundingBox instanceof NilObject ? null : geographicBoundingBox;
    }

    public Instant[] getTemporalExtent() {
        Instant[] instantArray = this.timeRange();
        if (instantArray.length != 0) {
            instantArray = (Instant[])instantArray.clone();
        }
        return instantArray;
    }

    private Instant[] timeRange() {
        Instant[] instantArray = this.timeRange;
        if (instantArray == null) {
            TemporalAccessor temporalAccessor = TemporalAccessor.of(GridGeometry.getCoordinateReferenceSystem(this.envelope), 0);
            instantArray = temporalAccessor != null ? temporalAccessor.getTimeRange(this.envelope) : new Instant[]{};
            this.timeRange = instantArray;
        }
        return instantArray;
    }

    public double[] getResolution(boolean bl) {
        if (this.resolution != null) {
            double[] dArray = (double[])this.resolution.clone();
            if (!bl) {
                int n;
                for (long i = this.nonLinears; i != 0L; i &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL) {
                    n = Long.numberOfTrailingZeros(i);
                    dArray[n] = Double.NaN;
                }
            }
            return dArray;
        }
        throw this.incomplete(16, this.gridToCRS == null ? (short)54 : 52);
    }

    static double[] resolution(MathTransform mathTransform, GridExtent gridExtent) {
        Matrix matrix = MathTransforms.getMatrix(mathTransform);
        if (matrix != null) {
            return GridGeometry.resolution(matrix, 1);
        }
        if (gridExtent != null && mathTransform != null) {
            try {
                return GridGeometry.resolution(mathTransform.derivative(new DirectPositionView.Double(gridExtent.getPointOfInterest())), 0);
            }
            catch (TransformException transformException) {
                GridGeometry.recoverableException(transformException);
            }
        }
        return null;
    }

    private static double[] resolution(Matrix matrix, int n) {
        double[] dArray = new double[matrix.getNumRow() - n];
        double[] dArray2 = new double[matrix.getNumCol() - n];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray2.length; ++j) {
                dArray2[j] = matrix.getElement(i, j);
            }
            dArray[i] = MathFunctions.magnitude(dArray2);
        }
        return dArray;
    }

    public boolean isConversionLinear(int ... nArray) {
        int n = this.getTargetDimension();
        long l = 0L;
        for (int n2 : nArray) {
            ArgumentChecks.ensureValidIndex(n, n2);
            if (n2 >= 64) continue;
            l |= 1L << n2;
        }
        return (this.nonLinears & l) == 0L;
    }

    private static long findNonLinearTargets(MathTransform mathTransform) {
        long l = 0L;
        for (MathTransform mathTransform2 : MathTransforms.getSteps(mathTransform)) {
            int n;
            int n2;
            long l2;
            Matrix matrix = MathTransforms.getMatrix(mathTransform2);
            if (matrix != null) {
                l2 = l;
                l = 0L;
                while (l2 != 0L) {
                    n2 = Long.numberOfTrailingZeros(l2);
                    n = matrix.getNumRow() - 1;
                    while (--n >= 0) {
                        if (matrix.getElement(n, n2) == 0.0) continue;
                        if (n >= 64) {
                            throw GridGeometry.excessiveDimension(mathTransform);
                        }
                        l |= 1L << n;
                    }
                    l2 &= 1L << n2 ^ 0xFFFFFFFFFFFFFFFFL;
                }
                continue;
            }
            if (mathTransform2 instanceof PassThroughTransform) {
                l2 = 0L;
                n2 = mathTransform2.getTargetDimensions() - mathTransform2.getSourceDimensions();
                n = 64 - Math.max(n2, 0);
                for (int n3 : ((PassThroughTransform)mathTransform2).getModifiedCoordinates()) {
                    if (n3 >= n) {
                        throw GridGeometry.excessiveDimension(mathTransform);
                    }
                    l2 |= 1L << n3;
                }
                if (n2 != 0) {
                    l2 = (Long.highestOneBit(l2) << n2 + 1) - Long.lowestOneBit(l2);
                }
                l |= l2;
                continue;
            }
            int n4 = mathTransform.getTargetDimensions();
            if (n4 > 64) {
                throw GridGeometry.excessiveDimension(mathTransform);
            }
            return n4 >= 64 ? -1L : (1L << n4) - 1L;
        }
        return l;
    }

    private static ArithmeticException excessiveDimension(MathTransform mathTransform) {
        return new ArithmeticException(Errors.format((short)37, mathTransform.getTargetDimensions()));
    }

    private IncompleteGridGeometryException incomplete(int n, short s2) {
        assert (this.getClass() != GridGeometry.class || !this.isDefined(n));
        return new IncompleteGridGeometryException(Resources.format(s2));
    }

    final MathTransform requireGridToCRS(boolean bl) throws IncompleteGridGeometryException {
        MathTransform mathTransform;
        if (this.extent == null) {
            throw this.incomplete(4, (short)52);
        }
        MathTransform mathTransform2 = mathTransform = bl ? this.gridToCRS : this.cornerToCRS;
        if (mathTransform == null) {
            throw this.incomplete(8, (short)54);
        }
        return mathTransform;
    }

    public boolean isDefined(int n) {
        if ((n & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException(Errors.format((short)45, "bitmask", n));
        }
        return !((n & 1) != 0 && null == GridGeometry.getCoordinateReferenceSystem(this.envelope) || (n & 2) != 0 && (null == this.envelope || this.envelope.isAllNaN()) || (n & 4) != 0 && null == this.extent || (n & 8) != 0 && null == this.gridToCRS || (n & 0x10) != 0 && null == this.resolution || (n & 0x20) != 0 && null == this.geographicBBox() || (n & 0x40) != 0 && this.timeRange().length == 0);
    }

    public GridDerivation derive() {
        return new GridDerivation(this);
    }

    public GridGeometry reduce(int ... nArray) {
        if ((nArray = GridExtent.verifyDimensions(nArray, this.getDimension())) != null) {
            try {
                return new GridGeometry(this, nArray);
            }
            catch (FactoryException factoryException) {
                throw new IllegalGridGeometryException(factoryException, "dimensions");
            }
        }
        return this;
    }

    public int hashCode() {
        int n = -1527952352;
        if (this.gridToCRS != null) {
            n += this.gridToCRS.hashCode();
        }
        if (this.extent != null) {
            n += this.extent.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            GridGeometry gridGeometry = (GridGeometry)object;
            return Objects.equals(this.extent, gridGeometry.extent) && Objects.equals(this.gridToCRS, gridGeometry.gridToCRS) && Objects.equals(this.envelope, gridGeometry.envelope);
        }
        return false;
    }

    static int defaultFlags() {
        return 127;
    }

    public String toString() {
        return this.toTree(Locale.getDefault(), GridGeometry.defaultFlags()).toString();
    }

    public TreeTable toTree(Locale locale, int n) {
        ArgumentChecks.ensureNonNull("locale", locale);
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(TableColumn.VALUE_AS_TEXT);
        TreeTable.Node node = defaultTreeTable.getRoot();
        node.setValue(TableColumn.VALUE_AS_TEXT, Classes.getShortClassName(this));
        this.formatTo(locale, Vocabulary.getResources(locale), n, node);
        return defaultTreeTable;
    }

    final void formatTo(Locale locale, Vocabulary vocabulary, int n, TreeTable.Node node) {
        if ((n & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException(Errors.format((short)45, "bitmask", n));
        }
        try {
            new Formatter(locale, vocabulary, n, node).format();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private final class Formatter {
        private final int bitmask;
        private final StringBuilder buffer;
        private final TreeTable.Node root;
        private TreeTable.Node section;
        private final Vocabulary vocabulary;
        private final Locale locale;
        private final CoordinateReferenceSystem crs;
        private final CoordinateSystem cs;

        Formatter(Locale locale, Vocabulary vocabulary, int n, TreeTable.Node node) {
            this.root = node;
            this.bitmask = n;
            this.buffer = new StringBuilder(256);
            this.locale = locale;
            this.vocabulary = vocabulary;
            this.crs = GridGeometry.getCoordinateReferenceSystem(GridGeometry.this.envelope);
            this.cs = this.crs != null ? this.crs.getCoordinateSystem() : null;
        }

        final void format() throws IOException {
            Matrix matrix;
            int n;
            Object object;
            Object object2;
            Object object3;
            if (this.section(4, (short)152, true, false)) {
                GridGeometry.this.extent.appendTo(this.buffer, this.vocabulary);
                this.writeNodes();
            }
            if (this.section(32, (short)172, false, false) || this.section(64, (short)175, false, false)) {
                object3 = new TableAppender(this.buffer, "  ");
                object2 = new AngleFormat("DD\u00b0MM\u2032SS\u2033", this.locale);
                GeographicBoundingBox geographicBoundingBox = GridGeometry.this.geographicBBox();
                object = GridGeometry.this.timeRange();
                this.vocabulary.appendLabel((short)174, (Appendable)object3);
                ((TableAppender)object3).setCellAlignment((byte)1);
                if (geographicBoundingBox != null) {
                    ((AngleFormat)object2).setRoundingMode(RoundingMode.CEILING);
                    ((TableAppender)object3).nextColumn();
                    ((TableAppender)object3).append(((Format)object2).format(new Latitude(geographicBoundingBox.getNorthBoundLatitude())));
                    ((TableAppender)object3).nextColumn();
                    ((TableAppender)object3).append(((Format)object2).format(new Longitude(geographicBoundingBox.getEastBoundLongitude())));
                }
                if (((Instant[])object).length >= 2) {
                    ((TableAppender)object3).nextColumn();
                    ((TableAppender)object3).append(object[1].toString());
                }
                ((TableAppender)object3).nextLine();
                ((TableAppender)object3).setCellAlignment((byte)-1);
                this.vocabulary.appendLabel((short)173, (Appendable)object3);
                ((TableAppender)object3).setCellAlignment((byte)1);
                if (geographicBoundingBox != null) {
                    ((AngleFormat)object2).setRoundingMode(RoundingMode.FLOOR);
                    ((TableAppender)object3).nextColumn();
                    ((TableAppender)object3).append(((Format)object2).format(new Latitude(geographicBoundingBox.getSouthBoundLatitude())));
                    ((TableAppender)object3).nextColumn();
                    ((TableAppender)object3).append(((Format)object2).format(new Longitude(geographicBoundingBox.getWestBoundLongitude())));
                }
                if (((Instant[])object).length >= 1) {
                    ((TableAppender)object3).nextColumn();
                    ((TableAppender)object3).append(object[0].toString());
                }
                ((TableAppender)object3).flush();
                this.writeNodes();
            }
            if (this.section(2, (short)151, true, false)) {
                boolean bl = (this.bitmask & 0x10) != 0 && GridGeometry.this.resolution != null;
                object2 = new TableAppender(this.buffer, "");
                int n2 = GridGeometry.this.envelope.getDimension();
                object = NumberFormat.getNumberInstance(this.locale);
                for (n = 0; n < n2; ++n) {
                    double d = GridGeometry.this.envelope.getLower(n);
                    double d2 = GridGeometry.this.envelope.getUpper(n);
                    double d3 = GridGeometry.this.resolution != null ? GridGeometry.this.resolution[n] : Double.NaN;
                    ((NumberFormat)object).setMinimumFractionDigits(Numerics.fractionDigitsForDelta(d3));
                    ((NumberFormat)object).setMaximumFractionDigits(Numerics.suggestFractionDigits(d, d2));
                    CoordinateSystemAxis coordinateSystemAxis = this.cs != null ? this.cs.getAxis(n) : null;
                    String string = coordinateSystemAxis != null ? coordinateSystemAxis.getName().getCode() : this.vocabulary.getString((short)148, n);
                    ((TableAppender)object2).append(string).append(": ").nextColumn();
                    ((TableAppender)object2).setCellAlignment((byte)1);
                    ((TableAppender)object2).append(((NumberFormat)object).format(d)).nextColumn();
                    ((TableAppender)object2).setCellAlignment((byte)-1);
                    ((TableAppender)object2).append(" \u2026 ").append(((NumberFormat)object).format(d2));
                    if (bl) {
                        boolean bl2 = n < 64 && (GridGeometry.this.nonLinears & 1L << n) == 0L;
                        ((TableAppender)object2).nextColumn();
                        ((TableAppender)object2).append("  \u2206");
                        if (coordinateSystemAxis != null) {
                            ((TableAppender)object2).append(coordinateSystemAxis.getAbbreviation());
                        }
                        ((TableAppender)object2).nextColumn();
                        ((TableAppender)object2).append(' ').append(bl2 ? (char)'=' : '\u2248').append(' ');
                        this.appendResolution((Appendable)object2, (NumberFormat)object, d3, n);
                    }
                    ((TableAppender)object2).nextLine();
                }
                ((TableAppender)object2).flush();
                this.writeNodes();
            } else if (this.section(16, (short)153, true, false)) {
                object3 = "";
                object2 = NumberFormat.getNumberInstance(this.locale);
                for (int i = 0; i < GridGeometry.this.resolution.length; ++i) {
                    this.appendResolution(this.buffer.append((String)object3), (NumberFormat)object2, GridGeometry.this.resolution[i], i);
                    object3 = " \u00d7 ";
                }
                this.writeNode();
            }
            if (this.section(1, (short)132, true, false)) {
                Identifier identifier = IdentifiedObjects.getIdentifier(this.crs, null);
                if (identifier != null) {
                    this.buffer.append(IdentifiedObjects.toString(identifier)).append(" \u2014 ");
                }
                this.buffer.append(this.crs.getName());
                this.writeNode();
            }
            if (this.section(8, (short)150, true, (matrix = MathTransforms.getMatrix(GridGeometry.this.gridToCRS)) != null)) {
                if (matrix != null) {
                    this.writeNode(Matrices.toString(matrix));
                } else {
                    long l;
                    this.buffer.append(GridGeometry.this.gridToCRS.getSourceDimensions()).append("D \u2192 ").append(GridGeometry.this.gridToCRS.getTargetDimensions()).append("D ");
                    object = Resources.forLocale(this.locale).getString((short)45, Long.bitCount(l));
                    for (l = GridGeometry.this.nonLinears; l != 0L; l &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL) {
                        n = Long.numberOfTrailingZeros(l);
                        this.buffer.append((String)object).append(' ').append(this.cs != null ? this.cs.getAxis(n).getName().getCode() : String.valueOf(n));
                        object = ",";
                    }
                    this.writeNode();
                }
            }
        }

        private boolean section(int n, short s2, boolean bl, boolean bl2) {
            if ((this.bitmask & n) != 0) {
                String string = this.vocabulary.getString(s2);
                if (bl2) {
                    string = this.buffer.append((CharSequence)string).append(" (").append(this.vocabulary.getString((short)155).toLowerCase(this.locale)).append(')').toString();
                    this.buffer.setLength(0);
                }
                this.section = this.root.newChild();
                this.section.setValue(TableColumn.VALUE_AS_TEXT, string);
                if (GridGeometry.this.isDefined(n)) {
                    return true;
                }
                if (bl) {
                    this.writeNode(this.vocabulary.getString((short)154));
                }
            }
            return false;
        }

        private void writeNode(CharSequence charSequence) {
            String string = charSequence.toString().trim();
            if (!string.isEmpty()) {
                this.section.newChild().setValue(TableColumn.VALUE_AS_TEXT, string);
            }
        }

        private void writeNode() {
            this.writeNode(this.buffer);
            this.buffer.setLength(0);
        }

        private void writeNodes() {
            for (CharSequence charSequence : CharSequences.splitOnEOL(this.buffer)) {
                this.writeNode(charSequence);
            }
            this.buffer.setLength(0);
        }

        private void appendResolution(Appendable appendable, NumberFormat numberFormat, double d, int n) throws IOException {
            if (Double.isNaN(d)) {
                appendable.append('?');
            } else {
                numberFormat.setMaximumFractionDigits(Numerics.suggestFractionDigits(d) / 2);
                appendable.append(numberFormat.format(d));
            }
            if (this.cs != null) {
                String string = String.valueOf(this.cs.getAxis(n).getUnit());
                if (string.isEmpty() || Character.isLetterOrDigit(string.codePointAt(0))) {
                    appendable.append(' ');
                }
                appendable.append(string);
            }
        }
    }
}

