/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.TimerTask;
import net.sf.ehcache.util.ProductInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateChecker
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateChecker.class.getName());
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final int CONNECT_TIMEOUT = 3000;
    private static final String UNKNOWN = "UNKNOWN";
    private static final String UPDATE_CHECK_URL = "http://www.terracotta.org/kit/reflector?kitID=ehcache.default&pageID=update.properties";
    private static final long START_TIME = System.currentTimeMillis();

    @Override
    public void run() {
        this.checkForUpdate();
    }

    public void checkForUpdate() {
        try {
            if (!Boolean.getBoolean("net.sf.ehcache.skipUpdateCheck")) {
                this.doCheck();
            }
        }
        catch (Throwable t) {
            LOG.debug("Update check failed: " + t.toString());
        }
    }

    private void doCheck() throws IOException {
        URL updateUrl = this.buildUpdateCheckUrl();
        if (Boolean.getBoolean("net.sf.ehcache.debug.updatecheck")) {
            LOG.info("Update check url: {}", (Object)updateUrl);
        }
        Properties updateProps = this.getUpdateProperties(updateUrl);
        String currentVersion = new ProductInfo().getVersion();
        String propVal = updateProps.getProperty("general.notice");
        if (this.notBlank(propVal)) {
            LOG.info(propVal);
        }
        if (this.notBlank(propVal = updateProps.getProperty(currentVersion + ".notice"))) {
            LOG.info(propVal);
        }
        if (this.notBlank(propVal = updateProps.getProperty(currentVersion + ".updates"))) {
            StringBuilder sb = new StringBuilder();
            String[] newVersions = propVal.split(",");
            for (int i = 0; i < newVersions.length; ++i) {
                String newVersion = newVersions[i].trim();
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(newVersion);
                propVal = updateProps.getProperty(newVersion + ".release-notes");
                if (!this.notBlank(propVal)) continue;
                sb.append(" [");
                sb.append(propVal);
                sb.append("]");
            }
            if (sb.length() > 0) {
                LOG.info("New update(s) found: " + sb.toString() + ". Please check http://ehcache.org for the latest version.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getUpdateProperties(URL updateUrl) throws IOException {
        URLConnection connection = updateUrl.openConnection();
        connection.setConnectTimeout(3000);
        InputStream in = connection.getInputStream();
        try {
            Properties props = new Properties();
            props.load(connection.getInputStream());
            Properties properties = props;
            return properties;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private URL buildUpdateCheckUrl() throws MalformedURLException, UnsupportedEncodingException {
        String url = System.getProperty("ehcache.update-check.url", UPDATE_CHECK_URL);
        String connector = url.indexOf(63) > 0 ? "&" : "?";
        return new URL(url + connector + this.buildParamsString());
    }

    protected String buildParamsString() throws UnsupportedEncodingException {
        ProductInfo productInfo = new ProductInfo();
        StringBuilder sb = new StringBuilder();
        sb.append("id=");
        sb.append(this.getClientId());
        sb.append("&os-name=");
        sb.append(this.urlEncode(this.getProperty("os.name")));
        sb.append("&jvm-name=");
        sb.append(this.urlEncode(this.getProperty("java.vm.name")));
        sb.append("&jvm-version=");
        sb.append(this.urlEncode(this.getProperty("java.version")));
        sb.append("&platform=");
        sb.append(this.urlEncode(this.getProperty("os.arch")));
        sb.append("&tc-version=");
        sb.append(productInfo.getVersion());
        sb.append("&tc-product=");
        sb.append(this.urlEncode(productInfo.getName() + " " + productInfo.getVersion()));
        sb.append("&source=");
        sb.append(this.urlEncode(productInfo.getName()));
        sb.append("&uptime-secs=");
        sb.append(this.getUptimeInSeconds());
        sb.append("&patch=");
        sb.append(this.urlEncode(productInfo.getPatchLevel()));
        return sb.toString();
    }

    private long getUptimeInSeconds() {
        long uptime = System.currentTimeMillis() - START_TIME;
        return uptime > 0L ? uptime / 1000L : 0L;
    }

    private int getClientId() {
        try {
            return InetAddress.getLocalHost().hashCode();
        }
        catch (Throwable t) {
            return 0;
        }
    }

    protected String urlEncode(String param) throws UnsupportedEncodingException {
        return URLEncoder.encode(param, "UTF-8");
    }

    private String getProperty(String prop) {
        return System.getProperty(prop, UNKNOWN);
    }

    private boolean notBlank(String s2) {
        return s2 != null && s2.trim().length() > 0;
    }
}

