/*
 * Decompiled with CFR 0.152.
 */
package colorspace.boxes;

import colorspace.ColorSpaceException;
import colorspace.boxes.JP2Box;
import icc.ICCProfile;
import java.io.IOException;
import jj2000.j2k.io.RandomAccessIO;

public final class PaletteBox
extends JP2Box {
    private int nentries;
    private int ncolumns;
    private short[] bitdepth;
    private int[][] entries;

    public PaletteBox(RandomAccessIO in, int boxStart) throws IOException, ColorSpaceException {
        super(in, boxStart);
        this.readBox();
    }

    void readBox() throws IOException, ColorSpaceException {
        int i;
        byte[] bfr = new byte[4];
        this.in.seek(this.dataStart);
        this.in.readFully(bfr, 0, 3);
        this.nentries = ICCProfile.getShort(bfr, 0) & 0xFFFF;
        this.ncolumns = bfr[2] & 0xFFFF;
        this.bitdepth = new short[this.ncolumns];
        bfr = new byte[this.ncolumns];
        this.in.readFully(bfr, 0, this.ncolumns);
        for (i = 0; i < this.ncolumns; ++i) {
            this.bitdepth[i] = (short)(bfr[i] & 0xFFF);
        }
        this.entries = new int[this.nentries * this.ncolumns][];
        bfr = new byte[2];
        for (i = 0; i < this.nentries; ++i) {
            this.entries[i] = new int[this.ncolumns];
            for (int j = 0; j < this.ncolumns; ++j) {
                int m3;
                short b;
                short bd = this.getBitDepth(j);
                boolean signed = this.isSigned(j);
                switch (this.getEntrySize(j)) {
                    case 1: {
                        this.in.readFully(bfr, 0, 1);
                        b = bfr[0];
                        break;
                    }
                    case 2: {
                        this.in.readFully(bfr, 0, 2);
                        b = ICCProfile.getShort(bfr, 0);
                        break;
                    }
                    default: {
                        throw new ColorSpaceException("palettes greater than 16 bits deep not supported");
                    }
                }
                if (signed) {
                    if ((b & 1 << bd - 1) == 0) {
                        m3 = (1 << bd) - 1;
                        this.entries[i][j] = m3 & b;
                        continue;
                    }
                    m3 = -1 << bd;
                    this.entries[i][j] = m3 | b;
                    continue;
                }
                m3 = (1 << bd) - 1;
                this.entries[i][j] = m3 & b;
            }
        }
    }

    public int getNumEntries() {
        return this.nentries;
    }

    public int getNumColumns() {
        return this.ncolumns;
    }

    public boolean isSigned(int column) {
        return (this.bitdepth[column] & 0x80) == 1;
    }

    public boolean isUnSigned(int column) {
        return !this.isSigned(column);
    }

    public short getBitDepth(int column) {
        return (short)((this.bitdepth[column] & 0x7F) + 1);
    }

    public int getEntry(int column, int entry) {
        return this.entries[entry][column];
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("[PaletteBox ").append("nentries= ").append(String.valueOf(this.nentries)).append(", ncolumns= ").append(String.valueOf(this.ncolumns)).append(", bitdepth per column= (");
        for (int i = 0; i < this.ncolumns; ++i) {
            rep.append(this.getBitDepth(i)).append(this.isSigned(i) ? "S" : "U").append(i < this.ncolumns - 1 ? ", " : "");
        }
        return rep.append(")]").toString();
    }

    private int getEntrySize(int column) {
        short bd = this.getBitDepth(column);
        return bd / 8 + bd % 8 == 0 ? 0 : 1;
    }

    static {
        type = 1885564018;
    }
}

