/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.gdal;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.parser.gdal.GDALParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class TestGDALParser
extends TikaTest {
    private boolean canRun() {
        String[] checkCmd = new String[]{"gdalinfo"};
        return ExternalParser.check((String[])checkCmd, (int[])new int[0]);
    }

    @Test
    public void testParseBasicInfo() {
        Assumptions.assumeTrue((boolean)this.canRun());
        String expectedDriver = "netCDF/Network Common Data Format";
        String expectedUpperRight = "512.0,    0.0";
        String expectedUpperLeft = "0.0,    0.0";
        String expectedLowerLeft = "0.0,  512.0";
        String expectedLowerRight = "512.0,  512.0";
        String expectedCoordinateSystem = "`'";
        String expectedSize = "512, 512";
        GDALParser parser = new GDALParser();
        InputStream stream = TestGDALParser.class.getResourceAsStream("/test-documents/sresa1b_ncar_ccsm3_0_run1_200001.nc");
        Metadata met = new Metadata();
        BodyContentHandler handler = new BodyContentHandler();
        try {
            parser.parse(stream, (ContentHandler)handler, met, new ParseContext());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
        Assertions.assertNotNull((Object)met);
        Assertions.assertNotNull((Object)met.get("Driver"));
        Assertions.assertEquals((Object)"netCDF/Network Common Data Format", (Object)met.get("Driver"));
        Assumptions.assumeTrue((met.get("Files") != null ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)met.get("Size"));
        Assertions.assertEquals((Object)"512, 512", (Object)met.get("Size"));
        Assertions.assertNotNull((Object)met.get("Upper Right"));
        Assertions.assertEquals((Object)"512.0,    0.0", (Object)met.get("Upper Right"));
        Assertions.assertNotNull((Object)met.get("Upper Left"));
        Assertions.assertEquals((Object)"0.0,    0.0", (Object)met.get("Upper Left"));
        Assertions.assertNotNull((Object)met.get("Upper Right"));
        Assertions.assertEquals((Object)"512.0,  512.0", (Object)met.get("Lower Right"));
        Assertions.assertNotNull((Object)met.get("Upper Right"));
        Assertions.assertEquals((Object)"0.0,  512.0", (Object)met.get("Lower Left"));
    }

    @Test
    public void testParseMetadata() {
        Assumptions.assumeTrue((boolean)this.canRun());
        String expectedNcInst = "NCAR (National Center for Atmospheric Research, Boulder, CO, USA)";
        String expectedModelNameEnglish = "NCAR CCSM";
        String expectedProgramId = "Source file unknown Version unknown Date unknown";
        String expectedProjectId = "IPCC Fourth Assessment";
        String expectedRealization = "1";
        String expectedTitle = "model output prepared for IPCC AR4";
        String expectedSub8Name = "\":ua";
        String expectedSub8Desc = "[1x17x128x256] eastward_wind (32-bit floating-point)";
        GDALParser parser = new GDALParser();
        InputStream stream = TestGDALParser.class.getResourceAsStream("/test-documents/sresa1b_ncar_ccsm3_0_run1_200001.nc");
        Metadata met = new Metadata();
        BodyContentHandler handler = new BodyContentHandler();
        try {
            parser.parse(stream, (ContentHandler)handler, met, new ParseContext());
            Assertions.assertNotNull((Object)met);
            Assertions.assertNotNull((Object)met.get("NC_GLOBAL#institution"));
            Assertions.assertEquals((Object)"NCAR (National Center for Atmospheric Research, Boulder, CO, USA)", (Object)met.get("NC_GLOBAL#institution"));
            Assertions.assertNotNull((Object)met.get("NC_GLOBAL#model_name_english"));
            Assertions.assertEquals((Object)"NCAR CCSM", (Object)met.get("NC_GLOBAL#model_name_english"));
            Assertions.assertNotNull((Object)met.get("NC_GLOBAL#prg_ID"));
            Assertions.assertEquals((Object)"Source file unknown Version unknown Date unknown", (Object)met.get("NC_GLOBAL#prg_ID"));
            Assertions.assertNotNull((Object)met.get("NC_GLOBAL#prg_ID"));
            Assertions.assertEquals((Object)"Source file unknown Version unknown Date unknown", (Object)met.get("NC_GLOBAL#prg_ID"));
            Assertions.assertNotNull((Object)met.get("NC_GLOBAL#project_id"));
            Assertions.assertEquals((Object)"IPCC Fourth Assessment", (Object)met.get("NC_GLOBAL#project_id"));
            Assertions.assertNotNull((Object)met.get("NC_GLOBAL#realization"));
            Assertions.assertEquals((Object)"1", (Object)met.get("NC_GLOBAL#realization"));
            Assertions.assertNotNull((Object)met.get("NC_GLOBAL#title"));
            Assertions.assertEquals((Object)"model output prepared for IPCC AR4", (Object)met.get("NC_GLOBAL#title"));
            Assertions.assertNotNull((Object)met.get("SUBDATASET_8_NAME"));
            Assertions.assertTrue((boolean)met.get("SUBDATASET_8_NAME").endsWith("\":ua"));
            Assertions.assertNotNull((Object)met.get("SUBDATASET_8_DESC"));
            Assertions.assertEquals((Object)"[1x17x128x256] eastward_wind (32-bit floating-point)", (Object)met.get("SUBDATASET_8_DESC"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseFITS() {
        String fitsFilename = "/test-documents/WFPC2u5780205r_c0fx.fits";
        Assumptions.assumeTrue((boolean)this.canRun());
        String[] fitsCommand = new String[]{"gdalinfo", this.getResourceAsUrl(fitsFilename).getPath()};
        Assumptions.assumeTrue((boolean)ExternalParser.check((String[])fitsCommand, (int[])new int[]{1}));
        String expectedAllgMin = "-7.319537E1";
        String expectedAtodcorr = "COMPLETE";
        String expectedAtodfile = "uref$dbu1405iu.r1h";
        String expectedCalVersion = "                        ";
        String expectedCalibDef = "1466";
        GDALParser parser = new GDALParser();
        InputStream stream = TestGDALParser.class.getResourceAsStream(fitsFilename);
        Metadata met = new Metadata();
        BodyContentHandler handler = new BodyContentHandler();
        try {
            parser.parse(stream, (ContentHandler)handler, met, new ParseContext());
            Assertions.assertNotNull((Object)met);
            Assertions.assertNotNull((Object)met.get("ALLG-MIN"));
            Assertions.assertEquals((Object)expectedAllgMin, (Object)met.get("ALLG-MIN"));
            Assertions.assertNotNull((Object)met.get("ATODCORR"));
            Assertions.assertEquals((Object)expectedAtodcorr, (Object)met.get("ATODCORR"));
            Assertions.assertNotNull((Object)met.get("ATODFILE"));
            Assertions.assertEquals((Object)expectedAtodfile, (Object)met.get("ATODFILE"));
            Assertions.assertNotNull((Object)met.get("CAL_VER"));
            Assertions.assertEquals((Object)expectedCalVersion, (Object)met.get("CAL_VER"));
            Assertions.assertNotNull((Object)met.get("CALIBDEF"));
            Assertions.assertEquals((Object)expectedCalibDef, (Object)met.get("CALIBDEF"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }
}

