/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.isatab;

import java.io.InputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.isatab.ISArchiveParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class ISArchiveParserTest {
    @Test
    public void testParseArchive() throws Exception {
        String path = "/test-documents/testISATab_BII-I-1/s_BII-S-1.txt";
        ISArchiveParser parser = new ISArchiveParser(ISArchiveParserTest.class.getResource("/test-documents/testISATab_BII-I-1/").toURI().getPath());
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        try (InputStream stream = ISArchiveParserTest.class.getResourceAsStream(path);){
            parser.parse(stream, (ContentHandler)handler, metadata, context);
        }
        Assertions.assertEquals((Object)"BII-I-1", (Object)metadata.get("Investigation Identifier"), (String)"Invalid Investigation Identifier");
        Assertions.assertEquals((Object)"Growth control of the eukaryote cell: a systems biology study in yeast", (Object)metadata.get("Investigation Title"), (String)"Invalid Investigation Title");
        Assertions.assertEquals((Object)"17439666", (Object)metadata.get("Investigation PubMed ID"), (String)"Invalid Investigation PubMed ID");
        Assertions.assertEquals((Object)"doi:10.1186/jbiol54", (Object)metadata.get("Investigation Publication DOI"), (String)"Invalid Investigation Publication DOI");
        Assertions.assertEquals((Object)"Oliver", (Object)metadata.get("Investigation Person Last Name"), (String)"Invalid Investigation Person Last Name");
        Assertions.assertEquals((Object)"Stephen", (Object)metadata.get("Investigation Person First Name"), (String)"Invalid Investigation Person First Name");
    }
}

