/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.hdf;

import java.io.InputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.hdf.HDFParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class HDFParserTest {
    @Test
    public void testParseGlobalMetadata() throws Exception {
        if (System.getProperty("java.version").startsWith("1.5")) {
            return;
        }
        HDFParser parser = new HDFParser();
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = HDFParser.class.getResourceAsStream("/test-documents/test.he5");){
            parser.parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        Assertions.assertNotNull((Object)metadata);
        Assertions.assertEquals((Object)"5", (Object)metadata.get("GranuleMonth"));
    }

    @Test
    public void testHDF4() throws Exception {
        if (System.getProperty("java.version").startsWith("1.5")) {
            return;
        }
        HDFParser parser = new HDFParser();
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = HDFParser.class.getResourceAsStream("/test-documents/test.hdf");){
            parser.parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        Assertions.assertNotNull((Object)metadata);
        Assertions.assertEquals((Object)"Direct read of HDF4 file through CDM library", (Object)metadata.get("_History"));
        Assertions.assertEquals((Object)"Ascending", (Object)metadata.get("Pass"));
        Assertions.assertEquals((Object)"Hierarchical Data Format, version 4", (Object)metadata.get("File-Type-Description"));
    }
}

