/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.netcdf;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.netcdf.NetCDFParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class NetCDFParserTest {
    @Test
    public void testParseGlobalMetadata() throws Exception {
        NetCDFParser parser = new NetCDFParser();
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = NetCDFParser.class.getResourceAsStream("/test-documents/sresa1b_ncar_ccsm3_0_run1_200001.nc");){
            parser.parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)metadata.get(TikaCoreProperties.TITLE), (Object)"model output prepared for IPCC AR4");
        Assertions.assertEquals((Object)metadata.get("contact"), (Object)"ccsm@ucar.edu");
        Assertions.assertEquals((Object)metadata.get("project_id"), (Object)"IPCC Fourth Assessment");
        Assertions.assertEquals((Object)metadata.get("Conventions"), (Object)"CF-1.0");
        Assertions.assertEquals((Object)metadata.get("realization"), (Object)"1");
        Assertions.assertEquals((Object)metadata.get("experiment_id"), (Object)"720 ppm stabilization experiment (SRESA1B)");
        Assertions.assertEquals((Object)metadata.get("File-Type-Description"), (Object)"NetCDF-3/CDM");
        String content = handler.toString();
        TikaTest.assertContains((String)"long_name = \"Surface area\"", (String)content);
        TikaTest.assertContains((String)"float area(lat=128, lon=256)", (String)content);
        TikaTest.assertContains((String)"float lat(lat=128)", (String)content);
        TikaTest.assertContains((String)"double lat_bnds(lat=128, bnds=2)", (String)content);
        TikaTest.assertContains((String)"double lon_bnds(lon=256, bnds=2)", (String)content);
    }
}

