/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.geoinfo;

import org.apache.tika.TikaTest;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.geoinfo.GeographicInformationParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GeographicInformationParserTest
extends TikaTest {
    @Test
    public void testISO19139() throws Exception {
        TikaTest.XMLResult r = this.getXML("sampleFile.iso19139", (Parser)new GeographicInformationParser());
        Assertions.assertEquals((Object)"text/iso19139+xml", (Object)r.metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"UTF-8", (Object)r.metadata.get("CharacterSet"));
        Assertions.assertEquals((Object)"https", (Object)r.metadata.get("TransferOptionsOnlineProtocol "));
        Assertions.assertEquals((Object)"browser", (Object)r.metadata.get("TransferOptionsOnlineProfile "));
        Assertions.assertEquals((Object)"Barrow Atqasuk ARCSS Plant", (Object)r.metadata.get("TransferOptionsOnlineName "));
        GeographicInformationParserTest.assertContains((String)"Barrow Atqasuk ARCSS Plant", (String)r.xml);
        GeographicInformationParserTest.assertContains((String)"<td>GeographicElementWestBoundLatitude</td>\t<td>-157.24</td>", (String)r.xml);
        GeographicInformationParserTest.assertContains((String)"<td>GeographicElementEastBoundLatitude</td>\t<td>-156.4</td>", (String)r.xml);
        GeographicInformationParserTest.assertContains((String)"<td>GeographicElementNorthBoundLatitude</td>\t<td>71.18</td>", (String)r.xml);
        GeographicInformationParserTest.assertContains((String)"<td>GeographicElementSouthBoundLatitude</td>\t<td>70.27</td>", (String)r.xml);
    }
}

