/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.tika.TikaTest;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PDF;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMP;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDMetadataExtractor;
import org.apache.tika.utils.XMLReaderUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CustomTikaXMPTest
extends TikaTest {
    @Test
    public void testPDFA() throws Exception {
        Metadata metadata = this.extract("testPDFA.xmp");
        Assertions.assertEquals((Object)"A-1b", (Object)metadata.get(PDF.PDFA_VERSION));
        Assertions.assertEquals((int)1, (Integer)metadata.getInt(PDF.PDFAID_PART));
        Assertions.assertEquals((Object)"B", (Object)metadata.get(PDF.PDFAID_CONFORMANCE));
    }

    @Test
    public void testPDFX() throws Exception {
        Metadata metadata = this.extract("testPDFX.xmp");
        Assertions.assertEquals((Object)"PDF/X-1:2001", (Object)metadata.get(PDF.PDFXID_VERSION));
        Assertions.assertEquals((Object)"PDF/X-1:2001", (Object)metadata.get(PDF.PDFX_VERSION));
        Assertions.assertEquals((Object)"PDF/X-1a:2001", (Object)metadata.get(PDF.PDFX_CONFORMANCE));
    }

    @Test
    public void testPDFUA() throws Exception {
        Metadata metadata = this.extract("testPDFUA.xmp");
        Assertions.assertEquals((int)1, (Integer)metadata.getInt(PDF.PDFUAID_PART));
        String[] subjects = metadata.getValues(TikaCoreProperties.SUBJECT);
        Assertions.assertEquals((Object)"keywords", (Object)subjects[0]);
        Assertions.assertEquals((Object)"subject", (Object)subjects[1]);
        Assertions.assertEquals((Object)"1234567890", (Object)metadata.get(XMP.IDENTIFIER));
        Assertions.assertEquals((Object)"Advisory", (Object)metadata.get(XMP.ADVISORY));
    }

    @Test
    public void testPDFVT() throws Exception {
        Metadata metadata = this.extract("testPDFVT.xmp");
        Assertions.assertEquals((Object)"PDF/VT-1", (Object)metadata.get(PDF.PDFVT_VERSION));
        Assertions.assertEquals((Object)"2018-08-06T11:53:12Z", (Object)metadata.getDate(PDF.PDFVT_MODIFIED).toInstant().toString());
    }

    @Test
    public void testDublinCore() throws Exception {
        Metadata metadata = this.extract("TIKA-4442.xmp");
        Assertions.assertEquals((Object)"research papers", (Object)metadata.get(TikaCoreProperties.TYPE));
        Assertions.assertEquals((Object)"doi:1234/S56789", (Object)metadata.get(TikaCoreProperties.IDENTIFIER));
        Assertions.assertEquals((Object)"en", (Object)metadata.get(TikaCoreProperties.LANGUAGE));
        Assertions.assertEquals((Object)"International Union of Thinkology", (Object)metadata.get(TikaCoreProperties.PUBLISHER));
        Assertions.assertEquals((Object)"Relation", (Object)metadata.get(TikaCoreProperties.RELATION));
        Assertions.assertEquals((Object)"Journal of Thinkology", (Object)metadata.get(TikaCoreProperties.SOURCE));
        Assertions.assertEquals((Object)"Copyright (c) 1939 International Union of Thinkology", (Object)metadata.get(TikaCoreProperties.RIGHTS));
        Assertions.assertEquals((Object)"Thinking: is it needed?", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
        String[] subjects = metadata.getValues(TikaCoreProperties.SUBJECT);
        Assertions.assertEquals((int)5, (int)subjects.length);
        Assertions.assertEquals((Object)"THOUGHTS", (Object)subjects[0]);
        Assertions.assertEquals((Object)"HAPPINESS", (Object)subjects[1]);
        Assertions.assertEquals((Object)"FEAR", (Object)subjects[2]);
        Assertions.assertEquals((Object)"ANGER", (Object)subjects[3]);
        Assertions.assertEquals((Object)"DESPAIR", (Object)subjects[4]);
        String[] creators = metadata.getValues(TikaCoreProperties.CREATOR);
        Assertions.assertEquals((int)5, (int)creators.length);
        Assertions.assertEquals((Object)"Dorothy", (Object)creators[0]);
        Assertions.assertEquals((Object)"Toto", (Object)creators[1]);
        Assertions.assertEquals((Object)"Scarecrow", (Object)creators[2]);
        Assertions.assertEquals((Object)"Tin Man", (Object)creators[3]);
        Assertions.assertEquals((Object)"Cowardly Lion", (Object)creators[4]);
    }

    private Metadata extract(String xmpFileName) throws IOException, TikaException, SAXException {
        try (InputStream is = this.getResourceAsStream("/test-documents/xmp/" + xmpFileName);){
            Document doc = XMLReaderUtils.buildDOM((InputStream)is);
            XMPMetadata xmp = new XMPMetadata(doc);
            ParseContext context = new ParseContext();
            Metadata metadata = new Metadata();
            PDMetadataExtractor.extract((XMPMetadata)xmp, (Metadata)metadata, (ParseContext)context);
            Metadata metadata2 = metadata;
            return metadata2;
        }
    }
}

