/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.tika.Tika;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.AccessPermissionException;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.ZeroByteFileException;
import org.apache.tika.extractor.DocumentSelector;
import org.apache.tika.metadata.Font;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PDF;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.TikaPagedText;
import org.apache.tika.metadata.XMP;
import org.apache.tika.metadata.XMPMM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.pdf.AccessChecker;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.tika.utils.ExceptionUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class PDFParserTest
extends TikaTest {
    public static Level PDFBOX_LOG_LEVEL = Level.INFO;

    @BeforeAll
    public static void setup() {
        PDFBOX_LOG_LEVEL = Logger.getLogger("org.apache.pdfbox").getLevel();
        Logger.getLogger("org.apache.pdfbox").setLevel(Level.OFF);
    }

    @AfterAll
    public static void tearDown() {
        Logger.getLogger("org.apache.pdfbox").setLevel(PDFBOX_LOG_LEVEL);
    }

    private static int substringCount(String needle, String haystack) {
        int next;
        int upto = -1;
        int count = 0;
        while ((next = haystack.indexOf(needle, upto)) != -1) {
            ++count;
            upto = next + 1;
        }
        return count;
    }

    @Test
    public void testPdfParsing() throws Exception {
        TikaTest.XMLResult r = this.getXML("testPDF.pdf");
        Metadata metadata = r.metadata;
        String xml = r.xml;
        Assertions.assertEquals((Object)"application/pdf", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Bertrand Delacr\u00e9taz", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"Firefox", (Object)metadata.get(TikaCoreProperties.CREATOR_TOOL));
        Assertions.assertEquals((Object)"Apache Tika - Apache Tika", (Object)metadata.get(TikaCoreProperties.TITLE));
        PDFParserTest.assertContains((String)"Apache Tika", (String)xml);
        PDFParserTest.assertContains((String)"Tika - Content Analysis Toolkit", (String)xml);
        PDFParserTest.assertContains((String)"incubator", (String)xml);
        PDFParserTest.assertContains((String)"Apache Software Foundation", (String)xml);
        Assertions.assertTrue((!xml.contains("ToolkitApache") ? 1 : 0) != 0, (String)"should have word boundary after headline");
        Assertions.assertTrue((!xml.contains("libraries.Apache") ? 1 : 0) != 0, (String)"should have word boundary between paragraphs");
    }

    @Test
    public void testFontNameExtraction() throws Exception {
        PDFParserConfig config = new PDFParserConfig();
        config.setExtractFontNames(true);
        ParseContext pc = new ParseContext();
        pc.set(PDFParserConfig.class, (Object)config);
        TikaTest.XMLResult r = this.getXML("testPDFVarious.pdf", pc);
        PDFParserTest.assertContains((String)"ABCDEE+Calibri", (String)r.metadata.get(Font.FONT_NAME));
    }

    @Test
    public void testPdfParsingMetadataOnly() throws Exception {
        Metadata metadata = this.getXML((String)"testPDF.pdf").metadata;
        Assertions.assertEquals((Object)"application/pdf", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Bertrand Delacr\u00e9taz", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"Firefox", (Object)metadata.get(TikaCoreProperties.CREATOR_TOOL));
        Assertions.assertEquals((Object)"Apache Tika - Apache Tika", (Object)metadata.get(TikaCoreProperties.TITLE));
    }

    @Test
    public void testCustomMetadata() throws Exception {
        TikaTest.XMLResult r = this.getXML("testPDF-custommetadata.pdf");
        Metadata metadata = r.metadata;
        Assertions.assertEquals((Object)"application/pdf", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Document author", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"Document title", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Custom Value", (Object)metadata.get("Custom Property"));
        Assertions.assertEquals((Object)"Array Entry 1", (Object)metadata.get("Custom Array"));
        Assertions.assertEquals((int)2, (int)metadata.getValues("Custom Array").length);
        Assertions.assertEquals((Object)"Array Entry 1", (Object)metadata.getValues("Custom Array")[0]);
        Assertions.assertEquals((Object)"Array Entry 2", (Object)metadata.getValues("Custom Array")[1]);
        PDFParserTest.assertContains((String)"Hello World!", (String)r.xml);
    }

    @Test
    public void testProtectedPDF() throws Exception {
        TikaTest.XMLResult r = this.getXML("testPDF_protected.pdf");
        Metadata metadata = r.metadata;
        Assertions.assertEquals((Object)"true", (Object)metadata.get("pdf:encrypted"));
        Assertions.assertEquals((Object)"application/pdf", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"The Bank of England", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"Speeches by Andrew G Haldane", (Object)metadata.get(TikaCoreProperties.SUBJECT));
        Assertions.assertEquals((Object)"Rethinking the Financial Network, Speech by Andrew G Haldane, Executive Director, Financial Stability delivered at the Financial Student Association, Amsterdam on 28 April 2009", (Object)metadata.get(TikaCoreProperties.TITLE));
        PDFParserTest.assertContains((String)"RETHINKING THE FINANCIAL NETWORK", (String)r.xml);
        PDFParserTest.assertContains((String)"On 16 November 2002", (String)r.xml);
        PDFParserTest.assertContains((String)"In many important respects", (String)r.xml);
        ParseContext context = new ParseContext();
        context.set(PasswordProvider.class, (Object)new PasswordProvider(){

            public String getPassword(Metadata metadata) {
                return "";
            }
        });
        r = this.getXML("testPDF_protected.pdf", context);
        metadata = r.metadata;
        Assertions.assertEquals((Object)"true", (Object)metadata.get("pdf:encrypted"));
        Assertions.assertEquals((Object)"application/pdf", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"The Bank of England", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"Speeches by Andrew G Haldane", (Object)metadata.get(TikaCoreProperties.SUBJECT));
        Assertions.assertEquals((Object)"Rethinking the Financial Network, Speech by Andrew G Haldane, Executive Director, Financial Stability delivered at the Financial Student Association, Amsterdam on 28 April 2009", (Object)metadata.get(TikaCoreProperties.TITLE));
        PDFParserTest.assertContains((String)"RETHINKING THE FINANCIAL NETWORK", (String)r.xml);
        PDFParserTest.assertContains((String)"On 16 November 2002", (String)r.xml);
        PDFParserTest.assertContains((String)"In many important respects", (String)r.xml);
        context.set(PasswordProvider.class, (Object)new PasswordProvider(){

            public String getPassword(Metadata metadata) {
                return "WRONG!!!!";
            }
        });
        boolean ex = false;
        BodyContentHandler handler = new BodyContentHandler();
        metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testPDF_protected.pdf");){
            AUTO_DETECT_PARSER.parse(stream, (ContentHandler)handler, metadata, context);
        }
        catch (EncryptedDocumentException e) {
            ex = true;
        }
        Assertions.assertTrue((boolean)ex, (String)"encryption exception");
        Assertions.assertEquals((Object)"application/pdf", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"true", (Object)metadata.get("pdf:encrypted"));
        Assertions.assertEquals((int)4, (int)metadata.names().length, (String)"very little metadata should be parsed");
        Assertions.assertEquals((int)0, (int)handler.toString().length());
    }

    @Test
    public void testTwoTextBoxes() throws Exception {
        String content;
        try (InputStream stream = this.getResourceAsStream("/test-documents/testPDFTwoTextBoxes.pdf");){
            content = this.getText(stream, AUTO_DETECT_PARSER);
        }
        content = content.replaceAll("\\s+", " ");
        PDFParserTest.assertContains((String)"Left column line 1 Left column line 2 Right column line 1 Right column line 2", (String)content);
    }

    @Test
    public void testVarious() throws Exception {
        int row;
        String content;
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testPDFVarious.pdf");){
            content = this.getText(stream, AUTO_DETECT_PARSER, metadata);
        }
        PDFParserTest.assertContains((String)"Footnote appears here", (String)content);
        PDFParserTest.assertContains((String)"This is a footnote.", (String)content);
        PDFParserTest.assertContains((String)"This is the header text.", (String)content);
        PDFParserTest.assertContains((String)"This is the footer text.", (String)content);
        PDFParserTest.assertContains((String)"Here is a text box", (String)content);
        PDFParserTest.assertContains((String)"Bold", (String)content);
        PDFParserTest.assertContains((String)"italic", (String)content);
        PDFParserTest.assertContains((String)"underline", (String)content);
        PDFParserTest.assertContains((String)"superscript", (String)content);
        PDFParserTest.assertContains((String)"subscript", (String)content);
        PDFParserTest.assertContains((String)"Here is a citation:", (String)content);
        PDFParserTest.assertContains((String)"Figure 1 This is a caption for Figure 1", (String)content);
        PDFParserTest.assertContains((String)"(Kramer)", (String)content);
        PDFParserTest.assertContains((String)"Row 1 Col 1 Row 1 Col 2 Row 1 Col 3 Row 2 Col 1 Row 2 Col 2 Row 2 Col 3", (String)content.replaceAll("\\s+", " "));
        PDFParserTest.assertContains((String)"Row 1 column 1 Row 2 column 1 Row 1 column 2 Row 2 column 2", (String)content.replaceAll("\\s+", " "));
        PDFParserTest.assertContains((String)"This is a hyperlink", (String)content);
        PDFParserTest.assertContains((String)"Here is a list:", (String)content);
        for (row = 1; row <= 3; ++row) {
            PDFParserTest.assertContains((String)("Bullet " + row), (String)content);
        }
        PDFParserTest.assertContains((String)"Here is a numbered list:", (String)content);
        for (row = 1; row <= 3; ++row) {
            PDFParserTest.assertContains((String)(row + ") Number bullet " + row), (String)content);
        }
        for (row = 1; row <= 2; ++row) {
            for (int col = 1; col <= 3; ++col) {
                PDFParserTest.assertContains((String)("Row " + row + " Col " + col), (String)content);
            }
        }
        PDFParserTest.assertContains((String)"Keyword1 Keyword2", (String)content);
        PDFParserTest.assertContains((String)"Keyword1 Keyword2", (String)metadata.get(TikaCoreProperties.SUBJECT));
        PDFParserTest.assertContains((String)"Subject is here", (String)content);
        PDFParserTest.assertContains((Object)"Subject is here", Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT)));
        PDFParserTest.assertContains((String)"Suddenly some Japanese text:", (String)content);
        PDFParserTest.assertContains((String)"\uff08\uff27\uff28\uff31\uff09", (String)content);
        PDFParserTest.assertContains((String)"\u30be\u30eb\u30b2\u3068\u5c3e\u5d0e\u3001\u6de1\u3005\u3068\u6700\u671f", (String)content);
        PDFParserTest.assertContains((String)"And then some Gothic text:", (String)content);
    }

    @Test
    public void testAnnotations() throws Exception {
        String content;
        try (InputStream stream = this.getResourceAsStream("/test-documents/testAnnotations.pdf");){
            content = this.getText(stream, AUTO_DETECT_PARSER);
        }
        content = content.replaceAll("[\\s\u00a0]+", " ");
        PDFParserTest.assertContains((String)"Here is some text", (String)content);
        PDFParserTest.assertContains((String)"Here is a comment", (String)content);
        PDFParser pdfParser = new PDFParser();
        pdfParser.getPDFParserConfig().setExtractAnnotationText(false);
        try (InputStream stream = this.getResourceAsStream("/test-documents/testAnnotations.pdf");){
            content = this.getText(stream, (Parser)pdfParser);
        }
        content = content.replaceAll("[\\s\u00a0]+", " ");
        PDFParserTest.assertContains((String)"Here is some text", (String)content);
        Assertions.assertEquals((int)-1, (int)content.indexOf("Here is a comment"));
        ParseContext context = new ParseContext();
        PDFParserConfig config = new PDFParserConfig();
        config.setExtractAnnotationText(false);
        context.set(PDFParserConfig.class, (Object)config);
        try (InputStream stream = this.getResourceAsStream("/test-documents/testAnnotations.pdf");){
            content = this.getText(stream, AUTO_DETECT_PARSER, context);
        }
        content = content.replaceAll("[\\s\u00a0]+", " ");
        PDFParserTest.assertContains((String)"Here is some text", (String)content);
        Assertions.assertEquals((int)-1, (int)content.indexOf("Here is a comment"));
        String xml = this.getXML((String)"testAnnotations.pdf").xml;
        Assertions.assertEquals((int)PDFParserTest.substringCount("<p>", xml), (int)PDFParserTest.substringCount("</p>", xml));
    }

    @Test
    public void testPopupAnnotation() throws Exception {
        TikaTest.XMLResult r = this.getXML("testPopupAnnotation.pdf");
        PDFParserTest.assertContains((String)"this is the note", (String)r.xml);
        PDFParserTest.assertContains((String)"igalsh", (String)r.xml);
    }

    @Test
    public void testEmbeddedPDFs() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPDFPackage.pdf");
        Assertions.assertEquals((int)3, (int)metadataList.size());
        Assertions.assertEquals((Object)"true", (Object)((Metadata)metadataList.get(0)).get(PDF.HAS_COLLECTION));
        PDFParserTest.assertContains((String)"Adobe recommends using Adobe Reader ", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
        PDFParserTest.assertContains((String)"<p>PDF1", (String)((Metadata)metadataList.get(1)).get(TikaCoreProperties.TIKA_CONTENT));
        PDFParserTest.assertContains((String)"<p>PDF2", (String)((Metadata)metadataList.get(2)).get(TikaCoreProperties.TIKA_CONTENT));
    }

    @Test
    public void testPageNumber() throws Exception {
        TikaTest.XMLResult result = this.getXML("testPageNumber.pdf");
        String content = result.xml.replaceAll("\\s+", "");
        PDFParserTest.assertContains((String)"<p>1</p>", (String)content);
    }

    @Test
    public void testLinks() throws Exception {
        TikaTest.XMLResult result = this.getXML("testPDFVarious.pdf");
        PDFParserTest.assertContains((String)"<div class=\"annotation\"><a href=\"http://tika.apache.org/\">http://tika.apache.org/</a></div>", (String)result.xml);
    }

    @Test
    public void testDisableAutoSpace() throws Exception {
        PDFParser parser = new PDFParser();
        parser.getPDFParserConfig().setEnableAutoSpace(false);
        TikaTest.XMLResult r = this.getXML("testExtraSpaces.pdf", (Parser)parser);
        String content = r.xml.replaceAll("[\\s\u00a0]+", " ");
        PDFParserTest.assertContains((String)"Here is some formatted text", (String)content);
        parser.getPDFParserConfig().setEnableAutoSpace(true);
        r = this.getXML("testExtraSpaces.pdf", (Parser)parser);
        content = r.xml.replaceAll("[\\s\u00a0]+", " ");
        Assertions.assertEquals((int)-1, (int)content.indexOf("Here is some formatted text"));
        ParseContext context = new ParseContext();
        PDFParserConfig config = new PDFParserConfig();
        context.set(PDFParserConfig.class, (Object)config);
        r = this.getXML("testExtraSpaces.pdf", context);
        content = r.xml.replaceAll("[\\s\u00a0]+", " ");
        Assertions.assertEquals((int)-1, (int)content.indexOf("Here is some formatted text"));
        config.setEnableAutoSpace(false);
        r = this.getXML("testExtraSpaces.pdf", (Parser)parser, context);
        content = r.xml.replaceAll("[\\s\u00a0]+", " ");
        PDFParserTest.assertContains((String)"Here is some formatted text", (String)content);
    }

    @Test
    public void testDuplicateOverlappingText() throws Exception {
        PDFParser parser = new PDFParser();
        TikaTest.XMLResult r = this.getXML("testOverlappingText.pdf", (Parser)parser);
        PDFParserTest.assertContains((String)"Text the first timeText the second time", (String)r.xml);
        parser.getPDFParserConfig().setSuppressDuplicateOverlappingText(true);
        r = this.getXML("testOverlappingText.pdf", (Parser)parser);
        PDFParserTest.assertContains((String)"Text the first timesecond time", (String)r.xml);
        ParseContext context = new ParseContext();
        PDFParserConfig config = new PDFParserConfig();
        context.set(PDFParserConfig.class, (Object)config);
        r = this.getXML("testOverlappingText.pdf", context);
        PDFParserTest.assertContains((String)"Text the first timeText the second time", (String)r.xml);
        config.setSuppressDuplicateOverlappingText(true);
        r = this.getXML("testOverlappingText.pdf", context);
        PDFParserTest.assertContains((String)"Text the first timesecond time", (String)r.xml);
    }

    @Test
    public void testSortByPosition() throws Exception {
        PDFParser parser = new PDFParser();
        parser.getPDFParserConfig().setEnableAutoSpace(false);
        InputStream stream = this.getResourceAsStream("/test-documents/testPDFTwoTextBoxes.pdf");
        String content = this.getText(stream, (Parser)parser);
        content = content.replaceAll("\\s+", " ");
        PDFParserTest.assertContains((String)"Left column line 1 Left column line 2 Right column line 1 Right column line 2", (String)content);
        parser.setSortByPosition(true);
        stream = this.getResourceAsStream("/test-documents/testPDFTwoTextBoxes.pdf");
        content = this.getText(stream, (Parser)parser);
        content = content.replaceAll("\\s+", " ");
        PDFParserTest.assertContains((String)"Left column line 1 Right column line 1 Left colu mn line 2 Right column line 2", (String)content);
        ParseContext context = new ParseContext();
        PDFParserConfig config = new PDFParserConfig();
        context.set(PDFParserConfig.class, (Object)config);
        content = this.getText("testPDFTwoTextBoxes.pdf", new Metadata(), context);
        content = content.replaceAll("\\s+", " ");
        PDFParserTest.assertContains((String)"Left column line 1 Left column line 2 Right column line 1 Right column line 2", (String)content);
        config.setSortByPosition(true);
        context.set(PDFParserConfig.class, (Object)config);
        stream = this.getResourceAsStream("/test-documents/testPDFTwoTextBoxes.pdf");
        content = this.getText("testPDFTwoTextBoxes.pdf", new Metadata(), context);
        content = content.replaceAll("\\s+", " ");
        PDFParserTest.assertContains((String)"Left column line 1 Right column line 1 Left colu mn line 2 Right column line 2", (String)content);
    }

    @Test
    public void testBookmarks() throws Exception {
        String xml = this.getXML((String)"testPDF_bookmarks.pdf").xml;
        int i = xml.indexOf("Denmark bookmark is here");
        int j = xml.indexOf("</body>");
        Assertions.assertTrue((i != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((j != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((i < j ? 1 : 0) != 0);
    }

    @Test
    public void testTurningOffBookmarks() throws Exception {
        PDFParserConfig config = new PDFParserConfig();
        config.setExtractBookmarksText(false);
        ParseContext parseContext = new ParseContext();
        parseContext.set(PDFParserConfig.class, (Object)config);
        String xml = this.getXML((String)"testPDF_bookmarks.pdf", (ParseContext)parseContext).xml;
        PDFParserTest.assertNotContained((String)"Denmark bookmark is here", (String)xml);
    }

    @Test
    public void testSignatureInAcroForm() throws Exception {
        TikaTest.XMLResult result = this.getXML("testPDF_acroform3.pdf");
        Metadata m = result.metadata;
        Assertions.assertEquals((Object)"true", (Object)m.get(PDF.HAS_XMP));
        Assertions.assertEquals((Object)"true", (Object)m.get(PDF.HAS_ACROFORM_FIELDS));
        Assertions.assertEquals((Object)"false", (Object)m.get(PDF.HAS_XFA));
        PDFParserTest.assertContains((String)"<li>aTextField: TIKA-1226</li>", (String)result.xml);
    }

    @Test
    public void testSingleCloseDoc() throws Exception {
        Metadata m = new Metadata();
        ParseContext c = new ParseContext();
        EventCountingHandler h = new EventCountingHandler();
        try (InputStream is = this.getResourceAsStream("/test-documents/testPDFTripleLangTitle.pdf");){
            AUTO_DETECT_PARSER.parse(is, (ContentHandler)((Object)h), m, c);
        }
        Assertions.assertEquals((int)1, (int)h.getEndDocument());
    }

    @Test
    public void testVersions() throws Exception {
        HashMap<String, String> dcFormat = new HashMap<String, String>();
        dcFormat.put("4.x", "application/pdf; version=1.3");
        dcFormat.put("5.x", "application/pdf; version=1.4");
        dcFormat.put("6.x", "application/pdf; version=1.5");
        dcFormat.put("7.x", "application/pdf; version=1.6");
        dcFormat.put("8.x", "application/pdf; version=1.7");
        dcFormat.put("9.x", "application/pdf; version=1.7");
        dcFormat.put("10.x", "application/pdf; version=1.7");
        dcFormat.put("11.x.PDFA-1b", "application/pdf; version=1.7");
        HashMap<String, String> pdfVersions = new HashMap<String, String>();
        pdfVersions.put("4.x", "1.3");
        pdfVersions.put("5.x", "1.4");
        pdfVersions.put("6.x", "1.5");
        pdfVersions.put("7.x", "1.6");
        pdfVersions.put("8.x", "1.7");
        pdfVersions.put("9.x", "1.7");
        pdfVersions.put("10.x", "1.7");
        pdfVersions.put("11.x.PDFA-1b", "1.7");
        HashMap<String, String> pdfExtensionVersions = new HashMap<String, String>();
        pdfExtensionVersions.put("9.x", "1.7 Adobe Extension Level 3");
        pdfExtensionVersions.put("10.x", "1.7 Adobe Extension Level 8");
        pdfExtensionVersions.put("11.x.PDFA-1b", "1.7 Adobe Extension Level 8");
        for (Map.Entry e : dcFormat.entrySet()) {
            String[] vals;
            String fName = "testPDF_Version." + (String)e.getKey() + ".pdf";
            TikaTest.XMLResult r = this.getXML(fName);
            boolean foundDC = false;
            for (String v : vals = r.metadata.getValues("dc:format")) {
                if (!v.equals(e.getValue())) continue;
                foundDC = true;
                break;
            }
            Assertions.assertTrue((boolean)foundDC, (String)("dc:format ::" + (String)e.getValue()));
            String extensionVersionTruth = (String)pdfExtensionVersions.get(e.getKey());
            if (extensionVersionTruth != null) {
                Assertions.assertEquals((Object)extensionVersionTruth, (Object)r.metadata.get("pdf:PDFExtensionVersion"), (String)("pdf:PDFExtensionVersion :: " + extensionVersionTruth));
            }
            Assertions.assertEquals(pdfVersions.get(e.getKey()), (Object)r.metadata.get("pdf:PDFVersion"), (String)"pdf:PDFVersion");
        }
        TikaTest.XMLResult r = this.getXML("testPDF_Version.11.x.PDFA-1b.pdf");
        HashSet<String> versions = new HashSet<String>(Arrays.asList(r.metadata.getValues("dc:format")));
        for (String hit : new String[]{"application/pdf; version=1.7", "application/pdf; version=\"1.7 Adobe Extension Level 8\""}) {
            Assertions.assertTrue((boolean)versions.contains(hit), (String)hit);
        }
        Assertions.assertEquals((Object)r.metadata.get("pdfaid:conformance"), (Object)"B", (String)"pdfaid:conformance");
        Assertions.assertEquals((Object)r.metadata.get("pdfaid:part"), (Object)"1", (String)"pdfaid:part");
    }

    @Test
    public void testMultipleAuthors() throws Exception {
        TikaTest.XMLResult r = this.getXML("testPDF_twoAuthors.pdf");
        List<String> authors = Arrays.asList(r.metadata.getValues(TikaCoreProperties.CREATOR));
        PDFParserTest.assertContains((Object)"Sample Author 1", authors);
        PDFParserTest.assertContains((Object)"Sample Author 2", authors);
    }

    @Test
    public void testMultipleTitles() throws Exception {
        TikaTest.XMLResult r = this.getXML("testPDFTripleLangTitle.pdf");
        Assertions.assertEquals((Object)"Hello World", (Object)r.metadata.get("dc:title"));
    }

    @Test
    public void testInlineSelector() throws Exception {
        String v;
        PDFParserConfig config = new PDFParserConfig();
        config.setExtractInlineImages(true);
        config.setExtractUniqueInlineImagesOnly(false);
        ParseContext context = new ParseContext();
        context.set(PDFParserConfig.class, (Object)config);
        List metadatas = this.getRecursiveMetadata("testPDF_childAttachments.pdf", context);
        int inline = 0;
        int attach = 0;
        for (Metadata m : metadatas) {
            v = m.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE);
            if (v == null) continue;
            if (v.equals(TikaCoreProperties.EmbeddedResourceType.INLINE.toString())) {
                ++inline;
                continue;
            }
            if (!v.equals(TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString())) continue;
            ++attach;
        }
        Assertions.assertEquals((int)2, (int)inline);
        Assertions.assertEquals((int)2, (int)attach);
        Assertions.assertEquals((int)1, (Integer)((Metadata)metadatas.get(1)).getInt(TikaPagedText.PAGE_NUMBER));
        Assertions.assertEquals((int)66, (Integer)((Metadata)metadatas.get(2)).getInt(TikaPagedText.PAGE_NUMBER));
        context.set(DocumentSelector.class, (Object)new AvoidInlineSelector());
        inline = 0;
        attach = 0;
        metadatas = this.getRecursiveMetadata("testPDF_childAttachments.pdf", context);
        for (Metadata m : metadatas) {
            v = m.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE);
            if (v == null) continue;
            if (v.equals(TikaCoreProperties.EmbeddedResourceType.INLINE.toString())) {
                ++inline;
                continue;
            }
            if (!v.equals(TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString())) continue;
            ++attach;
        }
        Assertions.assertEquals((int)0, (int)inline);
        Assertions.assertEquals((int)2, (int)attach);
    }

    @Test
    public void testInlineConfig() throws Exception {
        List metadatas = this.getRecursiveMetadata("testPDF_childAttachments.pdf");
        int inline = 0;
        int attach = 0;
        for (Metadata m : metadatas) {
            String v = m.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE);
            if (v == null) continue;
            if (v.equals(TikaCoreProperties.EmbeddedResourceType.INLINE.toString())) {
                ++inline;
                continue;
            }
            if (!v.equals(TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString())) continue;
            ++attach;
        }
        Assertions.assertEquals((int)0, (int)inline);
        Assertions.assertEquals((int)2, (int)attach);
        PDFParserConfig config = new PDFParserConfig();
        config.setExtractInlineImages(true);
        config.setExtractUniqueInlineImagesOnly(false);
        ParseContext context = new ParseContext();
        context.set(PDFParserConfig.class, (Object)config);
        inline = 0;
        attach = 0;
        metadatas = this.getRecursiveMetadata("testPDF_childAttachments.pdf", context);
        for (Metadata m : metadatas) {
            String v = m.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE);
            if (v == null) continue;
            if (v.equals(TikaCoreProperties.EmbeddedResourceType.INLINE.toString())) {
                ++inline;
                continue;
            }
            if (!v.equals(TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString())) continue;
            ++attach;
        }
        Assertions.assertEquals((int)2, (int)inline);
        Assertions.assertEquals((int)2, (int)attach);
    }

    @Test
    public void testEmbeddedFileNameExtraction() throws Exception {
        List metadatas = this.getRecursiveMetadata("testPDF_multiFormatEmbFiles.pdf");
        Assertions.assertEquals((int)5, (int)metadatas.size());
        Metadata firstAttachment = (Metadata)metadatas.get(1);
        Assertions.assertEquals((Object)"Test.txt", (Object)firstAttachment.get("resourceName"), (String)"attachment file name");
    }

    @Test
    public void testEmbeddedFileMarkup() throws Exception {
        ParseContext context = new ParseContext();
        context.set(Parser.class, (Object)AUTO_DETECT_PARSER);
        PDFParserConfig config = new PDFParserConfig();
        config.setExtractInlineImages(true);
        config.setExtractUniqueInlineImagesOnly(false);
        context.set(PDFParserConfig.class, (Object)config);
        TikaTest.XMLResult r = this.getXML("testPDF_childAttachments.pdf", context);
        PDFParserTest.assertContains((String)"<div source=\"attachment\" class=\"embedded\" id=\"Unit10.doc\" />", (String)r.xml);
        PDFParserTest.assertContains((String)"<img src=\"embedded:image1.tif\" alt=\"image1.tif\" />", (String)r.xml);
        r = this.getXML("testPDFFileEmbInAnnotation.pdf");
        PDFParserTest.assertContains((String)"<div source=\"annotationFileAttachment\" class=\"embedded\" id=\"Excel.xlsx\" />", (String)r.xml);
    }

    @Test
    public void testLegacyAccessChecking() throws Exception {
        for (String file : new String[]{"testPDF_no_extract_no_accessibility_owner_empty.pdf", "testPDF_no_extract_yes_accessibility_owner_empty.pdf"}) {
            String xml = this.getXML((String)file).xml;
            PDFParserTest.assertContains((String)"Hello World", (String)xml);
        }
        PasswordProvider provider = new PasswordProvider(){

            public String getPassword(Metadata metadata) {
                return "user";
            }
        };
        ParseContext context = new ParseContext();
        context.set(PasswordProvider.class, (Object)provider);
        for (String path : new String[]{"testPDF_no_extract_no_accessibility_owner_user.pdf", "testPDF_no_extract_yes_accessibility_owner_user.pdf"}) {
            PDFParserTest.assertContains((String)"Hello World", (String)this.getXML((String)path, (ParseContext)context).xml);
        }
    }

    @Test
    public void testAccessCheckingEmptyPassword() throws Exception {
        PDFParserConfig config = new PDFParserConfig();
        config.setAccessChecker(new AccessChecker(false));
        ParseContext context = new ParseContext();
        context.set(PDFParserConfig.class, (Object)config);
        for (String path : new String[]{"testPDF_no_extract_no_accessibility_owner_empty.pdf", "testPDF_no_extract_yes_accessibility_owner_empty.pdf"}) {
            this.assertException("/test-documents/" + path, AUTO_DETECT_PARSER, context, AccessPermissionException.class);
        }
        config.setAccessChecker(new AccessChecker(true));
        this.assertException("/test-documents/testPDF_no_extract_no_accessibility_owner_empty.pdf", AUTO_DETECT_PARSER, context, AccessPermissionException.class);
        PDFParserTest.assertContains((String)"Hello World", (String)this.getXML((String)"testPDF_no_extract_yes_accessibility_owner_empty.pdf", (ParseContext)context).xml);
    }

    @Test
    public void testAccessCheckingUserPassword() throws Exception {
        ParseContext context = new ParseContext();
        PDFParserConfig config = new PDFParserConfig();
        config.setAccessChecker(new AccessChecker(false));
        PasswordProvider passwordProvider = new PasswordProvider(){

            public String getPassword(Metadata metadata) {
                return "user";
            }
        };
        context.set(PasswordProvider.class, (Object)passwordProvider);
        context.set(PDFParserConfig.class, (Object)config);
        for (String path : new String[]{"testPDF_no_extract_no_accessibility_owner_empty.pdf", "testPDF_no_extract_yes_accessibility_owner_empty.pdf"}) {
            this.assertException("/test-documents/" + path, AUTO_DETECT_PARSER, context, EncryptedDocumentException.class);
        }
        config.setAccessChecker(new AccessChecker(true));
        for (String path : new String[]{"testPDF_no_extract_no_accessibility_owner_empty.pdf", "testPDF_no_extract_yes_accessibility_owner_empty.pdf"}) {
            this.assertException("/test-documents/" + path, AUTO_DETECT_PARSER, context, EncryptedDocumentException.class);
        }
        this.assertException("/test-documents/testPDF_no_extract_no_accessibility_owner_user.pdf", AUTO_DETECT_PARSER, context, AccessPermissionException.class);
        PDFParserTest.assertContains((String)"Hello World", (String)this.getXML((String)"testPDF_no_extract_yes_accessibility_owner_user.pdf", (ParseContext)context).xml);
        config.setAccessChecker(new AccessChecker(false));
        for (String path : new String[]{"testPDF_no_extract_no_accessibility_owner_user.pdf", "testPDF_no_extract_yes_accessibility_owner_user.pdf"}) {
            this.assertException("/test-documents/" + path, AUTO_DETECT_PARSER, context, AccessPermissionException.class);
        }
    }

    @Test
    public void testAccessCheckingOwnerPassword() throws Exception {
        ParseContext context = new ParseContext();
        PDFParserConfig config = new PDFParserConfig();
        config.setAccessChecker(new AccessChecker(true));
        PasswordProvider passwordProvider = new PasswordProvider(){

            public String getPassword(Metadata metadata) {
                return "owner";
            }
        };
        context.set(PasswordProvider.class, (Object)passwordProvider);
        context.set(PDFParserConfig.class, (Object)config);
        for (String path : new String[]{"testPDF_no_extract_no_accessibility_owner_user.pdf", "testPDF_no_extract_yes_accessibility_owner_user.pdf", "testPDF_no_extract_no_accessibility_owner_empty.pdf", "testPDF_no_extract_yes_accessibility_owner_empty.pdf"}) {
            PDFParserTest.assertContains((String)"Hello World", (String)this.getXML((String)path, (ParseContext)context).xml);
        }
        config.setAccessChecker(new AccessChecker(false));
        for (String path : new String[]{"testPDF_no_extract_no_accessibility_owner_user.pdf", "testPDF_no_extract_yes_accessibility_owner_user.pdf", "testPDF_no_extract_no_accessibility_owner_empty.pdf", "testPDF_no_extract_yes_accessibility_owner_empty.pdf"}) {
            PDFParserTest.assertContains((String)"Hello World", (String)this.getXML((String)path, (ParseContext)context).xml);
        }
    }

    @Test
    public void testNoXMP() throws Exception {
        Assertions.assertEquals((Object)"false", (Object)this.getXML((String)"testPDF.pdf").metadata.get(PDF.HAS_XMP));
    }

    @Test
    public void testPDFEncodedStringsInXMP() throws Exception {
        TikaTest.XMLResult r = this.getXML("testPDF_PDFEncodedStringInXMP.pdf");
        Assertions.assertEquals((Object)"Microsoft", (Object)r.metadata.get(TikaCoreProperties.TITLE));
    }

    @Test
    public void testXFAExtractionBasic() throws Exception {
        TikaTest.XMLResult r = this.getXML("testPDF_XFA_govdocs1_258578.pdf");
        Metadata m = r.metadata;
        Assertions.assertEquals((Object)"true", (Object)m.get(PDF.HAS_XFA));
        Assertions.assertEquals((Object)"true", (Object)m.get(PDF.HAS_ACROFORM_FIELDS));
        Assertions.assertEquals((Object)"true", (Object)m.get(PDF.HAS_XMP));
        PDFParserTest.assertContains((String)"Mount Rushmore National Memorial", (String)r.xml);
        PDFParserTest.assertContains((String)"<li fieldName=\"School_Name\">School Name: my_school</li>", (String)r.xml);
    }

    @Test
    public void testXFAOnly() throws Exception {
        ParseContext context = new ParseContext();
        PDFParserConfig config = new PDFParserConfig();
        config.setIfXFAExtractOnlyXFA(true);
        context.set(PDFParserConfig.class, (Object)config);
        String xml = this.getXML((String)"testPDF_XFA_govdocs1_258578.pdf", (ParseContext)context).xml;
        PDFParserTest.assertContains((String)"<body><div class=\"xfa_content\">", (String)xml);
        PDFParserTest.assertContains((String)"<li fieldName=\"Room_1\">Room [1]: my_room1</li>", (String)xml);
        PDFParserTest.assertNotContained((String)"Mount Rushmore National Memorial", (String)xml);
    }

    @Test
    public void testXMPMM() throws Exception {
        Metadata m = this.getXML((String)"testPDF_twoAuthors.pdf").metadata;
        Assertions.assertEquals((Object)"uuid:0e46913c-72b9-40c0-8232-69e362abcd1e", (Object)m.get(XMPMM.DOCUMENTID));
        m = this.getXML((String)"testPDF_Version.11.x.PDFA-1b.pdf").metadata;
        Assertions.assertEquals((Object)"uuid:cccee1fc-51b3-4b52-ac86-672af3974d25", (Object)m.get(XMPMM.DOCUMENTID));
        Assertions.assertArrayEquals((Object[])new String[]{"uuid:0313504b-a0b0-4dac-a9f0-357221f2eadf", "uuid:edc4279e-0d5f-465e-b13e-1298402fd11c", "uuid:f565b775-43f3-4a9a-8541-e98c4115db6d", "uuid:9fd5e0a8-14a5-4920-ad7f-870c0b8ee65f", "uuid:09b6cfba-efde-4e07-a77f-70de858cc0aa", "uuid:1e4ffbd7-dabc-4aae-801c-15b3404ade36", "uuid:c1669773-a6ca-4bdd-aade-519030d0af00"}, (Object[])m.getValues(XMPMM.HISTORY_EVENT_INSTANCEID));
        Assertions.assertArrayEquals((Object[])new String[]{"converted", "converted", "converted", "converted", "converted", "converted", "converted"}, (Object[])m.getValues(XMPMM.HISTORY_ACTION));
        Assertions.assertArrayEquals((Object[])new String[]{"Preflight", "Preflight", "Preflight", "Preflight", "Preflight", "Preflight", "Preflight"}, (Object[])m.getValues(XMPMM.HISTORY_SOFTWARE_AGENT));
        Assertions.assertArrayEquals((Object[])new String[]{"2014-03-04T23:50:41Z", "2014-03-04T23:50:42Z", "2014-03-04T23:51:34Z", "2014-03-04T23:51:36Z", "2014-03-04T23:51:37Z", "2014-03-04T23:52:22Z", "2014-03-04T23:54:48Z"}, (Object[])m.getValues(XMPMM.HISTORY_WHEN));
    }

    @Test
    public void testSkipBadPage() throws Exception {
        BodyContentHandler handler = new BodyContentHandler(-1);
        Metadata m = new Metadata();
        ParseContext context = new ParseContext();
        boolean tikaEx = false;
        try (InputStream is = this.getResourceAsStream("/test-documents/testPDF_bad_page_303226.pdf");){
            AUTO_DETECT_PARSER.parse(is, (ContentHandler)handler, m, context);
        }
        catch (TikaException e) {
            tikaEx = true;
        }
        String content = handler.toString();
        Assertions.assertTrue((boolean)tikaEx, (String)"Should have thrown exception");
        Assertions.assertEquals((int)1, (int)m.getValues(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING).length);
        PDFParserTest.assertContains((String)"Unknown dir", (String)m.get(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING));
        PDFParserTest.assertContains((String)"1309.61", (String)content);
        PDFParserConfig config = new PDFParserConfig();
        config.setCatchIntermediateIOExceptions(false);
        context.set(PDFParserConfig.class, (Object)config);
        handler = new BodyContentHandler(-1);
        m = new Metadata();
        tikaEx = false;
        try (InputStream is = this.getResourceAsStream("/test-documents/testPDF_bad_page_303226.pdf");){
            AUTO_DETECT_PARSER.parse(is, (ContentHandler)handler, m, context);
        }
        catch (TikaException e) {
            tikaEx = true;
        }
        content = handler.toString();
        Assertions.assertTrue((boolean)tikaEx, (String)"Should have thrown exception");
        Assertions.assertEquals((int)0, (int)m.getValues(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING).length);
        PDFParserTest.assertNotContained((String)"1309.61", (String)content);
    }

    @Test
    public void testInitializationViaConfig() throws Exception {
        try (InputStream is = this.getResourceAsStream("/org/apache/tika/parser/pdf/tika-config.xml");){
            Assertions.assertNotNull((Object)is);
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser p = new AutoDetectParser(tikaConfig);
            String text = this.getText(this.getResourceAsStream("/test-documents/testPDFTwoTextBoxes.pdf"), (Parser)p);
            text = text.replaceAll("\\s+", " ");
            PDFParserTest.assertContains((String)"Left column line 1 Right column line 1 Left colu mn line 2 Right column line 2", (String)text);
            ParseContext pc = new ParseContext();
            PDFParserConfig config = new PDFParserConfig();
            config.setSortByPosition(false);
            pc.set(PDFParserConfig.class, (Object)config);
            text = this.getText("testPDFTwoTextBoxes.pdf", (Parser)p, new Metadata(), pc);
            text = text.replaceAll("\\s+", " ");
            PDFParserTest.assertContains((String)"Left column line 1 Left column line 2 ", (String)text);
            config = new PDFParserConfig();
            config.setOcrDPI(10000);
            config.setOcrStrategy(PDFParserConfig.OCR_STRATEGY.NO_OCR);
            pc.set(PDFParserConfig.class, (Object)config);
            text = this.getText("testPDFTwoTextBoxes.pdf", (Parser)p, new Metadata(), pc);
            text = text.replaceAll("\\s+", " ");
            PDFParserTest.assertContains((String)"Left column line 1 Right column line 1 Left colu mn line 2 Right column line 2", (String)text);
        }
    }

    @Test
    public void testInitializationOfNonPrimitivesViaConfig() throws Exception {
        try (InputStream is = this.getResourceAsStream("/org/apache/tika/parser/pdf/tika-config-non-primitives.xml");){
            Assertions.assertNotNull((Object)is);
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser p = new AutoDetectParser(tikaConfig);
            Map parsers = p.getParsers();
            Parser composite = (Parser)parsers.get(MediaType.application((String)"pdf"));
            Parser pdfParser = (Parser)((CompositeParser)composite).getParsers().get(MediaType.application((String)"pdf"));
            Assertions.assertEquals((Object)"org.apache.tika.parser.pdf.PDFParser", (Object)pdfParser.getClass().getName());
            Assertions.assertEquals((Object)PDFParserConfig.OCR_STRATEGY.OCR_ONLY, (Object)((PDFParser)pdfParser).getPDFParserConfig().getOcrStrategy());
            Assertions.assertEquals((Object)ImageType.RGB, (Object)((PDFParser)pdfParser).getPDFParserConfig().getOcrImageType());
        }
    }

    @Test
    public void testDiffTitles() throws Exception {
        Metadata m = this.getXML((String)"testPDF_diffTitles.pdf").metadata;
        Assertions.assertEquals((Object)"this is a new title", (Object)m.get(PDF.DOC_INFO_TITLE));
        Assertions.assertEquals((Object)"Sample Title", (Object)m.get(TikaCoreProperties.TITLE));
    }

    @Test
    public void testMaxLength() throws Exception {
        InputStream is = this.getResourceAsStream("/test-documents/testPDF.pdf");
        String content = new Tika().parseToString(is, new Metadata(), 100);
        Assertions.assertTrue((content.length() == 100 ? 1 : 0) != 0);
        PDFParserTest.assertContains((String)"Tika - Content", (String)content);
    }

    @Test
    public void testConfiguringMoreParams() throws Exception {
        try (InputStream configIs = this.getResourceAsStream("/org/apache/tika/parser/pdf/tika-inline-config.xml");){
            Assertions.assertNotNull((Object)configIs);
            TikaConfig tikaConfig = new TikaConfig(configIs);
            AutoDetectParser p = new AutoDetectParser(tikaConfig);
            List metadata = this.getRecursiveMetadata("testOCR.pdf", (Parser)p);
            Assertions.assertEquals((int)2, (int)metadata.size());
            Map parsers = p.getParsers();
            Parser composite = (Parser)parsers.get(MediaType.application((String)"pdf"));
            Parser pdfParser = (Parser)((CompositeParser)composite).getParsers().get(MediaType.application((String)"pdf"));
            Assertions.assertTrue((boolean)(pdfParser instanceof PDFParser));
            PDFParserConfig pdfParserConfig = ((PDFParser)pdfParser).getPDFParserConfig();
            Assertions.assertEquals((Object)new AccessChecker(true), (Object)pdfParserConfig.getAccessChecker());
            Assertions.assertEquals((Object)true, (Object)pdfParserConfig.isExtractInlineImages());
            Assertions.assertEquals((Object)false, (Object)pdfParserConfig.isExtractUniqueInlineImagesOnly());
            Assertions.assertEquals((int)314, (int)pdfParserConfig.getOcrDPI());
            Assertions.assertEquals((float)2.1f, (float)pdfParserConfig.getOcrImageQuality(), (float)0.01f);
            Assertions.assertEquals((Object)"jpeg", (Object)pdfParserConfig.getOcrImageFormatName());
            Assertions.assertEquals((long)524288000L, (long)pdfParserConfig.getMaxMainMemoryBytes());
            Assertions.assertEquals((Object)false, (Object)pdfParserConfig.isCatchIntermediateIOExceptions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertException(String path, Parser parser, ParseContext context, Class expected) {
        boolean noEx = false;
        InputStream is = this.getResourceAsStream(path);
        try {
            String text = this.getText(is, parser, context);
            noEx = true;
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)expected, e.getClass(), (String)("Not the right exception: " + path));
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        Assertions.assertFalse((boolean)noEx, (String)(path + " should have thrown exception"));
    }

    @Test
    public void testLanguageMetadata() throws Exception {
        Assertions.assertEquals((Object)"de-CH", (Object)this.getXML((String)"testPDF-custommetadata.pdf").metadata.get(TikaCoreProperties.LANGUAGE));
        Assertions.assertEquals((Object)"zh-CN", (Object)this.getXML((String)"testPDFFileEmbInAnnotation.pdf").metadata.get(TikaCoreProperties.LANGUAGE));
    }

    @Test
    public void testAngles() throws Exception {
        PDFParserConfig pdfParserConfig = new PDFParserConfig();
        pdfParserConfig.setDetectAngles(true);
        ParseContext parseContext = new ParseContext();
        parseContext.set(PDFParserConfig.class, (Object)pdfParserConfig);
        String xml = this.getXML((String)"testPDF_angles.pdf", (ParseContext)parseContext).xml;
        PDFParserTest.assertContainsCount((String)"<div class=\"page\">", (String)xml, (int)1);
        PDFParserTest.assertContains((String)"IN-DEMAND", (String)xml);
        PDFParserTest.assertContains((String)"natural underground", (String)xml);
        PDFParserTest.assertContains((String)"transport mined materials", (String)xml);
    }

    @Test
    public void testAnglesOnPageRotation() throws Exception {
        PDFParserConfig pdfParserConfig = new PDFParserConfig();
        pdfParserConfig.setDetectAngles(true);
        ParseContext parseContext = new ParseContext();
        parseContext.set(PDFParserConfig.class, (Object)pdfParserConfig);
        String xml = this.getXML((String)"testPDF_rotated.pdf", (ParseContext)parseContext).xml;
        PDFParserTest.assertContains((String)"until a further review indicates that the infrastructure", (String)xml);
    }

    @Test
    public void testUnmappedUnicodeStats() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPDF_bad_page_303226.pdf", true);
        Metadata m = (Metadata)metadataList.get(0);
        int[] totalChars = m.getIntValues(PDF.CHARACTERS_PER_PAGE);
        int[] unmappedUnicodeChars = m.getIntValues(PDF.UNMAPPED_UNICODE_CHARS_PER_PAGE);
        int totalUnmappedChars = m.getInt(PDF.TOTAL_UNMAPPED_UNICODE_CHARS);
        float overallPercentage = Float.parseFloat(m.get(PDF.OVERALL_PERCENTAGE_UNMAPPED_UNICODE_CHARS));
        if (totalChars[15] > 0) {
            Assertions.assertEquals((int)3805, (int)totalChars[15]);
            Assertions.assertEquals((int)120, (int)unmappedUnicodeChars[15]);
            Assertions.assertEquals((int)126, (int)totalUnmappedChars);
            Assertions.assertEquals((double)0.00146, (double)overallPercentage, (double)1.0E-4f);
            Assertions.assertTrue((boolean)Boolean.parseBoolean(m.get(PDF.CONTAINS_NON_EMBEDDED_FONT)));
            Assertions.assertFalse((boolean)Boolean.parseBoolean(m.get(PDF.CONTAINS_DAMAGED_FONT)));
        }
        PDFParserConfig pdfParserConfig = new PDFParserConfig();
        pdfParserConfig.setDetectAngles(true);
        ParseContext parseContext = new ParseContext();
        parseContext.set(PDFParserConfig.class, (Object)pdfParserConfig);
        metadataList = this.getRecursiveMetadata("testPDF_bad_page_303226.pdf", parseContext, true);
        m = (Metadata)metadataList.get(0);
        totalChars = m.getIntValues(PDF.CHARACTERS_PER_PAGE);
        unmappedUnicodeChars = m.getIntValues(PDF.UNMAPPED_UNICODE_CHARS_PER_PAGE);
        if (totalChars[15] > 0) {
            Assertions.assertEquals((int)3805, (int)totalChars[15]);
            Assertions.assertEquals((int)120, (int)unmappedUnicodeChars[15]);
        }
    }

    @Test
    public void testNPEInPDFParserConfig() {
        PDFParserConfig config = new PDFParserConfig();
        String txt = config.toString();
        config.hashCode();
        config.equals((Object)new PDFParserConfig());
    }

    @Test
    @Disabled(value="turn back on if we add file from PDFBOX-52")
    public void testPDFBox52() throws Exception {
        PDFParserConfig config = new PDFParserConfig();
        config.setExtractInlineImages(true);
        config.setExtractUniqueInlineImagesOnly(false);
        ParseContext context = new ParseContext();
        context.set(PDFParserConfig.class, (Object)config);
        List metadataList = this.getRecursiveMetadata("testPDF_PDFBOX-52.pdf", context);
        int max = 0;
        Matcher matcher = Pattern.compile("image(\\d+)").matcher("");
        for (Metadata m : metadataList) {
            int i;
            String n = m.get("resourceName");
            if (n == null || !matcher.reset(n).find() || (i = Integer.parseInt(matcher.group(1))) <= max) continue;
            max = i;
        }
        Assertions.assertEquals((int)37, (int)metadataList.size());
        Assertions.assertEquals((int)35, (int)max);
    }

    @Test
    public void testXMPBasicSchema() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPDF_XMPBasicSchema.pdf");
        Metadata m = (Metadata)metadataList.get(0);
        Assertions.assertEquals((Object)"Hewlett-Packard MFP", (Object)m.get(XMP.CREATOR_TOOL));
        Assertions.assertEquals((Object)"1998-08-29T13:53:15Z", (Object)m.get(XMP.CREATE_DATE));
    }

    @Test
    public void testXMPPDFSchema() throws Exception {
        Metadata metadata = this.getXML((String)"testPopupAnnotation.pdf").metadata;
        Assertions.assertEquals((Object)"IBM Lotus Symphony 3.0", (Object)metadata.get(PDF.PRODUCER));
    }

    @Test
    public void testExtractInlineImageMetadata() throws Exception {
        ParseContext context = new ParseContext();
        PDFParserConfig config = new PDFParserConfig();
        config.setExtractInlineImageMetadataOnly(true);
        context.set(PDFParserConfig.class, (Object)config);
        List metadataList = this.getRecursiveMetadata("testOCR.pdf", context);
        Assertions.assertNull((Object)context.get(ZeroByteFileException.IgnoreZeroByteFileException.class));
        Assertions.assertEquals((int)2, (int)metadataList.size());
        Assertions.assertEquals((Object)"image/png", (Object)((Metadata)metadataList.get(1)).get("Content-Type"));
        Assertions.assertEquals((Object)"/image0.png", (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
        Assertions.assertEquals((int)261, (int)((Metadata)metadataList.get(1)).getInt(Metadata.IMAGE_LENGTH));
        Assertions.assertEquals((int)934, (int)((Metadata)metadataList.get(1)).getInt(Metadata.IMAGE_WIDTH));
        Assertions.assertEquals((Object)"image0.png", (Object)((Metadata)metadataList.get(1)).get("resourceName"));
    }

    @Test
    public void testDeeplyEmbeddedAttachments() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPDF_deeplyEmbeddedAttachments.pdf");
        Assertions.assertEquals((int)21, (int)metadataList.size());
    }

    @Test
    public void testEmbeddedRichMedia() throws Exception {
        List metadata = this.getRecursiveMetadata("testFlashInPDF.pdf");
        Assertions.assertEquals((int)2, (int)metadata.size());
        Assertions.assertEquals((Object)"application/x-shockwave-flash", (Object)((Metadata)metadata.get(1)).get("Content-Type"));
        Assertions.assertEquals((Object)"TestMovie02.swf", (Object)((Metadata)metadata.get(1)).get("resourceName"));
        Assertions.assertEquals((Object)"15036", (Object)((Metadata)metadata.get(1)).get("Content-Length"));
        Assertions.assertEquals((Object)"RichMedia", (Object)((Metadata)metadata.get(0)).getValues(PDF.ANNOTATION_SUBTYPES)[0]);
        Assertions.assertEquals((Object)"RM1", (Object)((Metadata)metadata.get(0)).getValues(PDF.ANNOTATION_TYPES)[0]);
    }

    @Test
    public void testCustomGraphicsEngineFactory() throws Exception {
        try (InputStream is = this.getResourceAsStream("tika-config-custom-graphics-engine.xml");){
            Assertions.assertNotNull((Object)is);
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser p = new AutoDetectParser(tikaConfig);
            try {
                List metadataList = this.getRecursiveMetadata("testPDF_JBIG2.pdf", (Parser)p);
                Assertions.fail((String)"should have thrown a runtime exception");
            }
            catch (TikaException e) {
                String stack = ExceptionUtils.getStackTrace((Throwable)e);
                PDFParserTest.assertContains((String)"testing123", (String)stack);
            }
        }
    }

    private static class AvoidInlineSelector
    implements DocumentSelector {
        private AvoidInlineSelector() {
        }

        public boolean select(Metadata metadata) {
            String v = metadata.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE);
            return v == null || !v.equals(TikaCoreProperties.EmbeddedResourceType.INLINE.toString());
        }
    }

    private static class EventCountingHandler
    extends ContentHandlerDecorator {
        private int endDocument = 0;

        private EventCountingHandler() {
        }

        public void endDocument() {
            ++this.endDocument;
        }

        public int getEndDocument() {
            return this.endDocument;
        }
    }
}

