/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.tika.TikaTest;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PDF;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDMetadataExtractor;
import org.apache.tika.utils.XMLReaderUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CustomTikaXMPTest
extends TikaTest {
    @Test
    public void testPDFA() throws Exception {
        Metadata metadata = this.extract("testPDFA.xmp");
        Assertions.assertEquals((Object)"A-1b", (Object)metadata.get(PDF.PDFA_VERSION));
        Assertions.assertEquals((int)1, (Integer)metadata.getInt(PDF.PDFAID_PART));
        Assertions.assertEquals((Object)"B", (Object)metadata.get(PDF.PDFAID_CONFORMANCE));
    }

    @Test
    public void testPDFX() throws Exception {
        Metadata metadata = this.extract("testPDFX.xmp");
        Assertions.assertEquals((Object)"PDF/X-1:2001", (Object)metadata.get(PDF.PDFXID_VERSION));
        Assertions.assertEquals((Object)"PDF/X-1:2001", (Object)metadata.get(PDF.PDFX_VERSION));
        Assertions.assertEquals((Object)"PDF/X-1:2001", (Object)metadata.get(PDF.PDFX_CONFORMANCE));
    }

    @Test
    public void testPDFUA() throws Exception {
        Metadata metadata = this.extract("testPDFUA.xmp");
        Assertions.assertEquals((int)1, (Integer)metadata.getInt(PDF.PDFUAID_PART));
    }

    @Test
    public void testPDFVT() throws Exception {
        Metadata metadata = this.extract("testPDFVT.xmp");
        Assertions.assertEquals((Object)"PDF/VT-1", (Object)metadata.get(PDF.PDFVT_VERSION));
        Assertions.assertEquals((Object)"2018-08-06T12:53:12Z", (Object)metadata.getDate(PDF.PDFVT_MODIFIED).toInstant().toString());
    }

    private Metadata extract(String xmpFileName) throws IOException, TikaException, SAXException {
        try (InputStream is = this.getResourceAsStream("/test-documents/xmp/" + xmpFileName);){
            Document doc = XMLReaderUtils.buildDOM((InputStream)is);
            XMPMetadata xmp = new XMPMetadata(doc);
            ParseContext context = new ParseContext();
            Metadata metadata = new Metadata();
            PDMetadataExtractor.extract((XMPMetadata)xmp, (Metadata)metadata, (ParseContext)context);
            Metadata metadata2 = metadata;
            return metadata2;
        }
    }
}

