/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ocr;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.ocr.TesseractOCRConfig;
import org.apache.tika.parser.ocr.TesseractOCRParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TesseractOCRConfigTest
extends TikaTest {
    @Test
    public void testNoConfig() throws Exception {
        TesseractOCRConfig config = new TesseractOCRConfig();
        Assertions.assertEquals((Object)"eng", (Object)config.getLanguage(), (String)"Invalid default language value");
        Assertions.assertEquals((Object)"1", (Object)config.getPageSegMode(), (String)"Invalid default pageSegMode value");
        Assertions.assertEquals((long)0L, (long)config.getMinFileSizeToOcr(), (String)"Invalid default minFileSizeToOcr value");
        Assertions.assertEquals((long)Integer.MAX_VALUE, (long)config.getMaxFileSizeToOcr(), (String)"Invalid default maxFileSizeToOcr value");
        Assertions.assertEquals((int)120, (int)config.getTimeoutSeconds(), (String)"Invalid default timeout value");
        Assertions.assertEquals((int)300, (int)config.getDensity(), (String)"Invalid default density value");
        Assertions.assertEquals((int)4, (int)config.getDepth(), (String)"Invalid default depth value");
        Assertions.assertEquals((Object)"gray", (Object)config.getColorspace(), (String)"Invalid default colorpsace value");
        Assertions.assertEquals((Object)"triangle", (Object)config.getFilter(), (String)"Invalid default filter value");
        Assertions.assertEquals((int)200, (int)config.getResize(), (String)"Invalid default resize value");
        Assertions.assertEquals((Object)false, (Object)config.isApplyRotation(), (String)"Invalid default applyRotation value");
    }

    @Test
    public void testPartialConfig() throws Exception {
        InputStream stream = this.getResourceAsStream("/test-configs/tika-config-tesseract-partial.xml");
        TesseractOCRParser parser = (TesseractOCRParser)((CompositeParser)new TikaConfig(stream).getParser()).getAllComponentParsers().get(0);
        TesseractOCRConfig config = parser.getDefaultConfig();
        Assertions.assertEquals((Object)"fra+deu", (Object)config.getLanguage(), (String)"Invalid overridden language value");
        Assertions.assertEquals((Object)"1", (Object)config.getPageSegMode(), (String)"Invalid default pageSegMode value");
        Assertions.assertEquals((long)1L, (long)config.getMinFileSizeToOcr(), (String)"Invalid overridden minFileSizeToOcr value");
        Assertions.assertEquals((long)Integer.MAX_VALUE, (long)config.getMaxFileSizeToOcr(), (String)"Invalid default maxFileSizeToOcr value");
        Assertions.assertEquals((int)240, (int)config.getTimeoutSeconds(), (String)"Invalid overridden timeout value");
        Assertions.assertEquals((int)200, (int)config.getDensity(), (String)"Invalid overridden density value");
        Assertions.assertEquals((int)8, (int)config.getDepth(), (String)"Invalid overridden depth value");
        Assertions.assertEquals((Object)"box", (Object)config.getFilter(), (String)"Invalid overridden filter value");
        Assertions.assertEquals((int)300, (int)config.getResize(), (String)"Invalid overridden resize value");
        Assertions.assertEquals((Object)false, (Object)config.isApplyRotation(), (String)"Invalid default applyRotation value");
    }

    @Test
    public void testFullConfig() throws Exception {
        InputStream stream = this.getResourceAsStream("/test-configs/tika-config-tesseract-full.xml");
        TesseractOCRParser parser = (TesseractOCRParser)((CompositeParser)new TikaConfig(stream).getParser()).getAllComponentParsers().get(0);
        TesseractOCRConfig config = parser.getDefaultConfig();
        Assertions.assertEquals((Object)"ceb", (Object)config.getLanguage(), (String)"Invalid overridden language value");
        Assertions.assertEquals((Object)"2", (Object)config.getPageSegMode(), (String)"Invalid default pageSegMode value");
        Assertions.assertEquals((long)1L, (long)config.getMinFileSizeToOcr(), (String)"Invalid overridden minFileSizeToOcr value");
        Assertions.assertEquals((long)2000000L, (long)config.getMaxFileSizeToOcr(), (String)"Invalid default maxFileSizeToOcr value");
        Assertions.assertEquals((int)240, (int)config.getTimeoutSeconds(), (String)"Invalid overridden timeout value");
        Assertions.assertEquals((int)200, (int)config.getDensity(), (String)"Invalid overridden density value");
        Assertions.assertEquals((int)8, (int)config.getDepth(), (String)"Invalid overridden depth value");
        Assertions.assertEquals((Object)"box", (Object)config.getFilter(), (String)"Invalid overridden filter value");
        Assertions.assertEquals((int)300, (int)config.getResize(), (String)"Invalid overridden resize value");
        Assertions.assertEquals((Object)true, (Object)config.isApplyRotation(), (String)"Invalid default applyRotation value");
    }

    @Test
    public void testValidateValidLanguage() {
        List<String> validLanguages = Arrays.asList("eng", "slk_frak", "chi_tra", "eng+fra", "tgk+chi_tra+slk_frak", "chi_tra_vert", "tgk+chi_tra_vert+slk_frak", "eng+script/Arabic", "script/HanT_vert");
        TesseractOCRConfig config = new TesseractOCRConfig();
        for (String language : validLanguages) {
            config.setLanguage(language);
            Assertions.assertEquals((Object)language, (Object)config.getLanguage(), (String)"Valid language not set");
        }
    }

    @Test
    public void testValidateInvalidLanguage() {
        List<String> invalidLanguages = Arrays.asList("+", "en", "en+", "eng+fra+", "Arabic", "/script/Arabic", "rm -rf *");
        TesseractOCRConfig config = new TesseractOCRConfig();
        for (String language : invalidLanguages) {
            try {
                config.setLanguage(language);
                Assertions.fail((String)("Invalid language set: " + language));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testValidatePageSegMode() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.setPageSegMode("0");
        config.setPageSegMode("10");
        Assertions.assertTrue((boolean)true, (String)"Couldn't set valid values");
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.setPageSegMode("14"));
    }

    @Test
    public void testValidateDensity() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.setDensity(300);
        config.setDensity(400);
        Assertions.assertTrue((boolean)true, (String)"Couldn't set valid values");
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.setDensity(1));
    }

    @Test
    public void testValidateDepth() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.setDepth(4);
        config.setDepth(8);
        Assertions.assertTrue((boolean)true, (String)"Couldn't set valid values");
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.setDepth(6));
    }

    @Test
    public void testValidateFilter() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.setFilter("Triangle");
        config.setFilter("box");
        Assertions.assertTrue((boolean)true, (String)"Couldn't set valid values");
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.setFilter("abc"));
    }

    @Test
    public void testValidateResize() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.setResize(200);
        config.setResize(400);
        Assertions.assertTrue((boolean)true, (String)"Couldn't set valid values");
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.setResize(1000));
    }

    @Test
    public void testDataPathCheck() {
        TesseractOCRParser parser = new TesseractOCRParser();
        Assertions.assertThrows(IllegalArgumentException.class, () -> parser.setTessdataPath("blah\u0000deblah"));
    }

    @Test
    public void testPathCheck() {
        TesseractOCRParser parser = new TesseractOCRParser();
        Assertions.assertThrows(IllegalArgumentException.class, () -> parser.setTesseractPath("blah\u0000deblah"));
    }

    @Test
    public void testBadOtherKey() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.addOtherTesseractConfig("bad bad", "bad"));
    }

    @Test
    public void testBadOtherValue() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.addOtherTesseractConfig("bad", "bad bad"));
    }

    @Test
    public void testBadOtherValueSlash() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.addOtherTesseractConfig("bad", "bad\\bad"));
    }

    @Test
    public void testBadOtherValueControl() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.addOtherTesseractConfig("bad", "bad\u0001bad"));
    }

    @Test
    public void testGoodOtherParameters() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.addOtherTesseractConfig("good", "good");
    }

    @Test
    public void testBadLanguageCode() throws Exception {
        TesseractOCRConfig tesseractOCRConfig = new TesseractOCRConfig();
        Assertions.assertThrows(IllegalArgumentException.class, () -> tesseractOCRConfig.setLanguage("kerplekistani"));
    }

    @Test
    public void testBadColorSpace() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.setColorspace("someth!ng"));
    }

    @Test
    public void testUpdatingConfigs() throws Exception {
        TesseractOCRConfig configA = new TesseractOCRConfig();
        configA.setLanguage("eng");
        configA.setMinFileSizeToOcr(100L);
        configA.setOutputType(TesseractOCRConfig.OUTPUT_TYPE.TXT);
        configA.addOtherTesseractConfig("k1", "a1");
        configA.addOtherTesseractConfig("k2", "a2");
        TesseractOCRConfig configB = new TesseractOCRConfig();
        configB.setLanguage("fra");
        configB.setMinFileSizeToOcr(1000L);
        configB.setOutputType(TesseractOCRConfig.OUTPUT_TYPE.HOCR);
        configB.addOtherTesseractConfig("k1", "b1");
        configB.addOtherTesseractConfig("k2", "b2");
        TesseractOCRConfig clone = configA.cloneAndUpdate(configB);
        Assertions.assertEquals((Object)"fra", (Object)clone.getLanguage());
        Assertions.assertEquals((long)1000L, (long)clone.getMinFileSizeToOcr());
        Assertions.assertEquals((Object)TesseractOCRConfig.OUTPUT_TYPE.HOCR, (Object)clone.getOutputType());
        Assertions.assertEquals((Object)"b1", clone.getOtherTesseractConfig().get("k1"));
        Assertions.assertEquals((Object)"b2", clone.getOtherTesseractConfig().get("k2"));
    }
}

