/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.mail.smime.MailcapUtil;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEGenerator;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;
import org.bouncycastle.operator.OutputEncryptor;

public class SMIMEEnvelopedGenerator
extends SMIMEGenerator {
    public static final String DES_EDE3_CBC = CMSEnvelopedDataGenerator.DES_EDE3_CBC;
    public static final String RC2_CBC = CMSEnvelopedDataGenerator.RC2_CBC;
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = CMSEnvelopedDataGenerator.AES128_CBC;
    public static final String AES192_CBC = CMSEnvelopedDataGenerator.AES192_CBC;
    public static final String AES256_CBC = CMSEnvelopedDataGenerator.AES256_CBC;
    public static final String CAMELLIA128_CBC = CMSEnvelopedDataGenerator.CAMELLIA128_CBC;
    public static final String CAMELLIA192_CBC = CMSEnvelopedDataGenerator.CAMELLIA192_CBC;
    public static final String CAMELLIA256_CBC = CMSEnvelopedDataGenerator.CAMELLIA256_CBC;
    public static final String SEED_CBC = CMSEnvelopedDataGenerator.SEED_CBC;
    public static final String DES_EDE3_WRAP = CMSEnvelopedDataGenerator.DES_EDE3_WRAP;
    public static final String AES128_WRAP = CMSEnvelopedDataGenerator.AES128_WRAP;
    public static final String AES256_WRAP = CMSEnvelopedDataGenerator.AES256_WRAP;
    public static final String CAMELLIA128_WRAP = CMSEnvelopedDataGenerator.CAMELLIA128_WRAP;
    public static final String CAMELLIA192_WRAP = CMSEnvelopedDataGenerator.CAMELLIA192_WRAP;
    public static final String CAMELLIA256_WRAP = CMSEnvelopedDataGenerator.CAMELLIA256_WRAP;
    public static final String SEED_WRAP = CMSEnvelopedDataGenerator.SEED_WRAP;
    public static final String ECDH_SHA1KDF = CMSEnvelopedDataGenerator.ECDH_SHA1KDF;
    private static final String ENCRYPTED_CONTENT_TYPE = "application/pkcs7-mime; name=\"smime.p7m\"; smime-type=enveloped-data";
    private EnvelopedGenerator fact = new EnvelopedGenerator();

    public void addRecipientInfoGenerator(RecipientInfoGenerator recipientInfoGenerator) throws IllegalArgumentException {
        this.fact.addRecipientInfoGenerator(recipientInfoGenerator);
    }

    public void setBerEncodeRecipients(boolean bl) {
        this.fact.setBEREncodeRecipients(bl);
    }

    private MimeBodyPart make(MimeBodyPart mimeBodyPart, OutputEncryptor outputEncryptor) throws SMIMEException {
        try {
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            mimeBodyPart2.setContent((Object)new ContentEncryptor(mimeBodyPart, outputEncryptor), ENCRYPTED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Type", ENCRYPTED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            mimeBodyPart2.addHeader("Content-Description", "S/MIME Encrypted Message");
            mimeBodyPart2.addHeader("Content-Transfer-Encoding", this.encoding);
            return mimeBodyPart2;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)messagingException));
        }
    }

    public MimeBodyPart generate(MimeBodyPart mimeBodyPart, OutputEncryptor outputEncryptor) throws SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), outputEncryptor);
    }

    public MimeBodyPart generate(MimeMessage mimeMessage, OutputEncryptor outputEncryptor) throws SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.make(this.makeContentBodyPart(mimeMessage), outputEncryptor);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CommandMap commandMap = CommandMap.getDefaultCommandMap();
                if (commandMap instanceof MailcapCommandMap) {
                    CommandMap.setDefaultCommandMap(MailcapUtil.addCommands((MailcapCommandMap)commandMap));
                }
                return null;
            }
        });
    }

    private class ContentEncryptor
    implements SMIMEStreamingProcessor {
        private final MimeBodyPart _content;
        private OutputEncryptor _encryptor;
        private boolean _firstTime = true;

        ContentEncryptor(MimeBodyPart mimeBodyPart, OutputEncryptor outputEncryptor) {
            this._content = mimeBodyPart;
            this._encryptor = outputEncryptor;
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            try {
                OutputStream outputStream2;
                if (this._firstTime) {
                    outputStream2 = SMIMEEnvelopedGenerator.this.fact.open(outputStream, this._encryptor);
                    this._firstTime = false;
                } else {
                    outputStream2 = SMIMEEnvelopedGenerator.this.fact.regenerate(outputStream, this._encryptor);
                }
                CommandMap commandMap = CommandMap.getDefaultCommandMap();
                if (commandMap instanceof MailcapCommandMap) {
                    this._content.getDataHandler().setCommandMap(MailcapUtil.addCommands((MailcapCommandMap)commandMap));
                }
                this._content.writeTo(outputStream2);
                outputStream2.close();
            }
            catch (MessagingException messagingException) {
                throw new WrappingIOException(messagingException.toString(), messagingException);
            }
            catch (CMSException cMSException) {
                throw new WrappingIOException(cMSException.toString(), cMSException);
            }
        }
    }

    private static class EnvelopedGenerator
    extends CMSEnvelopedDataStreamGenerator {
        private ASN1ObjectIdentifier dataType;
        private ASN1EncodableVector recipientInfos;

        private EnvelopedGenerator() {
        }

        @Override
        protected OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, ASN1EncodableVector aSN1EncodableVector, OutputEncryptor outputEncryptor) throws IOException {
            this.dataType = aSN1ObjectIdentifier;
            this.recipientInfos = aSN1EncodableVector;
            return super.open(aSN1ObjectIdentifier, outputStream, aSN1EncodableVector, outputEncryptor);
        }

        OutputStream regenerate(OutputStream outputStream, OutputEncryptor outputEncryptor) throws IOException {
            return super.open(this.dataType, outputStream, this.recipientInfos, outputEncryptor);
        }
    }

    private static class WrappingIOException
    extends IOException {
        private Throwable cause;

        WrappingIOException(String string, Throwable throwable) {
            super(string);
            this.cause = throwable;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }
    }
}

