/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.naming.InitialContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.CompletionStageRxInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.RxInvokerProvider;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.AsyncInvokerImpl;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.CompletionStageRxInvokerImpl;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.JaxrsClientCallback;
import org.apache.cxf.jaxrs.client.LocalClientState;
import org.apache.cxf.jaxrs.client.SyncInvokerImpl;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.client.spec.ClientImpl;
import org.apache.cxf.jaxrs.client.spec.InvocationBuilderImpl;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ParameterizedCollectionType;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

public class WebClient
extends AbstractClient {
    private static final String REQUEST_CLASS = "request.class";
    private static final String REQUEST_TYPE = "request.type";
    private static final String REQUEST_ANNS = "request.annotations";
    private static final String RESPONSE_CLASS = "response.class";
    private static final String RESPONSE_TYPE = "response.type";
    private static final String WEB_CLIENT_OPERATION_REPORTING = "enable.webclient.operation.reporting";
    private BodyWriter bodyWriter = new BodyWriter();

    protected WebClient(String baseAddress) {
        this(WebClient.convertStringToURI(baseAddress), Collections.emptyMap());
    }

    protected WebClient(String baseAddress, Map<String, Object> properties) {
        this(WebClient.convertStringToURI(baseAddress), properties);
    }

    protected WebClient(URI baseURI) {
        this(baseURI, Collections.emptyMap());
    }

    protected WebClient(URI baseURI, Map<String, Object> properties) {
        this(new LocalClientState(baseURI, properties));
    }

    protected WebClient(ClientState state) {
        super(state);
        this.cfg.getInInterceptors().add(new ClientAsyncResponseInterceptor());
    }

    public static WebClient create(String baseAddress) {
        return WebClient.create(baseAddress, Collections.emptyMap());
    }

    public static WebClient create(String baseAddress, Map<String, Object> properties) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        bean.setAddress(baseAddress);
        bean.setProperties(properties);
        return bean.createWebClient();
    }

    public static WebClient create(URI baseURI) {
        return WebClient.create(baseURI.toString());
    }

    public static WebClient create(String baseURI, boolean threadSafe) {
        return WebClient.create(baseURI, Collections.emptyList(), threadSafe);
    }

    public static WebClient create(String baseAddress, List<?> providers) {
        return WebClient.create(baseAddress, providers, null);
    }

    public static WebClient create(String baseAddress, List<?> providers, boolean threadSafe) {
        return WebClient.create(baseAddress, providers, Collections.emptyMap(), threadSafe);
    }

    public static WebClient create(String baseAddress, List<?> providers, Map<String, Object> properties, boolean threadSafe) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, null);
        bean.setProviders(providers);
        bean.setProperties(properties);
        if (threadSafe) {
            bean.setInitialState(new ThreadLocalClientState(baseAddress, properties));
        }
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, List<?> providers, long timeToKeepState) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, null);
        bean.setProviders(providers);
        bean.setInitialState(new ThreadLocalClientState(baseAddress, timeToKeepState));
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, List<?> providers, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setProviders(providers);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, List<?> providers, List<? extends Feature> features, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setProviders(providers);
        bean.setFeatures(features);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, String username, String password, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setUsername(username);
        bean.setPassword(password);
        return bean.createWebClient();
    }

    public static WebClient create(String baseAddress, List<?> providers, String username, String password, String configLocation) {
        JAXRSClientFactoryBean bean = WebClient.getBean(baseAddress, configLocation);
        bean.setUsername(username);
        bean.setPassword(password);
        bean.setProviders(providers);
        return bean.createWebClient();
    }

    public static WebClient fromClientObject(Object object) {
        Client client = WebClient.client(object);
        return client == null ? null : WebClient.fromClient(client, false);
    }

    public static WebClient fromClient(Client client) {
        return WebClient.fromClient(client, false);
    }

    public static WebClient fromClient(Client client, boolean inheritHeaders) {
        WebClient webClient;
        ClientState clientState = WebClient.getClientState(client);
        if (clientState == null) {
            webClient = WebClient.create(client.getCurrentURI());
            if (inheritHeaders) {
                webClient.headers((MultivaluedMap)client.getHeaders());
            }
        } else {
            MultivaluedMap<String, String> headers = inheritHeaders ? client.getHeaders() : null;
            webClient = new WebClient(clientState.newState(client.getCurrentURI(), headers, null));
        }
        WebClient.copyProperties(webClient, client);
        return webClient;
    }

    public static Client client(Object object) {
        if (object instanceof Client) {
            return (Client)object;
        }
        return null;
    }

    public static ClientConfiguration getConfig(Object client) {
        if (client instanceof ClientImpl.WebTargetImpl) {
            client = ((ClientImpl.WebTargetImpl)client).getWebClient();
        } else if (client instanceof InvocationBuilderImpl) {
            client = ((InvocationBuilderImpl)client).getWebClient();
        }
        if (client instanceof Client) {
            if (client instanceof WebClient) {
                return ((AbstractClient)client).getConfiguration();
            }
            if (client instanceof InvocationHandlerAware) {
                Object handler = ((InvocationHandlerAware)client).getInvocationHandler();
                return ((AbstractClient)handler).getConfiguration();
            }
        }
        throw new IllegalArgumentException("Not a valid Client");
    }

    public Response invoke(String httpMethod, Object body) {
        return this.doInvoke(httpMethod, body, null, Response.class, (Type)((Object)Response.class));
    }

    public Response post(Object body) {
        return this.invoke("POST", body);
    }

    public Response put(Object body) {
        return this.invoke("PUT", body);
    }

    public Response get() {
        return this.invoke("GET", null);
    }

    public Response head() {
        return this.invoke("HEAD", null);
    }

    public Response options() {
        return this.invoke("OPTIONS", null);
    }

    public Response delete() {
        return this.invoke("DELETE", null);
    }

    public Response form(Map<String, List<Object>> values) {
        this.type("application/x-www-form-urlencoded");
        return this.doInvoke("POST", values, null, Response.class, (Type)((Object)Response.class));
    }

    public Response form(Form form) {
        this.type("application/x-www-form-urlencoded");
        return this.doInvoke("POST", form.asMap(), null, Response.class, (Type)((Object)Response.class));
    }

    public <T> T invoke(String httpMethod, Object body, GenericType<T> responseType) {
        Class<?> responseClass = responseType.getRawType();
        Response r = this.doInvoke(httpMethod, body, null, responseClass, responseType.getType());
        return (T)this.castResponse(r, responseClass);
    }

    public <T> T invoke(String httpMethod, Object body, Class<T> responseClass) {
        Response r = this.doInvoke(httpMethod, body, null, responseClass, responseClass);
        return this.castResponse(r, responseClass);
    }

    public <T> T invoke(String httpMethod, Object body, Class<?> requestClass, Class<T> responseClass) {
        Response r = this.doInvoke(httpMethod, body, requestClass, null, responseClass, responseClass);
        return this.castResponse(r, responseClass);
    }

    private <T> T castResponse(Response r, Class<T> responseClass) {
        return (T)(responseClass == Response.class ? r : r.getEntity());
    }

    public <T> T post(Object body, Class<T> responseClass) {
        return this.invoke("POST", body, responseClass);
    }

    public <T> T post(Object body, GenericType<T> responseType) {
        return this.invoke("POST", body, responseType);
    }

    public <T> Future<T> post(Object body, InvocationCallback<T> callback) {
        return this.doInvokeAsyncCallback("POST", body, body.getClass(), null, callback);
    }

    public <T> T put(Object body, Class<T> responseClass) {
        return this.invoke("PUT", body, responseClass);
    }

    public <T> T put(Object body, GenericType<T> responseType) {
        return this.invoke("PUT", body, responseType);
    }

    public <T> Future<T> put(Object body, InvocationCallback<T> callback) {
        return this.doInvokeAsyncCallback("PUT", body, body.getClass(), null, callback);
    }

    public <T> Collection<? extends T> invokeAndGetCollection(String httpMethod, Object body, Class<T> memberClass) {
        Response r = this.doInvoke(httpMethod, body, null, Collection.class, new ParameterizedCollectionType(memberClass));
        return CastUtils.cast((Collection)r.getEntity(), memberClass);
    }

    public <T> Response postCollection(Object collection, Class<T> memberClass) {
        return this.doInvoke("POST", collection, new ParameterizedCollectionType(memberClass), Response.class, (Type)((Object)Response.class));
    }

    public <T1, T2> T2 postCollection(Object collection, Class<T1> memberClass, Class<T2> responseClass) {
        Response r = this.doInvoke("POST", collection, new ParameterizedCollectionType(memberClass), responseClass, responseClass);
        return responseClass.cast(responseClass == Response.class ? r : r.getEntity());
    }

    public <T1, T2> Collection<? extends T2> postAndGetCollection(Object collection, Class<T1> memberClass, Class<T2> responseClass) {
        Response r = this.doInvoke("POST", collection, new ParameterizedCollectionType(memberClass), Collection.class, new ParameterizedCollectionType(responseClass));
        return CastUtils.cast((Collection)r.getEntity(), responseClass);
    }

    public <T> Collection<? extends T> postObjectGetCollection(Object body, Class<T> responseClass) {
        Response r = this.doInvoke("POST", body, null, Collection.class, new ParameterizedCollectionType(responseClass));
        return CastUtils.cast((Collection)r.getEntity(), responseClass);
    }

    public <T> Collection<? extends T> postAndGetCollection(Object body, Class<T> memberClass) {
        return this.invokeAndGetCollection("POST", body, memberClass);
    }

    public <T> Collection<? extends T> getCollection(Class<T> memberClass) {
        return this.invokeAndGetCollection("GET", null, memberClass);
    }

    public <T> T get(Class<T> responseClass) {
        return this.invoke("GET", null, responseClass);
    }

    public <T> T get(GenericType<T> responseType) {
        return this.invoke("GET", null, responseType);
    }

    public <T> Future<T> get(InvocationCallback<T> callback) {
        return this.doInvokeAsyncCallback("GET", null, null, null, callback);
    }

    public WebClient path(Object path) {
        this.getCurrentBuilder().path(this.convertParamValue(path, null));
        return this;
    }

    public WebClient path(String path, Object ... values) {
        URI u = new UriBuilderImpl().uri(URI.create("http://tempuri")).path(path).buildFromEncoded(values);
        this.getState().setTemplates(this.getTemplateParametersMap(new URITemplate(path), Arrays.asList(values)));
        return this.path(u.getRawPath());
    }

    @Override
    public WebClient query(String name, Object ... values) {
        return (WebClient)super.query(name, values);
    }

    public WebClient matrix(String name, Object ... values) {
        this.addMatrixQueryParamsToBuilder(this.getCurrentBuilder(), name, ParameterType.MATRIX, null, values);
        return this;
    }

    public WebClient fragment(String name) {
        this.getCurrentBuilder().fragment(name);
        return this;
    }

    public WebClient to(String newAddress, boolean forward) {
        this.getState().setTemplates(null);
        if (forward) {
            if (!newAddress.startsWith("/") && !newAddress.startsWith(this.getBaseURI().toString())) {
                throw new IllegalArgumentException("Base address can not be preserved");
            }
            this.resetCurrentBuilder(URI.create(newAddress));
        } else {
            this.resetBaseAddress(URI.create(newAddress));
        }
        return this;
    }

    public WebClient back(boolean fast) {
        this.getState().setTemplates(null);
        if (fast) {
            this.getCurrentBuilder().replacePath(this.getBaseURI().getPath());
        } else {
            URI uri = this.getCurrentURI();
            if (uri == this.getBaseURI()) {
                return this;
            }
            List<PathSegment> segments = JAXRSUtils.getPathSegments(uri.getPath(), false);
            this.getCurrentBuilder().replacePath(null);
            for (int i = 0; i < segments.size() - 1; ++i) {
                this.getCurrentBuilder().path(HttpUtils.fromPathSegment(segments.get(i)));
            }
        }
        return this;
    }

    public WebClient replacePath(String path) {
        if (path == null) {
            return this.back(true);
        }
        this.back(path.startsWith("/"));
        return this.path(path);
    }

    public WebClient resetQuery() {
        return this.replaceQuery(null);
    }

    public WebClient replaceQuery(String queryString) {
        this.getCurrentBuilder().replaceQuery(queryString);
        return this;
    }

    public WebClient replaceHeader(String headerName, Object value) {
        MultivaluedMap<String, String> headers = this.getState().getRequestHeaders();
        headers.remove(headerName);
        if (value != null) {
            super.header(headerName, value);
        }
        return this;
    }

    public WebClient replaceQueryParam(String queryParam, Object ... value) {
        this.getCurrentBuilder().replaceQueryParam(queryParam, value);
        return this;
    }

    @Override
    public WebClient type(MediaType ct) {
        return (WebClient)super.type(ct);
    }

    @Override
    public WebClient type(String type) {
        return (WebClient)super.type(type);
    }

    @Override
    public WebClient accept(MediaType ... types) {
        return (WebClient)super.accept(types);
    }

    @Override
    public WebClient accept(String ... types) {
        return (WebClient)super.accept(types);
    }

    @Override
    public WebClient language(String language) {
        return (WebClient)super.language(language);
    }

    @Override
    public WebClient acceptLanguage(String ... languages) {
        return (WebClient)super.acceptLanguage(languages);
    }

    @Override
    public WebClient encoding(String encoding) {
        return (WebClient)super.encoding(encoding);
    }

    @Override
    public WebClient acceptEncoding(String ... encodings) {
        return (WebClient)super.acceptEncoding(encodings);
    }

    @Override
    public WebClient match(EntityTag tag, boolean ifNot) {
        return (WebClient)super.match(tag, ifNot);
    }

    @Override
    public WebClient modified(Date date, boolean ifNot) {
        return (WebClient)super.modified(date, ifNot);
    }

    @Override
    public WebClient cookie(Cookie cookie) {
        return (WebClient)super.cookie(cookie);
    }

    @Override
    public WebClient authorization(Object auth) {
        return (WebClient)super.authorization(auth);
    }

    @Override
    public WebClient header(String name, Object ... values) {
        return (WebClient)super.header(name, values);
    }

    @Override
    public WebClient headers(MultivaluedMap<String, String> map) {
        return (WebClient)super.headers(map);
    }

    @Override
    public WebClient reset() {
        return (WebClient)super.reset();
    }

    protected Response doInvoke(String httpMethod, Object body, Type inGenericType, Class<?> responseClass, Type outGenericType) {
        return this.doInvoke(httpMethod, body, body == null ? null : body.getClass(), inGenericType, responseClass, outGenericType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response doInvoke(String httpMethod, Object body, Class<?> requestClass, Type inGenericType, Class<?> responseClass, Type outGenericType) {
        Response r;
        Annotation[] inAnns = null;
        if (body instanceof Entity) {
            Entity entity = (Entity)body;
            this.setEntityHeaders(entity);
            body = entity.getEntity();
            requestClass = body.getClass();
            inGenericType = body.getClass();
            inAnns = entity.getAnnotations();
        }
        if (body instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)body;
            body = genericEntity.getEntity();
            requestClass = genericEntity.getRawType();
            inGenericType = genericEntity.getType();
        }
        MultivaluedMap<String, String> headers = this.prepareHeaders(responseClass, body);
        this.resetResponse();
        try {
            r = this.doChainedInvocation(httpMethod, headers, body, requestClass, inGenericType, inAnns, responseClass, outGenericType, null, null);
        }
        finally {
            this.resetResponseStateImmediatelyIfNeeded();
        }
        int status = r.getStatus();
        if (status != 304 && status >= 300 && responseClass != Response.class) {
            throw this.convertToWebApplicationException(r);
        }
        return r;
    }

    protected <T> Future<T> doInvokeAsyncCallback(String httpMethod, Object body, Class<?> requestClass, Type inType, InvocationCallback<T> callback) {
        Type outType = WebClient.getCallbackType(callback);
        Class<?> respClass = WebClient.getCallbackClass(outType);
        return this.doInvokeAsync(httpMethod, body, requestClass, inType, respClass, outType, callback);
    }

    protected <T> Future<T> doInvokeAsync(String httpMethod, Object body, Class<?> requestClass, Type inType, Class<?> respClass, Type outType, InvocationCallback<T> callback) {
        JaxrsClientCallback<T> cb = new JaxrsClientCallback<T>(callback, respClass, outType);
        this.prepareAsyncClient(httpMethod, body, requestClass, inType, respClass, outType, cb);
        return cb.createFuture();
    }

    protected void prepareAsyncClient(String httpMethod, Object body, Class<?> requestClass, Type inType, Class<?> respClass, Type outType, JaxrsClientCallback<?> cb) {
        Annotation[] inAnns = null;
        if (body instanceof Entity) {
            Entity entity = (Entity)body;
            this.setEntityHeaders(entity);
            body = entity.getEntity();
            requestClass = body.getClass();
            inType = body.getClass();
            inAnns = entity.getAnnotations();
        }
        if (body instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)body;
            body = genericEntity.getEntity();
            requestClass = genericEntity.getRawType();
            inType = genericEntity.getType();
        }
        MultivaluedMap<String, String> headers = this.prepareHeaders(respClass, body);
        this.resetResponse();
        Message m = this.finalizeMessage(httpMethod, headers, body, requestClass, inType, inAnns, respClass, outType, null, null);
        m.getExchange().setSynchronous(false);
        this.setAsyncMessageObserverIfNeeded(m.getExchange());
        m.getExchange().put(JaxrsClientCallback.class, cb);
        this.doRunInterceptorChain(m);
    }

    private MultivaluedMap<String, String> prepareHeaders(Class<?> responseClass, Object body) {
        MultivaluedMap<String, String> headers = this.getHeaders();
        if (headers.getFirst("Content-Type") == null && body instanceof Form) {
            headers.putSingle("Content-Type", "application/x-www-form-urlencoded");
        }
        if (responseClass != null && responseClass != Response.class && headers.getFirst("Accept") == null) {
            headers.putSingle("Accept", "*/*");
        }
        return headers;
    }

    @Override
    protected Object retryInvoke(URI newRequestURI, MultivaluedMap<String, String> headers, Object body, Exchange exchange, Map<String, Object> invContext) throws Throwable {
        Map reqContext = CastUtils.cast((Map)invContext.get("RequestContext"));
        String httpMethod = (String)reqContext.get("org.apache.cxf.request.method");
        Class requestClass = (Class)reqContext.get(REQUEST_CLASS);
        Type inType = (Type)reqContext.get(REQUEST_TYPE);
        Annotation[] inAnns = (Annotation[])reqContext.get(REQUEST_ANNS);
        Class respClass = (Class)reqContext.get(RESPONSE_CLASS);
        Type outType = (Type)reqContext.get(RESPONSE_TYPE);
        return this.doChainedInvocation(httpMethod, headers, body, requestClass, inType, inAnns, respClass, outType, exchange, invContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response doChainedInvocation(String httpMethod, MultivaluedMap<String, String> headers, Object body, Class<?> requestClass, Type inType, Annotation[] inAnns, Class<?> respClass, Type outType, Exchange exchange, Map<String, Object> invContext) {
        Bus configuredBus = this.getConfiguration().getBus();
        Bus origBus = BusFactory.getAndSetThreadDefaultBus(configuredBus);
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        try {
            ClassLoader loader = configuredBus.getExtension(ClassLoader.class);
            if (loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader(loader);
            }
            Message m = this.finalizeMessage(httpMethod, headers, body, requestClass, inType, inAnns, respClass, outType, exchange, invContext);
            this.doRunInterceptorChain(m);
            Response response = this.doResponse(m, respClass, outType);
            return response;
        }
        finally {
            if (origLoader != null) {
                origLoader.reset();
            }
            if (origBus != configuredBus) {
                BusFactory.setThreadDefaultBus(origBus);
            }
        }
    }

    private Message finalizeMessage(String httpMethod, MultivaluedMap<String, String> headers, Object body, Class<?> requestClass, Type inGenericType, Annotation[] inAnns, Class<?> responseClass, Type outGenericType, Exchange exchange, Map<String, Object> invContext) {
        URI uri = this.getCurrentURI();
        Message m = this.createMessage(body, httpMethod, headers, uri, exchange, invContext, false);
        this.setSupportOnewayResponseProperty(m);
        if (inAnns != null) {
            m.put(Annotation.class.getName(), inAnns);
        }
        Map<String, Object> reqContext = this.getRequestContext(m);
        reqContext.put("org.apache.cxf.request.method", httpMethod);
        reqContext.put(REQUEST_CLASS, requestClass);
        reqContext.put(REQUEST_TYPE, inGenericType);
        reqContext.put(REQUEST_ANNS, inAnns);
        reqContext.put(RESPONSE_CLASS, responseClass);
        reqContext.put(RESPONSE_TYPE, outGenericType);
        if (body != null) {
            m.put(Type.class, inGenericType);
        }
        m.getInterceptorChain().add(this.bodyWriter);
        this.setWebClientOperationProperty(m, httpMethod);
        return m;
    }

    private void setWebClientOperationProperty(Message m, String httpMethod) {
        Object prop = m.getContextualProperty(WEB_CLIENT_OPERATION_REPORTING);
        if (prop == null || PropertyUtils.isTrue(prop)) {
            UriBuilder absPathUri = super.getCurrentBuilder().clone();
            absPathUri.replaceQuery(null);
            this.setPlainOperationNameProperty(m, httpMethod + ":" + absPathUri.build(new Object[0]).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response doResponse(Message m, Class<?> responseClass, Type outGenericType) {
        try {
            Object[] results = this.preProcessResult(m);
            if (results != null && results.length == 1) {
                return (Response)results[0];
            }
        }
        catch (ProcessingException | WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ProcessingException(ex);
        }
        try {
            Response response = this.handleResponse(m, responseClass, outGenericType);
            return response;
        }
        finally {
            this.completeExchange(m.getExchange(), false);
        }
    }

    protected Response handleResponse(Message outMessage, Class<?> responseClass, Type genericType) {
        try {
            int status;
            Response.ResponseBuilder rb = this.setResponseBuilder(outMessage, outMessage.getExchange());
            Response currentResponse = rb.clone().build();
            ((ResponseImpl)currentResponse).setOutMessage(outMessage);
            Object entity = this.readBody(currentResponse, outMessage, responseClass, genericType, new Annotation[0]);
            if (entity == null && (status = currentResponse.getStatus()) >= 400) {
                entity = currentResponse.getEntity();
            }
            rb = JAXRSUtils.fromResponse(currentResponse, false);
            rb.entity(entity instanceof Response ? ((Response)entity).getEntity() : entity);
            Response r = rb.build();
            this.getState().setResponse(r);
            ((ResponseImpl)r).setOutMessage(outMessage);
            Response response = r;
            return response;
        }
        catch (ProcessingException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ProcessingException(ex);
        }
        finally {
            ClientProviderFactory.getInstance(outMessage).clearThreadLocalProxies();
        }
    }

    static void copyProperties(Client toClient, Client fromClient) {
        AbstractClient newClient = WebClient.toAbstractClient(toClient);
        AbstractClient oldClient = WebClient.toAbstractClient(fromClient);
        newClient.setConfiguration(oldClient.getConfiguration());
    }

    private static AbstractClient toAbstractClient(Object client) {
        if (client instanceof AbstractClient) {
            return (AbstractClient)client;
        }
        if (client instanceof InvocationHandlerAware) {
            return (AbstractClient)((InvocationHandlerAware)client).getInvocationHandler();
        }
        Object realObject = ClassHelper.getRealObject(client);
        if (realObject instanceof AbstractClient) {
            return (AbstractClient)realObject;
        }
        return null;
    }

    static JAXRSClientFactoryBean getBean(String baseAddress, String configLocation) {
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        if (configLocation != null) {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus(configLocation);
            bean.setBus(bus);
        }
        bean.setAddress(baseAddress);
        return bean;
    }

    static ClientState getClientState(Client client) {
        AbstractClient newClient = WebClient.toAbstractClient(client);
        if (newClient == null) {
            return null;
        }
        return newClient.getState();
    }

    static URI convertStringToURI(String baseAddress) {
        try {
            return URI.create(baseAddress);
        }
        catch (RuntimeException ex) {
            if (baseAddress.startsWith("http")) {
                return new UriBuilderImpl().uriAsTemplate(baseAddress).build(new Object[0]);
            }
            throw ex;
        }
    }

    public AsyncInvoker async() {
        return new AsyncInvokerImpl(this);
    }

    public SyncInvoker sync() {
        return new SyncInvokerImpl(this);
    }

    public CompletionStageRxInvoker rx() {
        return this.rx(this.lookUpExecutorService());
    }

    public CompletionStageRxInvoker rx(ExecutorService ex) {
        return new CompletionStageRxInvokerImpl(this, ex);
    }

    public <T extends RxInvoker> T rx(Class<T> rxCls) {
        return this.rx(rxCls, null);
    }

    public <T extends RxInvoker> T rx(Class<T> rxCls, ExecutorService executorService) {
        if (CompletionStageRxInvoker.class.isAssignableFrom(rxCls)) {
            return (T)this.rx(executorService);
        }
        ClientProviderFactory pf = ClientProviderFactory.getInstance(WebClient.getConfig(this).getEndpoint());
        RxInvokerProvider<T> rxProvider = pf.getRxInvokerProvider();
        if (rxProvider != null && rxProvider.isProviderFor(rxCls)) {
            return (T)rxProvider.getRxInvoker(this.sync(), executorService);
        }
        throw new IllegalStateException("Provider for " + rxCls.getName() + " is not available");
    }

    private void setEntityHeaders(Entity<?> entity) {
        this.type(entity.getMediaType());
        if (entity.getLanguage() != null) {
            this.language(entity.getLanguage().toString());
        }
        if (entity.getEncoding() != null) {
            this.encoding(entity.getEncoding());
        }
    }

    private ExecutorService lookUpExecutorService() {
        try {
            InitialContext ic = new InitialContext();
            Object execService = ic.lookup("java:comp/DefaultManagedExecutorService");
            if (execService != null) {
                return (ExecutorService)execService;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private class BodyWriter
    extends AbstractClient.AbstractBodyWriter {
        private BodyWriter() {
        }

        @Override
        protected void doWriteBody(Message outMessage, Object body, Type bodyType, Annotation[] customAnns, OutputStream os) throws Fault {
            Map<String, Object> requestContext = WebClient.this.getRequestContext(outMessage);
            Class requestClass = null;
            Type requestType = null;
            if (requestContext != null) {
                requestClass = (Class)requestContext.get(WebClient.REQUEST_CLASS);
                requestType = (Type)requestContext.get(WebClient.REQUEST_TYPE);
            }
            if (bodyType != null) {
                requestType = bodyType;
            }
            Annotation[] anns = customAnns != null ? customAnns : new Annotation[]{};
            boolean isAssignable = requestClass != null && requestClass.isAssignableFrom(body.getClass());
            try {
                WebClient.this.writeBody(body, outMessage, requestClass == null || !isAssignable ? body.getClass() : requestClass, requestType == null || !isAssignable ? body.getClass() : requestType, anns, os);
            }
            catch (Exception ex) {
                throw new Fault(ex);
            }
        }
    }

    class ClientAsyncResponseInterceptor
    extends AbstractClient.AbstractClientAsyncResponseInterceptor {
        ClientAsyncResponseInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doHandleAsyncResponse(Message message, Response r, JaxrsClientCallback<?> cb) {
            if (r == null) {
                try {
                    r = WebClient.this.handleResponse(message.getExchange().getOutMessage(), cb.getResponseClass(), cb.getOutGenericType());
                }
                catch (Throwable t) {
                    cb.handleException(message, t);
                    return;
                }
                finally {
                    WebClient.this.completeExchange(message.getExchange(), false);
                }
            }
            if (cb.getResponseClass() == null || Response.class.equals(cb.getResponseClass())) {
                cb.handleResponse(message, new Object[]{r});
            } else if (r.getStatus() >= 300) {
                cb.handleException(message, WebClient.this.convertToWebApplicationException(r));
            } else {
                cb.handleResponse(message, new Object[]{r.getEntity()});
                this.closeAsyncResponseIfPossible(r, message, cb);
            }
        }
    }
}

