/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xps;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XPSParserTest
extends TikaTest {
    @Test
    public void testBasic() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPPT.xps");
        Assertions.assertEquals((int)2, (int)metadataList.size());
        Assertions.assertEquals((Object)"Rajiv", (Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"2010-06-29T12:06:31Z", (Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"2010-06-29T12:06:31Z", (Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.MODIFIED));
        Assertions.assertEquals((Object)"Attachment Test", (Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TITLE));
        String content = ((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT);
        XPSParserTest.assertContains((String)"<p>Attachment Test</p>", (String)content);
        XPSParserTest.assertContains((String)"<div class=\"canvas\"><p>Different", (String)content);
        XPSParserTest.assertContains((String)"tikacontent", (String)content);
        Assertions.assertEquals((Object)"image/jpeg", (Object)((Metadata)metadataList.get(1)).get("Content-Type"));
    }

    @Test
    public void testVarious() throws Exception {
        List metadataList = this.getRecursiveMetadata("testXPS_various.xps");
        Assertions.assertEquals((int)4, (int)metadataList.size());
        String quickBrownFox = "\u0644\u062b\u0639\u0644\u0628 \u0627\u0644\u0628\u0646\u064a \u0627\u0644\u0633\u0631\u064a\u0639";
        String content = ((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT);
        XPSParserTest.assertContains((String)quickBrownFox, (String)content);
        XPSParserTest.assertContains((String)"The \u0627\u0644\u0628\u0646\u064a fox", (String)content);
        XPSParserTest.assertContains((String)"\u0644\u062b\u0639\u0644\u0628 brown \u0627\u0644\u0633\u0631\u064a\u0639", (String)content);
        XPSParserTest.assertContains((String)"<a href=\"http://tika.apache.org/\">http://tika.apache.org/</a>", (String)content);
        Metadata metadata = (Metadata)metadataList.get(0);
        Assertions.assertEquals((Object)"Allison, Timothy B.", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"2017-12-12T11:15:38Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"2017-12-12T11:15:38Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assertions.assertEquals((Object)"image/png", (Object)((Metadata)metadataList.get(1)).get("Content-Type"));
        Metadata inlineJpeg = (Metadata)metadataList.get(2);
        Assertions.assertEquals((Object)"image/jpeg", (Object)inlineJpeg.get("Content-Type"));
        XPSParserTest.assertContains((String)"INetCache", (String)inlineJpeg.get(TikaCoreProperties.ORIGINAL_RESOURCE_NAME));
        Assertions.assertEquals((Object)TikaCoreProperties.EmbeddedResourceType.INLINE.toString(), (Object)inlineJpeg.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
        Assertions.assertEquals((Object)"image/jpeg", (Object)((Metadata)metadataList.get(3)).get("Content-Type"));
    }

    @Test
    public void testXPSWithDataDescriptor() throws Exception {
        Path path = Paths.get(XPSParserTest.class.getResource("/test-documents/testXPSWithDataDescriptor.xps").toURI());
        List metadataList = this.getRecursiveMetadata(path, true);
        Assertions.assertEquals((int)2, (int)metadataList.size());
        XPSParserTest.assertContains((String)"This is my XPS document test", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Files.copy(path, bos);
        metadataList = this.getRecursiveMetadata(new ByteArrayInputStream(bos.toByteArray()), true);
        Assertions.assertEquals((int)2, (int)metadataList.size());
        XPSParserTest.assertContains((String)"This is my XPS document test", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
        Assertions.assertEquals((Object)TikaCoreProperties.EmbeddedResourceType.THUMBNAIL.toString(), (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
    }

    @Test
    public void testOpenXPSWithDataDescriptor() throws Exception {
        Path path = Paths.get(XPSParserTest.class.getResource("/test-documents/testXPSWithDataDescriptor2.xps").toURI());
        List metadataList = this.getRecursiveMetadata(path, true);
        Assertions.assertEquals((int)2, (int)metadataList.size());
        XPSParserTest.assertContains((String)"How was I supposed to know", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Files.copy(path, bos);
        metadataList = this.getRecursiveMetadata(new ByteArrayInputStream(bos.toByteArray()), true);
        Assertions.assertEquals((int)2, (int)metadataList.size());
        XPSParserTest.assertContains((String)"How was I supposed to know", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
    }
}

