/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.nio.charset.StandardCharsets;
import org.apache.tika.parser.microsoft.chm.ChmCommons;
import org.apache.tika.parser.microsoft.chm.ChmItsfHeader;
import org.apache.tika.parser.microsoft.chm.ChmItspHeader;
import org.apache.tika.parser.microsoft.chm.TestParameters;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestChmItspHeader {
    private ChmItspHeader chmItspHeader = null;

    @BeforeEach
    public void setUp() throws Exception {
        byte[] data = TestParameters.chmData;
        ChmItsfHeader chmItsfHeader = new ChmItsfHeader();
        chmItsfHeader.parse(ChmCommons.copyOfRange((byte[])data, (int)0, (int)95), chmItsfHeader);
        this.chmItspHeader = new ChmItspHeader();
        this.chmItspHeader.parse(ChmCommons.copyOfRange((byte[])data, (int)((int)chmItsfHeader.getDirOffset()), (int)((int)chmItsfHeader.getDirOffset() + 84)), this.chmItspHeader);
    }

    @Test
    public void testGetBlock_len() {
        Assertions.assertEquals((long)4096L, (long)this.chmItspHeader.getBlock_len());
    }

    @Test
    public void testGetBlockidx_intvl() {
        Assertions.assertEquals((int)2, (int)this.chmItspHeader.getBlockidx_intvl());
    }

    @Test
    public void testGetHeader_len() {
        Assertions.assertEquals((int)84, (int)this.chmItspHeader.getHeader_len());
    }

    @Test
    public void testGetIndex_depth() {
        Assertions.assertEquals((int)1, (int)this.chmItspHeader.getIndex_depth());
    }

    @Test
    public void testGetIndex_head() {
        Assertions.assertEquals((int)0, (int)this.chmItspHeader.getIndex_head());
    }

    @Test
    public void testGetIndex_root() {
        Assertions.assertEquals((int)-1, (int)this.chmItspHeader.getIndex_root());
    }

    @Test
    public void testGetLang_id() {
        Assertions.assertEquals((long)1033L, (long)this.chmItspHeader.getLang_id());
    }

    @Test
    public void testGetNum_blocks() {
        Assertions.assertEquals((long)-1L, (long)this.chmItspHeader.getNum_blocks());
    }

    @Test
    public void testGetUnknown_000c() {
        Assertions.assertEquals((int)10, (int)this.chmItspHeader.getUnknown_000c());
    }

    @Test
    public void testGetUnknown_0024() {
        Assertions.assertEquals((int)0, (int)this.chmItspHeader.getUnknown_0024());
    }

    @Test
    public void testGetUnknown_002() {
        Assertions.assertEquals((int)1, (int)this.chmItspHeader.getUnknown_002c());
    }

    @Test
    public void testGetUnknown_0044() {
        Assertions.assertEquals((int)16, (int)this.chmItspHeader.getUnknown_0044().length);
    }

    @Test
    public void testGetVersion() {
        Assertions.assertEquals((int)1, (int)this.chmItspHeader.getVersion());
    }

    @Test
    public void testGetSignature() {
        Assertions.assertEquals((Object)"ITSP", (Object)new String(this.chmItspHeader.getSignature(), StandardCharsets.UTF_8));
    }

    @Test
    public void testGetSystem_uuid() {
        Assertions.assertEquals((int)16, (int)this.chmItspHeader.getSystem_uuid().length);
    }

    @Test
    public void testToString() {
        Assertions.assertTrue((boolean)this.chmItspHeader.toString().contains("ITSP"));
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.chmItspHeader = null;
    }
}

