/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.chm.ChmDirectoryListingSet;
import org.apache.tika.parser.microsoft.chm.ChmExtractor;
import org.apache.tika.parser.microsoft.chm.DirectoryListingEntry;
import org.apache.tika.parser.microsoft.chm.TestParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestChmExtractor
extends TikaTest {
    private ChmExtractor chmExtractor = null;

    @BeforeEach
    public void setUp() throws Exception {
        this.chmExtractor = new ChmExtractor((InputStream)new ByteArrayInputStream(TestParameters.chmData));
    }

    @Test
    public void testEnumerateChm() {
        List chmEntries = this.chmExtractor.enumerateChm();
        Assertions.assertEquals((int)100, (int)chmEntries.size());
    }

    @Test
    public void testGetChmDirList() {
        Assertions.assertNotNull((Object)this.chmExtractor.getChmDirList());
    }

    @Test
    public void testExtractChmEntry() throws TikaException {
        ChmDirectoryListingSet entries = this.chmExtractor.getChmDirList();
        int count = 0;
        for (DirectoryListingEntry directoryListingEntry : entries.getDirectoryListingEntryList()) {
            this.chmExtractor.extractChmEntry(directoryListingEntry);
            ++count;
        }
        Assertions.assertEquals((int)100, (int)count);
    }

    @Test
    public void testOOMOnCorruptCHM() throws Exception {
        try {
            TikaTest.XMLResult r = this.getXML("testChm_oom.chm");
            Assertions.fail((String)"should have thrown TikaException");
        }
        catch (TikaException e) {
            Assertions.assertTrue((boolean)true, (String)"correct exception thrown");
        }
    }
}

