/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class WordParserTest
extends TikaTest {
    @Test
    public void testWordParser() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testWORD.doc");){
            BodyContentHandler handler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"application/msword", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"Sample Word Document", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Keith Bennett", (Object)metadata.get(TikaCoreProperties.CREATOR));
            WordParserTest.assertContains((String)"Sample Word Document", (String)handler.toString());
        }
    }

    @Test
    public void testWordWithWAV() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/Doc1_ole.doc");){
            BodyContentHandler handler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            WordParserTest.assertContains((String)"MSj00974840000[1].wav", (String)handler.toString());
        }
    }

    @Test
    public void testWordHTML() throws Exception {
        TikaTest.XMLResult result = this.getXML("testWORD.doc");
        String xml = result.xml;
        Metadata metadata = result.metadata;
        Assertions.assertEquals((Object)"application/msword", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Sample Word Document", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Keith Bennett", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertTrue((boolean)xml.contains("Sample Word Document"));
        Assertions.assertTrue((boolean)xml.contains("<h1 class=\"title\">"));
        Assertions.assertTrue((boolean)xml.contains("<h1>Heading Level 1</h1>"));
        Assertions.assertTrue((boolean)xml.contains("<h3>Heading Level 3</h3>"));
        Assertions.assertTrue((boolean)xml.contains("<b>BOLD</b>"));
        Assertions.assertTrue((boolean)xml.contains("<i>ITALIC</i>"));
        Assertions.assertTrue((boolean)xml.contains("<table>"));
        Assertions.assertTrue((boolean)xml.contains("<td>"));
        Assertions.assertTrue((boolean)xml.contains("<a href=\"http://tika.apache.org/\"><u>Tika</u></a>"));
        Assertions.assertTrue((boolean)xml.contains("<p class=\"signature\">This one"));
        xml = this.getXML((String)"testWORD_3imgs.doc").xml;
        Assertions.assertTrue((boolean)xml.contains("src=\"embedded:image1.png\""), (String)("Image not found in:\n" + xml));
        Assertions.assertTrue((boolean)xml.contains("src=\"embedded:image2.jpg\""), (String)("Image not found in:\n" + xml));
        Assertions.assertTrue((boolean)xml.contains("src=\"embedded:image3.png\""), (String)("Image not found in:\n" + xml));
        Assertions.assertTrue((boolean)xml.contains("<p>The end!"));
        xml = this.getXML((String)"testWORD_bold_character_runs.doc").xml;
        Assertions.assertTrue((boolean)xml.contains("F<b>oob</b>a<b>r</b>"), (String)("Bold text wasn't contiguous: " + xml));
        xml = this.getXML((String)"testWORD_bold_character_runs2.doc").xml;
        Assertions.assertTrue((boolean)xml.contains("F<b>oob</b>a<b>r</b>"), (String)("Bold text wasn't contiguous: " + xml));
    }

    @Test
    public void testEmbeddedNames() throws Exception {
        String result = this.getXML((String)"testWORD_embedded_pdf.doc").xml;
        int i = result.indexOf("Here is the pdf file:");
        Assertions.assertTrue((i != -1 ? 1 : 0) != 0);
        int j = result.indexOf("<div class=\"embedded\" id=\"_1402837031\" />");
        Assertions.assertTrue((j != -1 ? 1 : 0) != 0);
        int k = result.indexOf("Bye Bye");
        Assertions.assertTrue((k != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((i < j ? 1 : 0) != 0);
        Assertions.assertTrue((j < k ? 1 : 0) != 0);
    }

    @Test
    public void testEmbeddedRTF() throws Exception {
        String result = this.getXML((String)"testWORD_embedded_rtf.doc").xml;
        Assertions.assertTrue((boolean)result.contains("<div class=\"embedded\" id=\"_1404039792\" />"));
        Assertions.assertTrue((boolean)result.contains("_1404039792.rtf"));
    }

    @Test
    public void testDocumentLink() throws Exception {
        String result = this.getXML((String)"testDocumentLink.doc").xml;
        Assertions.assertTrue((boolean)result.contains("<div class=\"embedded\" id=\"_1327495610\" />"));
        Assertions.assertTrue((boolean)result.contains("_1327495610.unknown"));
    }

    @Test
    public void testWord6Parser() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testWORD6.doc");){
            BodyContentHandler handler = new BodyContentHandler();
            Metadata metadata = new Metadata();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"application/msword", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Gym class featuring a brown fox and lazy dog", (Object)metadata.get(DublinCore.SUBJECT));
            Assertions.assertEquals((Object)"Nevin Nollop", (Object)metadata.get(TikaCoreProperties.CREATOR));
            WordParserTest.assertContains((String)"The quick brown fox jumps over the lazy dog", (String)handler.toString());
        }
    }

    @Test
    public void testTextDecoration() throws Exception {
        TikaTest.XMLResult result = this.getXML("testWORD_various.doc");
        String xml = result.xml;
        Assertions.assertTrue((boolean)xml.contains("<b>Bold</b>"));
        Assertions.assertTrue((boolean)xml.contains("<i>italic</i>"));
        Assertions.assertTrue((boolean)xml.contains("<u>underline</u>"));
    }

    @Test
    public void testTextDecorationNested() throws Exception {
        TikaTest.XMLResult result = this.getXML("testWORD_various.doc");
        String xml = result.xml;
        Assertions.assertTrue((boolean)xml.contains("<i>ita<s>li</s>c</i>"));
        Assertions.assertTrue((boolean)xml.contains("<i>ita<s>l<u>i</u></s>c</i>"));
        Assertions.assertTrue((boolean)xml.contains("<i><u>unde<s>r</s>line</u></i>"));
    }

    @Test
    public void testTurningOffTextBox() throws Exception {
        ParseContext pc = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setIncludeShapeBasedContent(false);
        pc.set(OfficeParserConfig.class, (Object)officeParserConfig);
        String xml = this.getXML((String)"testWORD_various.doc", (ParseContext)pc).xml;
        WordParserTest.assertNotContained((String)"text box", (String)xml);
    }

    @Test
    public void testVarious() throws Exception {
        int row;
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testWORD_various.doc");){
            new OfficeParser().parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        String content = handler.toString();
        WordParserTest.assertContains((String)"Footnote appears here", (String)content);
        WordParserTest.assertContains((String)"This is a footnote.", (String)content);
        WordParserTest.assertContains((String)"This is the header text.", (String)content);
        WordParserTest.assertContains((String)"This is the footer text.", (String)content);
        WordParserTest.assertContains((String)"Here is a text box", (String)content);
        WordParserTest.assertContains((String)"Bold", (String)content);
        WordParserTest.assertContains((String)"italic", (String)content);
        WordParserTest.assertContains((String)"underline", (String)content);
        WordParserTest.assertContains((String)"superscript", (String)content);
        WordParserTest.assertContains((String)"subscript", (String)content);
        WordParserTest.assertContains((String)"Here is a citation:", (String)content);
        WordParserTest.assertContains((String)"Figure 1 This is a caption for Figure 1", (String)content);
        WordParserTest.assertContains((String)"(Kramer)", (String)content);
        WordParserTest.assertContains((String)"Row 1 Col 1 Row 1 Col 2 Row 1 Col 3 Row 2 Col 1 Row 2 Col 2 Row 2 Col 3", (String)content.replaceAll("\\s+", " "));
        WordParserTest.assertContains((String)"Row 1 column 1 Row 2 column 1 Row 1 column 2 Row 2 column 2", (String)content.replaceAll("\\s+", " "));
        WordParserTest.assertContains((String)"This is a hyperlink", (String)content);
        WordParserTest.assertContains((String)"Here is a list:", (String)content);
        for (row = 1; row <= 3; ++row) {
            WordParserTest.assertContains((String)("Bullet " + row), (String)content);
        }
        WordParserTest.assertContains((String)"Here is a numbered list:", (String)content);
        for (row = 1; row <= 3; ++row) {
            WordParserTest.assertContains((String)("Number bullet " + row), (String)content);
        }
        for (row = 1; row <= 2; ++row) {
            for (int col = 1; col <= 3; ++col) {
                WordParserTest.assertContains((String)("Row " + row + " Col " + col), (String)content);
            }
        }
        WordParserTest.assertContains((String)"Keyword1 Keyword2", (String)content);
        WordParserTest.assertContains((String)"Subject is here", (String)content);
        WordParserTest.assertContains((Object)"Subject is here", Arrays.asList(metadata.getValues(DublinCore.SUBJECT)));
        WordParserTest.assertContains((Object)"Keyword1 Keyword2", Arrays.asList(metadata.getValues(DublinCore.SUBJECT)));
        WordParserTest.assertContains((String)"Suddenly some Japanese text:", (String)content);
        WordParserTest.assertContains((String)"\uff08\uff27\uff28\uff31\uff09", (String)content);
        WordParserTest.assertContains((String)"\u30be\u30eb\u30b2\u3068\u5c3e\u5d0e\u3001\u6de1\u3005\u3068\u6700\u671f", (String)content);
        WordParserTest.assertContains((String)"And then some Gothic text:", (String)content);
        WordParserTest.assertContains((String)"\ud800\udf32\ud800\udf3f\ud800\udf44\ud800\udf39\ud800\udf43\ud800\udf3a", (String)content);
    }

    @Test
    public void testHeaderFooterNotExtraction() throws Exception {
        ParseContext parseContext = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setIncludeHeadersAndFooters(false);
        parseContext.set(OfficeParserConfig.class, (Object)officeParserConfig);
        String xml = this.getXML((String)"testWORD_various.doc", (ParseContext)parseContext).xml;
        WordParserTest.assertNotContained((String)"This is the header text.", (String)xml);
        WordParserTest.assertNotContained((String)"This is the footer text.", (String)xml);
        AutoDetectParser configuredParser = null;
        try (InputStream is = this.getResourceAsStream("tika-config-headers-footers.xml");){
            configuredParser = new AutoDetectParser(new TikaConfig(is));
        }
        xml = this.getXML((String)"testWORD_various.doc", (Parser)configuredParser).xml;
        WordParserTest.assertNotContained((String)"This is the header text.", (String)xml);
        WordParserTest.assertNotContained((String)"This is the footer text.", (String)xml);
    }

    @Test
    public void testNoFormat() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testWORD_no_format.doc");){
            new OfficeParser().parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        String content = handler.toString();
        WordParserTest.assertContains((String)"Will generate an exception", (String)content);
    }

    @Test
    public void testCustomProperties() throws Exception {
        Metadata metadata = new Metadata();
        try (InputStream input = this.getResourceAsStream("/test-documents/testWORD_custom_props.doc");){
            BodyContentHandler handler = new BodyContentHandler(-1);
            ParseContext context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, context);
        }
        Assertions.assertEquals((Object)"application/msword", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"EJ04325S", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"Etienne Jouvin", (Object)metadata.get(TikaCoreProperties.MODIFIER));
        Assertions.assertEquals((Object)"2012-01-03T22:14:00Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assertions.assertEquals((Object)"2010-10-05T09:03:00Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"Microsoft Office Word", (Object)metadata.get(OfficeOpenXMLExtended.APPLICATION));
        Assertions.assertEquals((Object)"1", (Object)metadata.get(Office.PAGE_COUNT));
        Assertions.assertEquals((Object)"2", (Object)metadata.get(Office.WORD_COUNT));
        Assertions.assertEquals((Object)"My Title", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Normal.dotm", (Object)metadata.get(OfficeOpenXMLExtended.TEMPLATE));
        Assertions.assertEquals((Object)"My Comments", (Object)metadata.get(TikaCoreProperties.COMMENTS));
        WordParserTest.assertContains((Object)"My subject", Arrays.asList(metadata.getValues(DublinCore.SUBJECT)));
        WordParserTest.assertContains((Object)"My Keyword", Arrays.asList(metadata.getValues(DublinCore.SUBJECT)));
        Assertions.assertEquals((Object)"EDF-DIT", (Object)metadata.get(OfficeOpenXMLExtended.COMPANY));
        Assertions.assertEquals((Object)"MyStringValue", (Object)metadata.get("custom:MyCustomString"));
        Assertions.assertEquals((Object)"2010-12-30T23:00:00Z", (Object)metadata.get("custom:MyCustomDate"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptions1() throws Exception {
        LoggerContext ctx = (LoggerContext)LogManager.getContext();
        LoggerConfig lc = ctx.getConfiguration().getRootLogger();
        Level originalLevel = lc.getLevel();
        lc.setLevel(Level.ERROR);
        try {
            TikaTest.XMLResult xml = this.getXML("testException1.doc");
            WordParserTest.assertContains((String)"total population", (String)xml.xml);
            xml = this.getXML("testException2.doc");
            WordParserTest.assertContains((String)"electric charge", (String)xml.xml);
        }
        finally {
            lc.setLevel(originalLevel);
        }
    }

    @Test
    public void testTabularSymbol() throws Exception {
        WordParserTest.assertContains((String)"one two", (String)this.getXML((String)"testWORD_tabular_symbol.doc").xml.replaceAll("\\s+", " "));
    }

    @Test
    public void testHeaderHyperlinks() throws Exception {
        TikaTest.XMLResult result = this.getXML("testWORD_header_hyperlink.doc");
        String xml = result.xml;
        Metadata metadata = result.metadata;
        Assertions.assertEquals((Object)"application/msword", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Lutz Theurer", (Object)metadata.get(TikaCoreProperties.CREATOR));
        WordParserTest.assertContains((String)"example.com", (String)xml);
        Assertions.assertFalse((boolean)xml.contains("HYPERLINK"));
        WordParserTest.assertContains((String)"<a href=\"http://tw-systemhaus.de\"><u>http:", (String)xml);
        WordParserTest.assertContains((String)"<a href=\"mailto:ab@example.com\"><u>ab@", (String)xml);
    }

    @Test
    public void testControlCharacter() throws Exception {
        WordParserTest.assertContains((String)"<u>1.</u> <u>Introduzione</u><b> </b></a><u> </u></p>", (String)this.getXML((String)"testControlCharacters.doc").xml.replaceAll("\\s+", " "));
    }

    @Test
    public void testParagraphsAfterTables() throws Exception {
        TikaTest.XMLResult result = this.getXML("test_TIKA-1251.doc");
        String xml = result.xml;
        Metadata metadata = result.metadata;
        Assertions.assertEquals((Object)"application/msword", (Object)metadata.get("Content-Type"));
        WordParserTest.assertContains((String)"<p><u>1. Organisering av vakten:</u></p>", (String)xml);
    }

    @Test
    public void testHyperlinkStringIOOBESmartQuote() throws Exception {
        TikaTest.XMLResult result = this.getXML("testWORD_closingSmartQInHyperLink.doc");
        WordParserTest.assertContains((String)"href=\"https://issues.apache.org/jira/browse/TIKA-1512", (String)result.xml);
    }

    @Test
    @Disabled
    public void testHyperlinkStringLongNoCloseQuote() throws Exception {
        TikaTest.XMLResult result = this.getXML("testWORD_longHyperLinkNoCloseQuote.doc");
        WordParserTest.assertContains((String)"href=\"http://www.lexis.com", (String)result.xml);
    }

    @Test
    @Disabled
    public void testHyperlinkStringLongCarriageReturn() throws Exception {
        TikaTest.XMLResult result = this.getXML("testWORD_hyperLinkCarriageReturn.doc");
        WordParserTest.assertContains((String)"href=\"http://www.nib.org", (String)result.xml);
    }

    @Test
    public void testDOCParagraphNumbering() throws Exception {
        String xml = this.getXML((String)"testWORD_numbered_list.doc").xml;
        WordParserTest.assertContains((String)"1) This", (String)xml);
        WordParserTest.assertContains((String)"a) Is", (String)xml);
        WordParserTest.assertContains((String)"i) A multi", (String)xml);
        WordParserTest.assertContains((String)"ii) Level", (String)xml);
        WordParserTest.assertContains((String)"1. Within cell 1", (String)xml);
        WordParserTest.assertContains((String)"b. Cell b", (String)xml);
        WordParserTest.assertContains((String)"iii) List", (String)xml);
        WordParserTest.assertContains((String)"2) foo", (String)xml);
        WordParserTest.assertContains((String)"ii) baz", (String)xml);
        WordParserTest.assertContains((String)"ii) foo", (String)xml);
        WordParserTest.assertContains((String)"II. bar", (String)xml);
        WordParserTest.assertContains((String)"6. six", (String)xml);
        WordParserTest.assertContains((String)"7. seven", (String)xml);
        WordParserTest.assertContains((String)"a. seven a", (String)xml);
        WordParserTest.assertContains((String)"e. seven e", (String)xml);
        WordParserTest.assertContains((String)"2. A ii 2", (String)xml);
        WordParserTest.assertContains((String)"3. page break list 3", (String)xml);
        WordParserTest.assertContains((String)"Some-1-CrazyFormat Greek numbering with crazy format - alpha", (String)xml);
        WordParserTest.assertContains((String)"1.1.1. 1.1.1", (String)xml);
        WordParserTest.assertContains((String)"1.1. 1.2-&gt;1.1  //set the value", (String)xml);
        WordParserTest.assertContains((String)"add a list here", (String)xml);
        WordParserTest.assertContains((String)">comment list 1", (String)xml);
    }

    @Test
    public void testDOCOverrideParagraphNumbering() throws Exception {
        String xml = this.getXML((String)"testWORD_override_list_numbering.doc").xml;
        WordParserTest.assertContains((String)"1.1.1.1...1 1.1.1.1...1", (String)xml);
        WordParserTest.assertContains((String)"1st.2.3someText 1st.2.3someText", (String)xml);
        WordParserTest.assertContains((String)"1st.2.2someOtherText.1 1st.2.2someOtherText.1", (String)xml);
        WordParserTest.assertContains((String)"5th 5th", (String)xml);
        WordParserTest.assertContains((String)"1.a.I 1.a.I", (String)xml);
        WordParserTest.assertContains((String)"1.b.III 1.b.III", (String)xml);
        WordParserTest.assertContains((String)"2.a.I 2.a.I", (String)xml);
        WordParserTest.assertContains((String)"2.b 2.b", (String)xml);
        WordParserTest.assertContains((String)"(1)) (1))", (String)xml);
        WordParserTest.assertContains((String)"2.17 2.17", (String)xml);
        WordParserTest.assertContains((String)"2.18.2.1 2.18.2.1", (String)xml);
        WordParserTest.assertContains((String)">2 2", (String)xml);
        WordParserTest.assertContains((String)">1 1", (String)xml);
        WordParserTest.assertContains((String)">A A", (String)xml);
        WordParserTest.assertContains((String)">B B", (String)xml);
        WordParserTest.assertContains((String)">C C", (String)xml);
        WordParserTest.assertContains((String)">4 4", (String)xml);
        WordParserTest.assertContains((String)">00 00", (String)xml);
        WordParserTest.assertContains((String)">01 01", (String)xml);
        WordParserTest.assertContains((String)">01. 01.", (String)xml);
        WordParserTest.assertContains((String)">01..1 01..1", (String)xml);
        WordParserTest.assertContains((String)">02 02", (String)xml);
    }

    @Test
    public void testMultiAuthorsManagers() throws Exception {
        TikaTest.XMLResult r = this.getXML("testWORD_multi_authors.doc");
        String[] authors = r.metadata.getValues(TikaCoreProperties.CREATOR);
        Assertions.assertEquals((int)3, (int)authors.length);
        Assertions.assertEquals((Object)"author2", (Object)authors[1]);
        String[] managers = r.metadata.getValues(OfficeOpenXMLExtended.MANAGER);
        Assertions.assertEquals((int)2, (int)managers.length);
        Assertions.assertEquals((Object)"manager1", (Object)managers[0]);
        Assertions.assertEquals((Object)"manager2", (Object)managers[1]);
    }

    @Test
    public void testOrigLocation() throws Exception {
        Metadata metadata = this.getXML((String)"testException2.doc").metadata;
        List<String> values = Arrays.asList(metadata.getValues(TikaCoreProperties.ORIGINAL_RESOURCE_NAME));
        WordParserTest.assertContains((Object)"C:\\Lab Documents\\Lab Manuals\\Physics 275-6\\276-s00\\07-Force-on-a-current-S00.doc", values);
        WordParserTest.assertContains((Object)"Hard Drive:Course Folders:276:276-s00:07-Force-on-a-current-S00", values);
    }

    @Test
    public void testOrigSourcePath() throws Exception {
        Metadata embed1_zip_metadata = (Metadata)this.getRecursiveMetadata("test_recursive_embedded.doc").get(2);
        WordParserTest.assertContains((Object)"C:\\Users\\tallison\\AppData\\Local\\Temp\\embed1.zip", Arrays.asList(embed1_zip_metadata.getValues(TikaCoreProperties.ORIGINAL_RESOURCE_NAME)));
        WordParserTest.assertContains((Object)"C:\\Users\\tallison\\Desktop\\tmp\\New folder (2)\\embed1.zip", Arrays.asList(embed1_zip_metadata.getValues(TikaCoreProperties.ORIGINAL_RESOURCE_NAME)));
    }

    @Test
    public void testBoldHyperlink() throws Exception {
        String xml = this.getXML((String)"testWORD_boldHyperlink.doc").xml;
        xml = xml.replaceAll("\\s+", " ");
        WordParserTest.assertContains((String)"<a href=\"http://tika.apache.org/\"><u>hyper <b>link</b></u></a>", (String)xml);
        WordParserTest.assertContains((String)"<a href=\"http://tika.apache.org/\"><b><u>hyper</u></b><u> link</u></a>; bold", (String)xml);
    }

    @Test
    public void testHyperlinkSurroundedByItalics() throws Exception {
        String xml = this.getXML((String)"testWORD_italicsSurroundingHyperlink.doc").xml;
        xml = xml.replaceAll("\\s+", " ");
        WordParserTest.assertContains((String)"<body><p><i>Italic Test before link </i><a href=\"http://www.google.com\"><b><i><u>hyperlink italics</u></i></b></a><i> Italic text after hyperlink</i></p>", (String)xml);
    }

    @Test
    public void testMacros() throws Exception {
        for (Metadata metadata : this.getRecursiveMetadata("testWORD_macros.doc")) {
            if (!metadata.get("Content-Type").equals("text/x-vbasic")) continue;
            Assertions.fail((String)"Shouldn't have extracted macros as default");
        }
        ParseContext context = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setExtractMacros(true);
        context.set(OfficeParserConfig.class, (Object)officeParserConfig);
        Metadata minExpected = new Metadata();
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "Sub Embolden()");
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "Sub Italicize()");
        minExpected.add("Content-Type", "text/x-vbasic");
        minExpected.add(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
        List metadataList = this.getRecursiveMetadata("testWORD_macros.doc", context);
        WordParserTest.assertContainsAtLeast((Metadata)minExpected, (List)metadataList);
        try (InputStream is = this.getResourceAsStream("tika-config-macros.xml");){
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser parser = new AutoDetectParser(tikaConfig);
            metadataList = this.getRecursiveMetadata("testWORD_macros.doc", (Parser)parser);
            WordParserTest.assertContainsAtLeast((Metadata)minExpected, (List)metadataList);
        }
    }

    @Test
    public void testDeleted() throws Exception {
        String xml = this.getXML((String)"testWORD_2006ml.doc").xml;
        WordParserTest.assertNotContained((String)"frog", (String)xml);
        WordParserTest.assertContainsCount((String)"Second paragraph", (String)xml, (int)1);
        ParseContext context = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setIncludeDeletedContent(true);
        context.set(OfficeParserConfig.class, (Object)officeParserConfig);
        TikaTest.XMLResult r = this.getXML("testWORD_2006ml.doc", context);
        WordParserTest.assertContains((String)"frog", (String)r.xml);
        WordParserTest.assertContainsCount((String)"Second paragraph", (String)r.xml, (int)2);
    }

    @Test
    public void testProtected() throws Exception {
        try {
            this.getXML("testWORD_protected_passtika.doc");
            Assertions.fail((String)"should have thrown encrypted document exception");
        }
        catch (EncryptedDocumentException encryptedDocumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPhonetic() throws Exception {
        WordParserTest.assertContains((String)"\\s\\up 10(\u3068\u3046\u304d\u3087\u3046),\u6771\u4eac", (String)this.getXML((String)"testWORD_phonetic.doc").xml);
    }

    @Test
    public void testSpecialControlCharacter() throws Exception {
        WordParserTest.assertContains((String)"Paragraph one", (String)this.getXML((String)"testWORD_specialControlCharacter1415.doc").xml);
    }

    @Test
    public void testEncryptedDRM() throws Exception {
        Assertions.assertThrows(EncryptedDocumentException.class, () -> this.getRecursiveMetadata("testWORD_protected_drm.doc"));
    }
}

