/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class VisioParserTest {
    @Test
    public void testVisioParser() throws Exception {
        try (InputStream input = VisioParserTest.class.getResourceAsStream("/test-documents/testVISIO.vsd");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"application/vnd.visio", (Object)metadata.get("Content-Type"));
            Assertions.assertNull((Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Hogwarts", (Object)metadata.get(TikaCoreProperties.CREATOR));
            String content = handler.toString();
            TikaTest.assertContains((String)"Some random text, on a page", (String)content);
        }
    }
}

