/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.InputStream;
import java.util.Arrays;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class ProjectParserTest {
    @Test
    public void testProject2003() throws Exception {
        try (InputStream input = ProjectParserTest.class.getResourceAsStream("/test-documents/testPROJECT2003.mpp");){
            this.doTestProject(input);
        }
    }

    @Test
    public void testProject2007() throws Exception {
        try (InputStream input = ProjectParserTest.class.getResourceAsStream("/test-documents/testPROJECT2007.mpp");){
            this.doTestProject(input);
        }
    }

    private void doTestProject(InputStream input) throws Exception {
        Metadata metadata = new Metadata();
        BodyContentHandler handler = new BodyContentHandler();
        new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
        Assertions.assertEquals((Object)"application/vnd.ms-project", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Pangram, fox, dog", (Object)metadata.get(Office.KEYWORDS));
        Assertions.assertEquals((Object)"Nevin Nollop", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertNull((Object)metadata.get(TikaCoreProperties.MODIFIER));
        TikaTest.assertContains((Object)"Pangram, fox, dog", Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT)));
        TikaTest.assertContains((Object)"Gym class featuring a brown fox and lazy dog", Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT)));
        Assertions.assertEquals((Object)"Comment Vulpes vulpes comment", (Object)metadata.get(TikaCoreProperties.COMMENTS));
        Assertions.assertEquals((Object)"Category1", (Object)metadata.get(OfficeOpenXMLCore.CATEGORY));
        Assertions.assertEquals((Object)"Mr Burns", (Object)metadata.get(OfficeOpenXMLExtended.MANAGER));
        Assertions.assertEquals((Object)"CompanyA", (Object)metadata.get(OfficeOpenXMLExtended.COMPANY));
        Assertions.assertEquals((Object)"2011-11-24T10:58:00Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"2011-11-24T11:31:00Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assertions.assertEquals((Object)"0%", (Object)metadata.get("custom:% Complete"));
        Assertions.assertEquals((Object)"0%", (Object)metadata.get("custom:% Work Complete"));
        Assertions.assertEquals((Object)"\u00a30.00", (Object)metadata.get("custom:Cost"));
        Assertions.assertEquals((Object)"2d?", (Object)metadata.get("custom:Duration"));
        Assertions.assertEquals((Object)"16h", (Object)metadata.get("custom:Work"));
        String content = handler.toString();
        Assertions.assertEquals((Object)"", (Object)content);
    }
}

