/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.tika.TikaTest;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class PowerPointParserTest
extends TikaTest {
    @Test
    public void testPowerPointParser() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testPPT.ppt");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"application/vnd.ms-powerpoint", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"Sample Powerpoint Slide", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Keith Bennett", (Object)metadata.get(TikaCoreProperties.CREATOR));
            String content = handler.toString();
            PowerPointParserTest.assertContains((String)"Sample Powerpoint Slide", (String)content);
            PowerPointParserTest.assertContains((String)"Powerpoint X for Mac", (String)content);
        }
    }

    @Test
    public void testVarious() throws Exception {
        int row;
        Metadata metadata = new Metadata();
        String xml = this.getXML((String)"testPPT_various.ppt", (Metadata)metadata).xml;
        PowerPointParserTest.assertContains((String)"<p>Footnote appears here", (String)xml);
        PowerPointParserTest.assertContains((String)"<p>[1] This is a footnote.", (String)xml);
        PowerPointParserTest.assertContains((String)"<p>This is the header text.</p>", (String)xml);
        PowerPointParserTest.assertContains((String)"<p>This is the footer text.</p>", (String)xml);
        PowerPointParserTest.assertContainsCount((String)"<p>Here is a text box</p>", (String)xml, (int)1);
        PowerPointParserTest.assertContains((String)"<p>Bold ", (String)xml);
        PowerPointParserTest.assertContains((String)"italic underline superscript subscript", (String)xml);
        PowerPointParserTest.assertContains((String)"underline", (String)xml);
        PowerPointParserTest.assertContains((String)"superscript", (String)xml);
        PowerPointParserTest.assertContains((String)"subscript", (String)xml);
        PowerPointParserTest.assertContains((String)"<p>Here is a citation:", (String)xml);
        PowerPointParserTest.assertContains((String)"Figure 1 This is a caption for Figure 1", (String)xml);
        PowerPointParserTest.assertContains((String)"(Kramer)", (String)xml);
        PowerPointParserTest.assertContains((String)"<table><tr>\t<td>Row 1 Col 1</td>", (String)xml);
        PowerPointParserTest.assertContains((String)"<td>Row 2 Col 2</td>\t<td>Row 2 Col 3</td></tr>", (String)xml);
        PowerPointParserTest.assertContains((String)"<p>Row 1 column 1</p>", (String)xml);
        PowerPointParserTest.assertContains((String)"<p>Row 2 column 2</p>", (String)xml);
        PowerPointParserTest.assertContains((String)"<p><a href=\"http://tika.apache.org/\">This is a hyperlink</a>", (String)xml);
        PowerPointParserTest.assertContains((String)"<p>Here is a list:", (String)xml);
        for (row = 1; row <= 3; ++row) {
            PowerPointParserTest.assertContains((String)("<li>Bullet " + row), (String)xml);
        }
        PowerPointParserTest.assertContains((String)"Here is a numbered list:", (String)xml);
        for (row = 1; row <= 3; ++row) {
            PowerPointParserTest.assertContains((String)("<li>Number bullet " + row), (String)xml);
        }
        for (row = 1; row <= 2; ++row) {
            for (int col = 1; col <= 3; ++col) {
                PowerPointParserTest.assertContains((String)("Row " + row + " Col " + col), (String)xml);
            }
        }
        PowerPointParserTest.assertContains((String)"Keyword1 Keyword2", (String)xml);
        Assertions.assertEquals((Object)"Keyword1 Keyword2", (Object)metadata.get(Office.KEYWORDS));
        PowerPointParserTest.assertContains((Object)"Keyword1 Keyword2", Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT)));
        PowerPointParserTest.assertContains((String)"Subject is here", (String)xml);
        PowerPointParserTest.assertContains((Object)"Subject is here", Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT)));
        PowerPointParserTest.assertContains((String)"Suddenly some Japanese text:", (String)xml);
        PowerPointParserTest.assertContains((String)"\uff08\uff27\uff28\uff31\uff09", (String)xml);
        PowerPointParserTest.assertContains((String)"\u30be\u30eb\u30b2\u3068\u5c3e\u5d0e\u3001\u6de1\u3005\u3068\u6700\u671f", (String)xml);
        PowerPointParserTest.assertContains((String)"And then some Gothic text:", (String)xml);
        PowerPointParserTest.assertContains((String)"\ud800\udf32\ud800\udf3f\ud800\udf44\ud800\udf39\ud800\udf43\ud800\udf3a", (String)xml);
    }

    @Test
    @Disabled(value="not sure why this isn't working")
    public void testSkipHeaderFooter() throws Exception {
        OfficeParserConfig config = new OfficeParserConfig();
        config.setIncludeHeadersAndFooters(false);
        ParseContext context = new ParseContext();
        context.set(OfficeParserConfig.class, (Object)config);
        String xml = this.getXML((String)"testPPT_various.ppt", (ParseContext)context).xml;
        PowerPointParserTest.assertNotContained((String)"This is the header text", (String)xml);
    }

    @Test
    public void testMasterFooter() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testPPT_masterFooter.ppt");){
            new OfficeParser().parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        String content = handler.toString();
        PowerPointParserTest.assertContains((String)"Master footer is here", (String)content);
        Assertions.assertEquals((int)-1, (int)content.indexOf("Click to edit Master"));
        Assertions.assertEquals((int)-1, (int)content.indexOf("*"));
    }

    @Test
    @Disabled(value="not working")
    public void testTurningOffMasterFooter() throws Exception {
        OfficeParserConfig config = new OfficeParserConfig();
        config.setIncludeSlideMasterContent(false);
        ParseContext context = new ParseContext();
        context.set(OfficeParserConfig.class, (Object)config);
        PowerPointParserTest.assertNotContained((String)"Master footer", (String)this.getXML((String)"testPPT_masterFooter.ppt", (ParseContext)context).xml);
    }

    @Test
    public void testMasterText() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testPPT_masterText.ppt");){
            new OfficeParser().parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        String content = handler.toString();
        PowerPointParserTest.assertContains((String)"Text that I added to the master slide", (String)content);
        Assertions.assertEquals((int)-1, (int)content.indexOf("Click to edit Master"));
        Assertions.assertEquals((int)-1, (int)content.indexOf("*"));
        OfficeParserConfig config = new OfficeParserConfig();
        config.setIncludeSlideMasterContent(false);
        ParseContext context = new ParseContext();
        context.set(OfficeParserConfig.class, (Object)config);
        content = this.getXML((String)"testPPT_masterText.ppt", (ParseContext)context).xml;
        PowerPointParserTest.assertNotContained((String)"Text that I added", (String)content);
    }

    @Test
    public void testMasterText2() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testPPT_masterText2.ppt");){
            new OfficeParser().parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        String content = handler.toString();
        PowerPointParserTest.assertContains((String)"Text that I added to the master slide", (String)content);
        Assertions.assertEquals((int)-1, (int)content.indexOf("Click to edit Master"));
        Assertions.assertEquals((int)-1, (int)content.indexOf("*"));
        OfficeParserConfig config = new OfficeParserConfig();
        config.setIncludeSlideMasterContent(false);
        ParseContext context = new ParseContext();
        context.set(OfficeParserConfig.class, (Object)config);
        content = this.getXML((String)"testPPT_masterText2.ppt", (ParseContext)context).xml;
        PowerPointParserTest.assertNotContained((String)"Text that I added", (String)content);
    }

    @Test
    public void testCustomProperties() throws Exception {
        Metadata metadata = new Metadata();
        try (InputStream input = this.getResourceAsStream("/test-documents/testPPT_custom_props.ppt");){
            BodyContentHandler handler = new BodyContentHandler(-1);
            ParseContext context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, context);
        }
        Assertions.assertEquals((Object)"application/vnd.ms-powerpoint", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"JOUVIN ETIENNE", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"EJ04325S", (Object)metadata.get(TikaCoreProperties.MODIFIER));
        Assertions.assertEquals((Object)"2011-08-22T13:32:58Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assertions.assertEquals((Object)"2011-08-22T13:30:53Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"1", (Object)metadata.get(Office.SLIDE_COUNT));
        Assertions.assertEquals((Object)"3", (Object)metadata.get(Office.WORD_COUNT));
        Assertions.assertEquals((Object)"Test extraction properties pptx", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"true", (Object)metadata.get("custom:myCustomBoolean"));
        Assertions.assertEquals((Object)"3", (Object)metadata.get("custom:myCustomNumber"));
        Assertions.assertEquals((Object)"MyStringValue", (Object)metadata.get("custom:MyCustomString"));
        Assertions.assertEquals((Object)"2010-12-30T22:00:00Z", (Object)metadata.get("custom:MyCustomDate"));
        Assertions.assertEquals((Object)"2010-12-29T22:00:00Z", (Object)metadata.get("custom:myCustomSecondDate"));
    }

    @Test
    public void testEmbeddedPlacedholder() throws Exception {
        TikaTest.XMLResult result = this.getXML("testPPT_embedded2.ppt");
        PowerPointParserTest.assertContains((String)"<div class=\"embedded\" id=\"1\" />", (String)result.xml);
        PowerPointParserTest.assertContains((String)"<div class=\"embedded\" id=\"14\" />", (String)result.xml);
    }

    @Test
    public void testAutoDatePPT() throws Exception {
        TikaTest.XMLResult result = this.getXML("testPPT_autodate.ppt");
        PowerPointParserTest.assertContains((String)"<div class=\"slide-content\"><p>Now</p>", (String)result.xml);
    }

    @Test
    public void testCommentAuthorship() throws Exception {
        TikaTest.XMLResult r = this.getXML("testPPT_comment.ppt");
        PowerPointParserTest.assertContains((String)"<p class=\"slide-comment\"><b>Allison, Timothy B. (ATB)", (String)r.xml);
    }

    @Test
    public void testMacros() throws Exception {
        Metadata minExpected = new Metadata();
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "Sub Embolden()");
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "Sub Italicize()");
        minExpected.add("Content-Type", "text/x-vbasic");
        minExpected.add(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
        ParseContext parseContext = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setExtractMacros(true);
        parseContext.set(OfficeParserConfig.class, (Object)officeParserConfig);
        List metadataList = this.getRecursiveMetadata("testPPT_macros.ppt", parseContext);
        PowerPointParserTest.assertContainsAtLeast((Metadata)minExpected, (List)metadataList);
    }

    @Test
    public void testSkippingBadCompressedObj() throws Exception {
        TikaTest.XMLResult r = this.getXML("testPPT_skipBadCompressedObject.ppt");
        PowerPointParserTest.assertContains((String)"NASA Human", (String)r.xml);
        Assertions.assertEquals((int)2, (int)r.metadata.getValues(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING).length);
        PowerPointParserTest.assertContains((String)"incorrect data check", (String)r.metadata.get(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING));
        List metadataList = this.getRecursiveMetadata("testPPT_skipBadCompressedObject.ppt");
        Assertions.assertEquals((int)2, (int)((Metadata)metadataList.get(0)).getValues(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING).length);
        PowerPointParserTest.assertContains((String)"incorrect data check", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING));
    }

    @Test
    public void testEncrypted() throws Exception {
        Assertions.assertThrows(EncryptedDocumentException.class, () -> this.getXML("testPPT_protected_passtika.ppt"));
    }

    @Test
    public void testGroups() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPPT_groups.ppt");
        Assertions.assertEquals((int)3, (int)metadataList.size());
        String content = ((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT);
        PowerPointParserTest.assertContainsCount((String)"Text box1", (String)content, (int)1);
        PowerPointParserTest.assertContainsCount((String)"WordArt1", (String)content, (int)1);
        PowerPointParserTest.assertContainsCount((String)"WordArt2", (String)content, (int)1);
        PowerPointParserTest.assertContainsCount((String)"Ungrouped text box", (String)content, (int)1);
        PowerPointParserTest.assertContains((String)"Text box2", (String)content);
        PowerPointParserTest.assertContains((String)"Text box3", (String)content);
        PowerPointParserTest.assertContains((String)"Text box4", (String)content);
        PowerPointParserTest.assertContains((String)"Text box5", (String)content);
        PowerPointParserTest.assertContains((String)"tika", (String)content);
        PowerPointParserTest.assertContains((String)"MyTitle", (String)content);
        Assertions.assertEquals((Object)"/embedded-1", (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
        Assertions.assertEquals((Object)"/embedded-2", (Object)((Metadata)metadataList.get(2)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
    }

    @Disabled(value="until we add smart text extraction")
    @Test
    public void testSmartArtText() throws Exception {
        String content = this.getXML((String)"testPPT_groups.ppt").xml;
        PowerPointParserTest.assertContains((String)"smart1", (String)content);
    }

    @Disabled(value="until we fix hyperlink extraction from text boxes")
    @Test
    public void testHyperlinksInTextBoxes() throws Exception {
        String content = this.getXML((String)"testPPT_groups.ppt").xml;
        PowerPointParserTest.assertContains((String)"href=\"http://tika.apache.org", (String)content);
    }

    @Test
    public void testEmbeddedXLSInOLEObject() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPPT_oleWorkbook.ppt");
        Assertions.assertEquals((int)3, (int)metadataList.size());
        Metadata xlsx = (Metadata)metadataList.get(1);
        PowerPointParserTest.assertContains((String)"<h1>Sheet1</h1>", (String)xlsx.get(TikaCoreProperties.TIKA_CONTENT));
        PowerPointParserTest.assertContains((String)"<td>1</td>", (String)xlsx.get(TikaCoreProperties.TIKA_CONTENT));
        Assertions.assertEquals((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (Object)xlsx.get("Content-Type"));
    }
}

