/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.TikaTest;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class OLE2CasingTest
extends TikaTest {
    static final Set<String> IGNORE_FIELDS = new HashSet<String>();

    @Test
    public void testEncrypted() throws Exception {
        Assertions.assertThrows(EncryptedDocumentException.class, () -> this.getXML("casing/protected_normal_case.docx"));
        Assertions.assertThrows(EncryptedDocumentException.class, () -> this.getXML("casing/protected_upper_case.docx"));
    }

    @Test
    @Disabled(value="until POI can handle case insensitive entry lookups")
    public void testBasic() throws Exception {
        List metadataList = this.getRecursiveMetadata("casing/simple_normal_case.doc");
        this.assertCloseEnough(metadataList, this.getRecursiveMetadata("casing/simple_lower_case.doc"));
        this.assertCloseEnough(metadataList, this.getRecursiveMetadata("casing/simple_upper_case.doc"));
    }

    private void assertCloseEnough(List<Metadata> expected, List<Metadata> test) {
        for (int i = 0; i < expected.size(); ++i) {
            this.assertCloseEnough(expected.get(i), test.get(i));
        }
    }

    private void assertCloseEnough(Metadata expected, Metadata test) {
        for (String n : expected.names()) {
            if (IGNORE_FIELDS.contains(n)) continue;
            Assertions.assertArrayEquals((Object[])expected.getValues(n), (Object[])test.getValues(n));
        }
    }

    static {
        IGNORE_FIELDS.add(TikaCoreProperties.PARSE_TIME_MILLIS.getName());
    }
}

