/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.microsoft.EMFParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EMFParserTest
extends TikaTest {
    @Test
    public void testTextExtractionMac() throws Exception {
        List metadataList = this.getRecursiveMetadata("testEXCEL_embeddedPDF_mac.xls");
        Metadata emfMetadata = (Metadata)metadataList.get(2);
        Assertions.assertEquals((Object)"image/emf", (Object)emfMetadata.get("Content-Type"));
        EMFParserTest.assertContains((String)"is a toolkit for detecting", (String)emfMetadata.get(TikaCoreProperties.TIKA_CONTENT));
        EMFParserTest.assertContains((String)"Tika http://incubator.apache.org/tika/", (String)emfMetadata.get(TikaCoreProperties.TIKA_CONTENT));
    }

    @Test
    public void testIconOnly() throws Exception {
        String fullFileName = "some word doc with a very long name that should be wrapped.docx";
        List metadataList = this.getRecursiveMetadata("testEMF_iconOnlyLongFilename.emf");
        Assertions.assertEquals((Object)"true", (Object)((Metadata)metadataList.get(0)).get(EMFParser.EMF_ICON_ONLY));
        Assertions.assertEquals((Object)fullFileName, (Object)((Metadata)metadataList.get(0)).get(EMFParser.EMF_ICON_STRING));
        EMFParserTest.assertContains((String)"some word doc", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
        EMFParserTest.assertContains((String)"a very long name that should be wrapped.docx", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
    }
}

