/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.rtf;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.tika.Tika;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.extractor.ContainerExtractor;
import org.apache.tika.extractor.EmbeddedResourceHandler;
import org.apache.tika.extractor.ParserContainerExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RTFParserTest
extends TikaTest {
    @Test
    public void testBasicExtraction() throws Exception {
        Metadata metadata = new Metadata();
        String content = this.getText("testRTF.rtf", metadata);
        Assertions.assertEquals((Object)"application/rtf", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((int)1, (int)metadata.getValues("Content-Type").length);
        RTFParserTest.assertContains((String)"Test", (String)content);
        RTFParserTest.assertContains((String)"indexation Word", (String)content);
    }

    @Test
    public void testUmlautSpacesExtraction2() throws Exception {
        String content = this.getText("testRTFUmlautSpaces2.rtf");
        content = content.replaceAll("\\s+", "");
        Assertions.assertEquals((Object)"\u00dcbersicht", (Object)content);
    }

    @Test
    public void testUnicodeUCNControlWordCharacterDoublingExtraction() throws Exception {
        String content = this.getText("testRTFUnicodeUCNControlWordCharacterDoubling.rtf");
        RTFParserTest.assertContains((String)"\u5e74", (String)content);
        RTFParserTest.assertContains((String)"\u5ff5", (String)content);
        RTFParserTest.assertContains((String)"0 ", (String)content);
        RTFParserTest.assertContains((String)"abc", (String)content);
        Assertions.assertFalse((boolean)content.contains("\u5e74\u5e74"), (String)"Doubled character \u5e74");
    }

    @Test
    public void testHexEscapeInsideWord() throws Exception {
        String content = this.getText("testRTFHexEscapeInsideWord.rtf");
        RTFParserTest.assertContains((String)"ESP\u00cdRITO", (String)content);
    }

    @Test
    public void testWindowsCodepage1250() throws Exception {
        String content = this.getText("testRTFWindowsCodepage1250.rtf");
        RTFParserTest.assertContains((String)"za\u017c\u00f3\u0142\u0107 g\u0119\u015bl\u0105 ja\u017a\u0144", (String)content);
        RTFParserTest.assertContains((String)"ZA\u017b\u00d3\u0141\u0106 G\u0118\u015aL\u0104 JA\u0179\u0143", (String)content);
    }

    @Test
    public void testTableCellSeparation() throws Exception {
        String content = this.getText("testRTFTableCellSeparation.rtf");
        content = content.replaceAll("\\s+", " ");
        RTFParserTest.assertContains((String)"a b c d \u00e4 \u00eb \u00f6 \u00fc", (String)content);
        RTFParserTest.assertContains((String)"a b c d \u00e4 \u00eb \u00f6 \u00fc", (String)content);
    }

    @Test
    public void testTableCellSeparation2() throws Exception {
        String content = this.getText("testRTFTableCellSeparation2.rtf");
        content = content.replaceAll("\\s+", " ");
        RTFParserTest.assertContains((String)"Station Fax", (String)content);
    }

    @Test
    public void testWordPadCzechCharactersExtraction() throws Exception {
        String s1 = this.getText("testRTFWordPadCzechCharacters.rtf");
        Assertions.assertTrue((boolean)s1.contains("\u010cl\u00e1nek t\u00fddne"));
        Assertions.assertTrue((boolean)s1.contains("starov\u011bk\u00e9 \u017eidovsk\u00e9 n\u00e1bo\u017eensk\u00e9 texty"));
    }

    @Test
    public void testWord2010CzechCharactersExtraction() throws Exception {
        String s1 = this.getText("testRTFWord2010CzechCharacters.rtf");
        Assertions.assertTrue((boolean)s1.contains("\u010cl\u00e1nek t\u00fddne"));
        Assertions.assertTrue((boolean)s1.contains("starov\u011bk\u00e9 \u017eidovsk\u00e9 n\u00e1bo\u017eensk\u00e9 texty"));
    }

    @Test
    public void testMS932Extraction() throws Exception {
        TikaTest.XMLResult xmlResult = this.getXML("testRTF-ms932.rtf");
        Assertions.assertTrue((boolean)xmlResult.xml.contains("\u3053\u3093\u306b\u3061\u306f"));
        Assertions.assertEquals((Object)"\u30bf\u30a4\u30c8\u30eb", (Object)xmlResult.metadata.get(TikaCoreProperties.TITLE));
    }

    @Test
    public void testUmlautSpacesExtraction() throws Exception {
        RTFParserTest.assertContains((String)"\u00dcbersicht", (String)this.getText("testRTFUmlautSpaces.rtf"));
    }

    @Test
    public void testGothic() throws Exception {
        String content = this.getText("testRTFUnicodeGothic.rtf");
        RTFParserTest.assertContains((String)"\ud800\udf32\ud800\udf3f\ud800\udf44\ud800\udf39\ud800\udf43\ud800\udf3a", (String)content);
    }

    @Test
    public void testJapaneseText() throws Exception {
        TikaTest.XMLResult r = this.getXML("testRTFJapanese.rtf");
        String content = r.xml;
        Assertions.assertEquals((Object)"\u30be\u30eb\u30b2\u3068\u5c3e\u5d0e\u3001\u6de1\u3005\u3068\u6700\u671f\u3000", (Object)r.metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"VMazel", (Object)r.metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"StarWriter", (Object)r.metadata.get(TikaCoreProperties.COMMENTS));
        RTFParserTest.assertContains((String)"\uff08\uff27\uff28\uff31\uff09", (String)content);
        RTFParserTest.assertContains((String)"\u6771\u4eac\u90fd\u4e09\u9df9\u5e02", (String)content);
    }

    @Test
    public void testMaxLength() throws Exception {
        Metadata metadata;
        Tika localTika = new Tika();
        File file = this.getResourceAsFile("/test-documents/testRTFJapanese.rtf");
        TikaInputStream stream = TikaInputStream.get((File)file, (Metadata)(metadata = new Metadata()));
        String content = localTika.parseToString((InputStream)stream, metadata);
        Assertions.assertTrue((content.length() > 500 ? 1 : 0) != 0);
        localTika.setMaxStringLength(200);
        stream = TikaInputStream.get((File)file, (Metadata)metadata);
        content = localTika.parseToString((InputStream)stream, metadata);
        Assertions.assertTrue((content.length() <= 200 ? 1 : 0) != 0);
        stream = TikaInputStream.get((File)file, (Metadata)metadata);
        content = localTika.parseToString((InputStream)stream, metadata, 100);
        Assertions.assertTrue((content.length() <= 100 ? 1 : 0) != 0);
    }

    @Test
    public void testTextWithCurlyBraces() throws Exception {
        String content = this.getText("testRTFWithCurlyBraces.rtf");
        RTFParserTest.assertContains((String)"{ some text inside curly brackets }", (String)content);
    }

    @Test
    public void testControls() throws Exception {
        String content = this.getText("testRTFControls.rtf");
        RTFParserTest.assertContains((String)"Thiswordhasanem\u2014dash", (String)content);
        RTFParserTest.assertContains((String)"Thiswordhasanen\u2013dash", (String)content);
        RTFParserTest.assertContains((String)"Thiswordhasanon\u2011breakinghyphen", (String)content);
        RTFParserTest.assertContains((String)"Thiswordhasanonbreaking\u00a0space", (String)content);
        RTFParserTest.assertContains((String)"Thiswordhasanoptional\u00adhyphen", (String)content);
        RTFParserTest.assertContains((String)"\u2018Single quoted text\u2019", (String)content);
        RTFParserTest.assertContains((String)"\u201cDouble quoted text\u201d", (String)content);
        RTFParserTest.assertContains((String)"\u201cDouble quoted text again\u201d", (String)content);
    }

    @Test
    public void testInvalidUnicode() throws Exception {
        String content = this.getText("testRTFInvalidUnicode.rtf");
        RTFParserTest.assertContains((String)"Unpaired hi \ufffd here", (String)content);
        RTFParserTest.assertContains((String)"Unpaired lo \ufffd here", (String)content);
        RTFParserTest.assertContains((String)"Mismatched pair \ufffd\ufffd here", (String)content);
    }

    @Test
    public void testVarious() throws Exception {
        int row;
        Metadata metadata = new Metadata();
        String content = this.getText("testRTFVarious.rtf", metadata);
        RTFParserTest.assertContains((String)"Footnote appears here", (String)content);
        RTFParserTest.assertContains((String)"This is a footnote.", (String)content);
        RTFParserTest.assertContains((String)"This is the header text.", (String)content);
        RTFParserTest.assertContains((String)"This is the footer text.", (String)content);
        RTFParserTest.assertContains((String)"Here is a text box", (String)content);
        RTFParserTest.assertContains((String)"Bold", (String)content);
        RTFParserTest.assertContains((String)"italic", (String)content);
        RTFParserTest.assertContains((String)"underline", (String)content);
        RTFParserTest.assertContains((String)"superscript", (String)content);
        RTFParserTest.assertContains((String)"subscript", (String)content);
        RTFParserTest.assertContains((String)"Here is a citation:", (String)content);
        RTFParserTest.assertContains((String)"Figure 1 This is a caption for Figure 1", (String)content);
        RTFParserTest.assertContains((String)"(Kramer)", (String)content);
        RTFParserTest.assertContains((String)"Row 1 Col 1 Row 1 Col 2 Row 1 Col 3 Row 2 Col 1 Row 2 Col 2 Row 2 Col 3", (String)content.replaceAll("\\s+", " "));
        RTFParserTest.assertContains((String)"Row 1 column 1 Row 2 column 1 Row 1 column 2 Row 2 column 2", (String)content.replaceAll("\\s+", " "));
        RTFParserTest.assertContains((String)"This is a hyperlink", (String)content);
        RTFParserTest.assertContains((String)"Here is a list:", (String)content);
        for (row = 1; row <= 3; ++row) {
            RTFParserTest.assertContains((String)("Bullet " + row), (String)content);
        }
        RTFParserTest.assertContains((String)"Here is a numbered list:", (String)content);
        for (row = 1; row <= 3; ++row) {
            RTFParserTest.assertContains((String)("Number bullet " + row), (String)content);
        }
        for (row = 1; row <= 2; ++row) {
            for (int col = 1; col <= 3; ++col) {
                RTFParserTest.assertContains((String)("Row " + row + " Col " + col), (String)content);
            }
        }
        RTFParserTest.assertContains((String)"Keyword1 Keyword2", (String)content);
        RTFParserTest.assertContains((Object)"Keyword1 Keyword2", Arrays.asList(metadata.getValues(Office.KEYWORDS)));
        RTFParserTest.assertContains((String)"Subject is here", (String)content);
        Assertions.assertEquals((Object)"Subject is here", (Object)metadata.get(DublinCore.SUBJECT));
        RTFParserTest.assertContains((String)"Suddenly some Japanese text:", (String)content);
        RTFParserTest.assertContains((String)"\uff08\uff27\uff28\uff31\uff09", (String)content);
        RTFParserTest.assertContains((String)"\u30be\u30eb\u30b2\u3068\u5c3e\u5d0e\u3001\u6de1\u3005\u3068\u6700\u671f", (String)content);
        RTFParserTest.assertContains((String)"And then some Gothic text:", (String)content);
        RTFParserTest.assertContains((String)"\ud800\udf32\ud800\udf3f\ud800\udf44\ud800\udf39\ud800\udf43\ud800\udf3a", (String)content);
    }

    @Test
    public void testVariousStyle() throws Exception {
        String content = this.getXML((String)"testRTFVarious.rtf").xml;
        RTFParserTest.assertContains((String)"<b>Bold</b>", (String)content);
        RTFParserTest.assertContains((String)"<i>italic</i>", (String)content);
    }

    @Test
    public void testBoldItalic() throws Exception {
        String content = this.getXML((String)"testRTFBoldItalic.rtf").xml;
        RTFParserTest.assertContains((String)"<b>bold</b>", (String)content);
        RTFParserTest.assertContains((String)"<b>bold </b><b><i>italic</i></b>", (String)content);
        RTFParserTest.assertContains((String)"<b><i>italic </i></b><b>bold</b>", (String)content);
        RTFParserTest.assertContains((String)"<i>italic</i>", (String)content);
        RTFParserTest.assertContains((String)"<b>bold then </b><b><i>italic then</i></b><i> not bold</i>", (String)content);
        RTFParserTest.assertContains((String)"<i>italic then </i><b><i>bold then</i></b><b> not italic</b>", (String)content);
    }

    @Test
    public void testHyperlink() throws Exception {
        String content = this.getXML((String)"testRTFHyperlink.rtf").xml;
        RTFParserTest.assertContains((String)"our most <a href=\"http://r.office.microsoft.com/r/rlidwelcomeFAQ?clid=1033\">frequently asked questions</a>", (String)content);
        Assertions.assertEquals((int)-1, (int)content.indexOf("<p>\t\t</p>"));
    }

    @Test
    public void testIgnoredControlWord() throws Exception {
        RTFParserTest.assertContains((String)"<p>The quick brown fox jumps over the lazy dog</p>", (String)this.getXML((String)"testRTFIgnoredControlWord.rtf").xml);
    }

    @Test
    public void testFontAfterBufferedText() throws Exception {
        RTFParserTest.assertContains((String)"\u0423\u0432\u0430\u0436\u0430\u0435\u043c\u044b\u0439 \u043a\u043b\u0438\u0435\u043d\u0442!", (String)this.getXML((String)"testFontAfterBufferedText.rtf").xml);
    }

    @Test
    public void testListMicrosoftWord() throws Exception {
        String content = this.getXML((String)"testRTFListMicrosoftWord.rtf").xml;
        RTFParserTest.assertContains((String)"<ol>\t<li>one</li>", (String)content);
        RTFParserTest.assertContains((String)"</ol>", (String)content);
        RTFParserTest.assertContains((String)"<ul>\t<li>first</li>", (String)content);
        RTFParserTest.assertContains((String)"</ul>", (String)content);
    }

    @Test
    public void testTurningOffList() throws Exception {
        try (InputStream is = this.getResourceAsStream("/org/apache/tika/parser/microsoft/rtf/ignoreListMarkup-tika-config.xml");){
            Assertions.assertNotNull((Object)is);
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser p = new AutoDetectParser(tikaConfig);
            String content = this.getXML((String)"testRTFListMicrosoftWord.rtf", (Parser)p).xml;
            RTFParserTest.assertNotContained((String)"<ol>", (String)content);
            RTFParserTest.assertNotContained((String)"<ul>", (String)content);
            RTFParserTest.assertNotContained((String)"<li>", (String)content);
        }
    }

    @Test
    public void testListLibreOffice() throws Exception {
        String content = this.getXML((String)"testRTFListLibreOffice.rtf").xml;
        RTFParserTest.assertContains((String)"<ol>\t<li>one</li>", (String)content);
        RTFParserTest.assertContains((String)"</ol>", (String)content);
        RTFParserTest.assertContains((String)"<ul>\t<li>first</li>", (String)content);
        RTFParserTest.assertContains((String)"</ul>", (String)content);
    }

    @Test
    public void testBinControlWord() throws Exception {
        TikaTest.ByteCopyingHandler embHandler = new TikaTest.ByteCopyingHandler();
        try (TikaInputStream tis = TikaInputStream.get((InputStream)this.getResourceAsStream("/test-documents/testBinControlWord.rtf"));){
            ParserContainerExtractor ex = new ParserContainerExtractor();
            Assertions.assertEquals((Object)true, (Object)ex.isSupported(tis));
            ex.extract(tis, (ContainerExtractor)ex, (EmbeddedResourceHandler)embHandler);
        }
        Assertions.assertEquals((int)1, (int)embHandler.bytes.size());
        byte[] bytes = (byte[])embHandler.bytes.get(0);
        Assertions.assertEquals((int)10, (int)bytes.length);
        Assertions.assertEquals((int)125, (int)bytes[4]);
        Assertions.assertEquals((int)-1, (int)bytes[9]);
    }

    @Test
    public void testMetaDataCounts() throws Exception {
        TikaTest.XMLResult xml = this.getXML("testRTFWord2010CzechCharacters.rtf");
        Assertions.assertEquals((Object)"1", (Object)xml.metadata.get(Office.PAGE_COUNT));
        Assertions.assertEquals((Object)"70", (Object)xml.metadata.get(Office.WORD_COUNT));
        Assertions.assertEquals((Object)"401", (Object)xml.metadata.get(Office.CHARACTER_COUNT));
        Assertions.assertTrue((boolean)xml.metadata.get(TikaCoreProperties.CREATED).startsWith("2010-10-13T"));
    }

    @Test
    public void testListOverride() throws Exception {
        RTFParserTest.assertContains((String)"Body", (String)this.getText("testRTFListOverride.rtf"));
    }

    @Test
    public void testCorruptListOverride() throws Exception {
        RTFParserTest.assertContains((String)"apple", (String)this.getText("testRTFCorruptListOverride.rtf"));
    }

    @Test
    public void testMultipleNewlines() throws Exception {
        String content = this.getXML((String)"testRTFNewlines.rtf").xml;
        content = content.replaceAll("[\r\n]+", " ");
        RTFParserTest.assertContains((String)"<body><p>one</p> <p /> <p>two</p> <p /> <p /> <p>three</p> <p /> <p /> <p /> <p>four</p>", (String)content);
    }

    @Test
    public void testEmbeddedLinkedDocument() throws Exception {
        ParserContainerExtractor ex;
        HashSet<MediaType> skipTypes = new HashSet<MediaType>();
        skipTypes.add(MediaType.parse((String)"image/emf"));
        skipTypes.add(MediaType.parse((String)"image/wmf"));
        TikaTest.TrackingHandler tracker = new TikaTest.TrackingHandler(skipTypes);
        try (TikaInputStream tis = TikaInputStream.get((InputStream)this.getResourceAsStream("/test-documents/testRTFEmbeddedLink.rtf"));){
            ex = new ParserContainerExtractor();
            Assertions.assertEquals((Object)true, (Object)ex.isSupported(tis));
            ex.extract(tis, (ContainerExtractor)ex, (EmbeddedResourceHandler)tracker);
        }
        Assertions.assertEquals((int)0, (int)tracker.filenames.size());
        tracker = new TikaTest.TrackingHandler();
        tis = TikaInputStream.get((InputStream)this.getResourceAsStream("/test-documents/testRTFEmbeddedLink.rtf"));
        var4_4 = null;
        try {
            ex = new ParserContainerExtractor();
            Assertions.assertEquals((Object)true, (Object)ex.isSupported(tis));
            ex.extract(tis, (ContainerExtractor)ex, (EmbeddedResourceHandler)tracker);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tis != null) {
                if (var4_4 != null) {
                    try {
                        tis.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tis.close();
                }
            }
        }
        Assertions.assertEquals((int)2, (int)tracker.filenames.size());
    }

    @Test
    public void testConfig() throws Exception {
        try (InputStream is = this.getResourceAsStream("/org/apache/tika/parser/microsoft/rtf/tika-config.xml");){
            Assertions.assertNotNull((Object)is);
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser p = new AutoDetectParser(tikaConfig);
            List metadataList = this.getRecursiveMetadata("testBinControlWord.rtf", (Parser)p);
            Assertions.assertEquals((int)1, (int)metadataList.size());
            RTFParserTest.assertContains((String)"TikaMemoryLimitException", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_META_EXCEPTION_EMBEDDED_STREAM));
        }
    }

    @Test
    public void testBoldPlain() throws Exception {
        TikaTest.XMLResult r = this.getXML("testRTFBoldPlain.rtf");
        RTFParserTest.assertContains((String)"<b>Hank</b>", (String)r.xml);
        RTFParserTest.assertNotContained((String)"<b>Anna Smith", (String)r.xml);
    }

    @Test
    public void testSpacingInAnnotations() throws Exception {
        RTFParserTest.assertContains((String)"supercali ATB Allison, Timothy B.  This is a comment fragilistic", (String)this.getXML((String)"testRTF_annotation_spacing.rtf").xml);
    }

    @Test
    public void testTIKA1713() throws Exception {
        RTFParserTest.assertContains((String)"For discussion", (String)this.getXML((String)"testRTFTIKA_1713.rtf").xml);
    }

    @Test
    public void testTIKA2150() throws Exception {
        RTFParserTest.assertContains((String)"TO\tFROM", (String)this.getXML((String)"testRTFTIKA_2150.rtf").xml);
    }

    @Test
    public void testTIKA2500() throws Exception {
        RTFParserTest.assertContains((String)"Level1", (String)this.getXML((String)"testRTFTIKA_2500.rtf").xml);
    }

    @Test
    public void testTIKA2883() throws Exception {
        RTFParserTest.assertContains((String)"This message has been archived.", (String)this.getXML((String)"testRTFTIKA_2883.rtf").xml);
    }

    @Test
    public void testTIKA2899() throws Exception {
        RTFParserTest.assertContains((String)"this Agreement on today", (String)this.getXML((String)"testRTFTIKA_2899.rtf").xml);
    }
}

